<?php

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB()
{    
    $db = parse_ini_file("../../lib/datasource.ini");
    $conexion = mysqli_connect($db['ServidorBD'],$db['UsuarioBD'],$db['ClaveBD'],$db['NombreBD']);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECT
////////////////////////////////////////////////////////////////////////////////////////////////////
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    return $rawdata; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////$
$tipo           = strtoupper(trim($_GET['tipo']));  
$codconcepto    = strtoupper(trim($_GET['codconcepto']));  
$numero         = strtoupper(trim($_GET['numero']));  
$codsucursal    = strtoupper(trim($_GET['codsucursal']));  
$observaciones  = strtoupper(trim($_GET['observaciones']));
$diaoperativo   = strtoupper(trim($_GET['diaoperativo']));  
$proveedor      = strtoupper(trim($_GET['proveedor'])); 
$nrosoporte     = strtoupper(trim($_GET['nrosoporte']));  
$codfuncionario = strtoupper(trim($_GET['codfuncionario'])); 
$valorbase      = strtoupper(trim($_GET['valorbase'])); 
$valoriva       = strtoupper(trim($_GET['valoriva'])); 
$valortotal     = strtoupper(trim($_GET['valortotal'])); 
$archivoid     = strtoupper(trim($_GET['archivoid'])); 

//// Inserto el registro
$vsql = "INSERT INTO autorizacionesgastos(tipo,codconcepto,codsucursal,observaciones,diaoperativo,proveedor,nrosoporte,autorizado,codfuncionario,valorbase,valoriva,valortotal,archivoid) 
         VALUES('".$tipo."', '".$codconcepto."', '".$codsucursal."','".$observaciones."','".$diaoperativo."','".$proveedor."','".$nrosoporte."','".$autorizado."','".$codfuncionario."','".$valorbase."','".$valoriva."','".$valortotal."',".$archivoid.")";
$autorizaid = EjecutarSQL($vsql);

/// Armo la Respuesta segun el caso
if($autorizaid  != "")
{
    if($archivoid != "")
    {
        $autorizaid = SeleccionarUno("SELECT MAX(autorizaid) FROM autorizacionesgastos WHERE tipo = '".$tipo."' AND codsucursal = '".$codsucursal."'");
        EjecutarSQL("UPDATE archivodigital SET docuid2 = ".$autorizaid." WHERE archivoid = ".$archivoid);
    }
    $code = 200;
    $message = "Autorizacion registrada con Exito";    
}
else
{
    $code = 400;
    $message = "Se ha producido un Error al Registrar la Autorizacion";    
}

/// Retorno la respuesta correspondiente
$response = array("code" => $code , "autorizacionid" => $autorizaid );
header('Content-type: application/json; charset=utf-8');
echo json_encode($response);
?>