<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrartipo
    // Creación: 29/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que obtiene el filtro de la ventana principal
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrartipo")
    {
        $tipo = $_POST['tipo'];        
        header("Location: excluidoscloseup.php?opcion=ventanaexcluidos&tipo=$tipo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaexcluidos
    // Creación: 29/10/2024		última modificación: 30/10/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana principal del formulario
    // Última modificación: Botón para la salida en una hoja de Excel de los excluidos del 
    //                      programa close up
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "ventanaexcluidos")
    {
        $tipo = $_GET['tipo'];

        if(strlen($tipo) == 0)
            $tipo = "T";

        switch($tipo)
        {
            case 'T':
                  $seleccion1 = 'selected';
                  $seleccion2 = '';
                  $seleccion3 = '';
                  break;
            case 'L':
                  $seleccion1 = '';
                  $seleccion2 = 'selected';
                  $seleccion3 = '';
                  break;
            case 'P':
                  $seleccion1 = '';
                  $seleccion2 = '';
                  $seleccion3 = 'selected';
                  break;
            default:
                  break;
        }

        // consulta de la vista
        $vsql = "SELECT ec.excluidosid, ec.tipo, 
                        CASE
                            WHEN ec.tipo = 'L' THEN 'LABORATORIO'
                            WHEN ec.tipo = 'P' THEN 'PRODUCTO'
                        END nombretipo, 
                        (SELECT codigo FROM productos WHERE productoid = ec.productoid) codigoproducto,
                        (SELECT descripcion FROM productos WHERE productoid = ec.productoid) nombreproducto,
                        (SELECT codigo FROM gruposprod WHERE gruposprodid = ec.gruposprodid) codigolabo,
                        (SELECT descripcion FROM gruposprod WHERE gruposprodid = ec.gruposprodid) nombrelabo
                   FROM excluidoscloseup ec "; 

        if($tipo != "T")
            $vsql.= " WHERE ec.tipo = '".$tipo."'";

        // variable de sesión para la salida a Excel
        $_SESSION['SQL_EXCLUIDOSCLOSEUPXLS'] = $vsql;

        // construyo el detalle
        $i = 0;         $det = '';
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $det.='<tr class="TablaDocsPar">';
            else
                $det.='<tr class="TablaDocsImPar">';
            
            $det.=' <td align="center"> '.$i.' </td>
                    <td align="center"> '.$row['nombretipo'].' </td>';

            // determino el tipo
            if($row['tipo'] == "L")
                $det.=' <td align="left"> '.$row['codigolabo'].' </td>
                        <td align="left"> '.$row['nombrelabo'].' </td>';
            
            if($row['tipo'] == "P")
                $det.=' <td align="left"> '.$row['codigoproducto'].' </td>
                        <td align="left"> '.$row['nombreproducto'].' </td>';

            // botón para eliminar
            $det.=' <td align="center"> 
                     <a href="?opcion=confirmarelim&excluidosid='.$row['excluidosid'].'&tipo='.$row['tipo'].'&tipoventana='.$tipo.'" rel="facebox">
                      <img src="images/basicas/iconoborrar.png" title="eliminar excluido" border="0" width="20" height="20">
                     </a>
                    </td>
                   </tr>';
        }

        $det.='</table>';

        // pie de página
        $pie = '<table width="100%"> <tr class="TituloTabla"> <td width="1608"> &nbsp; </td> </tr> </table>';

        // valido que el archivo de mostrar errores exista
        $archivoerror = "reportes/errorescloseup.txt";
        if (file_exists ($archivoerror))
            $htmlarchivoerror = '<a href="?opcion=vererrores&tipoventana='.$tipo.'" rel="facebox">
                                  <img src="images/iconos/notas.png" border="0" width="32" height="32" title="c&oacute;digos de excluidos no guardados en el &uacute;ltimo proceso de importaci&oacute;n">
                                 </a>';
        else
            $htmlarchivoerror = '<img src="images/iconos/notas.png" border="0" width="32" height="32" title="c&oacute;digos de excluidos no guardados en el &uacute;ltimo proceso de importaci&oacute;n">';

        // Validación del botón de limpiar lista de los excluidos close up y del botón para la salida a Excel
        $vsql32 = "SELECT COUNT(*) numprodexcl FROM excluidoscloseup";
        $numprodexcl = $clase->SeleccionarUno($vsql32);

        if($numprodexcl > 0)
        {
            $htmllimpiar = ' <a href="?opcion=confirmarlimpiar&tipoventana='.$tipo.'" rel="facebox">
                              <img src="images/iconos/anulardoc.png" border="0" width="32" height="32" title="limpiar toda la lista de excluidos de close up">
                             </a>';
            $htmlsalidaxls = '<a href="?opcion=excluidoscloseupxls&tipoventana='.$tipo.'" target="_blank"> 
                               <img src="images/iconos/exportarexcel2.png" border="0" width="32" height="32" title="exportar a una hoja de Excel"> 
                              </a>';
        }
        else
        {
            $htmllimpiar = '<img src="images/iconos/anulardoc.png" border="0" width="32" height="32" title="limpiar toda la lista de excluidos de close up">';        
            $htmlsalidaxls = '<img src="images/iconos/exportarexcel2.png" border="0" width="32" height="32" title="exportar a una hoja de Excel">';
        }

        // Pintamos la ventana
        $enc = $clase->Header("S","W");
        $enc.= '<form action="?opcion=filtrartipo" method="POST" name="x">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cerrar2.png" width="32" height="32" border="0"> </td>
                  <td width="220"> <b> Laboratorios y productos <br> excluidos de close up </b> </td>
                  <td width="460"> &nbsp; </td>
                  <td width="140"> 
                   <select name="tipo" id="tipo" style="width:120px;height:25px" OnChange="x.submit();">
                    <option value="T" '.$seleccion1.'> todos </option> 
                    <option value="L" '.$seleccion2.'> laboratorios </option>
                    <option value="P" '.$seleccion3.'> productos </option>
                   </select>
                   </form> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30">
                   <a href="?opcion=ventananuevoexcluido&tipo='.$tipo.'" rel="facebox">
                    <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="incluir un nuevo registro"> 
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
		          <td width="30">
		           <a href="?opcion=importarexcel1&tipoventana='.$tipo.'" rel="facebox">
		            <img src="images/iconos/cargar.png" width="32" height="32" border="0" title="importar excluidos desde una hoja de Excel">
		           </a>
		          </td>
		          <td width="10"> &nbsp; </td>
				  <td width="30"> '.$htmlarchivoerror.' </td>
		          <td width="10"> &nbsp; </td>
				  <td width="30"> '.$htmllimpiar.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> '.$htmlsalidaxls.' </td>
				  <td width="10"> &nbsp; </td>
		          <td width="50" align="center"> <a href="principal.php"> <input type="button" value="<<" class="button blue"> </a> </td> 
		          <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // títulos
        $enc .='<script type="text/javascript" src="lib/sorttable.js"> </script>
                <table id="fixTableV" class="sortable">
                 <tr class="TituloTabla">
                  <th width="40"> # </th>
                  <th width="30"> Tipo </th>
                  <th width="120"> C&oacute;digo </th>
                  <th width="600"> Nombre </th>
                  <th width="30"> &nbsp; </th>
                 </tr>';

        // Construyo el contenido del formulario
        $cont = $enc.$det.$pie;

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventananuevoexcluido
    // Creación: 29/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar el nuevo excluido close up
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventananuevoexcluido")
    {
        $tipocancelar = $_GET['tipo'];

		// pinto la ventana
		$cont ='<table width="400">
				 <tr class="CabezoteTabla">
				  <td width="50" align="left"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0"> </td>
				  <td width="350" align="center"> <b> Incluir Excluido </b> <br> </td>
				 </tr> 
				</table>
				<form action="?opcion=guardarnewexclusion" method="POST" name="x">
                <input type="hidden" name="tipocancelar" value="'.$tipocancelar.'"> 
				<table width="400">
				 <center><br>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"><label class="Texto12"> Tipo: </label>&nbsp;</td>
				  <td width="300">				   
                   <select name="tipo" id="tipo" style="width:120px;height:25px">                    
                    <option value="L" selected> laboratorio </option>
                    <option value="P"> producto </option>
                   </select>
				  </td>
				 </tr>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"> <label class="Texto12"> C&oacute;digo: </label> &nbsp; </td>
				  <td width="300"> <input type="text" class="Texto11" name="codigo" style="width:230px;height:25px;" size="20" maxlenght="20" value="" style="text-transform:uppercase!Important;" autocomplete="off"> </td>
				 </tr>	
				</table>
				<br>
				<center>
				<input type="submit" value="aceptar" class="button blue">
				<a href="?opcion=ventanaexcluidos&tipo='.$tipocancelar.'"> <input type="button" value="CANCELAR" class="button red"> </a>
				</form><br>';
		echo $cont;
		exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarnewexclusion
    // Creación: 29/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que guarda un nuevo excluido close up
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarnewexclusion")
    {
        $tipo = $_POST['tipo'];
        $codigo = $_POST['codigo'];
        $tipocancelar = $_POST['tipocancelar'];

        if(strlen($codigo) == 0)
            $clase->Aviso(3,"Debe incluir el código");
        else
        {
            // proceso el laboratorio
            if($tipo == "L")
            {
                // Valido que el laboratorio o producto sea valido
                $gruposprodid = $clase->BDLockup($codigo,'gruposprod','codigo','gruposprodid');
    
                if($gruposprodid == "")
                    $clase->Aviso(3,"Laboratorio no existe");
                else
                {
                    $descripcion = $clase->BDLockup($gruposprodid,'gruposprod','gruposprodid','descripcion');

                    // valido que el laboratorio no esté ya incluido
                    $valreg = $clase->SeleccionarUno("SELECT COUNT(*) FROM excluidoscloseup WHERE gruposprodid = ".$gruposprodid."");
    
                    if($valreg > 0)
                        $clase->Aviso(3,"$descripcion ya está excluido de close up");
                    else
                    {
                        // Almaceno el nuevo laboratorio
                        $clase->EjecutarSQL("INSERT INTO excluidoscloseup (tipo,gruposprodid,productoid,creador,momento) VALUE ('".$tipo."',".$gruposprodid.",0,'".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)");
                        $clase->Aviso(3,"$descripcion excluido satisfactoriamente");
                    }
                }
            }
    
            // proceso para incluir producto
            if($tipo == "P")
            {
                // Valido que el laboratorio o producto sea valido
                $productoid = $clase->BDLockup($codigo,'productos','codigo','productoid');
    
                if($productoid == "")
                    $clase->Aviso(3,"Producto no existe");
                else
                {
                    $descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');

                    // valido que el laboratorio no esté ya incluido
                    $valreg = $clase->SeleccionarUno("SELECT COUNT(*) FROM excluidoscloseup WHERE productoid = ".$productoid."");
    
                    if($valreg > 0)
                        $clase->Aviso(3,"$descripcion ya está excluido de close up");
                    else
                    {
                        // Almaceno el nuevo laboratorio
                        $clase->EjecutarSQL("INSERT INTO excluidoscloseup (tipo,gruposprodid,productoid,creador,momento) VALUE ('".$tipo."',0,".$productoid.",'".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)");
                        $clase->Aviso(3,"$descripcion excluido satisfactoriamente");
                    }
                }
            }
        }

        // redirecciono el formulario
        header("Location: excluidoscloseup.php?opcion=ventanaexcluidos&tipo=$tipocancelar");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarelim
    // Creación: 29/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de un excluido
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarelim")
    {
        $excluidosid = $_GET['excluidosid'];
        $tipo = $_GET['tipo'];
        $tipoventana = $_GET['tipoventana'];

        // obtengo el nombre del laboratorio
        if($tipo == "L")
        {
            $gruposprodid = $clase->BDLockup($excluidosid,'excluidoscloseup','excluidosid','gruposprodid');
            $descripcion = $clase->BDLockup($gruposprodid,'gruposprod','gruposprodid','descripcion');
        }

        // obtengo el nombre del producto
        if($tipo == "P")
        {
            $productoid = $clase->BDLockup($excluidosid,'excluidoscloseup','excluidosid','productoid');
            $descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');
        }

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Eliminar Excluido </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12"> ¿Confirma que desea eliminar <br>
                    <b>'.trim($descripcion).'</b> <br> de la lista de productos excluidos del programa close up? </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=elimianrexclcs" method="POST">
                   <input type="hidden" name="excluidosid" value="'.$excluidosid.'"> 
                   <input type="hidden" name="tipoventana" value="'.$tipoventana.'">
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="?opcion=ventanaexcluidos&tipo='.$tipoventana.'"> <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
       echo $cont;
       exit();
    }  

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: elimianrexclcs
    // Creación: 29/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un laboratorio o producto excluido de close up
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "elimianrexclcs")
    {
        $excluidosid = $_POST['excluidosid'];
        $tipoventana = $_POST['tipoventana'];

        // obtengo el tipo
        $tipo = $clase->BDLockup($excluidosid,'excluidoscloseup','excluidosid','tipo');

        // obtengo el nombre de excluido
        if($tipo == "L")
        {
            $gruposprodid = $clase->BDLockup($excluidosid,'excluidoscloseup','excluidosid','gruposprodid');
            $descripcion = $clase->BDLockup($gruposprodid,'gruposprod','gruposprodid','descripcion');            
        }

        if($tipo == "P")
        {
            $productoid = $clase->BDLockup($excluidosid,'excluidoscloseup','excluidosid','productoid');
            $descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');
        }        

		// Elimino el excluido
		$clase->EjecutarSQL("DELETE FROM excluidoscloseup WHERE excluidosid = ".$excluidosid."");

        // emito el mensaje correspondiente
        $clase->Aviso(3,"$descripcion eliminado satisfactoriamente");

        // redirecciono el formulario
        header("Location: excluidoscloseup.php?opcion=ventanaexcluidos&tipo=$tipoventana");        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: elimianrexclcs
    // Creación: 29/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel con los 
    //              excluidos de close up
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel1")
    {
        $tipoventana = $_GET['tipoventana'];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor dir&iacute;jase al servidor </font> <br>
                       <a href="http://192.168.14.248:9999/dropos/login/" target="_blank"> 
                        <font color=blue> 192.168.14.248:9999 </font> <br>                        
                       </a>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=ventanaexcluidos&tipo='.$tipoventana.'" id="theform" enctype="multipart/form-data">
                       <input type="submit" name="enviar" id="enviarr" value="aceptar" class="button blue" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
        else
        {
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b> Importar excluidos del programa close up </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=importarexcel2" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="tipoventana" value="'.$tipoventana.'">
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>
                     </tr>
                    </table>';

			// estructura de la tabla
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: Tipo (L) laboratorio (P) producto </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: C&oacute;digo del producto o laboratorio </td> </tr>
                    </table>';
    
            // Impresión de la imagen de ejemplo
            $cont.='<table width="400">                    
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemploexcluidocloseup.png" width="300" height="200" border="0">
                      </td> 
                     </tr>';

            // Botón de ejecutar
            $cont.=' <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensi&oacute;n .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel2
    // Creación: 29/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que incluye laboratorios y/o productos excluidos de close up
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel2")
    {
		set_time_limit(0);
		extract($_POST);
        $tipoventana = $_POST['tipoventana'];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['tipo'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['codigo'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['tipo']) == 0) || (strlen($_DATOS_EXCEL[$i]['codigo']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;

            $carpetaactual = 'reportes/';

            // // nombre del sector
            // $nombre = $clase->BDLockup($seguimientoid,'seguimientovtasinstante','seguimientoid','nombre');

            // Construcción de la variable con los documentos no grabados
            $noproductos = 'EXCLUIDOS DEL PROGRAMA CLOSE UP'.Chr(13).Chr(10);            
            $noproductos.= 'CODIGOS NO GRABADOS:'.Chr(13).Chr(10);
            $noproductos.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $motivo = "";
                $valreg = 0;
                $lbgrabo = false;

                $tipo = $_DATOS_EXCEL[$j]['tipo'];

                if($tipo != "")
                {
                    if(($tipo != "P") && ($tipo != "L"))
                        $motivo = "El tipo es incorrecto";
                    else
                    {
                        $codigo = $_DATOS_EXCEL[$j]['codigo'];
    
                        if($codigo == "")
                            $motivo = "Código no ingresado";
                        else
                        {
                            if($tipo == "L")
                            {
                                $gruposprodid = $clase->BDLockup($codigo,'gruposprod','codigo','gruposprodid');
    
                                $valreg = $clase->SeleccionarUno("SELECT COUNT(*) FROM excluidoscloseup WHERE gruposprodid = ".$gruposprodid."");
    
                                if($valreg > 0)
                                    $motivo = "Laboratorio ya existe";
                                else
                                {
                                    $clase->EjecutarSQL("INSERT INTO excluidoscloseup (tipo,gruposprodid,productoid,creador,momento) VALUE ('".$tipo."',".$gruposprodid.",0,'".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)");
                                    $lbgrabo = true;
                                    $grabados++;
                                }
                            }
    
                            if($tipo == "P")
                            {
                                $productoid = $clase->BDLockup($codigo,'productos','codigo','productoid');
    
                                $valreg = $clase->SeleccionarUno("SELECT COUNT(*) FROM excluidoscloseup WHERE productoid = ".$productoid."");
    
                                if($valreg > 0)
                                    $motivo = "Producto ya existe";
                                else
                                {
                                    $clase->EjecutarSQL("INSERT INTO excluidoscloseup (tipo,gruposprodid,productoid,creador,momento) VALUE ('".$tipo."',0,".$productoid.",'".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)");
                                    $lbgrabo = true;
                                    $grabados++;
                                }
                            }
                        }
                    }
    
                    // Almaceno en un archivo de texto los códigos de los excluidos que no fueron grabados en este proceso
                    if(!$lbgrabo)
                    {
                        $noproductos.= str_pad($codigo,1,"").' -- '.str_pad($motivo,1,"").Chr(13).Chr(10);                  // Actualizo la variable con el documento no almacenado
                        $archivo = "errorescloseup.txt";                                                                    // nombre del archivo
                        $fd = fopen ($carpetaactual."/".$archivo, "w");                                                     // se abre el archivo para escribir
                        fwrite($fd, $noproductos);                                                                          // Grabas
                        fclose($fd);                                                                                        // Cierras el archivo
                    }
                }
            }

            $fechoraimp = fechayhoraejecucion();

            $noproductos.= ''.Chr(13).Chr(10);
            $noproductos.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);       // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "errorescloseup.txt";                                                // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                                 // se abre el archivo para escribir
            fwrite($fd, $noproductos);                                                      // Grabas
            fclose($fd);

            // Elimino el Archivo
            unlink($destino);

            
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los excluidos");
            else
                $clase->Aviso(1,"Se cargaron $grabados excluidos");
        }

        // redirecciono el formulario
        header("Location: excluidoscloseup.php?opcion=ventanaexcluidos&tipo=$tipoventana");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererrores
    // Creación: 29/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para ver los códigos de los excluidos no 
    //              grabados en el último proceso de importación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererrores")
    {
        $tipoventana = $_GET['tipoventana'];

        // Inicialización de variables
        $archivoerror = "reportes/errorescloseup.txt";
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        $txt = trim(str_replace("<br />","",$txt));
        $txt = trim(str_replace(" -- codigo en blanco","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> C&oacute;digos no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
				  <a href="?opcion=ventanaexcluidos&tipo='.$tipoventana.'"> <input type="button" value="aceptar" class="button blue"> </a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();    
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarlimpiar
    // Creación: 29/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de todos los 
    //              excluidos de close up
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarlimpiar")
    {
        $tipoventana = $_GET['tipoventana'];

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/anulardoc.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Eliminar todos los excluidos <br> del programa close up </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">
                   ¿Confirma que desea eliminar todos los excluidos del programa close up? <br> Esta opci&oacute;n no podr&aacute; ser revertida
                   </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=limpiarcloseup" method="POST">
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="?opcion=ventanaexcluidos&tipo='.$tipoventana.'"> <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: limpiarcloseup
    // Creación: 29/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina todos los excluidos de close up
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "limpiarcloseup")
    {
        // limpio la tabla
        $clase->EjecutarSQL("DELETE FROM excluidoscloseup");

        // Emito el mensaje correspondiente
        $clase->Aviso(1,"Excluidos del programa close up eliminados satisfactoriamente");
        
        // redirecciono el formulario
        $tipoventana = "T";
        header("Location: excluidoscloseup.php?opcion=ventanaexcluidos&tipo=$tipoventana");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: excluidoscloseupxls
    // Creación: 30/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Salida en una hoja de Excel de los excluidos del programa close up
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "excluidoscloseupxls")
    {
        $tipoventana = $_GET['tipoventana'];

        switch($tipoventana)
        {
            case 'T':
                  $tiposeleccionado = 'TODOS LOS EXCLUIDOS';
                  break;
            case 'L':
                  $tiposeleccionado = 'FILTRADO POR LABORATORIO';
                  break;
            case 'P':
                  $tiposeleccionado = 'FILTRADO POR PRODUCTO';
                  break;
            default:
                  break;
        }        

        $vsql = $_SESSION['SQL_EXCLUIDOSCLOSEUPXLS'];

        // preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');

        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');

        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("excluidos close up - DROPOS")
                                     ->setSubject("excluidos close up - DROPOS")
                                     ->setDescription("excluidos close up - DROPOS")
                                     ->setKeywords("excluidos close up - DROPOS")
                                     ->setCategory("excluidos close up");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'LABORATORIOS Y PRODUCTOS EXCLUIDOS DE CLOSE UP')
                    ->setCellValue('A2', $tiposeleccionado)
                    ->setCellValue('A3', '#')
                    ->setCellValue('B3', 'TIPO')
                    ->setCellValue('C3', 'CODIGO')
                    ->setCellValue('D3', 'NOMBRE');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);

        // Detalle del informe
        $i = 4;
        $numlinea = 1;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            if($row['tipo'] == "L")
            {
                $codigo = $row['codigolabo'];
                $nombre = $row['nombrelabo'];
            }

            if($row['tipo'] == "P")
            {
                $codigo = $row['codigoproducto'];
                $nombre = $row['nombreproducto'];
            }

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, number_format($numlinea))
                        ->setCellValue('B'.$i, $row['nombretipo'])
                        ->setCellValue('C'.$i, $codigo)
                        ->setCellValue('D'.$i, $nombre);            
            $i++;
            $numlinea++;
        }

        $rangoEncabezado = 'A3:D3';
        $rangoCeldas     = 'A3:D'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('excluidos close up');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // -------------------------------------------------------------------------------------------- //
        $nombrearcexcel = "excluidos close up.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // -------------------------------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }    
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Función fechayhoraejecucion
    // Parámetro de entrada:    Ninguno
    // Valor de retorno:        $fechoraimp --> día, fecha y hora
    // Descripción: Función que devuelve la fecha con día, fecha y hora de ejecución del 
    //              último proceso
    ////////////////////////////////////////////////////////////////////////////////////////
    function fechayhoraejecucion()
    {
        $mesimp = date('F');
        if($mesimp == "January")       $mesimp = "enero";
        if($mesimp == "February")      $mesimp = "febrero";
        if($mesimp == "March")         $mesimp = "marzo";
        if($mesimp == "April")         $mesimp = "abril";
        if($mesimp == "May")           $mesimp = "mayo";
        if($mesimp == "June")          $mesimp = "junio";
        if($mesimp == "July")          $mesimp = "julio";
        if($mesimp == "August")        $mesimp = "agosto";
        if($mesimp == "September")     $mesimp = "septiembre";
        if($mesimp == "October")       $mesimp = "octubre";
        if($mesimp == "November")      $mesimp = "noviembre";
        if($mesimp == "December")      $mesimp = "diciembre";

        $dayweek = date("l");
        if($dayweek == "Monday")       $dayweek = "lunes";
        if($dayweek == "Tuesday")      $dayweek = "martes";
        if($dayweek == "Wednesday")    $dayweek = "miércoles";
        if($dayweek == "Thursday")     $dayweek = "jueves";
        if($dayweek == "Friday")       $dayweek = "viernes";
        if($dayweek == "Saturday")     $dayweek = "sábado";
        if($dayweek == "Sunday")       $dayweek = "domingo";

        $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');
        return($fechoraimp);
    }
?>