<?php
    session_start(); 
    ini_set("memory_limit","500M");  
    set_time_limit(0);
    include("../../../lib/Sistema.php");
    
    //// Inicializo la Base de Datos
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];

    //// Dia Operativo y Sucursal
    $diaoperativo = str_pad(date("d"),2,"0",STR_PAD_LEFT).date("/m/Y");
    $sucursal = $clase->BDLockup('G_SUCURSALPOS','configuraciones','variab','contenido'); 

    //// Envio el Disponible al Servidor
    $disponible = file_get_contents("http://localhost:8082/dropos/wsjson/efedisponible/disponible.php");
    $URLWSDISPO = "http://dromedicas.sytes.net:9999/dropos/wsjson/efedisponible/recibirdisponible.php?sucursal=".$sucursal."&disponible=".$disponible;
    $respuesta1 = file_get_contents($URLWSDISPO);
    
    ///// Ruta URL Web para envio 
    $RUTARECEPCION = "http://www.dromedicas.com.co/wsjson/ventasinstante/webservice.php";

    //// Extraigo la Data    
    $jsondata     = DataVentaMySQL($diaoperativo,$sucursal);

    /// Si hay Datos
    if($jsondata!="")
       $resultado    = ConsumumirWebservice($RUTARECEPCION,$jsondata);
    
    //// Muestro los Resultados en pantalla
    /*
    echo'<br><br><br>';
    echo'<h3>Cargando Ventas del <font color="blue"> '.$diaoperativo.'</font></h3>';
    
    echo'Enviado : <br>';
    print_r($jsondata);

    echo'<br><br>Recibido : <br>';
    print_r($resultado);

    echo'<br><br>';
*/
    echo"<h3>Ventas actualizadas con exito ".date("d/m/Y")." a las ".date("H:i")."</h3>";
    echo'Puede Cerrar esta Ventana';
    exit;
    
  /////////////////////////////////////////////////////////////////////////////
  //// Consumir WebService
  /////////////////////////////////////////////////////////////////////////////  
  function ConsumumirWebservice($ruta,$datajson)
  {
       $dirWS = $ruta.'?m=POST';
       $ch = curl_init($dirWS);
       curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
       curl_setopt($ch, CURLOPT_POSTFIELDS, $datajson);
       curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
       curl_setopt($ch, CURLOPT_HTTPHEADER, array(
          'Content-Type: application/json',
          'Content-Length: ' . strlen($datajson))
       );
       curl_setopt($ch, CURLOPT_TIMEOUT, 55);
       curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 55);

       //execute post
       $result2 = curl_exec($ch);

       //close connection
       curl_close($ch);

       /// Retorno el JSON con el resultado
       $obj = json_decode($result2);   
       //print_r($result2);
       $objArr = (array)$obj;
       return($objArr);    
  }
  

  /////////////////////////////////////////////////////////////////////////////
  //// Datos de Venta - en Sucursal
  /////////////////////////////////////////////////////////////////////////////  
  function DataVentaMySQL($diaoperativo,$sucursal)
  {
      $clase = new Sistema();
      $zona    = $clase->BDLockup($sucursal,"sucursales","codigo","zona");
      $region  = $clase->BDLockup($zona,"zonas","codzona","codregion");
      
      $vsql2 = "SELECT '".$sucursal."' sucursal , '".$zona."' zona , '".$region."' region , DV.diaoperativo , T2.codvende , CONCAT(T2.nombres,' ',T2.apellidos) vendedor , SUM( total ) vtageneral ,
                (
                SELECT SUM(DD2.valtotal) FROM documentos D2 INNER JOIN docuventa DV2 ON (D2.docuid = DV2.docuid) INNER JOIN dedocumentos DD2 ON (D2.docuid = DD2.docuid)                
                INNER JOIN productos P2 ON (P2.productoid = DD2.productoid) 
                WHERE D2.tipodoc = 'FVE' AND D2.fecanulado = '0000-00-00' AND D2.fecasentado <> '0000-00-00' AND D2.terid2 = T2.terid AND P2.porcenboni > 0 AND DV2.diaoperativo = '".$diaoperativo."'
                ) vtaespecial ,
                (
                SELECT SUM(DD2.cantidad*DD2.valunitario*(P2.porcenboni/100)) FROM documentos D2 INNER JOIN docuventa DV2 ON (D2.docuid = DV2.docuid) INNER JOIN dedocumentos DD2 ON (D2.docuid = DD2.docuid)                
                INNER JOIN productos P2 ON (P2.productoid = DD2.productoid) 
                WHERE D2.tipodoc = 'FVE' AND D2.fecasentado <> '0000-00-00' AND D2.fecanulado = '0000-00-00' AND D2.terid2 = T2.terid AND P2.porcenboni > 0 AND DV2.diaoperativo = '".$diaoperativo."'
                ) especialganado ,
                (
                  SELECT SUM(DD3.unidades) FROM dedocumentos DD3 INNER JOIN productos P3 ON (P3.productoid = DD3.productoid)
                  INNER JOIN docuventa DV3 ON (DD3.docuid = DV3.docuid)
                  INNER JOIN documentos D3 ON (DD3.docuid = D3.docuid)
                  WHERE D3.tipodoc = 'FVE' AND D3.fecasentado <> '0000-00-00' AND P3.descripcion LIKE 'SURE%ZINC%' AND T2.terid = D3.terid2 AND DV3.diaoperativo = '".$diaoperativo."'
                ) surezinc             
                FROM documentos D INNER JOIN docuventa DV ON ( D.docuid = DV.docuid ) INNER JOIN terceros T2 ON (T2.terid = D.terid2) 
                WHERE D.tipodoc =  'FVE' AND D.fecasentado <>  '0000-00-00' AND D.fecanulado =  '0000-00-00' AND DV.diaoperativo = '".$diaoperativo."' GROUP BY 1,2,3,4,5 ORDER BY 6 DESC";
//echo $vsql2;

      $conex  = $clase->Conectar();
      $result = mysql_query($vsql2,$conex);
      $list = array();
      while($row = mysql_fetch_array($result)) 
        $list[] = $row;
      
      //echo $vsql2."<br>";
      //print_r($list);
        
      $param = json_encode($list);			  
      return($param); 
      
  } // Fin de DataVentaMySQL  

?>