<?php
    session_start(); 
    ini_set("memory_limit","500M");  
    set_time_limit(0);
    include("../../../lib/Sistema.php");
    
    //// Inicializo la Base de Datos
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];

    //// Dia Operativo y Sucursal
    $diaoperativo  = str_pad(date("d"),2,"0",STR_PAD_LEFT).date("/m/Y");
    $diaoperativo2 = date("Y-m-d");
    $sucursal = $clase->BDLockup('G_SUCURSALPOS','configuraciones','variab','contenido'); 

    //// Envio el Disponible al Servidor
    /*
    $disponible = file_get_contents("http://localhost:8082/dropos/wsjson/efedisponible/disponible.php");
    $URLWSDISPO = "http://dromedicas.sytes.net:9999/dropos/wsjson/efedisponible/recibirdisponible.php?sucursal=".$sucursal."&disponible=".$disponible;
    $respuesta1 = file_get_contents($URLWSDISPO);
    */

    ///// Ruta URL Web para envio 
    $RUTARECEPCION  = "http://www.dromedicas.com.co/wsjson/ventasinstante/webservice.php";
    $RUTARECEPCION2 = "http://www.dromedicas.com.co/wsjson/ventasinstante/webservice2.php";

    //// Extraigo la Data de Ventas   
    $jsondata  = DataVentaMySQL($diaoperativo,$sucursal);

    /// Si hay Datos - los Envio
    if($jsondata!="")
       $resultado    = ConsumumirWebservice($RUTARECEPCION,$jsondata);
    
    //// Extraigo la Data de Ventas   
    $jsondata2 = DataVentaMySQL2($diaoperativo2,$sucursal);

    if($jsondata2!="")
       $resultado2   = ConsumumirWebservice($RUTARECEPCION2,$jsondata2);

    echo     $RUTARECEPCION2;
    echo '<br>';
    echo $jsondata2;

    echo"<h3>Ventas actualizadas con exito ".date("d/m/Y")." a las ".date("H:i")."</h3>";
    echo'Puede Cerrar esta Ventana';
    exit;
    
  /////////////////////////////////////////////////////////////////////////////
  //// Consumir WebService
  /////////////////////////////////////////////////////////////////////////////  
  function ConsumumirWebservice($ruta,$datajson)
  {
       $dirWS = $ruta.'?m=POST';
       $ch = curl_init($dirWS);
       curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
       curl_setopt($ch, CURLOPT_POSTFIELDS, $datajson);
       curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
       curl_setopt($ch, CURLOPT_HTTPHEADER, array(
          'Content-Type: application/json',
          'Content-Length: ' . strlen($datajson))
       );
       curl_setopt($ch, CURLOPT_TIMEOUT, 55);
       curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 55);

       //execute post
       $result2 = curl_exec($ch);

       //close connection
       curl_close($ch);

       /// Retorno el JSON con el resultado
       $obj = json_decode($result2);   
       //print_r($result2);
       $objArr = (array)$obj;
       return($objArr);    
  }
  

  /////////////////////////////////////////////////////////////////////////////
  //// Datos de Venta - en Sucursal
  /////////////////////////////////////////////////////////////////////////////  
  function DataVentaMySQL($diaoperativo,$sucursal)
  {
      $clase = new Sistema();
      $zona    = $clase->BDLockup($sucursal,"sucursales","codigo","zona");
      $region  = $clase->BDLockup($zona,"zonas","codzona","codregion");
      
      $vsql2 = "SELECT '".$sucursal."' sucursal , '".$zona."' zona , '".$region."' region , DV.diaoperativo , T2.codvende , CONCAT(T2.nombres,' ',T2.apellidos) vendedor , SUM( total ) vtageneral ,
                (
                  SELECT SUM(DD2.valtotal) FROM documentos D2 INNER JOIN docuventa DV2 ON (D2.docuid = DV2.docuid) INNER JOIN dedocumentos DD2 ON (D2.docuid = DD2.docuid)                
                  INNER JOIN productos P2 ON (P2.productoid = DD2.productoid) 
                  WHERE D2.tipodoc = 'FVE' AND D2.fecanulado = '0000-00-00' AND D2.fecasentado <> '0000-00-00' AND D2.terid2 = T2.terid AND P2.porcenboni > 0 AND DV2.diaoperativo = '".$diaoperativo."'
                ) vtaespecial ,
                (
                  SELECT SUM(DD2.cantidad*DD2.valunitario*(P2.porcenboni/100)) FROM documentos D2 INNER JOIN docuventa DV2 ON (D2.docuid = DV2.docuid) INNER JOIN dedocumentos DD2 ON (D2.docuid = DD2.docuid)                
                  INNER JOIN productos P2 ON (P2.productoid = DD2.productoid) 
                  WHERE D2.tipodoc = 'FVE' AND D2.fecasentado <> '0000-00-00' AND D2.fecanulado = '0000-00-00' AND D2.terid2 = T2.terid AND P2.porcenboni > 0 AND DV2.diaoperativo = '".$diaoperativo."'
                ) especialganado ,
                (
                    SELECT SUM(DD3.unidades) FROM dedocumentos DD3 INNER JOIN productos P3 ON (P3.productoid = DD3.productoid)
                    INNER JOIN docuventa DV3 ON (DD3.docuid = DV3.docuid)
                    INNER JOIN documentos D3 ON (DD3.docuid = D3.docuid)
                    WHERE D3.tipodoc = 'FVE' AND D3.fecasentado <> '0000-00-00' AND P3.descripcion LIKE 'SURE%ZINC%' AND T2.terid = D3.terid2 AND DV3.diaoperativo = '".$diaoperativo."'
                ) surezinc , 
                 (
                    SELECT SUM(DD3.valtotal) FROM dedocumentos DD3 INNER JOIN productos P3 ON (P3.productoid = DD3.productoid)
                    INNER JOIN docuventa DV3 ON (DD3.docuid = DV3.docuid)
                    INNER JOIN documentos D3 ON (DD3.docuid = D3.docuid)
                    WHERE D3.tipodoc = 'FVE' AND D3.fecasentado <> '0000-00-00' AND (P3.productoid = 48019 OR P3.productoid = 60214) AND T2.terid = D3.terid2 AND DV3.diaoperativo = '".$diaoperativo."'
                ) agua , 
                 (
                    SELECT SUM(DD3.valtotal) FROM dedocumentos DD3 INNER JOIN productos P3 ON (P3.productoid = DD3.productoid)                    
                    INNER JOIN docuventa DV3 ON (DD3.docuid = DV3.docuid)
                    INNER JOIN documentos D3 ON (DD3.docuid = D3.docuid)
                    WHERE D3.tipodoc = 'FVE' AND D3.fecasentado <> '0000-00-00' AND P3.gruposprodid = 151 AND T2.terid = D3.terid2 AND DV3.diaoperativo = '".$diaoperativo."'
                ) ecar , 
                (
                  SELECT SUM(valtotal) 
                  FROM documentos DX INNER JOIN dedocumentos DDX ON (DX.docuid = DDX.docuid) 
                  INNER JOIN docuventa DVX ON (DVX.docuid = DX.docuid)
                  INNER JOIN productos PX ON (PX.productoid = DDX.productoid)
                  WHERE DX.tipodoc = 'FVE' AND (PX.gruposprodid = 596 OR PX.gruposprodid = 577 OR PX.gruposprodid = 578) AND DX.tipodoc = 'FVE' AND DX.fecasentado <> '0000-00-00' 
                  AND DVX.diaoperativo = DV.diaoperativo AND DX.terid2 = D.terid2 AND DV.diaoperativo = '".$diaoperativo."'
                ) licores 
                FROM documentos D INNER JOIN docuventa DV ON ( D.docuid = DV.docuid ) INNER JOIN terceros T2 ON (T2.terid = D.terid2) 
                WHERE D.tipodoc =  'FVE' AND D.fecasentado <>  '0000-00-00' AND D.fecanulado =  '0000-00-00' AND DV.diaoperativo = '".$diaoperativo."' GROUP BY 1,2,3,4,5 ORDER BY 6 DESC";

      $conex  = $clase->Conectar();
      $result = mysql_query($vsql2,$conex);
      $list = array();
      while($row = mysql_fetch_array($result)) 
        $list[] = $row;
      
      //echo $vsql2."<br>";
      //print_r($list);
        
      $param = json_encode($list);			  
      return($param); 
      
  } // Fin de DataVentaMySQL  


  /////////////////////////////////////////////////////////////////////////////
  //// Datos de Venta - en Sucursal
  /////////////////////////////////////////////////////////////////////////////  
  function DataVentaMySQL2($diaoperativo,$sucursal)
  {
      $clase = new Sistema();
      
      ///// Dia Operativo DMA
      $diaoperativodma = substr($diaoperativo,8,2)."/".substr($diaoperativo,5,2)."/".substr($diaoperativo,0,4);

      //// Busco la configuracion Diaria
      $vsql = "SELECT * FROM seguimientoalinstante WHERE diaoperativo = '".$diaoperativo."'";
      $conex  = $clase->Conectar();
      $result = mysql_query($vsql,$conex);
      $list = array();
      while($row = mysql_fetch_array($result)) 
        $list[] = $row;

      //// Armo la consulta segun la cantidad de Productos indicados que hayan  
      $vsql2 = "SELECT S.codigo codsuc , T.codvende , '".$diaoperativodma."' as diaoperativo ";      
      if($list[0]['pid01'] != "")   $vsql2.= " , SUM(IF(DD.productoid = ".$list[0]['pid01'].",DD.cantidad,0)) canvenp01 ";
      if($list[0]['pid02'] != "")   $vsql2.= " , SUM(IF(DD.productoid = ".$list[0]['pid02'].",DD.cantidad,0)) canvenp02 ";
      if($list[0]['pid03'] != "")   $vsql2.= " , SUM(IF(DD.productoid = ".$list[0]['pid03'].",DD.cantidad,0)) canvenp03 ";
      if($list[0]['pid04'] != "")   $vsql2.= " , SUM(IF(DD.productoid = ".$list[0]['pid04'].",DD.cantidad,0)) canvenp04 ";
      if($list[0]['pid05'] != "")   $vsql2.= " , SUM(IF(DD.productoid = ".$list[0]['pid05'].",DD.cantidad,0)) canvenp05 ";
      if($list[0]['pid06'] != "")   $vsql2.= " , SUM(IF(DD.productoid = ".$list[0]['pid06'].",DD.cantidad,0)) canvenp06 ";
      if($list[0]['pid07'] != "")   $vsql2.= " , SUM(IF(DD.productoid = ".$list[0]['pid07'].",DD.cantidad,0)) canvenp07 ";
      if($list[0]['pid08'] != "")   $vsql2.= " , SUM(IF(DD.productoid = ".$list[0]['pid08'].",DD.cantidad,0)) canvenp08 ";
      if($list[0]['pid09'] != "")   $vsql2.= " , SUM(IF(DD.productoid = ".$list[0]['pid09'].",DD.cantidad,0)) canvenp09 ";
      if($list[0]['pid10'] != "")   $vsql2.= " , SUM(IF(DD.productoid = ".$list[0]['pid10'].",DD.cantidad,0)) canvenp10 ";      
      $vsql2.= "FROM documentos D
                INNER JOIN sucursales S ON (D.sucursalid = S.sucursalid) 
                INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
                INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid)
                LEFT JOIN terceros T ON (T.terid = D.terid2) 
                WHERE DV.diaoperativo = '".$diaoperativodma."' AND S.codigo = '".$sucursal."' 
                GROUP BY 1,2,3
                ORDER BY 1,2,3 ASC";

      $conex  = $clase->Conectar();
      $result = mysql_query($vsql2,$conex);
      $list2 = array();
      while($row = mysql_fetch_array($result)) 
        $list2[] = $row;
      
      //echo $vsql2."<br>";
      //print_r($list2);
        
      $param = json_encode($list2);			  
      return($param); 
      
  } // Fin de DataVentaMySQL  

?>