<?PHP

 date_default_timezone_set('America/New_York');
 set_time_limit(0);
 session_start();
 
 class SistemaCRM
 {
    /// Propiedades Base de Datos
    public $UsuarioBD;
    public $ClaveBD;
    public $ServidorBD;
    public $NombreBD;       
   
    /// Atributos Ambiente CRM
    public $TituloVentana;
    public $NomUsuario;
    public $RolUsuario;
    
    //// Atributos Database Connection
    private $Conex;             // Database Connection Link
    public  $lastError;         // Holds the last error
    public  $lastQuery;         // Ultimo Query
    public  $result;            // Holds the MySQL query result
    public  $records;           // Holds the total number of records returned
    public  $affected;          // Holds the total number of records affected
    public  $rawResults;        // Holds raw 'arrayed' results
    public  $arrayedResult;     // Holds an array of the result    


    ////////////////////////////////////////////////
    //  * Class Constructor * Metodo contruc
    ////////////////////////////////////////////////
    function __construct($hostname='localhost', $port=3306, $persistant = false)
    {

       /// Cargo la Cadena de Conexion a la Base de Datos
       if(file_exists("../lib/datasource.ini"))
         $db = parse_ini_file("../lib/datasource.ini");
       else
         $db = parse_ini_file("../../lib/datasource.ini");
          
       $this->UsuarioBD  =  $db['UsuarioBD'];
       $this->ClaveBD    =  $db['ClaveBD'];
       $this->NombreBD   =  $db['NombreBD'];
       $this->ServidorBD =  $db['ServidorBD'];
       
       /// Asigno el Rol segun la Variable de Sesion
       switch ($_SESSION["ROL"]) 
       {
          case "SUP":
             $this->RolUsuario = "Supervisor de Zona";
          break;
          
          case "SAD":
             $this->RolUsuario = "Personal Oficinas";
          break;
       }

       $this->NomUsuario = $_SESSION['USERNAME'];
    }
    
    //////////////////////////////////////////////////////////////////////
    //  * Class Destructor * Metodo Destructor de la Clase
    //////////////////////////////////////////////////////////////////////
    function __destruct(){
        $this->closeConnection();
    }   
  
    ////////////////////////////////////////////////
    //  * Metodos de Acceso a Datos *
    //  Conectar a Base de datos
    ////////////////////////////////////////////////
    function Conectar($persistant = false)
    {
       
       $this->closeConnection();
        
       if($persistant)
       {
              $this->Conex = @mysql_pconnect($this->ServidorBD,$this->UsuarioBD,$this->ClaveBD);
         }else{
              $this->Conex = @mysql_connect($this->ServidorBD,$this->UsuarioBD,$this->ClaveBD);
       }  
        
       if(!$this->Conex)
       {
          $this->lastError = 'ERROR al conectar al Servidor !  <br><font color="blue">ERROR No. <b> 00 ' .mysql_errno($this->Conex) . "</font><font color=\"red\"></b><br>Detalle del Problema : <b>" .mysql_error($this->Conex);
          echo $this->lastError; exit;
          return false;
       }  
       
       if(!$this->UseDB()){
          $this->lastError = 'ERROR al conectar al Servidor !  <br>ERROR No. <b>' .mysql_errno($this->Conex) . "</b><br>Detalle del Problema : <b>" .mysql_error($this->Conex);
          echo $this->lastError; exit;
          return false;
       }
       
       $this->setCharset(); // TODO: remove forced charset find out a specific management
       return($this->Conex);
    }
    
    // Select database to use
    private function UseDB(){
        if(!mysql_select_db($this->NombreBD,$this->Conex)){
            $this->lastError = 'ERROR al Seleccionar la Base de Datos : ' . mysql_error($this->Conex);
            return false;
        }else{
            return true;
        }
    }
    
    public function commit(){
        return @mysql_query("COMMIT", $this->Conex);
    }
  
    public function rollback(){
        return @mysql_query("ROLLBACK", $this->Conex);
    }
    public function setCharset( $charset = 'UTF8' ) {
        return @mysql_set_charset( $this->SecureData($charset,'string'), $this->Conex);
    }

    ///////////////////////////////////////////////////
    /// Performs a 'mysql_real_escape_string' on the entire array/string
      private function SecureData($data, $types=array()){
        if(is_array($data)){
            $i = 0;
            foreach($data as $key=>$val){
                if(!is_array($data[$key])){
                    $data[$key] = $this->CleanData($data[$key], $types[$i]);
                    $data[$key] = mysql_real_escape_string($data[$key], $this->Conex);
                    $i++;
                }
            }
        }else{
            $data = $this->CleanData($data, $types);
            $data = @mysql_real_escape_string($data, $this->Conex);
        }
        return $data;
    }
    
    // clean the variable with given types
    // possible types: none, str, int, float, bool, datetime, ts2dt (given timestamp convert to mysql datetime)
    // bonus types: hexcolor, email
    private function CleanData($data, $type = ''){
        switch($type) {
            case 'none':
                    // useless do not reaffect just do nothing
            // $data = $data;
            break;
            case 'str':
            case 'string':
                settype( $data, 'string');
                break;
            case 'int':
            case 'integer':
                settype( $data, 'integer');
                break;
            case 'float':
                settype( $data, 'float');
                break;
            case 'bool':
            case 'boolean':
                settype( $data, 'boolean');
                break;
            // Y-m-d H:i:s
            // 2014-01-01 12:30:30
            case 'datetime':
                $data = trim( $data );
                $data = preg_replace('/[^\d\-: ]/i', '', $data);
                preg_match( '/^([\d]{4}-[\d]{2}-[\d]{2} [\d]{2}:[\d]{2}:[\d]{2})$/', $data, $matches );
                $data = $matches[1];
                break;
            case 'ts2dt':
                settype( $data, 'integer');
                $data = date('Y-m-d H:i:s', $data);
                break;
            // bonus types
            case 'hexcolor':
                preg_match( '/(#[0-9abcdef]{6})/i', $data, $matches );
                $data = $matches[1];
                break;
            case 'email':
                $data = filter_var($data, FILTER_VALIDATE_EMAIL);
                break;
            default:
                break;
        }
        return $data;
    }
        
    /////////////////////////////////////////////////////////////////////////
    /// Ejecuta una Instruccion SQL de accion INSERT - UPDATE - DELETE
    /////////////////////////////////////////////////////////////////////////    
    function EjecutarSQL($SQL)
    {
     $this->lastQuery = $SQL;
     $this->Conectar();
     if($this->result = @mysql_query($SQL, $this->Conex))
     {
            if (gettype($this->result) === 'resource') {
                $this->records  = @mysql_num_rows($this->result);
            } else {
               $this->records  = 0;
            }
            $this->affected = @mysql_affected_rows($this->Conex);
            if($this->records > 0){
                $this->arrayResults();
                return $this->arrayedResult;
            }else{
                return true;
            }
        }else{
            $this->lastError = @mysql_error($this->Conex);
            
            return false;
       }
      $this->closeConnection();
    }

   // ************************************************************
   // Busca el Campo RETORNO en la tabla TABLA por el campo CAMPO 
   // segun un CRITERIO
   // Recibe : CRITERIO - TABLA - CAMPO A BUSCAR - CAMPO A RETORNAR
   function BDLockup($criterio,$tabla,$campo,$retorno)
   {
       $campoEnc = "";
       $conex    = $this->Conectar();
       $consulta = "SELECT " . $retorno . " AS RET FROM " . $tabla . " WHERE " . $campo . " ='" . $criterio . "'";
       $this->lastQuery = $consulta;
       $result = @mysql_query($consulta,$conex);
       if($row = @mysql_fetch_array($result)) 
         $campoEnc = $row['RET'];
       
       @mysql_free_result($result); 
           $this->closeConnection();
       return($campoEnc);   
   }
  
   // ************************************************************
   // Ejecuta una consulta SQL y Devuelve el UNICO CAMPO econtrado
   // Si la consulta genera mas campos solo devuelve el 1,1
   // Recibe : La Consulta SQL a Ejecutar
   // Devuelve : El Campo encontrado 
   function SeleccionarUno($SQL)
   {
       $campoEnc = "";
       $conex  = $this->Conectar();
       $result = @mysql_query($SQL,$this->Conex);
       if($row = @mysql_fetch_array($result)) 
         $campoEnc = $row[0];
    
       @mysql_free_result($result); 
       $this->closeConnection();
       return($campoEnc);    
   }   

    /////////////////////////////////////////////////
    ///// Desconectar
    public function closeConnection()
    {
        if(@$this->Conex)
        {
               // Commit before closing just in case :)
               @$this->commit();
           @mysql_close($this->Conex);
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// Crea los Opcion de Combo para una tabla
    function OptionsCombo($tabla,$caption,$valor,$valordefecto)
    {  
       $vsql="SELECT ".$caption." caption ,".$valor." valor FROM ".$tabla." ORDER BY ".$valor." ASC";
       $conex  = $this->Conectar();
       $result = mysql_query($vsql,$conex); 
       $cont = '';  
       while($row = @mysql_fetch_array($result)){
         if($row['caption'] != "")
         {
           if($valordefecto == $row['valor'])
              $cont.='<option value="'.$row['valor'].'" selected> '.$row['caption'].'</option>';
           else
              $cont.='<option value="'.$row['valor'].'"> '.$row['caption'].'</option>';             
         }   
       }
       return($cont);
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// Crea los Opcion de Combo para una tabla
    function OptionsComboSQL($vsql,$caption,$valor,$valordefecto)
    {  
       $conex  = $this->Conectar();
       $result = mysql_query($vsql,$conex); 
       $cont = '';  
       while($row = @mysql_fetch_array($result)){
         if($row[$caption] != "")
         {
           if($valordefecto == $row['valor'])
              $cont.='<option value="'.$row[$valor].'" selected> '.$row[$caption].'</option>';
           else
              $cont.='<option value="'.$row[$valor].'"> '.$row[$caption].'</option>';             
         }   
       }
       return($cont);
    }

    ////////////////////////////////////////////////
    //  Function Asignar Titulo Ventana
    ////////////////////////////////////////////////
    function SetTitulo($titulo)
    {
       $this->TituloVentana = $titulo;
       return; 
    }

    ////////////////////////////////////////////////
    //  Function Asignar Titulo Ventana
    ////////////////////////////////////////////////
    function GetTitulo()
    {
       return($this->TituloVentana);
    }

    ////////////////////////////////////////////////
    //  Function Includes Librerias
    ////////////////////////////////////////////////
    function IncludesLibrerias()
    {
       $ret = ' <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1.0, user-scalable=no">
                <meta http-equiv="X-UA-Compatible" content="IE=edge">
                <meta name="msapplication-tap-highlight" content="no">
                <meta name="description" content="Materialize is a Material Design Admin Template,Its modern, responsive and based on Material Design by Google. ">
                <meta name="keywords" content="materialize, admin template, dashboard template, flat admin template, responsive admin template,">
  
                <!--TITULO EJEMPLO DE MATERIALIZE -->
                <!-- <title> '.$this->GetTitulo().' </title>-->
                <title> CRM - Dropos</title>

                <!-- Favicons-->
                <link rel="icon" href="images/favicon/favicon.ico" sizes="32x32">


                <!-- Favicons REVISAR PARA LAS OTRAS PLATAFORMAS-->
                <!--  <link rel="apple-touch-icon-precomposed" href="images/favicon/apple-touch-icon-152x152.png">-->
                <!-- For iPhone -->
                <!-- <meta name="msapplication-TileColor" content="#00bcd4">-->
                <!--  <meta name="msapplication-TileImage" content="images/favicon/mstile-144x144.png">-->
                <!-- For Windows Phone -->


                <!-- CORE CSS-->    
                <link href="css/materialize.css" type="text/css" rel="stylesheet" media="screen,projection">
                <link href="css/style.min.css" type="text/css" rel="stylesheet" media="screen,projection">
                <!-- Custome CSS-->    
                <link href="css/custom/custom.min.css" type="text/css" rel="stylesheet" media="screen,projection">


                <!-- INCLUDED PLUGIN CSS ON THIS PAGE -->
                <link href="js/plugins/perfect-scrollbar/perfect-scrollbar.css" type="text/css" rel="stylesheet" media="screen,projection">
                <link href="js/plugins/jvectormap/jquery-jvectormap.css" type="text/css" rel="stylesheet" media="screen,projection">
                <link href="js/plugins/chartist-js/chartist.min.css" type="text/css" rel="stylesheet" media="screen,projection">
                <script type="text/javascript" src="js/plugins/chartjs/Chart.js"></script>
                <link href="js/plugins/chartist-js/chartist.min.css" type="text/css" rel="stylesheet" media="screen,projection">
                <script type="text/javascript" src="http://code.jquery.com/jquery-2.1.3.js"></script>';
       
       return($ret); 
    }

    ////////////////////////////////////////////////
    //  Function LoaderEfect
    ////////////////////////////////////////////////
    function LoaderEfect()
    {

        $cont = '<div id="loader-wrapper">
                   <div id="loader"></div>        
                   <div class="loader-section section-left"></div>
                   <div class="loader-section section-right"></div>
                 </div>';
        
        return($cont);
    }      

    ////////////////////////////////////////////////
    //  Function Header
    ////////////////////////////////////////////////
    function Header()
    {
        $cont = '<header id="header" class="page-topbar">
                    <!-- start header nav-->
                    <div class="navbar-fixed">
                        <nav class="navbar-color">
                            <div class="nav-wrapper">
                                <ul class="left">                      
                                  <li><h1 class="logo-wrapper"><a href="index.php" class="brand-logo darken-1"><img src="images/materialize-logo.png" alt="materialize logo"></a> <span class="logo-text">Materialize</span></h1></li>
                                </ul>
                                <div class="header-search-wrapper hide-on-med-and-down">
                                    <i class="mdi-action-search"></i>
                                    <input type="text" name="Search" class="header-search-input z-depth-2" placeholder="Buscar Clientes"/>
                                </div>
                                <ul class="right hide-on-med-and-down">
                                  <!--  <li><a href="javascript:void(0);" class="waves-effect waves-block waves-light translation-button"  data-activates="translation-dropdown"><img src="images/flag-icons/United-States.png" alt="USA" /></a>
                                    </li> -->
                                    <li><a href="javascript:void(0);" class="waves-effect waves-block waves-light toggle-fullscreen"><i class="mdi-action-settings-overscan"></i></a>
                                    </li>
                                    <li><a href="javascript:void(0);" class="waves-effect waves-block waves-light notification-button" data-activates="notifications-dropdown"><i class="mdi-social-notifications"><small class="notification-badge">5</small></i>
                                    
                                    </a>
                                    </li>                        
                                    <li><a href="#" data-activates="chat-out" class="waves-effect waves-block waves-light chat-collapse"><i class="mdi-communication-chat"></i></a>
                                    </li>
                                </ul>
                                <!-- translation-button -->
                                <ul id="translation-dropdown" class="dropdown-content">
                                  <li>
                                    <a href="#!"><img src="images/flag-icons/Spain.png" alt="Espanol" />  <span class="language-select">Espa&ntilde;ol</span></a>
                                  </li>
                                  <li>
                                    <a href="#!"><img src="images/flag-icons/China.png" alt="Chinese" />  <span class="language-select">Chinese</span></a>
                                  </li>
                                  <li>
                                    <a href="#!"><img src="images/flag-icons/United-States.png" alt="English" />  <span class="language-select">English</span></a>
                                  </li>
                                </ul>
                                <!-- notifications-dropdown -->
                                <ul id="notifications-dropdown" class="dropdown-content">
                                  <li>
                                    <h5>NOTIFICATIONS <span class="new badge">5</span></h5>
                                  </li>
                                  <li class="divider"></li>
                                  <li>
                                    <a href="#!"><i class="mdi-action-add-shopping-cart"></i> A new order has been placed!</a>
                                    <time class="media-meta" datetime="2015-06-12T20:50:48+08:00">2 hours ago</time>
                                  </li>
                                  <li>
                                    <a href="#!"><i class="mdi-action-stars"></i> Completed the task</a>
                                    <time class="media-meta" datetime="2015-06-12T20:50:48+08:00">3 days ago</time>
                                  </li>
                                  <li>
                                    <a href="#!"><i class="mdi-action-settings"></i> Settings updated</a>
                                    <time class="media-meta" datetime="2015-06-12T20:50:48+08:00">4 days ago</time>
                                  </li>
                                  <li>
                                    <a href="#!"><i class="mdi-editor-insert-invitation"></i> Director meeting started</a>
                                    <time class="media-meta" datetime="2015-06-12T20:50:48+08:00">6 days ago</time>
                                  </li>
                                  <li>
                                    <a href="#!"><i class="mdi-action-trending-up"></i> Generate monthly report</a>
                                    <time class="media-meta" datetime="2015-06-12T20:50:48+08:00">1 week ago</time>
                                  </li>
                                </ul>
                            </div>
                        </nav>
                    </div>
                    <!-- end header nav-->
                </header>';
        return($cont);
    }               

    ////////////////////////////////////////////////
    //  Function LateralMenu
    ////////////////////////////////////////////////
    function LateralMenu()
    {
        if(($_SESSION['USERNAME'] == 'SAIDRODRIGUEZ')||($_SESSION['USERNAME'] == 'J.DURAN'))
           return($this->LateralMenuAdministrador());
        else
           return($this->LateralMenuUsuario());  
    }
    ///////////////////////////////////////////////////////////////
    //// Menu del Usuario - Version Usuario Restringido
    ///////////////////////////////////////////////////////////////
    function LateralMenuAdministrador()
    {
        $cont = '<aside id="left-sidebar-nav">
                <ul id="slide-out" class="side-nav fixed leftside-navigation">
                <li class="user-details cyan darken-2">
                <div class="row">
                    <div class="col col s4 m4 l4">
                        <img src="images/avatar.jpg" alt="" class="circle responsive-img valign profile-image">
                    </div>
                    <div class="col col s8 m8 l8">
                        <ul id="profile-dropdown" class="dropdown-content">
                            <li><a href="#"><i class="mdi-action-face-unlock"></i> Mi Perfil</a>
                            </li>
                            <li><a href="#"><i class="mdi-action-settings"></i> Ajustes</a>
                            </li>
                            <li><a href="#"><i class="mdi-communication-live-help"></i> Ayuda</a>
                            </li>
                            <li class="divider"></li>
                            <li><a href="../usuarios.php?opcion=salir"><i class="mdi-hardware-keyboard-tab"></i> Salir</a>
                            </li>
                        </ul>
                        <a class="btn-flat dropdown-button waves-effect waves-light white-text profile-btn" href="#" data-activates="profile-dropdown">
                        '.$this->NomUsuario.'  <i class="mdi-navigation-arrow-drop-down right"></i></a>
                        <p class="user-roal"> '.$this->RolUsuario.' </p>
                    </div>
                </div>
                </li>
                <li class="li-hover"><p class="ultra-small margin more-text">CRM</p></li>
                <li class="bold active"><a href="index.php" class="waves-effect waves-cyan"><i class="mdi-action-dashboard"></i> Dashboard</a>
                </li>
                <li class="bold"><a href="listacontactos.php" class="waves-effect waves-cyan"><i class="mdi-communication-quick-contacts-dialer"></i> Historial Contactos </a>
                </li>
                <li class="bold"><a href="crearcontacto.php" class="waves-effect waves-cyan"><i class="mdi-communication-forum"></i> Nuevo Contacto <span class="new badge"></span></a>
                </li>
                <li class="bold"><a href="llamadasdia.php" target="_blank" class="waves-effect waves-cyan"><i class="mdi-action-perm-phone-msg"></i> Llamadas del Dia </a>
                </li>
                <li class="bold"><a href="llamadasdia.php?opcion=estadisticas" class="waves-effect waves-cyan"><i class="mdi-editor-insert-chart"></i> Estadistica de Llamadas </a>
                </li>
                <li class="li-hover"><div class="divider"></div></li>
                <li class="li-hover"><p class="ultra-small margin more-text">CVP</p></li>
                <li class="bold"><a href="app-calendar.html" class="waves-effect waves-cyan"><i class="mdi-action-account-circle"></i> Cliente </a>
                </li>
                <li class="bold"><a href="app-calendar.html" class="waves-effect waves-cyan"><i class="mdi-communication-message"></i> Vendedor </a>
                </li>
                <li class="bold"><a href="app-calendar.html" class="waves-effect waves-cyan"><i class="mdi-action-bookmark-outline"></i> Producto </a>
                </li>
                <li class="bold"><a href="app-calendar.html" class="waves-effect waves-cyan"><i class="mdi-action-account-balance"></i> Sucursal </a>
                </li>
                <li class="li-hover"><div class="divider"></div></li>
                <li class="li-hover"><p class="ultra-small margin more-text">Venta Ult dias (Bon|Gral)</p></li>

                        <div class="col s12 m12 l12">
                            
                           <img src="graventas7dias.php" border="0" width="100%" height="100%">
                                
                        </div>    

                </li>
            </ul>
                <a href="#" data-activates="slide-out" class="sidebar-collapse btn-floating btn-medium waves-effect waves-light hide-on-large-only cyan"><i class="mdi-navigation-menu"></i></a>
            </aside>';         
   return($cont);
  } 
 
  ///////////////////////////////////////////////////////////////
  //// Menu del Usuario - Version Usuario Restringido
  ///////////////////////////////////////////////////////////////
  function LateralMenuUsuario()
  {
        $cont = '<aside id="left-sidebar-nav">
                <ul id="slide-out" class="side-nav fixed leftside-navigation">
                <li class="user-details cyan darken-2">
                <div class="row">
                    <div class="col col s4 m4 l4">
                        <img src="images/avatar.jpg" alt="" class="circle responsive-img valign profile-image">
                    </div>
                    <div class="col col s8 m8 l8">
                        <ul id="profile-dropdown" class="dropdown-content">
                            <li><a href="#"><i class="mdi-action-face-unlock"></i> Mi Perfil</a>
                            </li>
                            <li><a href="#"><i class="mdi-action-settings"></i> Ajustes</a>
                            </li>
                            <li><a href="#"><i class="mdi-communication-live-help"></i> Ayuda</a>
                            </li>
                            <li class="divider"></li>
                            <li><a href="../usuarios.php?opcion=salir"><i class="mdi-hardware-keyboard-tab"></i> Salir</a>
                            </li>
                        </ul>
                        <a class="btn-flat dropdown-button waves-effect waves-light white-text profile-btn" href="#" data-activates="profile-dropdown">
                        '.$this->NomUsuario.'  <i class="mdi-navigation-arrow-drop-down right"></i></a>
                        <p class="user-roal"> '.$this->RolUsuario.' </p>
                    </div>
                </div>
                </li>
                <li class="li-hover"><p class="ultra-small margin more-text">CRM</p></li>
                <li class="bold"><a href="llamadasdia.php" target="_blank" class="waves-effect waves-cyan"><i class="mdi-action-perm-phone-msg"></i> Llamadas del Dia </a>
                </li>
                <li class="bold"><a href="llamadasdia.php?opcion=estadisticas" class="waves-effect waves-cyan"><i class="mdi-editor-insert-chart"></i> Estadistica de Llamadas </a>
                </li>
                <li class="li-hover"><div class="divider"></div></li>
            </aside>';         
   return($cont);
  } 
  
  ////////////////////////////////////////////////
  //  Function LateralDerechaMenu
  ////////////////////////////////////////////////
  function LateralDerechaMenu()
  {
     $cont = '<aside id="right-sidebar-nav">
                <ul id="chat-out" class="side-nav rightside-navigation">
                    <li class="li-hover">
                    <a href="#" data-activates="chat-out" class="chat-close-collapse right"><i class="mdi-navigation-close"></i></a>
                    <div id="right-search" class="row">
                        <form class="col s12">
                            <div class="input-field">
                                <i class="mdi-action-search prefix"></i>
                                <input id="icon_prefix" type="text" class="validate">
                                <label for="icon_prefix">Search</label>
                            </div>
                        </form>
                    </div>
                    </li>
                    <li class="li-hover">
                        <ul class="chat-collapsible" data-collapsible="expandable">
                        <li>
                            <div class="collapsible-header teal white-text active"><i class="mdi-social-whatshot"></i>Recent Activity</div>
                            <div class="collapsible-body recent-activity">
                                <div class="recent-activity-list chat-out-list row">
                                    <div class="col s3 recent-activity-list-icon"><i class="mdi-action-add-shopping-cart"></i>
                                    </div>
                                    <div class="col s9 recent-activity-list-text">
                                        <a href="#">just now</a>
                                        <p>Jim Doe Purchased new equipments for zonal office.</p>
                                    </div>
                                </div>
                                <div class="recent-activity-list chat-out-list row">
                                    <div class="col s3 recent-activity-list-icon"><i class="mdi-device-airplanemode-on"></i>
                                    </div>
                                    <div class="col s9 recent-activity-list-text">
                                        <a href="#">Yesterday</a>
                                        <p>Your Next flight for USA will be on 15th August 2015.</p>
                                    </div>
                                </div>
                                <div class="recent-activity-list chat-out-list row">
                                    <div class="col s3 recent-activity-list-icon"><i class="mdi-action-settings-voice"></i>
                                    </div>
                                    <div class="col s9 recent-activity-list-text">
                                        <a href="#">5 Days Ago</a>
                                        <p>Natalya Parker Send you a voice mail for next conference.</p>
                                    </div>
                                </div>
                                <div class="recent-activity-list chat-out-list row">
                                    <div class="col s3 recent-activity-list-icon"><i class="mdi-action-store"></i>
                                    </div>
                                    <div class="col s9 recent-activity-list-text">
                                        <a href="#">Last Week</a>
                                        <p>Jessy Jay open a new store at S.G Road.</p>
                                    </div>
                                </div>
                                <div class="recent-activity-list chat-out-list row">
                                    <div class="col s3 recent-activity-list-icon"><i class="mdi-action-settings-voice"></i>
                                    </div>
                                    <div class="col s9 recent-activity-list-text">
                                        <a href="#">5 Days Ago</a>
                                        <p>Natalya Parker Send you a voice mail for next conference.</p>
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="collapsible-header light-blue white-text active"><i class="mdi-editor-attach-money"></i>Sales Repoart</div>
                            <div class="collapsible-body sales-repoart">
                                <div class="sales-repoart-list  chat-out-list row">
                                    <div class="col s8">Target Salse</div>
                                    <div class="col s4"><span id="sales-line-1"></span>
                                    </div>
                                </div>
                                <div class="sales-repoart-list chat-out-list row">
                                    <div class="col s8">Payment Due</div>
                                    <div class="col s4"><span id="sales-bar-1"></span>
                                    </div>
                                </div>
                                <div class="sales-repoart-list chat-out-list row">
                                    <div class="col s8">Total Delivery</div>
                                    <div class="col s4"><span id="sales-line-2"></span>
                                    </div>
                                </div>
                                <div class="sales-repoart-list chat-out-list row">
                                    <div class="col s8">Total Progress</div>
                                    <div class="col s4"><span id="sales-bar-2"></span>
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="collapsible-header red white-text"><i class="mdi-action-stars"></i>Favorite Associates</div>
                            <div class="collapsible-body favorite-associates">
                                <div class="favorite-associate-list chat-out-list row">
                                    <div class="col s4"><img src="images/avatar.jpg" alt="" class="circle responsive-img online-user valign profile-image">
                                    </div>
                                    <div class="col s8">
                                        <p>Eileen Sideways</p>
                                        <p class="place">Los Angeles, CA</p>
                                    </div>
                                </div>
                                <div class="favorite-associate-list chat-out-list row">
                                    <div class="col s4"><img src="images/avatar.jpg" alt="" class="circle responsive-img online-user valign profile-image">
                                    </div>
                                    <div class="col s8">
                                        <p>Zaham Sindil</p>
                                        <p class="place">San Francisco, CA</p>
                                    </div>
                                </div>
                                <div class="favorite-associate-list chat-out-list row">
                                    <div class="col s4"><img src="images/avatar.jpg" alt="" class="circle responsive-img offline-user valign profile-image">
                                    </div>
                                    <div class="col s8">
                                        <p>Renov Leongal</p>
                                        <p class="place">Cebu City, Philippines</p>
                                    </div>
                                </div>
                                <div class="favorite-associate-list chat-out-list row">
                                    <div class="col s4"><img src="images/avatar.jpg" alt="" class="circle responsive-img online-user valign profile-image">
                                    </div>
                                    <div class="col s8">
                                        <p>Weno Carasbong</p>
                                        <p>Tokyo, Japan</p>
                                    </div>
                                </div>
                                <div class="favorite-associate-list chat-out-list row">
                                    <div class="col s4"><img src="images/avatar.jpg" alt="" class="circle responsive-img offline-user valign profile-image">
                                    </div>
                                    <div class="col s8">
                                        <p>Nusja Nawancali</p>
                                        <p class="place">Bangkok, Thailand</p>
                                    </div>
                                </div>
                            </div>
                        </li>
                        </ul>
                    </li>
                </ul>
            </aside>';
      return($cont);  
   }

  ////////////////////////////////////////////////
  //  Function Pie Pagina
  ////////////////////////////////////////////////
  function Footer()
  {
     $cont = '<footer class="page-footer">
             <div class="footer-copyright">
            <div class="container">
                <b>DROPOS ERP</b> - M&oacute;dulo CRM 
                <span class="right">Copyright © 2018 <a class="grey-text text-lighten-4" href="http://www.farmanorte.com.co" target="_blank">SoftDromedicas</a> Derechos Reservados</span>
             </div>
          </div>
        </footer>';
      return($cont);    
  }

  ////////////////////////////////////////////////
  //  Function Plugins
  ////////////////////////////////////////////////
  function Plugins()
  {
      $cont = '
            <!-- jQuery Library -->
            <script type="text/javascript" src="js/plugins/jquery-1.11.2.min.js"></script>    
            <!--materialize js-->
            <script type="text/javascript" src="js/materialize.min.js"></script>
            <!--scrollbar-->
            <script type="text/javascript" src="js/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
            

            <!-- chartist -->
            <script type="text/javascript" src="js/plugins/chartist-js/chartist.min.js"></script>   

            <!-- chartjs -->
            <script type="text/javascript" src="js/plugins/chartjs/chart.min.js"></script>
            <script type="text/javascript" src="js/plugins/chartjs/chart-script.js"></script>

            <!-- sparkline -->
            <script type="text/javascript" src="js/plugins/sparkline/jquery.sparkline.min.js"></script>
            <script type="text/javascript" src="js/plugins/sparkline/sparkline-script.js"></script>
            
            <!--jvectormap-->
            <script type="text/javascript" src="js/plugins/jvectormap/jquery-jvectormap-1.2.2.min.js"></script>
            <script type="text/javascript" src="js/plugins/jvectormap/jquery-jvectormap-world-mill-en.js"></script>
            <script type="text/javascript" src="js/plugins/jvectormap/vectormap-script.js"></script>
            
            <!--plugins.js - Some Specific JS codes for Plugin Settings-->
            <script type="text/javascript" src="js/plugins.min.js"></script>
            <!--custom-script.js - Add your own theme custom JS-->
            <script type="text/javascript" src="js/custom-script.js"></script>';

      return($cont);      
  }

  ////////////////////////////////////////////////////
  //  Function Plugins2 Son los Plugins con Tables
  ////////////////////////////////////////////////////
  function Plugins2()
  {
      $cont = '<!-- jQuery Library -->
                <script type="text/javascript" src="js/plugins/jquery-1.11.2.min.js"></script>    
                <!--materialize js-->
                <script type="text/javascript" src="js/materialize.min.js"></script>
                <!--prism-->
                <script type="text/javascript" src="js/plugins/prism/prism.js"></script>
                <!--scrollbar-->
                <script type="text/javascript" src="js/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
                <!-- data-tables -->
                <script type="text/javascript" src="js/plugins/data-tables/js/jquery.dataTables.min.js"></script>
                <script type="text/javascript" src="js/plugins/data-tables/data-tables-script.js"></script>
                <!-- chartist -->
                <script type="text/javascript" src="js/plugins/chartist-js/chartist.min.js"></script>   
                
                <!--plugins.js - Some Specific JS codes for Plugin Settings-->
                <script type="text/javascript" src="js/plugins.min.js"></script>
                <!--custom-script.js - Add your own theme custom JS-->
                <script type="text/javascript" src="js/custom-script.js"></script>
                <script type="text/javascript">
                    /*Show entries on click hide*/
                    $(document).ready(function(){
                        $(".dropdown-content.select-dropdown li").on( "click", function() {
                            var that = this;
                            setTimeout(function(){
                            if($(that).parent().hasClass(\'active\')){
                                    $(that).parent().removeClass(\'active\');
                                    $(that).parent().hide();
                            }
                            },100);
                        });
                    });
                </script>';

       return($cont);         
   }     
   
  ///////////////////////////////////////////////////////
  /// Funcion Encabezado
  /// Se coloca para Inicializar el entorno
  /// y generar paginas dinámicamente
  function Encabezado($titulo)
  {
         $this->SetTitulo($titulo);

         $cont = '
                <!DOCTYPE html>
                <html lang="es">
                <head>
                  <style>
                    body {font-family: Arial, Helvetica, sans-serif;}
                    * {box-sizing: border-box;}

                    /* Button used to open the contact form - fixed at the bottom of the page */
                    .open-button {
                      background-color: #555;
                      color: white;
                     /* padding: 16px 20px;*/
                      padding: 6px 10px;
                      border: none;
                      cursor: pointer;
                      opacity: 0.8;
                      /*position: fixed;*/
                      bottom: 23px;
                      right: 28px;
                     /* width: 280px;*/
                    }

                    /* The popup form - hidden by default */
                    .form-popup {
                      display: none;
                    /*  position: fixed;*/
                      bottom: 0;
                      /*right: 15px;*/
                    /*  border: 3px solid #f1f1f1;*/
                      z-index: 9;
                    }

                    /* Add styles to the form container */
                    .form-container {
                      max-width: 100%;
                      padding: 10px;
                      background-color: #82828ae6;
                    }

                    /* Full-width input fields */
                    .form-container input[type=text], .form-container input[type=password] {
                      width: 100%;
                      padding: 15px;
                      margin: 5px 0 22px 0;
                      border: none;
                     /* background: #f1f1f1;*/
                    }

                    /* When the inputs get focus, do something *//*
                    .form-container input[type=text]:focus, .form-container input[type=password]:focus {
                      background-color: #ddd;
                      outline: none;
                    }*/

                    /* Set a style for the submit/login button */
                    .form-container .btn {
                      background-color: #4CAF50;
                      color: white;
                      /*padding: 16px 20px;*/
                      border: none;
                      cursor: pointer;
                      width: 48%;
                      margin-bottom:10px;
                      opacity: 0.8;
                    }

                    /* Add a red background color to the cancel button */
                    .form-container .cancel {
                      background-color: red;
                      width: 48%;
                    }

                    /* Add some hover effects to buttons */
                    .form-container .btn:hover, .open-button:hover {
                      opacity: 1;
                    }
                  </style>
                        ';
      
         $cont.= $this->IncludesLibrerias();

         $cont.= '
                  </head>
                  <body>
                  <!-- Start Page Loading -->
                 ';

         $cont.= $this->LoaderEfect();       

         $cont.='
                  <!-- End Page Loading -->
                  <!-- //////////////////////////////////////////////////////////////////////////// -->
                  <!-- START HEADER -->
                ';

         $cont.= $this->Header();       
         $cont.= ' 
                  <!-- END HEADER -->
                  <!-- //////////////////////////////////////////////////////////////////////////// -->
                  <!-- START MAIN -->';

         if(($_SESSION['USERNAME'] != "ADMINISTRADOR")&&($_SESSION['USERNAME'] != "VENDEDOR"))         
         {
                $cont.='<div id="main">
                        <!-- START WRAPPER -->
                        <div class="wrapper">
                        <!-- START LEFT SIDEBAR NAV-->
                        ';
                $cont.= $this->LateralMenu();          
         }
  
         $cont.= '
                 <!-- END LEFT SIDEBAR NAV-->
                 <!-- //////////////////////////////////////////////////////////////////////////// -->
                 <!-- START CONTENT -->
                 <section id="content">
                 <!--start container-->
                 <div class="container">
                ';
         
         return($cont);
   }

    //////////////////////////////////////////////////////////////////////////////////////////
    function CrearComboEsp($nombrecombo,$vsql,$caption,$valor,$valordefecto,$incluirblanco,$otros)
    {  
      $conex = $this->Conectar();
      $result = @mysql_query($vsql,$conex); 
      $cont = '<SELECT name="'.$nombrecombo.'" onkeypress="return TabulaEnter(this, event)" '.$otros.' >';
     
      if($incluirblanco == "S")
        $cont.='<option value=""> </option>';
        
      while($row = @mysql_fetch_row($result)){
        if($row[0] != "")
        {
          if($valordefecto == $row[0])
              $cont.='<option value="'.$row[0].'" selected> '.$row[1].'</option>';
          else
             $cont.='<option value="'.$row[0].'"> '.$row[1].'</option>';		 		
        }	 
      }
         $cont.='</SELECT>';	   
      return($cont);
   }
   
   ///////////////////////////////////////////////////////
   /// Funcion Camino
   /// Se coloca para Cerrar el Entorno de la Pagina
   function Camino($titulo,$links)
   {
       $cont = '<!--breadcrumbs start-->
                <div id="breadcrumbs-wrapper">
                    <!-- Search for small screen -->
                    <div class="header-search-wrapper grey hide-on-large-only">
                        <i class="mdi-action-search active"></i>
                        <input type="text" name="Search" class="header-search-input z-depth-2" placeholder="Explore Materialize">
                    </div>
                  <div class="container">
                    <div class="row">
                      <div class="col s12 m12 l12">
                        <h5 class="breadcrumbs-title">'.$titulo.'</h5>
                        <ol class="breadcrumbs">
                            <li><a href="#">Lista de Contactos</a></li>
                            <li class="active">Últimos Contactos</li>
                        </ol>
                      </div>
                    </div>
                  </div>
                </div>
                <!--breadcrumbs end-->';

        return($cont);        
   }

   ///////////////////////////////////////////////////////
   /// Funcion PiePagina
   /// Se coloca para Cerrar el Entorno de la Pagina
   function PiePagina()
   {
       $cont = ' <!-- START FOOTER -->';
       $cont.= $this->Footer();       
       $cont.=' <!-- END FOOTER -->';
       $cont.= $this->Plugins();
       $cont.=' </body> </html>';
       
       return($cont);
   } 

   ///////////////////////////////////////////////////////
   /// Funcion PiePagina
   /// Se coloca para Cerrar el Entorno de la Pagina
   function PiePagina2()
   {
       $cont = ' <!-- START FOOTER -->';
       $cont.= $this->Footer();       
       $cont.=' <!-- END FOOTER -->';
       $cont.= $this->Plugins2();
       $cont.='

        </body> </html>';
       
       return($cont);
   } 

   function CargarLlamadasDropos()
   {
   	   $clase = new SistemaCRM();
   	   $clase->Conectar();

   	   $vsql = "SELECT DVDIAOPE , ADDDATE(FECHADOC , INTERVAL AGENDO DAY) LLAMAR ,  ADDDATE(FECHADOC , INTERVAL P.duracionesti DAY) LLAMAR2 , PREFIJODOC , NUMERODOC , NOMSUCDOC , CODPRODUCTO , NOMPRODUCTO , DEUNICOM , DEUNIFRA , 
CODVENDOC , NOMVENDOC , APEVENDOC , P.duracionesti , AGENDO , NOMBRESCLIDOC , APECLIDOC , TELCLIDOC , DEVALUNI 
FROM consolida1 C INNER JOIN productos P ON (C.CODPRODUCTO = P.codigo) 
WHERE C.TIPODOC = 'FVE' AND ((ADDDATE(FECHADOC , INTERVAL AGENDO DAY) BETWEEN '2018-08-17 00:00:00' AND '2018-08-17 23:59:59')
OR (P.recompra = 'CHECKED' AND P.duracionesti > 0 AND ADDDATE(FECHADOC , INTERVAL P.duracionesti DAY) BETWEEN '2018-08-17 00:00:00' AND '2018-08-17 23:59:59'))
ORDER BY MOMENTODOC ASC";
   }

} /// Fin de la Clase