<?PHP
     session_start(); 

     /// Aplico la Zona horaria de Colombia
     date_default_timezone_set('America/Bogota');
	  setlocale( LC_TIME, 'spanish' );

     include("lib/Sistema.php");
     require_once 'lib/PHPExcel.php';
     ini_set('display_errors', TRUE);
     ini_set('display_startup_errors', TRUE);

     $codsucursal = $_SESSION['G_SUCURSALPOS'];
     $contpayless = "";
     /* ////////////////////////////////////////////////////////////////////////////
                           IMPLEMENTACION RAPPI PAYLESS  

        Solo usaremos 4 End Points que se implementan a continuacion

        1. Autenticacion : Obtiene un Token para usar a lo largo de la Transaccion
        2. OrdenDetais   : Con el CodBarra se obtiene el Order ID
        3. Authorization : Enviando el OrderID y el Basket en JSON Rappi retorna
                           Si la orden es Autorizada o no
        4. Cancel        : En caso de No obtener una respuesta a los 30 Seg se debe  
                           consumir esta API para cancelar la Transacción.

                                
        Se crean Funciones para los diferentes pasos de la Integracion y se muestra 
        el resultado en Pantalla Completa. Finalmente regresa a la Factura  

     ////////////////////////////////////////////////////////////////////////////// */
     
     /////////////////////////////////////
     //// Parametros Entorno Productivo
     $domain     = "https://services.grability.rappi.com/";
     $retailer   = "FarmanorteComt"; 
     $secret     = "bd112ca8d575ab8";    /// Productivo                
     $terminal_id = "123456";
     $terminal_tran_id = "1743722654663";
     
     /////////////////////////////////////
     //// Parametros Ambiente de Pruebas
     /*
     $domain   = "https://microservices.dev.rappi.com/";
     $retailer = "FarmanorteComt"; 
     $secret   = "5e3e8eecbb84ab9";    /// Test 
     $terminal_id = "01-82";
     $terminal_tran_id = "1743722654663";
     */

     ////////////////////////////////////////////////
     //// Valido que el Docuid Exista
     $docuid = $_GET['docuid'];
     if($docuid == "")    $docuid = @$_POST['docuid'];
     $codbarra = $_GET['codbarra'];
     if($codbarra == "")  $codbarra = @$_POST['codbarra'];
     
     if(($docuid == "")||($codbarra == ""))
     {
         echo"<h1> Imposible Ejecutar Payless </h1>"; 
         echo"<h3> Los campos Docuid y Cod Barra son Requeridos </h3>"; 
         echo'<a href="finalizarfactura.php?docuid='.$docuid.'"> <input type="button" value="<< Volver a la Factura"> </a>';
         exit;
     }

     //// Capturo la Opcion
     $opcion = @$_GET['opcion'];        

     //// Guardo el Cod Sucursal en una Variable 
     $CODSUCURSALX = $_SESSION['G_SUCURSALPOS'];

     //// Paso 1. Autenticacion
     $AccessToken = Paso1Autenticacion($domain,$retailer,$secret);     
     
     if(strlen($AccessToken)>0)
        $contpayless.= " Autenticaci&oacute;n ... <b> Ok </b>"; 
     else
        $contpayless.= " Autenticaci&oacute;n ... <b> Error </b>"; 

     $contpayless.= "<br><br>";

     //// Paso 2. Order Details con el codigo de barras que pasa el usuario
     $Obj1 = Paso2OrderDetails($domain,$AccessToken,$codbarra); 
     //print_r($Obj1);
     
     $Orderid = @$Obj1->order_id;
     if(strlen($Orderid)>0)
        $contpayless.= "Obteniendo detalles de la Orden ... <b>OK<b><BR>El C&oacute;digo de Barras es Correcto!<br></b>"; 
     else
     {
        $contpayless.= "Obteniendo detalles de la Orden ... <b>ERROR</b>"; 
        $ObjError = $Obj1->error;
        $contpayless.= "<br> <font color=red> Error Code : <B>".$ObjError->code."</b><br>";
        $contpayless.= "Detalle del Error : <b>".$ObjError->message."<br><br>";
        $contpayless.= '<a href="finalizarfactura.php?docuid='.$docuid.'" class="btn btn-danger"> << Volver a la Factura </a>';
     }
     
     
     //// Paso 3. Authorize 
     if(strlen($Orderid)>0)
     {
         $Obj2   = Paso3Authorization($domain,$retailer,$secret,$terminal_id,$terminal_tran_id,$codbarra,$docuid,$Obj1,$AccessToken,$codsucursal);                 
         $status = @$Obj2->status;               
         if($status == "")
         {
               $codeautoriza = @$Obj2->code;             
               if($codeautoriza == "")
               {
                  $ObjError2 = $Obj2->error;
                  $status  = $ObjError2->code;
                  $Message = $ObjError2->message;
               }
         }

         if($status == "payment_authorization_request_succeeded")  
         {
               $contpayless.= "</b> <font color=blue>";
               $contpayless.= "Status : <b> ".$status." </b><br>"; 
               $contpayless.= '<img src="images/basicas/check_gif.gif" border="0">'; 
               $contpayless.= "<h3> Orden Autorizada Exitosamente </h3>";                      
               $contpayless.= "Redireccionando ... Por Favor Espere ....<br>";
               $contpayless.= '<script language="javascript">
                                 <!--
                                 function redireccionarPagina() {
                                    window.location = "ventas.php?opcion=preasentarrappi&docuid='.$docuid.'";
                                  }
                                  setTimeout("redireccionarPagina()", 2000);
                                 -->
                               </script>';
         }
         else
         {
               $contpayless.= "<br><br></b><font color=red>";
               $contpayless.= "Status Code : <b>".$status."</b> <br>"; 
               $contpayless.= "Mensaje : <b>".strtoupper($Message)."</b> <br>";
               $contpayless.= "<h2> ORDEN NO AUTORIZADA <br> NO ENTREGUE LOS PRODUCTOS </h2><br>"; 
               $contpayless.= '<a href="finalizarfactura.php?docuid='.$docuid.'" class="btn btn-danger"> << Volver a la Factura </a>';
               $contpayless.= "<br><br>";                 
         }
     }
     else
     {
        $contpayless.= "<br><br><font color=black>";
        $contpayless.= "No se puede Procesar la Orden.<br>Orden No existe o C&oacute;digo Incorrecto";
        $contpayless.= "<h2> ORDEN NO AUTORIZADA <br> NO ENTREGUE LOS PRODUCTOS </h2><br>"; 
     }

    /////////////////////////////////////////////////      
    //// Muestro el Resultado en Pantalla
     echo'
      <!doctype html>
      <html lang="es" data-bs-theme="auto">
      <head>
         
         <meta charset="utf-8">
         <meta name="viewport" content="width=device-width, initial-scale=1">
         <meta name="description" content="">
         <meta name="author" content="Said Rodriguez Castiblanco">
         <meta name="generator" content="Hugo 0.111.3">
         <title>Payless Rappi DROPOS</title>
         
         <link href="assets/dist/css/bootstrap.min.css" rel="stylesheet">    
         <script src="assets/dist/js/bootstrap.bundle.min.js"></script>
         <script src="assets/dist/js/jquery.min.js"></script>

      </head>
      <body class="bg-body-tertiary">

         <center>
            
         <div class="card w-75 text-center">
            <h5 class="card-header">DROPOS ERP --> Rappi Payless</h5>
            <div class="card-body">
               <img src="images/integraciones/rappi.png" border=0>
               <h5 class="card-title">Analizando Orden ...</h5>
                  <p class="card-text">'.$contpayless.'</p>            
               </div>
               <div class="card-footer text-muted">
                  Resultado de la Integracion con Payless de Rappi
            </div>
         </div>

         
      </body>
      </html>';         
      exit;

     /////////////////////////////////////////////////////////////
     ///   FUNCIONES PARA LA IMPLEMENTACION DE RAPPI PAYLESS   ///
     /////////////////////////////////////////////////////////////


     ///////////////////////////////////////////////////////////////////////////
     ///  4. Con todos los Parametros de la Venta - Los envio a CANCELAR ORDEN
     ///////////////////////////////////////////////////////////////////////////
     function Paso4Cancel($domain,$retailer,$secret,$terminal_id,$terminal_tran_id,$codbarra,$docuid,$objdata)
     {
        //// Creo el JSON de MI Basket de MI Factura
        $jsonMiBasket = "[]";
        $totalfactura = TotalFactura($docuid);
        $totalivafactura = TotalIVAFactura($docuid);
        $data = DatosVendedorFactura($docuid);
        //$store_id = TiendaID(); 
        $porciones = explode("|", $data);
        $codvende = $porciones[0];
        $nomvende = $porciones[1];
        
        //// Creo el JSON de Entrada
        $jsonEntrada = '{
                           "currency": "COP",
                           "amount": '.$totalfactura.',
                           "basket": '.$jsonMiBasket.',
                           "store_id": "403",
                           "terminal_id": "FN403-C1",
                           "terminal_transaction_id": "FN403-'.$docuid.'", 
                           "total_discount": 0,
                           "total_taxes": '.$totalivafactura.',
                           "metadata": {
                              "nombrecajero": "'.$nomvende.'",
                              "identificacion": "'.$codvende.'",
                              "report_id": "'.$docuid.'"
                           }
                      }';

        $url = $domain."/api/cpgops-integrations/pos/v3/payments/".$codbarra."/cancel";
        $ch = curl_init($url);        
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonEntrada);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
          'Accept: application/json',
          'Authorization: '.$AccessToken.'',
          'x-rappi-channel: B2B',
          'Content-Type: application/json',
          'Content-Length: ' . strlen($jsonEntrada))          
        );

        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        
        // Execute the POST request
        $jsonretorno = curl_exec($ch);
        $dataretorno = json_decode($jsonretorno);
        
        // Close cURL resource
        curl_close($ch);

        /// Guardo en el Log
        GuardarenLog('Authorization',$jsonEntrada,$jsonretorno);
        
        /// Retorno el Objeto
        return($dataretorno);
     } 

     /////////////////////////////////////////////////////////////////
     ///  3. Con todos los Parametros de la Venta - Los envio a Autorizar
     /////////////////////////////////////////////////////////////////
     function Paso3Authorization($domain,$retailer,$secret,$terinal_id,$terminal_tran_id,$codbarra,$docuid,$objdata,$AccessToken,$codsucursal)
     {
        //// Creo el JSON de MI Basket de MI Factura
        $jsonMiBasket = GenerarJsonBasket($docuid);
        $totalfactura = TotalFactura($docuid);
        $totalivafactura = TotalIVAFactura($docuid);
        $data = DatosVendedorFactura($docuid);
        $porciones = explode("|", $data);
        $codvende = $porciones[0];
        $nomvende = $porciones[1];
        $apevende = $porciones[2];
        
        //// Creo el JSON de Entrada
        $jsonEntrada = '{
                           "currency": "COP",
                           "amount": '.$totalfactura.',
                           "basket": '.$jsonMiBasket.',
                           "store_id": "'.$codsucursal.'",
                           "terminal_id": "FN'.$codsucursal.'-C1",
                           "terminal_transaction_id": "FN'.$codsucursal.'-'.$docuid.'", 
                           "total_discount": 0,
                           "total_taxes": '.$totalivafactura.',
                           "metadata": {
                              "nombrecajero": "'.substr($nomvende,0,3).'XXX  '.substr($apevende,0,3).'XXX",
                              "identificacion": "'.$codvende.'",
                              "report_id": "'.$docuid.'"
                           }
                      }';
        //echo $jsonEntrada;
        $url = $domain."api/cpgops-integrations/pos/v3/payments/".$codbarra."/authorize";
        $ch = curl_init($url);        
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonEntrada);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
          'Accept: application/json',
          'Authorization: '.$AccessToken.'',
          'x-rappi-channel: B2B',
          'Content-Type: application/json',
          'Content-Length: ' . strlen($jsonEntrada))          
        );

        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        
        // Execute the POST request
        $jsonretorno = curl_exec($ch);
        $dataretorno = json_decode($jsonretorno);

        // Close cURL resource
        curl_close($ch);

        /// Guardo en el Log
        GuardarenLog('Authorization',$jsonEntrada,$jsonretorno);
        
        /// Retorno el Objeto
        return($dataretorno);
     }    

     /////////////////////////////////////////////////////////////
     /// 2. Envia el CodBarra y Retorna el ORDER ID
     /////////////////////////////////////////////////////////////
     function Paso2OrderDetails($domain,$AccessToken,$codbarra)
     {
          $url = $domain."api/cpgops-integrations/pos/v3/payments/".$codbarra."/order";
          $ch = curl_init($url);        
          curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
          curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
          curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
          curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Accept: application/json', 
            'x-rappi-channel: B2B',
            'Authorization: '.$AccessToken.'')
          );          

          curl_setopt($ch, CURLOPT_TIMEOUT, 20);
          curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);

          // Execute the POST request
          $jsonretorno = curl_exec($ch);
          $dataretorno = json_decode($jsonretorno);
          //echo $jsonretorno;
        
          // Close cURL resource
          curl_close($ch);
          
          /// Guardo en el Log
          GuardarenLog('OrderDetails',$url,$jsonretorno);

          /// Retorno el Array con la INFO
          return($dataretorno);          
     }

     /////////////////////////////////////////////////////////////
     /// Envia el Docuid y Retorna el Codigo de Autenticacion
     /////////////////////////////////////////////////////////////
     function Paso1Autenticacion($domain,$retailer,$secret)
     {
        $jsonfinal = '{
                         "retailer": "'.$retailer.'",
                         "secret": "'.$secret.'"
                      }';             
               
        $url = $domain."api/cpgops-integrations/retailers/sign-in/";

        $ch = curl_init($url);        
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonfinal);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
          'Accept: application/json',
          'Content-Type: application/json',
          'Content-Length: ' . strlen($jsonfinal))
        );

        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        
        // Execute the POST request
        $jsonretorno = curl_exec($ch);
        $dataretorno = json_decode($jsonretorno);
        
        // Close cURL resource
        curl_close($ch);

        /// Guardo en el Log
        GuardarenLog('Autentication',$jsonfinal,$jsonretorno);
        
        /// Guardo la Variable de Retorno
        $retorno = $dataretorno->accessToken;
        
        return($retorno);
     }    

     ////////////////////////////////////////////////////////////
     // Guarda en el Log de Rappi todos los eventos
     ////////////////////////////////////////////////////////////
     function GuardarenLog($metodo,$request,$response)
     {
        $clase = new Sistema(); 
        /// Guardo en la Tabla Seguimientorappi
        $vsql = "INSERT INTO seguimientorappi(metodo,request,response) 
                 VALUES('".$metodo."','".$request."','".$response."')";           
        $clase->EjecutarSQL($vsql);         
        return;
     }

     
     ////////////////////////////////////////////////////////////
     // Guarda en el Log de Rappi todos los eventos
     ////////////////////////////////////////////////////////////     
     function GenerarJsonBasket($docuid)
     {
        $clase = new Sistema(); 
        $jsonBasket = "[";
     
         $vsql = "SELECT P.productoid sku , P.codigo ean , P.precio1m price , DD.porciva ,
                  SUM(DD.cantidad) qty , SUM(DD.valparcial) totalprice ,  SUM(DD.valiva) valiva  
                  FROM documentos D 
                  INNER JOIN terceros T ON (T.terid = D.terid1) 
                  INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
                  INNER JOIN productos P ON (P.productoid = DD.productoid) 
                  WHERE D.docuid = ".$docuid." GROUP BY 1,2,3,4";

        //// Connect to DB
        $con = $clase->Conectar();
    
        //// Extraigo el Faltante para Completar el Total de la Factura
        $i = 0;
        $res2 = mysql_query($vsql,$con);
        while($row = mysql_fetch_array($res2))
        {
            $sku = $row['sku'];
            $qty = $row['qty'];
            $ean = $row['ean'];
            $pri = $row['price'];
            $tpr = $row['totalprice'];   
            $por = $row['porciva'];   
            $iva = $row['valiva'];   
            
            if($i>0)
               $jsonBasket .= '
                              ,
                              ';

            $jsonBasket.= '{
                              "sku": "'.$sku.'",
                              "quantity": '.$qty.',
                              "units": '.$qty.',
                              "weight_units": 0,
                              "ean": "'.$ean.'",
                              "unit_type": "UN",
                              "unit_price": '.$pri.',
                              "sale_price": '.$pri.',
                              "total_price": '.$tpr.',
                              "taxes": [
                                 {
                                    "tax_code": "'.$por.'%",
                                    "tax_amount": '.$iva.'
                                 }
                              ]
                           }';
            $i++;
        }
        $jsonBasket.= "]";
        
        return($jsonBasket);
     }

     ////////////////////////////////////////////////////////////
     // Trae el Total de la Factura
     ////////////////////////////////////////////////////////////     
     function TotalFactura($docuid)
     {
        $clase = new Sistema(); 
        $total = $clase->BDLockup($docuid,"documentos","docuid","total");
        return($total);
     }

     ////////////////////////////////////////////////////////////
     // Trae el Total IVA de la Factura
     ////////////////////////////////////////////////////////////     
     function TotalIVAFactura($docuid)
     {
        $clase = new Sistema(); 
        $iva = $clase->BDLockup($docuid,"documentos","docuid","iva");
        return($iva);
     }
     
     ////////////////////////////////////////////////////////////
     // Trae el Codigo del Vendedor
     ////////////////////////////////////////////////////////////     
     function DatosVendedorFactura($docuid)
     {
        $clase = new Sistema(); 
        $vsql = "SELECT CONCAT(codvende,'|',nombres,'|',apellidos) 
                 FROM terceros T INNER JOIN documentos D ON (D.terid2 = T.terid) 
                 WHERE D.docuid = ".$docuid;
        $data = $clase->SeleccionarUno($vsql);
        return($data);
     }

     ///////////////////////////////////////////////////////////
     ///     FIN DE LA IMPLEMENTACION DE RAPPI PAYLESS       ///
     ///////////////////////////////////////////////////////////
?>