<?PHP
  session_start(); 
  include("../lib/Sistema.php");
 
  class TransmisionRem
  {
    protected $mysqli;

    public $docuid;
    public $momento;
    public $usuario;
    public $sucorigen;
    public $sucdestino;
    public $rutaorigen;
    public $rutadestino;
    public $estadoori;
    public $estadodes;
    public $intentos;
 
    public $transmid;

    /**
     * Constructor de clase
     */
    public function __construct() 
    {           
        $clase = new Sistema();         
        try{
            //conexión a base de datos
            $this->mysqli = new mysqli($clase->ServidorBD , $clase->UsuarioBD , $clase->ClaveBD , $clase->NombreBD);
        }catch (mysqli_sql_exception $e){
            //Si no se puede realizar la conexión          
            http_response_code(400);
            exit;
        } 
    } 

    /**
    * Constructor de la Transmision
    */
    public function Transmision()
    {    
        $this->CrearRegistroTransmision();
        $this->CargarDatosTransferencia();
        $this->CargarDatosTransmision();
    }

    /**
    * Cargo la informacion desde el Documento TRB
    */
    public function CargarDatosTransferencia()
    {
        /// Selecciono de la Base de Datos la informacion
        if($this->docuid)
        {
	        $stmt = $this->mysqli->prepare("SELECT D.docuid , D.creador , B1.codbodega origen , B2.codbodega destino , 
                                          S1.rutaweb rutaori , S2.rutaweb rutades 
                                          FROM documentos D  INNER JOIN docutranfe DT ON (D.docuid = DT.docuid)
                                          INNER JOIN bodegas B1 ON (B1.bodegaid = DT.bodegaidori)
                                          INNER JOIN sucursales S1 ON (S1.sucursalid = B1.sucursalid) 
                                          INNER JOIN bodegas B2 ON (B2.bodegaid = DT.bodegaiddes)
                                          INNER JOIN sucursales S2 ON (S2.sucursalid = B2.sucursalid) 
                                          WHERE D.docuid = ?;");
	        $stmt->bind_param('s', $this->docuid);
	        $stmt->execute();
	        $result = $stmt->get_result();        
	        $row = $result->fetch_all(MYSQLI_ASSOC); 
	        $stmt->close();
	      
	        /// La asigno a las variables 
	        $this->usuario     = $row[0]['creador'];
	        $this->sucorigen   = $row[0]['origen'];
	        $this->sucdestino  = $row[0]['destino'];
          $this->rutaorigen  = $row[0]['rutaori'];
          $this->rutadestino = $row[0]['rutades'];
	    }
    }

    /**
    * Cargo la informacion desde la Transmision Global
    */
    public function CargarDatosTransmision()
    {
        /// Selecciono de la Base de Datos la informacion
	    if($this->docuid)
        {
	        $stmt = $this->mysqli->prepare("SELECT * FROM transmisiondatos WHERE docuid=?;");
	        $stmt->bind_param('s', $this->docuid);
	        $r = $stmt->execute();
	        $result = $stmt->get_result();        
	        $row = $result->fetch_all(MYSQLI_ASSOC); 
	        $stmt->close();

	        /// La asigno a las variables 
	        $this->transmid   = $row[0]['transmid'];
	        $this->usuario    = $row[0]['usuario'];
	        $this->estadoori  = $row[0]['estadoori'];
	        $this->estadodes  = $row[0]['estadodes'];	        
	        $this->intentos   = $row[0]['intentos'];                
	        $this->sucorigen  = $row[0]['sucorigen'];
	        $this->sucdestino = $row[0]['sucdestino'];        
	        $this->intentos   = $row[0]['intentos'];
	        
	        /// Cargo la informacion del Documento
	        if(!$this->usuario)         
	           $this->CargarDatosTransferencia();
  	    }
    }

    /**
    * Inserta el registro de la transmision Inicial
    */
    public function CrearRegistroTransmision()
    {
        $stmt = $this->mysqli->prepare("INSERT INTO transmisiondatos(docuid,usuario,sucorigen,sucdestino,estadoori,estadodes,momento,intentos) VALUES (?,?,?,?,'000','000',CURRENT_TIMESTAMP,0); ");
        $stmt->bind_param('ssss', $this->docuid , $this->usuario , $this->sucorigen , $this->sucdestino);
        $r = $stmt->execute(); 
        $this->transmiid = $stmt->insert_id;
        $stmt->close();
        return $r;      
    }

   /**
    * Inserta el registro de cada intento de Transmision
    * NO Actualizo el Encabezado -> Eso lo hace el Trigger After-Update detransmidatos
    */
    public function IntentoTransmisionREM($estado,$destino)
    {
        $intento = 0 + $this->intentos;
        $intento++;
        $stmt = $this->mysqli->prepare("INSERT INTO detransmidatos(transmid,sucdestino,intento,momento,estado) VALUES (?,?,?,CURRENT_TIMESTAMP,?); ");
        $stmt->bind_param('isis', $this->transmid , $destino , $intento , $estado);
        $r = $stmt->execute(); 
        $stmt->close();

        /* Cargo nuevamente la informacion del Objeto */
        $this->CargarDatosTransmision();
        return $r;      
    }
    
    /**
    * Envia la Remision via WebService a la Sucursal
    * Guarda los registros en la Base de Datos de la operacion
    **/
    public function EnviarASucursal($docuid)
    {
       ini_set("memory_limit","200M");                              set_time_limit(0);
       $clase = new Sistema();       
       $this->docuid = $docuid;
       $this->Transmision();
       
       $sucursalactual = $_SESSION['G_BODEGAPREDETPOS'];
      /*
       if($sucursalactual != $this->sucorigen)
       {
           $estado = $this->WebServiceEnvio($this->sucorigen,'POST');
           $a = $this->IntentoTransmisionREM($estado,$this->sucorigen);    
       }
       */
       if($sucursalactual != $this->sucdestino)
       {
           $estado = $this->WebServiceEnvio($this->sucdestino,'POST');
           $b = $this->IntentoTransmisionREM($estado,$this->sucdestino);    
       }    
       return($estado);
    }

   /**
    * Prueba si hay conexion con el Servidor Remoto o NO
    * Devuelve 200 si es existoso o NULL en caso de error
    **/
    public function ConexionWS()
    {
       $rutasuc   = $this->rutades;
       $rutasuc   = "http://localhost:8080/dropos/";
       $url       = $rutasuc.'classes/WSindex.php';
       $json      = file_get_contents($url);
       if(strlen($json)>0)   return 200;
       else                  return 400;
     }

    /**
    * Ejecuta los 2 Webservices que extraen la Informacion en formato JSON
    * y lo envia a la Sucursal ejecutando el Webservice POST 
    **/
    public function WebServiceEnvio($codSucursal,$method)
    {
       $codRetorno = 400; 
       $continuar_proceso = true;
       $conexion = $this->ConexionWS();

       if( $conexion != 200)
           $continuar_proceso = false;   

       if($continuar_proceso)
       {
        echo $codSucursal."-".$this->docuid;
           if(($codSucursal)&&($this->docuid))
           {
              try
              {
                  //// Obtengo el documento en formato JSON 
                  if($continuar_proceso)
                  {
                      $rutasuc   = "http://localhost:9999/";
                      $url       = $rutasuc.'dropos/classes/WSremisionesAPI.php?action=remision&id='.$this->docuid;                              // LOCAL PARA PRUEBAS
                      $json      = file_get_contents($url);
                      $resultado = json_decode($json,true);  
                      
                      if(strlen($resultado)==0)
                         $continuar_proceso = false;                           
                  }  
                  
                  return($resultado);
                  /*               
                  /// Envio este JSON a la Sucursal para crear el documento
                  if($continuar_proceso)
                  {
                      $rutasuc = "http://localhost:9999/";
                      $url2    = $rutasuc.'dropos/classes/WSremisionesAPI.php?action=remisiones';
                      $data_string = json_encode($resultado);

                      $ch = curl_init($url2);
                      curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                      curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
                      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                      curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Content-Type: application/json',
                        'Content-Length: ' . strlen($data_string)));

                      $result = curl_exec($ch);
                      $result = json_decode($result);
                      $codRetorno = $result->code;

                      if(strlen($result)==0)
                         $continuar_proceso = false;                           
                  }
                   */   
               } catch (Exception $e) {
                   $codRetorno = 400;    
              }    
           }
       }    
       
       //return $codRetorno;
     }

  } // Fin de la Clase 

  $objtrans = new TransmisionRem();
  $resp = $objtrans->ConexionWS();
  echo $resp;

/*
  $docuid = $_GET['docuid']; 
  $objtrans = new TransmisionRem();
  $objtrans->docuid = $docuid;
  echo $docuid."*<br>";
  $objtrans->Transmision();  
  $resp = $objtrans->EnviarASucursal($objtransrans->docuid);
  echo $resp;
  //header("Location: ../transferencias.php?opcion=enviarws2&respuesta=".$resp);
  */
?> 