<?PHP
    session_start();
    include("lib/Sistema.php");
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];
    
    $avisos = "";
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardareditado y guardarnuevo
    // Creación: 28/09/2020		última modificación: 22/12/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para ingresar los datos de un nuevo cargo
    // Última modificación: Inclusión del campo sección (21/10/2020)
    //                      Inclusión de los nuevos campos aplicatransporte, aplicapension y 
    //                      aplicasalud (19/08/2021)
    //                      Supresión del campo sección
    ////////////////////////////////////////////////////////////////////////////////////////
    if(($opcion == "guardareditado")||($opcion == "guardarnuevo"))
    {
        $cargoid          = $_POST['cargoid'];
        $codcargo         = $_POST['codcargo'];
        $descripcioncargo = strtoupper($_POST['descripcioncargo']);
        // $seccionid        = $_POST['seccionid'];
        $seccionid        = 0;
        $aplicatransporte = $_POST['aplicatransporte'];
        $aplicapension = $_POST['aplicapension'];
        $aplicasalud = $_POST['aplicasalud'];

        // Valido que sean introducidos los datos necesarios
        if(($codcargo == "")||($descripcioncargo == ""))
        {
            $clase->Aviso(2,"El código y la descripción no pueden estar vacíos &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
            header("Location: cargos.php");
            exit();
        }
        else
        {
            if($opcion == "guardarnuevo")
            {
                // Validación de que el código ya exista
                $vsqlx = "SELECT COUNT(codcargo) FROM cargos WHERE codcargo ='".trim($codcargo)."'";
                $valor = $clase->SeleccionarUno($vsqlx);

                if($valor>=1)
                {
                    $clase->Aviso(2,"El código <b> $codcargo </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                    header("Location: cargos.php");
                    exit();
                }
                else
                {
                    // Validación de la existencia de descripción del cargo
                    $vsqlx = "SELECT COUNT(descripcioncargo) FROM cargos WHERE descripcioncargo ='".trim($descripcioncargo)."'";
                    $valor = $clase->SeleccionarUno($vsqlx);

                    if($valor>=1)
                    {
                        $clase->Aviso(2,"El cargo <b> $descripcioncargo </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                        header("Location: cargos.php");
                        exit();                        
                    }
                    else
                    {
                        // Almaceno el nuevo cargo
                        $vsql = "INSERT INTO cargos (codcargo,descripcioncargo,seccionid,aplicatransporte,aplicapension,aplicasalud)
                                             VALUES ('".$codcargo."','".$descripcioncargo."',".$seccionid.",'".$aplicatransporte."','".$aplicapension."','".$aplicasalud."')";
                        $cant = $clase->EjecutarSQL($vsql);

                        // valido que se almacenen los datos para emitir el mensaje correspondiente
                        if(mysql_affected_rows() < 1)
                            $clase->Aviso(3,"No se incluyó el cargo");
                        else
                            $clase->Aviso(1,"Cargo creado exitosamente");
                    }
                }
            }

            if($opcion == "guardareditado")
            {
                // ---------------------------------------------------------------------------------------------- //
                // Proceso para validar si el código introducido ya existe
                $lb_codigodiferente=false;
                $lb_codigonuevoexiste=false;
                $valorcod = 0;

                $codnuevo = trim($codcargo);
                $vsqly = "SELECT codcargo FROM cargos WHERE cargoid=".$cargoid;
                $codanterior = $clase->SeleccionarUno($vsqly);
                
                if($codnuevo!=$codanterior)
                    $lb_codigodiferente=true;

                if($lb_codigodiferente)
                {
                    // Validación de la existencia del código del concepto
                    $vsqlx = "SELECT COUNT(codcargo) FROM cargos WHERE codcargo ='".$codnuevo."'";
                    $valorcod = $clase->SeleccionarUno($vsqlx);

                    if($valorcod>=1)
                        $lb_codigonuevoexiste=true;
                }

                // ---------------------------------------------------------------------------------------------- //
                if($lb_codigonuevoexiste)
                {
                    $clase->Aviso(2,"El código <b> $codcargo </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                    header("Location: cargos.php");
                    exit();
                }
                else
                {
                    // Proceso para validar si la descripción introducida ya existe
                    $lb_descripciondiferente=false;
                    $lb_descripcionnuevoexiste=false;
                    $valordes = 0;

                    $desnueva = trim($descripcioncargo);
                    $vsqly = "SELECT descripcioncargo FROM cargos WHERE cargoid=".$cargoid;
                    $desanterior = $clase->SeleccionarUno($vsqly);
                    
                    if($desnueva!=$desanterior)
                        $lb_descripciondiferente=true;

                    if($lb_descripciondiferente)
                    {
                        // Validación de la existencia del código del periodo
                        $vsqlx = "SELECT COUNT(descripcioncargo) FROM cargos WHERE descripcioncargo ='".$desnueva."'";
                        $valordes = $clase->SeleccionarUno($vsqlx);

                        if($valordes>=1)
                            $lb_descripcionnuevoexiste=true;
                    }
                    
                    if(($lb_descripciondiferente)&&($lb_descripcionnuevoexiste))
                    {
                        $clase->Aviso(2,"La descripción <b> $descripcioncargo </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                        header("Location: cargos.php");
                        exit();
                    }
                    else
                    {
                        // Almaceno los cambios del cargo                    
                        $vsql = "UPDATE cargos SET 
                                        codcargo = '".$codcargo."',
                                        descripcioncargo = '".$descripcioncargo."', 
                                        seccionid = ".$seccionid.",
                                        aplicatransporte = '".$aplicatransporte."',
                                        aplicapension = '".$aplicapension."',
                                        aplicasalud = '".$aplicasalud."'
                                  WHERE cargoid = ".$cargoid;
                        $clase->EjecutarSQL($vsql);

                        // valido que se almacenen los datos para emitir el mensaje correspondiente
                        if(mysql_affected_rows() < 1)
                            $clase->Aviso(3,"No se modificó el cargo");
                        else
                            $clase->Aviso(1,"Cargo modificado exitosamente");
                    }
                }
            }		
        }        
        header("Location: cargos.php");
    }
  
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nuevo
    // Creación: 28/09/2020		última modificación: 22/12/2022
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que pinta la ventana para ingresar los datos de un nuevo cargo
    // Última modificación: Modificación del combo de sección quitando el código
    //                      (07/12/2020)
    //                      Se incluyó el campo código (05/01/2021)
    //                      Inclusión de los nuevos campos aplicatransporte, aplicapension 
    //                      y aplicasalud (19/08/2021)
    //                      Supresión del campo sección
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nuevo")
    {
        $vsqlcomboseccion = "SELECT seccionid, descripcionsec FROM seccion ORDER BY seccionid ASC";
        $cont = $clase->Header("S","W"); ;  	 
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp;</td>
                  <td width="37"> <img src="images/iconos/infcomisiones.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Nuevo cargo </b> </td>
                  <td align="right"> <a href="cargos.php"><input type="button" value="<<" class="button"></a> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>	 			   
                </table>';

        $cont.='<br>
                <center>                
                <fieldset style="width: 530px; height: 300px;" class="grupos">
                <legend class="titgrupos"> Datos </legend>
                <form action="?opcion=guardarnuevo" method="POST">
                 <table width="200">
                  <tr height="55">
                   <td> <label class="Texto12"> <b> C&oacute;digo: </b></label><br>
                    <input type="text" autocomplete="off" name="codcargo" class="Texto15" maxlength="10" size="10"> 
                   </td>
                  </tr>
                  <tr height="55">
                   <td> <label class="Texto12"> <b> Descripci&oacute;n: </b></label><br>
                    <input type="text" autocomplete="off" name="descripcioncargo" class="Texto15"  maxlength="80" size="50"> 
                   </td>
                  </tr>
                  <tr height="30">
                   <td> <input type="checkbox" value="CHECKED" name="aplicatransporte" class="Texto12" '.$aplicatransporte.'> Aplica c&aacute;lculo de subsidio de transporte </td>
                  </tr>
                  <tr height="30">
                   <td> <input type="checkbox" value="CHECKED" name="aplicapension" class="Texto12" '.$aplicapension.'> Aplica c&aacute;lculo de pensi&oacute;n</td>
                  </tr>
                  <tr height="30">
                   <td> <input type="checkbox" value="CHECKED" name="aplicasalud" class="Texto12" '.$aplicasalud.'> Aplica c&aacute;lculo de salud</td>
                  </tr>
                  <tr height="55">
                   <td align="center"><br><br> <input type="submit" value="crear cargo" class="button blue"> </td>
                  </tr>			                  
                 </table>
                </form>
                <br>
                <br>
                </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: detalles
    // Creación: 28/09/2020		última modificación: 22/12/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para modificar los datos de un cargo
    // Última modificación: Inclusión del campo sección (21/10/2020)
    //                      Se incluyó el campo código (05/01/2021)
    //                      Inclusión de los nuevos campos aplicatransporte, aplicapension 
    //                      y aplicasalud (19/08/2021)
    //                      Supresión del campo sección
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "detalles")
    {
        $cargoid = $_GET['cargoid'];
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/infcomisiones.png" width="32" height="32" border="0"> </td>
                  <td width="750"> <b> Modificar cargo </b> </td>                
                  <td width="750"> &nbsp; </td> 
                  <td> <a href="cargos.php"><input type="button" value="<<" class="button"></a> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>	 			   
                </table>';
        
        $vsql = "SELECT * FROM cargos WHERE cargoid=".$cargoid;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);

        if($row = mysql_fetch_array($result))
        {
            // Variables para la sección
            $seccionid = $clase->BDLockup($cargoid,'cargos','cargoid','seccionid');
            $vsqlcomboseccion = "SELECT seccionid, descripcionsec FROM seccion ORDER BY seccionid ASC";
            $comboseccion  = $clase->CrearComboBuscar("seccionid",$vsqlcomboseccion,"descripcionsec","seccionid",$seccionid,"N",$params,400);
            $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');
            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');

            $cont.='<br><br><br><center>
                    <form action="?opcion=guardareditado" method="POST">
                     <input type="hidden" name="cargoid" value="'.$cargoid.'">                    
                     <fieldset style="width: 530px; height: 300px;" class="grupos">
                     <legend class="titgrupos"> Datos </legend>
                     <table width="400">
                      <tr height="55"><td> <label class="Texto12"> <b>C&oacute;digo: </b></label><br>
                       <input type="text" autocomplete="off" name="codcargo" class="Texto15"  maxlength="10" size="10" value="'.$row['codcargo'].'"> </td>
                      </tr>
                      <tr height="55"><td> <label class="Texto12"> <b>Descripci&oacute;n: </b></label><br>
                       <input type="text" autocomplete="off" name="descripcioncargo" class="Texto15"  maxlength="80" size="50" value="'.$row['descripcioncargo'].'"> </td>
                      </tr>
                      <tr height="30">
                       <td> <input type="checkbox" value="CHECKED" name="aplicatransporte" class="Texto12" '.$aplicatransporte.'> Aplica c&aacute;lculo de subsidio de transporte </td>
                      </tr>
                      <tr height="30">
                       <td> <input type="checkbox" value="CHECKED" name="aplicapension" class="Texto12" '.$aplicapension.'> Aplica c&aacute;lculo de pensi&oacute;n</td>
                      </tr>
                      <tr height="30">
                       <td> <input type="checkbox" value="CHECKED" name="aplicasalud" class="Texto12" '.$aplicasalud.'> Aplica c&aacute;lculo de salud</td>
                      </tr>
                      <tr height="55">
                       <td align="center"><br><br> <input type="submit" value="modificar cargo" class="button blue"> </td>
                      </tr>			
                     </table>
                    </form> 
                    <br><br>
                    </fieldset>';
        }
        mysql_free_result($result); 
        mysql_close($conex);			  
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: encontrar
    // Creación: 28/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que busca un cargo de acuerdo a su descripción
    // Última modificación:
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "encontrar")
    {
        $criterio = $_POST['criterio'];
        $vsql = "SELECT * 
                   FROM cargos 
                  WHERE codcargo LIKE '%".$criterio."%'
                        OR descripcioncargo LIKE '%".$criterio."%' 
               ORDER BY cargoid ASC Limit 0,".$_SESSION["NUMREGISTROSXCONSULTA"];
        $_SESSION['SQL_CARGOS'] = $vsql;
        header("Location: cargos.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nofiltro
    // Creación: 28/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que revierte la búsqueda de un cargo y los muestra todos
    // Última modificación:
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {
        $criterio = $_POST['criterio'];
        $vsql = "SELECT * FROM cargos ORDER BY cargoid";
        $_SESSION['SQL_CARGOS'] = "";
        header("Location: cargos.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 28/09/2020		última modificación: 16/11/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana principal de cargos
    // Última modificación: Botón para la salida a Excel de las secciones
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                    <tr class="CabezoteTabla"> 
                    <td width="10"> &nbsp; </td>
                    <td width="37"> <img src="images/iconos/infcomisiones.png" width="32" height="32" border="0"> </td>
                    <td width="800"> <b>Cargos</b> </td>';

        $cont.='<td width="10"> 
                 <a href="?opcion=cargospdf" title="informe de cargos en pdf" target="_blank"> 
                  <img src="images/iconos/exportarpdf2.png" border="0"> 
                 </a> 
                </td>
                <td width="10"> &nbsp; </td>
                <td width="10"> 
                 <a href="?opcion=cargosxls" title="informe de cargos en excel" target="_blank"> 
                  <img src="images/iconos/exportarexcel2.png" border="0"> 
                 </a> 
                </td>
                <td width="10"> &nbsp; </td>
                <td width="24"> 
                 <a href="?opcion=nuevo"> 
                  <img src="images/basicas/icononuevo.png" border="0">
                 </a> 
                </td>';

        $cont.='<form action="?opcion=encontrar" method="POST" name="x">
                <td> <input type="text" name="criterio" size="30" placeholder="Criterio a Buscar" tabindex="1" id="default"> </td>
                <td> <input type="submit" value="Encontrar" class="button"></form> </td> ';
        
        if($_SESSION['SQL_CARGOS'] != "")
            $cont.='<td width="10"> <a href="?opcion=nofiltro"> <img src="images/basicas/nofiltro.png"> </a> </td>';           

        $cont.='  </form> 
                  <td width="8"> &nbsp; </td>
                 </tr>	 			   
                </table> ';		
    
        if($_SESSION['SQL_CARGOS'] == "")
            $vsql = "SELECT * FROM cargos ORDER BY cargoid ASC";
        else
            $vsql = $_SESSION['SQL_CARGOS'];

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                <thead> 
                 <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                  <td width="15">&nbsp;</td>
                  <td width="150" align="left"> C&oacute;digo </td>				 
                  <td width="350" align="left"> Descripci&oacute;n </td>
                  <td width="150" align="left"> &nbsp; </td>			
                  <td width="350" align="left"> &nbsp; </td>		
                  <td width="50" align="left"> &nbsp; </td>	
                  <td width="45"> &nbsp; </td>
                  <td width="45"> &nbsp; </td>				 
                  <td width="45"> &nbsp; </td>
                 </tr>
                </thead>
                <tbody style="display:block; width:1050; height:690px; overflow-Y:scroll">';	
        
        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $cargoid =  $row['cargoid'];
            $codcargo =  $row['codcargo'];

            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
            
            $cont.=' <td width="15"> &nbsp; </td>
                     <td width="140"> '.$row['codcargo'].' </td>                         
                     <td width="320"> '.$row['descripcioncargo'].' </td>
                     <td width="190"> &nbsp; </td>				  				  
                     <td width="350"> &nbsp; </td>	                         
                     <td width="30"> 
                      <a href="?opcion=confirmacion&cargoid='.$row['cargoid'].'" rel="facebox">
                      <img src="images/basicas/iconoborrar.png" title="Eliminar" border="0"></a> 
                     </td>                         
                     <td width="35"> <a href="?opcion=detalles&cargoid='.$cargoid.'"> <img src="images/basicas/iconobuscar.png" border="0"> </td>				  				  
                    </tr>';
        }
    
        $cont.=' </tbody> 
                </table> 
                <br>';
        
        mysql_free_result($result);
        mysql_close($conex);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmacion
    // Creación: 30/08/2020		última modificación: 18/09/2020
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para confirmar la eliminación de una EPS
    // Última modificación: Se incluyó la impresión de la descripción de la EPS
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmacion")
    {
        $cargoid          = $_GET['cargoid'];
        $descripcioncargo = $clase->BDLockup($cargoid,'cargos','cargoid','descripcioncargo');
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Eliminar cargo</b><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"> ¿Confirma que desea eliminar el cargo<br><b> '.$descripcioncargo.'</b>? <br></td>       
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=eliminar" method="POST">
                   <input type="hidden" name="cargoid" value="'.$cargoid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                    <a href="cargos.php" ><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ///////////////////////////////////////////////////////////////////////////
    // Opción: eliminar
    // Creación: 30/08/2020		última modificación: 08/09/2020
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para eliminar un cargo
    // Última modificación: 
    ///////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminar")
    {
        $cargoid = $_POST['cargoid'];
        $valor   = 0;
        $descripcioncargo = $clase->BDLockup($cargoid,'cargos','cargoid','descripcioncargo');

   	  	// No se puede eliminar el cargo porque está asociado a un(varios) empleado(s)
        $vsqlx = "SELECT COUNT(cargoid) FROM terceros WHERE cargoid =".$cargoid;
        $valor = $clase->SeleccionarUno($vsqlx);
   
        if($valor>=1)
        {            
            $clase->Aviso(3,"No se puede eliminar el cargo $descripcioncargo porque hay empleados asociados a él");
            header("Location: cargos.php");
        }
        else
        {            
            $vsql = "DELETE FROM cargos WHERE cargoid=".$cargoid;
            $clase->EjecutarSQL($vsql);	

            // valido que se almacenen los datos para emitir el mensaje correspondiente
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se eliminó el cargo $descripcioncargo");
            else
                $clase->Aviso(1,"Cargo $descripcioncargo eliminado exitosamente");
            
            header("Location: cargos.php");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cargosxls
    // Creación: 16/11/2022		última modificación: 23/11/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera la salida a Excel de los cargos
    // Última modificación: Se incluyó la comilla simple para los códigos que comiencen en 
    //                      cero
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "cargosxls")
    {
        $vsql = "SELECT codcargo, descripcioncargo FROM cargos ORDER BY cargoid";

        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("Cargos de nomina - DROPOS")
                                     ->setSubject("Cargos de nomina - DROPOS")
                                     ->setDescription("Cargos de nomina - DROPOS")
                                     ->setKeywords("Cargos de nomina - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'INFORME DE CARGOS')
                    ->setCellValue('A3', 'CODIGO')
                    ->setCellValue('B3', 'NOMBRE');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 4;
        while($row = mysql_fetch_array($result))
        {
            $codcargo = $row['codcargo'];
            if(substr($codcargo,0,1) == "0")            $codcargo="'".$codcargo;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $codcargo)
                        ->setCellValue('B'.$i, $row['descripcioncargo']);
            $i++;
        }

        $rangoEncabezado = 'A3:B3';
        $rangoCeldas     = 'A3:B'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('cargos');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //                
        $nombrearcexcel = "informe de cargos.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cargospdf
    // Creación: 17/11/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida en pdf de los cargos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "cargospdf")
    {
        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        // Procedo a construir el encabezado del recibo
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF();
        
        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

        // Imprimo el encabezado del informe
        $x = 25;
        $y = 13;
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+124,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "INFORME DE CARGOS";               $pdf->Text($x,$y+5,$enc);

        // Encabezado del informe
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(5,28,200,8,'F');
        $pdf->SetFont('Arial','B',9);

        $enc= "CODIGO";                         $pdf->Text($x-17,$y+20,$enc);
        $enc= "CARGO";                          $pdf->Text($x+17,$y+20,$enc);

        // consulta del informe
        $vsql = "SELECT codcargo, descripcioncargo FROM cargos ORDER BY cargoid";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $x = 8;
        $y = 41;
        $i = 0;
        $linea = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%38==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "INFORME DE CARGOS";               $pdf->Text($x,$y+5,$enc);

                // Encabezado del informe
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(5,28,200,8,'F');
                $pdf->SetFont('Arial','B',9);

                $enc= "CODIGO";                         $pdf->Text($x-17,$y+20,$enc);
                $enc= "CARGO";                          $pdf->Text($x+17,$y+20,$enc);

                $x = 8;
                $y = 41;
            }
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y,$row['codcargo']);
            $pdf->Text($x+34,$y,$row['descripcioncargo']);

            $y+=6;
        }
        $pdf->Output();
    }

    // ------------------------------------ //
    echo $cont.$clase->PiePagina();  
?> 