<?PHP
    @session_start(); 

    require_once("classes/class_validaciones.php");
    $io_fecha=new class_validaciones();

    include("lib/Sistema.php");  
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanareprocesarliq
    // Creación: 22/11/2021		última modificación: 24/06/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Ventana donde se visualiza y procesa el cálculo de liquidación de un 
    //              empleado
    // Última modificación: Ajuste de año cuando el código del periodo es blanco o null
    //                      (04/01/2022)
    //                      Inclusión del botón para editar la ficha del empleado 
    //                      (04/05/2022)
    //                      Configuración de combo de periodos de acuerdo al tipo de periodo
    //                      (03/11/2022)
    //                      Ajuste de la eliminación de toda la liquidación borrando por la 
    //                      lista de periodos y sustitución de los iconos principales
    //                      (07/12/2023)
    //                      No aplicar el descuento a la incapacidad superior a 180 días
    //                      (11/01/2024)
    //                      Exclusión de las primas cargadas en la tabla noliquida 
    //                      (23/01/2024)
    //                      Validación del cierre de la liquidación (19/02/2024)
    //                      Acceso al histórico de contratos
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanareprocesarliq")
    {
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];

        if($terid=="")              $terid = $_GET['terid'];
        if($periodoid=="")          $periodoid = $_GET['periodoid'];

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Salario básico
        // $basico = $clase->BDLockup($terid,'terceros','terid','basico');

        // Obtengo el salario básico del empleado
        $vsql17 = "SELECT hc.ultsueldo 
                     FROM histcontrato hc
                    WHERE hc.terid = ".$terid." 
                          AND hc.id = (SELECT MAX(id)
                                         FROM histcontrato
                                        WHERE terid = ".$terid.")";
        $basico = $clase->SeleccionarUno($vsql17);

        // fechas de ingreso y retiro
        $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
        $idhistorico = $clase->SeleccionarUno($vsql18);

        $vsql21 = "SELECT hc.fecingreso
                     FROM histcontrato hc
                    WHERE hc.terid = ".$terid." 
                          AND hc.id = ".$idhistorico;
        $fecingreso = $clase->SeleccionarUno($vsql21);

        $vsql21 = "SELECT hc.fecretiro 
                     FROM histcontrato hc
                    WHERE hc.terid = ".$terid." 
                          AND hc.id = ".$idhistorico;
        $fecretiro = $clase->SeleccionarUno($vsql21);

        $fechadeingreso  = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
        $fecchaderetiro  = substr($fecretiro,8,2)."/".substr($fecretiro,5,2)."/".substr($fecretiro,0,4);

        // Cédula o documento del empleado
        $dni = $clase->BDLockup($terid,'terceros','terid','dni');

        // La sección
        $vsqldatos = "SELECT s.descripcionsec 
                        FROM terceros t
                             INNER JOIN seccion s ON (t.seccionid = s.seccionid) 
                       WHERE t.terid = ".$terid;
        $seccion = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Preparo las variables para el combo del mes
        $yeartoday = date("Y");

        // ------------------------------------------------------------- //
        $monthtoday = date("m");
        $daytoday = date("j");
        if(($monthtoday=="01")&&($daytoday<=16))   $yeartoday--;
        // ------------------------------------------------------------- //

        // Determino el código y el nombre del periodo que se reportará
        $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                         FROM periodosnomina 
                        WHERE consecutivone <> ''
                              AND YEAR(fechasta) = ".$yeartoday."";
        $nummesval = $clase->SeleccionarUno($vsqlmesval);
        
        $nummesval++;        

        if($nummesval==13)      $nummesval = 1;

        $vsqlcodmesrep  = "SELECT codperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
        $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);

        if(($codperiodo=="")||($codperiodo==NULL))
        {
            $yeartoday--;
            $nummesval--;
            $vsqlcodmesrep = "SELECT codperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
        }

        // $codperiodo = "072024";

        $vsqldesmesrep  = "SELECT desperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
        $desmesrep = $clase->SeleccionarUno($vsqldesmesrep);
        
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        $mesperiodo = substr($desperiodo,0,-5);

        // fechas del periodo
        $fecinicio = substr($desperiodo,-4)."-".substr($codperiodo,0,2)."-01";
        $fecfinal = date("Y-m-t", strtotime($fecinicio));

        // Consulta de los periodos de nómina que se van a consultar
        $vsql = "SELECT periodoid 
                   FROM periodosnomina 
                  WHERE descripcion LIKE '%".$mesperiodo."%' 
                        AND descripcion LIKE '%".$yeartoday."%'";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $periodosreportar = mysql_num_rows($result);

        // Periodos a procesar
        if($periodosreportar>0)
        {
            $j = 0;
            while($row = mysql_fetch_array($result))
            {
                $listaperiodos.= $row['periodoid'].",";
                $segundaquinper = $row['periodoid'];

                $j++;
                if($j==1)   $pquin = $row['periodoid'];
                if($j==2)   $squin = $row['periodoid'];
            }
            $listaperiodos = substr($listaperiodos, 0, -1);
        }        
        // ---------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // días trabajados
        $vsqldatos = "SELECT valor AS diastrab 
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid = 1";

        $diastrab = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($diastrab=="")
            $diastrab = 0;

        $diastrab2 = $diastrab;

        // El cargo
        $vsqldatos = "SELECT c.descripcioncargo 
                        FROM terceros t
                             INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                       WHERE t.terid = ".$terid;
        $cargo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // sueldo
        $vsqldatos = "SELECT devengados AS sueldo 
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid=1";
        $sueldo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($sueldo=="")
            $sueldo = 0;

        // auxilio de transporte
        $vsqldatos = "SELECT devengados AS auxtransporte 
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid=3";
        $auxtransporte = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($auxtransporte=="")
            $auxtransporte = 0;

        // pensión
        $vsqldatos = "SELECT descuentos AS pension 
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid=4";
        $pension = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($pension=="")
            $pension = 0;

        // salud
        $vsqldatos = "SELECT descuentos AS salud 
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid=5";
        $salud = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($salud=="")
            $salud = 0;
        
        // Primas
        $vsqldatos = "SELECT l.cantidad AS diasprima
                        FROM liquidacion l
                       WHERE l.terid = ".$terid."
                             AND l.periodonomina = '".$codperiodo."' 
                             AND l.tipo = 'primas'
                             AND l.terid NOT IN (SELECT terid
                                                   FROM noliquida
                                                  WHERE terid = l.terid
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'primas')";

        $diasprima = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($diasprima=="")
            $diasprima = 0;

        $vsqldatos = "SELECT l.pago AS pagoprimas
                        FROM liquidacion l
                       WHERE l.terid = ".$terid."
                             AND l.periodonomina = '".$codperiodo."' 
                             AND l.tipo = 'primas'
                             AND l.terid NOT IN (SELECT terid
                                                   FROM noliquida
                                                  WHERE terid = l.terid
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'primas')";
        $pagoprimas = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($pagoprimas=="")
            $pagoprimas = 0;

        // Vacaciones
        $vsqldatos = "SELECT cantidad AS diasvaca
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'vacaciones'";
        $diasvaca = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($diasvaca=="")
            $diasvaca = 0;

        $vsqldatos = "SELECT pago AS pagovaca
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'vacaciones'";
        $pagovaca = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($pagovaca=="")
            $pagovaca = 0;

        // Cesantías
        $vsqldatos = "SELECT pago AS pagocesantias
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'cesantias'";
        $pagocesantias = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($pagocesantias=="")
            $pagocesantias = 0;

        $vsqldatos = "SELECT porcentaje AS porcesantias
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'cesantias'";
        $porcesantias = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($porcesantias=="")
            $porcesantias = 0;

        $vsqldatos = "SELECT pagointereses 
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'cesantias'";
        $pagointereses = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($pagointereses=="")
            $pagointereses = 0;
        
        // Indemnización
        $vsqldatos = "SELECT pago AS pagoinde
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'indemnizacion'";
        $pagoinde = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($pagoinde=="")
            $pagoinde = 0;

        // ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Combo de periodos
        $params = ' class="Texto11" style="height: 32px;" ';
        
        // periodo actual
        $vsql = "SELECT periodoid 
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado = '')";
        $periodoidactual = $clase->SeleccionarUno($vsql);        

        // Determino qué tipo de periodo es para armar el combo
        $fecdesde = $clase->BDLockup($periodoidactual,'periodosnomina','periodoid','fecdesde');
        $diadesde = substr($fecdesde, -2);        

        if($diadesde=="01")
        {   
            $vsqlcomboperiodos = "SELECT periodoid, descripcion FROM periodosnomina WHERE periodoid IN ($listaperiodos) ORDER BY periodoid ASC";
            $comboperiodos = $clase->CrearComboBuscar("periodoid",$vsqlcomboperiodos,"descripcion","periodoid",$periodoid,"N",$params,300);
        }

        if($diadesde=="16")
        {
            $vsqlcomboperiodos = "SELECT periodoid, descripcion FROM periodosnomina WHERE periodoid = ".$periodoid." ORDER BY periodoid ASC";
            $comboperiodos = $clase->CrearComboBuscar("periodoid",$vsqlcomboperiodos,"descripcion","periodoid",$periodoidactual,"N",$params,300);
        }
        // ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
        {
            $botonelivaca = '';
            $botoneliprima = '';
            $botonelicesantia = '';
            $botoneliindem = '';
        }
        else
        {
            $botonelivaca = '<a href="?opcion=confirelivaca&codperiodo='.$codperiodo.'&terid='.$terid.'&periodoid='.$periodoid.'" rel="facebox">
                              <img src="images/basicas/iconoborrar.png" title="Eliminar vacaciones" border="0">
                             </a>';
            $botoneliprima = '<a href="?opcion=confireliprima&codperiodo='.$codperiodo.'&terid='.$terid.'&periodoid='.$periodoid.'" rel="facebox">
                               <img src="images/basicas/iconoborrar.png" title="Eliminar prima" border="0">
                              </a>';
            $botonelicesantia = '<a href="?opcion=confirelicesantia&codperiodo='.$codperiodo.'&terid='.$terid.'&periodoid='.$periodoid.'" rel="facebox">
                                  <img src="images/basicas/iconoborrar.png" title="Eliminar cesantía" border="0">
                                 </a>';
            $botoneliindem = '<a href="?opcion=confireliindem&codperiodo='.$codperiodo.'&terid='.$terid.'&periodoid='.$periodoid.'" rel="facebox">
                               <img src="images/basicas/iconoborrar.png" title="Eliminar cesantía" border="0">
                              </a>';
        }
        // ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //

        // Pintamos la ventana
        $cont = $clase->Header("S","W");

        if($norecalcular == "CHECKED")
        {
            $cont.='<table width="100%">
                     <input type="hidden" name="cesantiasant" value="'.$cesantiasant.'">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="24"> <img src="images/iconos/retirados.png" width="32" height="32" border="0"> </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> <img src="images/basicas/bloqueado.png" title="registro cerraro para recalculo" border="0" width="28" height="28"> </td>
                      <td width="10"> &nbsp; </td>
                      <td width="750"> <b>Liquidaci&oacute;n del periodo <font color="blue">'.$desperiodo.'</font></b> </td>
                      <td width="24"> &nbsp; </td>
                      <td width="24"> &nbsp; </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> &nbsp; </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> &nbsp; </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> &nbsp; </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> &nbsp; </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> &nbsp; </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> &nbsp; </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> 
                       <a href="calculoliquidados.php?opcion=ventanaliquidados"> 
                       <input type="button" value="<<" class="button blue"> </a> 
                      </td>
                     </tr> 
                    </table>';

            $lbldiastrab = ''.number_format($diastrab).'';
            $lbldiastrab2 = ''.number_format($diastrab2).'';
            $htmldiasvaca = ''.number_format($diasvaca).'';
            $htmlpagovaca = ''.number_format($pagovaca,2).'';
            $htmldiasprima = ''.number_format($diasprima).'';
            $htmlpagoprimas = ''.number_format($pagoprimas,2).'';
            $htmlpagocesantias = ''.number_format($pagocesantias,2).'';
            $htmlporcesantias = ''.number_format($porcesantias,2).'';
            $htmlpagointereses = ''.number_format($pagointereses,2).'';
            $htmlpagoinde = ''.number_format($pagoinde,2).'';
        }
        else
        {
            $tiposalida = "vista";
            $cont.='<table width="100%">
                     <input type="hidden" name="cesantiasant" value="'.$cesantiasant.'">
                     <tr class="BarraDocumentos" style="height:45px;Important!">
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/retirados.png" width="32" height="32" border="0"> </td>
                      <td width="750"> <b> Liquidaci&oacute;n del periodo <br> <font color="blue"> '.$desperiodo.' </font> </b> </td>
                      <td width="24"> 
                       <a href="infhistcont.php?opcion=listadocontratos&terid='.$terid.'&tiposalida='.$tiposalida.'" title="hist&oacute;rico de contratos" target="_blank">
                        <img src="images/iconos/agenda.png" width="34" height="34" border="0"> 
                       </a> 
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> 
                       <a href="terceros.php?opcion=detalles2&id='.$terid.'" title="editar ficha del empleado" target="_blank">
                       <img src="images/iconos/clientes.png" width="34" height="34" border="0"> </a> 
                      </td>
                      <td width="10"> &nbsp; </td>
                      <!-- ------------------------------------------------------------------------------------------------------------------------------------------------------ 
                      <td width="24"> 
                       <a href="?opcion=imprimirliq&terid='.$terid.'&codperiodo='.$codperiodo.'&periodoid='.$periodoid.'" title="imprimir liquidaci&oacute;n" target="_blank">
                       <img src="images/iconos/exportarpdf2.png" width="34" height="34" border="0"> </a> 
                      </td>
                      <td width="10"> &nbsp; </td>
                      ------------------------------------------------------------------------------------------------------------------------------------------------------- -->
                      <td width="24"> 
                       <a href="?opcion=precalconliq&terid='.$terid.'&codperiodo='.$codperiodo.'&periodoid='.$periodoid.'" title="calcular vacaciones, primas y cesant&iacute;as" rel="facebox"> 
                       <img src="images/iconos/calculando.png" width="34" height="34" border="0"> </a> 
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> 
                       <a href="?opcion=incluirconcepto&terid='.$terid.'&periodoid='.$periodoid.'" title="incluir un concepto en la quincena" target="_blank"> 
                       <img src="images/iconos/nuevodoc.png" width="34" height="34" border="0"> </a> 
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> 
                       <a href="?opcion=editarlicencia&terid='.$terid.'&periodoid='.$periodoid.'" target="_blank">
                        <img src="images/iconos/gastos.png" title="licencias" width="34" height="34" border="0">
                       </a>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> 
                       <a href="?opcion=ventanaelimconp&terid='.$terid.'&listaperiodos='.$listaperiodos.'&periodoid='.$periodoid.'" target="_blank">
                        <img src="images/iconos/eliminardoc.png" title="eliminar concepto" width="34" height="34" border="0">
                       </a>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> 
                       <a href="?opcion=actincapacidadarl&terid='.$terid.'&periodoid='.$periodoid.'&diastrab='.$diastrab.'" title="recalcular incapacidad ARL" target="_blank"> 
                        <img src="images/iconos/refrescar.png" width="34" height="34" border="0">  
                       </a> 
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> 
                       <a href="?opcion=recalcularliq&terid='.$terid.'&basico='.$basico.'&periodoid='.$periodoidactual.'&diastrab='.$diastrab.'" target="_blank">
                        <img src="images/iconos/reconciliar.png" title="recalcular quincena" width="34" height="34" border="0">
                       </a>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> 
                       <a href="?opcion=confirmarelim&terid='.$terid.'&listaperiodos='.$listaperiodos.'&codperiodo='.$codperiodo.'" title="eliminar toda la liquidaci&oacute;n" rel="facebox"> 
                       <img src="images/iconos/anulardoc.png" width="34" height="34" border="0"> </a> 
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> 
                       <a href="calculoliquidados.php?opcion=ventanaliquidados"> 
                       <input type="button" value="<<" class="button blue"> </a> 
                      </td>
                     </tr> 
                    </table>';

            $lbldiastrab = '<input type="number" name="diastrab" min="0" max="15" step="1" class="Texto11New" size="2" style="width:60px;height:25px" autocomplete="off" title="días trabajados" value="'.$diastrab.'">';
            $lbldiastrab2 = '<input type="number" name="diastrab2" min="0" max="15" step="1" class="Texto11New" size="2" style="width:60px;height:25px" autocomplete="off" title="días trabajados" value="'.$diastrab2.'">';
            $htmldiasvaca = '<input type="number" name="diasvaca" min="0" class="Texto11New" size="20" style="width:145px;height:25px" autocomplete="off" title="días de vacaciones" value="'.$diasvaca.'">';
            $htmlpagovaca = '<input type="number" name="pagovaca" min="0" step="0.01" class="Texto10" size="20" style="width:145px;height:25px" autocomplete="off" title="pago de vacaciones" value="'.$pagovaca.'">';
            $htmldiasprima = '<input type="number" name="diasprima" min="0" class="Texto11New" size="20" style="width:145px;height:25px" autocomplete="off" title="días de primas" value="'.$diasprima.'">';
            $htmlpagoprimas = '<input type="number" name="pagoprimas" min="0" step="0.01" class="Texto10" size="20" style="width:145px;height:25px" autocomplete="off" title="pago de vacaciones" value="'.$pagoprimas.'">';
            $htmlpagocesantias = '<input type="number" name="pagocesantias" min="0" step="0.01" class="Texto11New" size="2" style="width:145px;height:25px" autocomplete="off" title="Pago de cesantías" value="'.$pagocesantias.'">';
            $htmlporcesantias = '<input type="number" name="porcesantias" min="0" step="0.01" class="Texto9" size="20" style="width:100px;height:25px" autocomplete="off" title="Porcentaje de las cesantías" value="'.$porcesantias.'">';
            $htmlpagointereses = '<input type="number" name="pagointereses" min="0" step="0.01" class="Texto9" size="20" style="width:120px;height:25px" autocomplete="off" title="Intereses de las cesantías" value="'.$pagointereses.'">';
            $htmlpagoinde = '<input type="number" name="pagoinde" min="0" class="Texto10" size="20" style="width:145px;height:25px" autocomplete="off" title="pago de indemnización" value="'.$pagoinde.'">';
        }

        $cont.='<form action="?opcion=calculosliq" name="y" method="POST">
                <input type="hidden" name="basico" value="'.$basico.'">
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="47"> &nbsp; </td>
                  <td width="352"> <label class="Texto12"> Documento: </label> '.$dni.' </td>
                  <td width="255"> &nbsp; </td>
                  <td width="206"> &nbsp; </td>
                  <td width="206"> &nbsp; </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="47"> &nbsp; </td>
                  <td width="352"> <label class="Texto12"> Empleado(a): <br> </label> '.$nombreemp.' </td>
                  <td width="255"> <label class="Texto12"> Salario b&aacute;sico: <br> '.number_format($basico).' </label> </td>
                  <td width="206"> <label class="Texto12"> Fecha de ingreso: <br> '.$fechadeingreso.' </label> </td>
                  <td width="206"> <label class="Texto12"> Fecha de retiro: <br> '.$fecchaderetiro.' </label> </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="47"> &nbsp; </td>
                  <td width="352"> <label class="Texto12"> Cargo: <br> </label> '.$cargo.' </td>
                  <td width="255"> &nbsp; </td>
                  <td width="206"> &nbsp; </td>
                  <td width="206"> &nbsp; </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="47"> &nbsp; </td>
                  <td width="352"> <label class="Texto12"> Periodo: </label> <br>'.$comboperiodos.' </td>
                  <td width="255"> &nbsp; </td>
                  <td width="206"> &nbsp; </td>
                  <td width="206"> &nbsp; </td>
                 </tr> 
                 <tr class="CabezoteTabla">
                  <td width="47"> &nbsp; </td>
                  <td width="352"> <label class="Texto12"> D&iacute;as trabajados: </label> '.$lbldiastrab.' </td>
                  <td width="255"> <label class="Texto12"> Sueldo: </label> '.number_format($sueldo).' </td>
                  <td width="206"> <label class="Texto12"> Pensi&oacute;n: </label> '.number_format($pension).' </td>
                  <td width="206"> <label class="Texto12"> Salud: </label> '.number_format($salud).' </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="47"> &nbsp; </td>
                  <td width="352"> <label class="Texto12"> D&iacute;as trabajados: </label> '.$lbldiastrab2.' </td>
                  <td width="255"> <label class="Texto12"> Transporte: </label> '.number_format($auxtransporte).' </td>
                  <td width="206"> &nbsp; </td>
                  <td width="206"> &nbsp; </td>
                 </tr>
                </table>';

        if($norecalcular == "CHECKED")
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <center>
                      <td width="657" align="center"> &nbsp; </td>
                      </center>
                     </tr>
                    </table>';
        else
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <center>
                      <td width="657" align="center">                    
                       <input type="submit" value="calcular" class="button blue">
                       </form>
                      </td>
                      </center>
                     </tr>
                    </table>';

        $cont.='<table width="100%"> 
                 <tr class="CabezoteTabla">
                  <td width="47" align="center"> '.$botonelicesantia.' </td>
                  <td width="352"> <label class="Texto12"> Cesant&iacute;as: </label> </td>
                  <td width="255"> <label class="Texto12"> Pago: </label> '.$htmlpagocesantias.' </td>
                  <td width="206"> <label class="Texto12"> Porc.: </label> '.$htmlporcesantias.' % </td>
                  <td width="206"> <label class="Texto11"> Intereses: </label> '.$htmlpagointereses.' </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="47" align="center"> '.$botoneliprima.' </td>
                  <td width="352"> <label class="Texto12"> Primas: </label> </td>
                  <td width="255"> <label class="Texto12"> D&iacute;as: </label> '.$htmldiasprima.' </td>
                  <td width="206"> <label class="Texto12"> Pago: </label> '.$htmlpagoprimas.' </td>
                  <td width="206"> &nbsp; </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="47" align="center"> '.$botonelivaca.' </td>
                  <td width="352"> <label class="Texto12"> Vacaciones: </label> </td>
                  <td width="255"> <label class="Texto12"> D&iacute;as: </label> '.$htmldiasvaca.' </td>
                  <td width="206"> <label class="Texto12"> Pago: </label> '.$htmlpagovaca.' </td>
                  <td width="206"> &nbsp; </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="47" align="center"> '.$botoneliindem.' </td>
                  <td width="352"> <label class="Texto12"> Indemnizaci&oacute;n: </label> </td>
                  <td width="255"> <label class="Texto12"> Pago: </label> '.$htmlpagoinde.' </td>
                  <td width="206"> &nbsp; </td>
                  <td width="206"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <center>
                  <td width="657" align="center"> <b> Otros conceptos </b> </td>
                  </center>
                 </tr>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="12"> &nbsp; </td>
                   <td width="290"> Concepto </td>
                   <td width="320" align="right"> Devengados </td>			
                   <td width="23" align="right"> &nbsp; </td>
                   <td width="320" align="right"> Descuentos </td>
                   <td width="60"> &nbsp; </td>
                  </tr>
                </thead>
                <tbody style="display:block; width:1050px; height:150px; overflow-Y:scroll">';

        // Consulta con los demás conceptos del empleado en el periodo
        $vsql = "SELECT c.nomconcepto, d.devengados, d.descuentos, c.tipodc, d.conceptoid 
                   FROM detalleliquidacion d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.pernominaid IN ($listaperiodos)
                        AND d.terid = ".$terid."
                        AND d.conceptoid NOT IN (1,3,4,5)
               ORDER BY c.tipodc, c.codconcepto";

        // Conexión a la base de datos
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);

        // Inicialización de variables
        $totdevengado = 0;
        $totdescuento = 0;
        $netoapagar = 0;

        // Validación de la ejecución del ciclo
        if($cant>0)
        {
            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
    
                $cont.=' <td width="12">&nbsp;  </td>
                         <td width="290"> '.$row['nomconcepto'].' </td>';

                // Impresión del monto si es un devengado
                if($row['tipodc']=="C")
                {
                    $cont.=' <td width="320" align="right">'.number_format($row['devengados']).' </td>
                             <td width="23" align="right"> &nbsp; </td>
                             <td width="320" align="right"> &nbsp; </td>
                             <td width="60"> &nbsp; </td>
                            </tr>';

                    $totdevengado += $row['devengados'];
                }

                // Impresión del monto si es un descuento
                if($row['tipodc']=="D")
                {
                    $cont.=' <td width="320" align="right"> &nbsp; </td>
                             <td width="23" align="right"> &nbsp; </td>
                             <td width="320" align="right">'.number_format($row['descuentos']).' </td>
                             <td width="60"> &nbsp; </td>
                            </tr>';
                                                                                                  
                    if(($row['conceptoid']!=6)&&($row['conceptoid']!=9)&&($row['conceptoid']!=43)&&($row['conceptoid']!=58))
                        $totdescuento += $row['descuentos'];
                }
            }
        }

        $cont.=' </tbody>
                </table>';

        // Cálculo de los totales
        $totdevengado += $sueldo + $auxtransporte + $pagoprimas + $pagovaca + $pagocesantias + $pagointereses + $pagoinde;
        $totdescuento += ($pension + $salud);
        $netoapagar = $totdevengado - $totdescuento;

        // Impresión de los totales
        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Total devengado: </b> '.number_format($totdevengado,2).' </font> </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Total descuentos: </b> '.number_format($totdescuento,2).' </font> </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Neto a pagar: </b> '.number_format($netoapagar,2).' </font> </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirelivaca
    // Creación: 03/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de las vacaciones del empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confirelivaca")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);

        // Días de vacaciones
        $vsqlcanvacaciones = "SELECT cantidad AS canvacaciones
                                FROM liquidacion
                               WHERE terid=".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'vacaciones'";
        $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

        if($canvacaciones==NULL)
            $canvacaciones = 0;

        // Pago de vacaciones
        $vsqlpagovaca = "SELECT pago AS pagovaca
                           FROM liquidacion
                          WHERE terid=".$terid."
                                AND periodonomina = '".$codperiodo."' 
                                AND tipo = 'vacaciones'";
        $pagovaca = $clase->SeleccionarUno($vsqlpagovaca);

        if($pagovaca==NULL)
            $pagovaca = 0;

        // id de las vacaciones
        $vsqlidliquidacion = "SELECT idliquidacion
                                FROM liquidacion
                               WHERE terid=".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'vacaciones'";
        $idliquidacion = $clase->SeleccionarUno($vsqlidliquidacion);

        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Eliminar vacaciones</b><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center">¿Confirma que desea eliminar las vacaciones al empleado<br><b> '.$nombreemp.'</b> <br> de <b>'.$canvacaciones.'</b> d&iacute;as por un monto de <b>'.number_format($pagovaca).' </b> pesos?</td>
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=eliminarvacaciones" method="POST">
                   <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">
                   <input type="hidden" name="terid" value="'.$terid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   <a href="calculoliquidados.php?opcion=ventanareprocesarliq&periodoid='.$periodoid.'&terid='.$terid.'" ><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarvacaciones
    // Creación: 03/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina las vacaciones de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminarvacaciones")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];

        $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
        $clase->EjecutarSQL($vsql);

        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se eliminaron las vacaciones");
        else
            $clase->Aviso(1,"Vacaciones eliminadas satisfactoriamente");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=ventanareprocesarliq&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confireliprima
    // Creación: 03/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de la prima del empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confireliprima")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);

        // Días de la prima
        $vsqlcanprimas = "SELECT cantidad AS canprimas
                            FROM liquidacion
                           WHERE terid = ".$terid."
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'primas'";
        $canprimas = $clase->SeleccionarUno($vsqlcanprimas);

        if($canprimas==NULL)
            $canprimas = 0;

        // Pago de la prima
        $vsqlpagoprimas = "SELECT pago AS pagoprimas
                             FROM liquidacion
                            WHERE terid = ".$terid."
                                  AND periodonomina = '".$codperiodo."' 
                                  AND tipo = 'primas'";
        $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);

        if($pagoprimas==NULL)
            $pagoprimas = 0;

        // id de la prima
        $vsqlidliquidacion = "SELECT idliquidacion
                                FROM liquidacion
                               WHERE terid = ".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'primas'";
        $idliquidacion = $clase->SeleccionarUno($vsqlidliquidacion);

        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Eliminar prima</b><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center">¿Confirma que desea eliminar la prima al empleado<br><b> '.$nombreemp.'</b> <br> de <b>'.$canprimas.'</b> d&iacute;as por un monto de <b>'.number_format($pagoprimas).' </b> pesos?</td>
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=eliminarprima" method="POST">
                   <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">
                   <input type="hidden" name="terid" value="'.$terid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   <a href="calculoliquidados.php?opcion=ventanareprocesarliq&periodoid='.$periodoid.'&terid='.$terid.'" ><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarprima
    // Creación: 03/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina la prima de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminarprima")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];

        $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
        $clase->EjecutarSQL($vsql);

        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se eliminó la prima");
        else
            $clase->Aviso(1,"Prima eliminada satisfactoriamente");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=ventanareprocesarliq&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirelicesantia
    // Creación: 06/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de la cesantía
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confirelicesantia")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);

        // Pago de la cesantía
        $vsqlpagocesantia = "SELECT pago AS pagocesantia
                               FROM liquidacion
                              WHERE terid = ".$terid."
                                    AND periodonomina = '".$codperiodo."' 
                                    AND tipo = 'cesantias'";
        $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);

        if($pagocesantia==NULL)
            $pagocesantia = 0;

        // Porcentaje cesantía
        $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                               FROM liquidacion
                              WHERE terid = ".$terid."
                                    AND periodonomina = '".$codperiodo."' 
                                    AND tipo = 'cesantias'";
        $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);

        if($porccesantia==NULL)
            $porccesantia = 0;

        // Pago de intereses de cesantías
        $vsqlpagointereses = "SELECT pagointereses AS pagointereses
                                FROM liquidacion
                               WHERE terid = ".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'cesantias'";
        $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);

        if($pagointereses==NULL)
            $pagointereses = 0;

        // id de la cesantía
        $vsqlidliquidacion = "SELECT idliquidacion
                                FROM liquidacion
                               WHERE terid = ".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'cesantias'";
        $idliquidacion = $clase->SeleccionarUno($vsqlidliquidacion);

        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Eliminar cesant&iacute;a</b><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center">¿Confirma que desea eliminar la cesant&iacute;a al empleado<br><b> '.$nombreemp.'</b> <br> por un monto de <b>'.number_format($pagocesantia).' </b> pesos <br> con un porcentaje <b>'.number_format($porccesantia).' </b> % y pago de intereses <b>'.number_format($pagointereses).'</b>?</td>       
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=eliminarcesantia" method="POST">
                   <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">
                   <input type="hidden" name="terid" value="'.$terid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   <a href="calculoliquidados.php?opcion=ventanareprocesarliq&periodoid='.$periodoid.'&terid='.$terid.'" ><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarcesantia
    // Creación: 06/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina la cesantía de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminarcesantia")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];

        $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
        $clase->EjecutarSQL($vsql);

        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se eliminó la cesantía");
        else
            $clase->Aviso(1,"Cesantía eliminada satisfactoriamente");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=ventanareprocesarliq&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confireliindem
    // Creación: 06/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de una indemnización
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confireliindem")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);

        $vsqlindemnizacion = "SELECT pago AS indemnizacion
                                FROM liquidacion
                               WHERE terid=".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'indemnizacion'";
        $indemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);

        if($indemnizacion==NULL)
            $indemnizacion=0;

        // id de la cesantía
        $vsqlidliquidacion = "SELECT idliquidacion
                                FROM liquidacion
                               WHERE terid=".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'indemnizacion'";
        $idliquidacion = $clase->SeleccionarUno($vsqlidliquidacion);

        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Eliminar indemnizaci&oacute;n</b><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center">¿Confirma que desea eliminar la indemnizaci&oacute;n al empleado<br><b> '.$nombreemp.'</b> <br> por un monto de <b>'.number_format($indemnizacion).' </b> pesos?</td>       
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=eliminarinde" method="POST">
                   <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">
                   <input type="hidden" name="terid" value="'.$terid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   <a href="calculoliquidados.php?opcion=ventanareprocesarliq&periodoid='.$periodoid.'&terid='.$terid.'" ><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarinde
    // Creación: 06/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina la indemnización de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminarinde")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];

        $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
        $clase->EjecutarSQL($vsql);

        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se eliminó la indemnización");
        else
            $clase->Aviso(1,"Indemnización eliminada satisfactoriamente");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=ventanareprocesarliq&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarelim
    // Creación: 03/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de toda una liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "confirmarelim")
    {
        $terid = $_GET['terid'];
        $listaperiodos = $_GET['listaperiodos'];
        $codperiodo = $_GET['codperiodo'];

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Pintamos la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Eliminar liquidaci&oacute;n</b><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"> ¿Confirma que desea eliminar la liquidaci&oacute;n del empleado<br><b> '.$nombreemp.'</b>? </td>       
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=eliminarliq" method="POST">
                   <input type="hidden" name="terid" value="'.$terid.'">
                   <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                   <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   <a href="calculoliquidados.php?opcion=ventanareprocesarliq&periodoid='.$periodoid.'&terid='.$terid.'"><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: eliminarliq
    // Creación: 13/12/2021		última modificación: 04/04/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que elimina completamente una liquidación de un empleado
    // Última modificación: Eliminación del registro en la tabla de parámetros de 
    //                      liquidación (19/02/2024)
    //                      Se revirtió la eliminación de la tabla parámetros de liquidación
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminarliq")
    {
        $terid = $_POST['terid'];
        $listaperiodos = $_POST['listaperiodos'];
        $codperiodo = $_POST['codperiodo'];

        // Elimino los registros en el detalle de liquidación
        $vsql = "DELETE FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)";
        $clase->EjecutarSQL($vsql);

        if(mysql_affected_rows() < 1)
            $eliminodet = false;
        else
            $eliminodet = true;

        // Elimino los registros en la tabla de liquidación
        $vsql = "DELETE FROM liquidacion WHERE terid=".$terid." AND periodonomina = '".$codperiodo."'";
        $clase->EjecutarSQL($vsql);

        // // Elimino los registros en la tabla de parámetros de liquidación
        // $vsql = "DELETE FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        // $clase->EjecutarSQL($vsql);

        // if(mysql_affected_rows() < 1)
        //     $eliminoliq = false;
        // else
        //     $eliminoliq = true;

        // // Emito el mensaje correspondiente
        // if($eliminodet||$eliminoliq)
        //     $clase->Aviso(1,"Liquidación eliminada exitosamente");
        // else
        //     $clase->Aviso(3,"No se eliminó la liquidación");

        // Emito el mensaje correspondiente
        if($eliminodet)
            $clase->Aviso(1,"Liquidación eliminada exitosamente");
        else
            $clase->Aviso(3,"No se eliminó la liquidación");        

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=ventanaliquidados");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanaliquidados
    // Creación: 22/11/2021		última modificación: 15/08/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Ventana donde se selecciona el empleado al cual se le calculará la 
    //              liquidación
    // Última modificación: Incorporación de los botones para la importación desde Excel de 
    //                      las dotaciones y su proceso manual (04/03/2022)
    //                      Se trasladaron los botones de los procesos adicionales debajo 
    //                      del botón de aceptar (06/04/2022)
    //                      Nuevo botón para importar las novedades (25/07/2022)
    //                      nuevos botones para la importación desde Excel de las libranzas 
    //                      y los descuentos permanentes y su procesamiento manual 
    //                      (04/08/2022)
    //                      Incorporación del botón de la importación de las novedades
    //                      (19/08/2022)
    //                      Inclusión de los botones para activar masivamente empleados a la 
    //                      nómina y extralegales mediante una hoja de Excel (03/10/2022)
    //                      Incorporación del pie de página
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "ventanaliquidados")
    {
        // Consulta para el combo de empleados
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                                AND basico > 0
                       ORDER BY primernombre";

        // Periodo anterior
        $vsql = "SELECT periodoid
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MAX(periodoid) FROM periodosnomina WHERE calculado ='CHECKED')";
        $periodoid = $clase->SeleccionarUno($vsql);

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Nombre del periodo
        $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $codperiodo = substr($fecdesde,5,2).substr($fecdesde,0,4);
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Validación del enlace para las importaciones de las liquidaciones
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];
        // if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
        //     $vimportarliq = '<img src="images/iconos/exportarexcel2.png" border="0" width="38" height="38" title="importar desde Excel las liquidaciones - debe ir al servidor 248">';
        // else
        //     $vimportarliq = '<a href="importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo='.$codperiodo.'&periodoid='.$periodoid.'" title="importar desde Excel las liquidaciones" target="_blank"> 
        //                       <img src="images/iconos/exportarexcel2.png" border="0" width="38" height="38" title="importar desde Excel las liquidaciones"> 
        //                      </a> ';

        $vimportarliq = '<a href="importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo='.$codperiodo.'&periodoid='.$periodoid.'" title="importar desde Excel las liquidaciones" target="_blank"> 
                          <img src="images/iconos/exportarexcel2.png" border="0" width="38" height="38" title="importar desde Excel las liquidaciones"> 
                         </a> ';

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/retirados.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Empleados liquidados para el periodo <font color="BLUE">'.$desperiodo.'</font></b> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> <a href="principal.php"> <input type="button" value="<<" class="button blue"> </a> </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';
    
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <form action="?opcion=ventanareprocesarliq" method="POST" name="x">                  
                  <input type="hidden" name="periodoid" value="'.$periodoid.'">                  
                  <td width="700"> <label class="Texto12"> Empleado:</label>
                   '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,550).'
                  </td>                  
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="terceros.php" title="acceder a la ficha terceros" target="_blank">
                    <img src="images/iconos/terceros.png" border="0" width="38" height="38">                    
                   </a> 
                  </td>';
                  
        // Botón para administrar los registros duplicados
        if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED"))
            $cont.='  <td width="20">
                       <a href="?opcion=ventanaactdatos" title="actualizar datos" target="_blank">
                        <img src="images/iconos/guardardoc.png" border="0" width="38" height="38">                      
                       </a>
                      </td>';
        // else
        //     $cont.='  <td width="20"> &nbsp; </td>';

        // --------------------------------------------------------------------------------------------------------------------------- //
        // Nota: esto se debe activar en el caso de que sea solicitado, en el archivo ajusteextemporaneo.php en la opción seldatosext 
        //       en el control de permisos hay que incluir al usuario DROPOS.NOMINA para que pueda entrar.
        // if($_SESSION['USERNAME'] == "DROPOS.NOMINA")
        //     $cont.= '  <td width="50">
        //                 <a href="ajusteextemporaneo.php?opcion=seldatosext" title="editar datos periodos anteriores" target="_blank">
        //                  <img src="images/iconos/agenda.png" border="0" width="38" height="38">                     
        //                 </a>
        //                </td>';
    
        // --------------------------------------------------------------------------------------------------------------------------- //
        if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED"))
            $cont.='  <td width="20"> <img src="images/iconos/calculando.png" border="0" width="38" height="38" title="editar periodo cerrado (opción para usuarios de n&oacute;mina)"> </td>
                      <td width="10"> &nbsp; </td>                  
                      <td width="20"> '.$vimportarliq.' </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';
        else
        {
            // Validación de los periodos que se editarán
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoidactualw = $clase->SeleccionarUno($vsql);

            $segundaq = ($periodoidactualw - 1);
            $primeraq = ($periodoidactualw - 2);

            $vsql35 = "SELECT COUNT(*) AS permodact FROM periodosnomina WHERE periodoid IN ($primeraq,$segundaq) AND transmitido <> 'CHECKED'";
            $permodact = $clase->SeleccionarUno($vsql35);

            // Validación del usuario
            if(($_SESSION['USERNAME'] == 'DROPOS.NOMINA')||($_SESSION['SUPERUSUARIO'] == 'CHECKED'))
                $puedeeditarper = true;
            else
                $puedeeditarper = false;

            // Pinto el botón
            if(($permodact > 0) && $puedeeditarper)
            {
                $origen = "actdatos";
                $cont.='  <td width="20">
                           <a href="?opcion=venteditarperant&periodoid='.$periodoid.'&origen='.$origen.'" title="editar periodos cerrado" rel="facebox">
                            <img src="images/iconos/calculando.png" border="0" width="38" height="38">
                           </a>
                          </td>
                          <td width="10"> &nbsp; </td>                  
                          <td width="20"> '.$vimportarliq.' </td>
                          <td width="24"> &nbsp; </td>
                         </tr>
                        </table>';
            }
            else
                $cont.='  <td width="20"> <img src="images/iconos/calculando.png" border="0" width="38" height="38"> </td>
                          <td width="10"> &nbsp; </td>                  
                          <td width="20"> '.$vimportarliq.'  </td>
                          <td width="24"> &nbsp; </td>
                         </tr>
                        </table>';
        }
            
        // --------------------------------------------------------------------------------------------------------------------------- //    
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editarlibyperm
    // Creación: 05/08/2022		última modificación: 12/08/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Ventana para la captación de datos del proceso manual de las libranzas  
    //              y los descuentos permanentes
    // Última modificación: Validación del cálculo del periodo
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "editarlibyperm")
    {
        $periodoidanterior = $_GET["periodoidanterior"];
        $tipodesc = $_GET["tipodesc"];

        $descripcionant = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');
            
        $vsql = "SELECT count(*) 
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoidanterior;
        $valorperiodo = $clase->SeleccionarUno($vsql);
        
        $cont = '';

        if($valorperiodo==0)            
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Periodo no calculado </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> No se pueden procesar estos datos porque <br>el periodo '.strtolower($descripcionant).'<br> no ha sido calculado <br> </font><br>                            
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="400" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=ventanaliquidados" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            $params = ' class="Texto12" ';
    
            // combo de empleados
            $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                               FROM terceros 
                              WHERE (primernombre <> '' AND primerapellido <> '')
                           ORDER BY primernombre";
            $monto = 1;
    
            // Combo de conceptos
            $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto
                                    FROM conceptosnomina ";
    
            if($tipodesc=="ambas")      $vsqlcomboconcepto.= "WHERE eslibranza = 'CHECKED' OR montopermanente = 'CHECKED' ";
            if($tipodesc=="descperm")   $vsqlcomboconcepto.= "WHERE montopermanente = 'CHECKED' ";
            if($tipodesc=="libranza")   $vsqlcomboconcepto.= "WHERE eslibranza = 'CHECKED' ";
    
            $vsqlcomboconcepto.= " ORDER BY conceptoid ASC";
    
            $descripcionant = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');
    
            // Pintamos la ventana        
            $cont.='<table width="500">
                     <tr class="CabezoteTabla">
                      <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>';
    
            if($tipodesc=="ambas")      $cont.='<td align="center"> <b>Edici&oacute;n de libranzas y descuentos permanentes <br><font color="BLUE">'.strtolower($descripcionant).'</font></b><br><br></td> ';
            if($tipodesc=="descperm")   $cont.='<td align="center"> <b>Edici&oacute;n de descuentos permanentes <br><font color="BLUE">'.strtolower($descripcionant).'</font></b><br><br></td> ';
            if($tipodesc=="libranza")   $cont.='<td align="center"> <b>Edici&oacute;n de libranzas<br> <font color="BLUE">'.strtolower($descripcionant).'</font></b><br><br></td> ';
    
            $cont.='  </tr> 
                    </table>                
                    <form action="?opcion=guardarlibyperm" name="y" method="POST">
                    <input type="hidden" name="periodoidanterior" value="'.$periodoidanterior.'">
                    <table width="500">                 
                     <tr class="CabezoteTabla">
                      <td width="10"> &nbsp; </td>
                      <td align="left"><label class="Texto12">Empleado:</label>';
    
            $cont.= $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,400);
                       
            $cont.='  </td>                  
                     </tr>                 
                     <tr class="CabezoteTabla">
                      <td width="10"> &nbsp; </td>
                      <td align="left"><label class="Texto12">concepto:</label>                  
                       '.$clase->CrearComboEsp("conceptoid",$vsqlcomboconcepto,"conceptoid","nomperiodo",$conceptoid,"N",$params).'
                      </td>                  
                     </tr>
                     <tr class="CabezoteTabla">
                      <td width="10"> &nbsp; </td>
                      <td align="left"><label class="Texto12">Monto:</label>&nbsp;&nbsp;&nbsp;&nbsp;
                       <input type="number" name="monto" min="1" class="Texto11New" size="2" autocomplete="off" title="monto de la dotaci&oacute;n" value="'.$monto.'">                  
                      </td>
                     </tr>
                    </table>
                    <table width="500">
                     <tr class="CabezoteTabla">
                      <td align="center">                    
                       <input type="submit" value="aceptar" class="button blue">
                       </form>
                      </td>
                     </tr>
                    </table>';
        }
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarlibyperm
    // Creación: 05/08/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para almacenar las libranzas y los descuentos permanentes 
    //              procesados manualmente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarlibyperm")
    {
        $terid = $_POST['terid'];
        $conceptoid = $_POST['conceptoid'];
        $monto = $_POST['monto'];
        $periodoidanterior = $_POST['periodoidanterior'];

        // Validación de los datos
        if((strlen($terid)==0) || (strlen($conceptoid)==0) || (strlen($monto)==0) || (strlen($periodoidanterior)==0))
            $clase->Aviso(3,"Debe ingresar todos los datos");
        else
        {
            // Valido que el concepto asignado a un empleado no esté repetido
            $vsql3 = "SELECT count(*) AS valreg
                        FROM detallenomina
                       WHERE pernominaid = ".$periodoidanterior."
                             AND terid = ".$terid."
                             AND conceptoid = ".$conceptoid;
            $valreg = $clase->SeleccionarUno($vsql3);

            if($valreg>0)
            {
                $vsql4 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid=".$terid;
                $nombreemp = $clase->SeleccionarUno($vsql4);
    
                $vsql5 = "SELECT nomconcepto FROM conceptosnomina WHERE conceptoid=".$conceptoid;
                $nomconcepto = $clase->SeleccionarUno($vsql5);
    
                $clase->Aviso(3,"$nombreemp ya tiene $nomconcepto en este periodo");
            }
            else
            {
                // Obtengo el número de registros de la tabla detallenomina
                $vsql = "SELECT MAX(detalleid) FROM detallenomina";
                $numeroid = $clase->SeleccionarUno($vsql);
        
                // Incremento el ID
                $numeroid++;
        
                // Determino el tipo de concepto
                $tipodc = $clase->BDLockup($periodoidanterior,'conceptosnomina','conceptoid','tipodc');
        
                // Construyo la instrucción
                if($tipodc=="C")
                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                    VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidanterior.",".$monto.",0,0,0)";
                else
                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidanterior.",0,".$monto.",0,0)";
        
                // Almaceno en la tabla
                $clase->EjecutarSQL($vsql);
        
                // Emito el mensaje correspondiente
                if(mysql_affected_rows() >= 1)
                    $clase->Aviso(1,"Datos almacenados satisfactoriamente");
                else
                    $clase->Aviso(3,"No se almacenaron los datos");
            }
        }

        // Redirecciona el formulario
        header("Location: calculoliquidados.php?opcion=ventanaliquidados");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: incluirconcepto
    // Creación: 23/11/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Ventana para la inclusión de conceptos para los liquidados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "incluirconcepto")
    {
        $periodoid = $_GET['periodoid'];
        $terid = $_GET['terid'];

        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Nombre del empleado
        $sqlnomemp = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                        FROM terceros 
                       WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($sqlnomemp);

        // Conceptos para liquidados
        $vsqlcombooca = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) 
                           FROM conceptosnomina 
                          WHERE (montoocasional = 'CHECKED' OR montopermanente = 'CHECKED' OR eslibranza = 'CHECKED')
                       ORDER BY conceptoid";
        $params = ' class="Texto11" ';
        $monto = 1;
        
        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/egresos.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Inclusi&oacute;n de conceptos para liquidados </b></td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=guardarconliq" method="POST">
                 <input type="hidden" name="periodoid" value="'.$periodoid.'">
                 <input type="hidden" name="terid" value="'.$terid.'">
                  <fieldset style="width: 530px; height: 280px;" class="grupos">
                  <legend class="titgrupos"> Datos </legend>
                  <table width="350">
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Empleado: </b> </label> <br> <h2> '.$nombreemp.' </h2> </td>                   
                   </tr>
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Concepto:</b></label><br>';

        $cont.= $clase->CrearComboBuscar("conceptoid",$vsqlcombooca,"nombres","conceptoid","","N",$params,420);

        $cont.='    </td>                   
                   </tr>
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Monto:</b></label><br>
                     <input type="number" name="monto" min="1" class="Texto12New" size="20" autocomplete="off" title="monto a descontar" value="'.$monto.'"> 
                    </td>                   
                   </tr>                    
                   <tr height="55">
                    <td align="center"><br><br> 
                     <input type="submit" value="guardar" class="button blue"> 
                    </td>
                   </tr>
                  </table>
                 </form>
                 <br><br>
                 </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarconliq
    // Creación: 23/11/2021		última modificación: 14/07/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para guardar en la tabla correspondiente el concepto para 
    //              liquidados
    // Última modificación: Validación para no repetir un concepto
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarconliq")
    {
        $periodoid = $_POST['periodoid'];
        $conceptoid = $_POST['conceptoid'];
        $terid = $_POST['terid'];
        $monto = $_POST['monto'];

        // Validación para no repetir un concepto
        $vsql2 = "SELECT COUNT(*) AS numregistro
                    FROM detalleliquidacion
                   WHERE terid=".$terid."
                         AND conceptoid = '".$conceptoid."'
                         AND pernominaid = '".$periodoid."'";
        $numregistro = $clase->SeleccionarUno($vsql2);

        if($numregistro>0)
        {
            $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid=".$terid;
            $nombreemp = $clase->SeleccionarUno($vsql3);

            $vsql4 = "SELECT nomconcepto FROM conceptosnomina WHERE conceptoid=".$conceptoid;
            $nomconcepto = $clase->SeleccionarUno($vsql4);

            $clase->Aviso(3,"$nombreemp ya tiene $nomconcepto en este periodo");
        }
        else
        {
            // Obtengo el número de registros de la tabla detallenomina
            $vsql = "SELECT MAX(detalleid) FROM detalleliquidacion";
            $numeroid = $clase->SeleccionarUno($vsql);
    
            // Incremento el ID
            $numeroid++;
    
            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
        
            // Almaceno en la tabla el concepto de compras a crédito para el trabajador
            if($tipodc=="C")
                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                 VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
            else
                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
    
            $clase->EjecutarSQL($vsql);
    
            // Envío el mensaje correspondiente
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se procesó el concepto, verifique por favor");
            else
                $clase->Aviso(1,"Concepto procesado exitosamente");
        }

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=ventanareprocesarliq&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: eliminarconcepto
    // Creación: 23/11/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Ventana para seleccionar el concepto que se le eliminará a un empleado 
    //              liquidado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarconcepto")
    {
        $listaperiodos = $_GET['listaperiodos'];
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];

        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Nombre del empleado
        $sqlnomemp = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                        FROM terceros 
                       WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($sqlnomemp);

        // Conceptos para liquidados
        $vsqlcombooca = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) 
                           FROM conceptosnomina 
                          WHERE (montoocasional = 'CHECKED' OR montopermanente = 'CHECKED' OR eslibranza = 'CHECKED')
                       ORDER BY conceptoid";
        $params = ' class="Texto11" ';

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/anulardoc.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Eliminar un concepto a un empleado liquidado </b></td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=eliminarconliq" method="POST">
                 <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                 <input type="hidden" name="periodoid" value="'.$periodoid.'">
                 <input type="hidden" name="terid" value="'.$terid.'">
                  <fieldset style="width: 530px; height: 220px;" class="grupos">
                  <legend class="titgrupos"> Datos </legend>
                  <table width="350">
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Empleado: </b></label><br>'.$nombreemp.' </td>                   
                   </tr>
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Concepto:</b></label><br>';

        $cont.= $clase->CrearComboBuscar("conceptoid",$vsqlcombooca,"nombres","conceptoid","","N",$params,420);

        $cont.='    </td>                   
                   </tr>
                   <tr height="55">
                    <td align="center"><br><br> 
                     <input type="submit" value="guardar" class="button blue"> 
                    </td>
                   </tr>
                  </table>
                 </form>
                 <br><br>
                 </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: eliminarconliq
    // Creación: 23/11/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un concepto a un empleado liquidado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "eliminarconliq")
    {
        $periodoid = $_POST['periodoid'];
        $conceptoid = $_POST['conceptoid'];
        $terid = $_POST['terid'];
        $listaperiodos = $_POST['listaperiodos'];        

        $vsql = "DELETE FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = ".$conceptoid."";        
        $clase->EjecutarSQL($vsql);

        // Envío el mensaje correspondiente
        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se eliminó el concepto, verifique por favor");
        else
            $clase->Aviso(1,"Concepto eliminado exitosamente");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=ventanareprocesarliq&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: calculosliq
    // Creación: 23/11/2021		última modificación: 17/03/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que realiza el cálculo de la liquidación de un empleado
    // Última modificación: Eliminación de los registros en la tabla detalleliquidacion 
    //                      para evitar duplicidad al recalcular la liquidación 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "calculosliq")
    {
        $diastrab = $_POST['diastrab'];
        $basico = $_POST['basico'];
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];
        $diastrab2 = $_POST['diastrab2'];
        $diasvaca = $_POST['diasvaca'];
        $pagovaca = $_POST['pagovaca'];
        $pagocesantias = $_POST['pagocesantias'];
        $porcesantias = $_POST['porcesantias'];
        $pagointereses = $_POST['pagointereses'];
        $diasprima = $_POST['diasprima'];
        $pagoprimas = $_POST['pagoprimas'];
        $pagoinde = $_POST['pagoinde'];
        $codperiodo = $_POST['codperiodo'];
        $listaperiodos = $_POST['listaperiodos'];
        $numreg = 0;
        $numregliq = 0;

        // Obtengo el salario mínimo legal vigente
        $smlv = $_SESSION['N_SALMIN2020'];

        // Obtengo la formula del sueldo
        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
        $formulabasico = $clase->SeleccionarUno($vsql);

        // Calculo el sueldo básico
        eval("\$sueldo = $formulabasico;");
        $sueldo = round($sueldo,0);

        // --------------------------------------------------------------------------------------------------- //
        // Determino si el empleado posee pagos de quincena en liquidación para eliminárselo        
        $vsqldatos = "";
        $vsqldatos = "SELECT COUNT(*) AS numregliq 
                        FROM detalleliquidacion 
                       WHERE pernominaid IN ($listaperiodos) 
                             AND terid = ".$terid;
        $numregliq = $clase->SeleccionarUno($vsqldatos);

        if($numregliq>0)
        {
            $vsql = "DELETE FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid;
            $clase->EjecutarSQL($vsql);
        }
        // --------------------------------------------------------------------------------------------------- //
        // sueldo
        $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
        $numreg = $clase->SeleccionarUno($vsql);
        $numreg++;

        $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",$basico)";        
        $clase->EjecutarSQL($vsql);
        
        // Recalculo el subsidio de transporte
        $valsubtrasp = $smlv * 2;       // Variable para la validación del auxilio de transporte

        // Obtengo la formula para el subsidio de transporte
        $auxtrans = $_SESSION['N_AUXTRANS2020'];
        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
        $formulatransporte = $clase->SeleccionarUno($vsql);

        $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                       // Obtengo el cargo del empleado
        $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte

        if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
        {
            // Calculo el subsidio de transporte
            $aux_trans = $diastrab;
            $diastrab = $diastrab2;

            eval("\$subsidiotransporte = $formulatransporte;");
            $subsidiotransporte = round($subsidiotransporte,0);

            $diastrab = $aux_trans;
        }
        else
            $subsidiotransporte = 0;

        // Le coloco subsidio de transporte en cero a 
        // quienes devengan un básico de 750.000 pesos
        if($basico==750000)
            $subsidiotransporte = 0;

        // Obtengo el valor del subsidio de transporte
        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];

        $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
        $numreg = $clase->SeleccionarUno($vsql);
        $numreg++;

        $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
        $clase->EjecutarSQL($vsql);

        // Determino si el empleado es de condición extralegal
        $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
        $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
        $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
        
        if($epsid==NULL)                $epsid=0;
        if($pensionesid==NULL)          $pensionesid=0;

        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                   FROM detalleliquidacion d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
        $totnovedades = $clase->SeleccionarUno($vsql);

        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
        $totrecargos = $clase->SeleccionarUno($vsql);

        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

        $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');   // Obtengo el control del cálculo de pensión
        $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');   // Obtengo el control del cálculo de salud

        if($extralegal=="CHECKED")
        {
            $pension = 0;
            $salud = 0;
        }
        else
        {
            // Recalculo pensión y salud
            if(($pensionesid==5)||($aplicapension!="CHECKED"))
                $pension = 0;
            else
            {
                // Obtengo la formula para el descuento por pensión
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                $formulapension = $clase->SeleccionarUno($vsql);

                // Calculo la pensión
                eval("\$pension = $formulapension;");
                $pension = round($pension,0);
            }

            if(($epsid==37)||($aplicasalud!="CHECKED"))
                $salud = 0;
            else
            {
                // Obtengo la formula para el descuento de salud
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                $formulasalud = $clase->SeleccionarUno($vsql);
                
                // Calculo la salud
                eval("\$salud = $formulasalud;");
                $salud = round($salud,0);
            }
        }

        // ------------------------------------------------------------------------------------------------------------------------------------ //
        // pensión
        $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
        $numreg = $clase->SeleccionarUno($vsql);
        $numreg++;

        $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
        $clase->EjecutarSQL($vsql);

        // salud
        $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
        $numreg = $clase->SeleccionarUno($vsql);
        $numreg++;

        $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
        $clase->EjecutarSQL($vsql);

        // Aquí depuro los conceptos que estén en cero
        $vsql = "DELETE FROM detalleliquidacion WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid =".$terid."";
        $clase->EjecutarSQL($vsql);

        // Primas
        if(($diasprima>=0)||($pagoprimas>=0))
        {
            $vsql2 = "SELECT COUNT(*) AS numregistro
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'primas'";
            $numregistro = $clase->SeleccionarUno($vsql2);

            if($numregistro>0)
            {
                $vsql3 = "SELECT idliquidacion
                            FROM liquidacion
                           WHERE terid=".$terid."
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'primas'";
                $idliquidacion = $clase->SeleccionarUno($vsql3);

                $vsql4 = "UPDATE liquidacion SET 
                                 pago = ".$pagoprimas.",
                                 cantidad = ".$diasprima."                               
                           WHERE idliquidacion = ".$idliquidacion."";
            }
            else
                $vsql4 = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                           VALUES ('".$codperiodo."',".$terid.",'primas',".$pagoprimas.",".$diasprima.",0,0)";

            $clase->EjecutarSQL($vsql4);
        }

        // Vacaciones
        if(($diasvaca>=0)||($pagovaca>=0))
        {
            $vsql2 = "SELECT COUNT(*) AS numregistro
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'vacaciones'";
            $numregistro = $clase->SeleccionarUno($vsql2);

            if($numregistro>0)
            {
                $vsql3 = "SELECT idliquidacion
                            FROM liquidacion
                           WHERE terid=".$terid."
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'vacaciones'";
                $idliquidacion = $clase->SeleccionarUno($vsql3);

                $vsql4 = "UPDATE liquidacion SET 
                                 pago = ".$pagovaca.",
                                 cantidad = ".$diasvaca."                               
                           WHERE idliquidacion = ".$idliquidacion."";
            }
            else
                $vsql4 = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                           VALUES ('".$codperiodo."',".$terid.",'vacaciones',".$pagovaca.",".$diasvaca.",0,0)";

            $clase->EjecutarSQL($vsql4);
        }

        // Cesantías
        if(($pagocesantias>=0)||($porcesantias>=0)||($pagointereses>=0))
        {
            $vsql2 = "SELECT COUNT(*) AS numregistro
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'cesantias'";
            $numregistro = $clase->SeleccionarUno($vsql2);

            if($numregistro>0)
            {
                $vsql3 = "SELECT idliquidacion
                            FROM liquidacion
                           WHERE terid=".$terid."
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'cesantias'";
                $idliquidacion = $clase->SeleccionarUno($vsql3);

                $vsql4 = "UPDATE liquidacion SET 
                                 pago = ".$pagocesantias.",
                                 porcentaje = ".$porcesantias.",
                                 pagointereses = ".$pagointereses."
                           WHERE idliquidacion = ".$idliquidacion."";
            }
            else
                $vsql4 = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                           VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",0,".$porcesantias.",".$pagointereses.")";

            $clase->EjecutarSQL($vsql4);
        }

        // Indemnización
        if($pagoinde>=0)
        {
            $vsql2 = "SELECT COUNT(*) AS numregistro
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'indemnizacion'";
            $numregistro = $clase->SeleccionarUno($vsql2);

            if($numregistro>0)
            {
                $vsql3 = "SELECT idliquidacion
                            FROM liquidacion
                           WHERE terid=".$terid."
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'indemnizacion'";
                $idliquidacion = $clase->SeleccionarUno($vsql3);

                $vsql4 = "UPDATE liquidacion SET 
                                 pago = ".$pagoinde."
                           WHERE idliquidacion = ".$idliquidacion."";
            }
            else
                $vsql4 = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                           VALUES ('".$codperiodo."',".$terid.",'indemnizacion',".$pagoinde.",0,0,0)";

            $clase->EjecutarSQL($vsql4);
        }

        // Aquí depuro los conceptos que estén en cero
        $vsql = "DELETE FROM liquidacion WHERE pago = 0 AND cantidad = 0 AND tipo ='primas' AND terid =".$terid."";
        $clase->EjecutarSQL($vsql);

        $vsql = "DELETE FROM liquidacion WHERE pago = 0 AND cantidad = 0 AND tipo ='vacaciones' AND terid =".$terid."";
        $clase->EjecutarSQL($vsql);

        $vsql = "DELETE FROM liquidacion WHERE pago = 0 AND porcentaje = 0 AND pagointereses = 0 AND tipo ='cesantias' AND terid =".$terid."";
        $clase->EjecutarSQL($vsql);

        $vsql = "DELETE FROM liquidacion WHERE pago = 0 AND tipo ='indemnizacion' AND terid =".$terid."";
        $clase->EjecutarSQL($vsql);

        $clase->Aviso(1,"Calculo procesado exitosamente");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=ventanareprocesarliq&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel
    // Creación: 14/12/2021		última modificación: 29/06/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para seleccionar la hoja de Excel
    // Última modificación: Se añadió la advertencia que se debe utilizar un archivo .xlsx
    //                      (03/01/2021)
    //                      Inclusión de la estructura de la hoja de Excel que se importará
    //                      (08/02/2022)
    //                      Validación del servidor 248 y .net para realizar el proceso
    ////////////////////////////////////////////////////////////////////////////////////////
	if($opcion == "importarexcel")
	{
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red> para poder importar primas </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=ventanaliquidados" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el código del periodo
            $yeartoday = date("Y");
    
            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;
    
            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";    
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
    
            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }
    
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                        $(function()
                        {
                        $("#enviarr").on("click",function()
                        {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                        });
    
                        });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar primas <br> <font color="BLUE">'.strtolower($desperiodo).'</font></b> </td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=importarexcel2" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>
                       <input type="checkbox" name="elimnaprimas" value="CHECKED"> Eliminar primas del periodo '.strtolower($desperiodo).'</a><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: D&iacute;as </td> </tr> 
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Pago </td> </tr>                 
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemploprimas.png" width="260" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel2
    // Creación: 14/12/2021		última modificación: 20/01/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para grabar los datos importados de la hoja de Excel
    // Última modificación: Inclusión de registro en la tabla de enlace primas con terceros 
    //                      para los datos del recibo de pago (31/12/2021)
    //                      Validación de la extensión del archivo que se importará
    //                      (04/01/2022)
    // Última modificación: Se incluyó el campo tipo de la tabla primasterceros para 
    //                      diferenciar las primas de las cesantías
    ////////////////////////////////////////////////////////////////////////////////////////
	if($opcion == "importarexcel2")
	{
		set_time_limit(0);
		extract($_POST);
		$docuid = $_POST["docuid"];
        $elimnaprimas = $_POST["elimnaprimas"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();  
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cantidad'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pago']    = round( $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue() );
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)&&(strlen($_DATOS_EXCEL[$i]['cantidad']) == 0)) 
                    $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
      
            // ------------------------------------------------------------------------------------------ //
            // Obtengo el código del periodo
            $yeartoday = date("Y");

            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                            FROM periodosnomina 
                           WHERE consecutivone <> ''
                                 AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);            

            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);                
            }

            // ------------------------------------------------------------------------------------------ //
            // Eliminación de las compras a crédito en el periodo si se marca el checkbox correspondiente
            if($elimnaprimas == "CHECKED")
            {
                $vsql = "DELETE FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND tipo = 'primas'";
                $clase->EjecutarSQL($vsql);
            }

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;
            for($j=1; $j < $i; $j++)
            {
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");
                
                if($terid != "")
                {
                    $cantidad    = $_DATOS_EXCEL[$j]['cantidad'];
                    $pago    = $_DATOS_EXCEL[$j]['pago'];
    
                    // Almaceno en la tabla
                    $vsql = "INSERT INTO liquidacion (periodonomina,terid,tipo,pago,cantidad,porcentaje,pagointereses) 
                                              VALUES ('".$codperiodo."',".$terid.",'primas',".$pago.",".$cantidad.",0,0)";
                    $clase->EjecutarSQL($vsql);
    
                    if(mysql_affected_rows() >= 1)
                    {
                        $grabados++;
    
                        // Guardo en la tabla de enlace
                        $vsql = "INSERT INTO primasterceros (tipo, periodonomina, terid, esempleado, esempleadoactivo, extralegal,
                                                             areaid, seccionid, cargoid, bancoid, numcuenta, fecingreso,
                                                             basico, codvende, dni, nombre, epsid, pensionesid)                             
                                     SELECT  'primas', '".$codperiodo."', terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid,
                                             cargoid, bancoid, numcuenta, fecingreso, basico, codvende, dni, 
                                             CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre,
                                             epsid, pensionesid
                                        FROM terceros
                                       WHERE terid = ".$terid."";
                        $clase->EjecutarSQL($vsql);
                    }
                }
            }
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron las primas");
            else
            {
                $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
                $clase->Aviso(1,"Se cargaron $grabados primas para el periodo $desperiodo");
            }
    
            // Redirecciona el formulario
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel3
    // Creación: 18/01/2022		última modificación: 29/06/2022
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para grabar los datos importados de la hoja de Excel
    // Última modificación: Inclusión de la estructura de la hoja de Excel que se importará
    //                      (08/02/2022)
    //                      Validación del servidor 248 y .net para realizar el proceso
    ////////////////////////////////////////////////////////////////////////////////////////          
    if($opcion == "importarexcel3")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red> para poder importar intereses de cesantías </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=ventanaliquidados" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el código del periodo
            $yeartoday = date("Y");
    
            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;
    
            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                     FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
    
            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }
    
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                        $(function()
                        {
                        $("#enviarr").on("click",function()
                        {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                        });
    
                        });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar intereses de <br> cesant&iacute;as <font color="BLUE">'.strtolower($desperiodo).'</font> </b></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=importarexcel4" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>
                       <input type="checkbox" name="elimnacesantias" value="CHECKED"> Eliminar cesant&iacute;as del periodo '.strtolower($desperiodo).'</a><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Pago de cesant&iacute;as (0) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: D&iacute;as </td> </tr> 
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>D</b>: Porcentaje de cesant&iacute;as </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>E</b>: Pago de intereses </td> </tr>                 
                    </table>';
    
            $cont.='<table width="400">
                    <tr class="TablaDocsPar"> 
                     <td align="center"> 
                      <img src="images/iconos/ejemplocesantias.png" width="260" height="180" border="0">
                     </td> 
                    </tr>
                    <tr class="TablaDocsPar"> 
                     <td width="100%" align="center"> 
                      <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                     </td> 
                    </tr>
                   </table>';
        }

        echo $cont; 
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel4
    // Creación: 18/01/2022	    última modificación: 20/01/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para grabar los datos de las cesantías importados de la hoja de 
    //              Excel
    // Última modificación: Se incluyó el campo tipo de la tabla primasterceros para 
    //                      diferenciar las primas de las cesantías
    ////////////////////////////////////////////////////////////////////////////////////////    
	if($opcion == "importarexcel4")
	{
		set_time_limit(0);
		extract($_POST);
		$docuid = $_POST["docuid"];
        $elimnacesantias = $_POST["elimnacesantias"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pagocesantias'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cantidad'] = round( $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue() );
                    $_DATOS_EXCEL[$i]['porcesantias'] = round( $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue() );
                    $_DATOS_EXCEL[$i]['pagointereses'] = round( $objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue() );                    
                
                    if(strlen($_DATOS_EXCEL[$i]['dni']) == 0) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
      
            // ------------------------------------------------------------------------------------------ //
            // Obtengo el código del periodo
            $yeartoday = date("Y");

            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday." ";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;

            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);

            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }

            // ------------------------------------------------------------------------------------------ //
            // Eliminación de las compras a crédito en el periodo si se marca el checkbox correspondiente
            if($elimnacesantias == "CHECKED")
            {
                $vsql = "DELETE FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
                $clase->EjecutarSQL($vsql);
            }

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;
            for($j=1; $j < $i; $j++)
            {
                $valreg = 0;
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");
                
                if($terid != "")
                {
                    $pagocesantias = $_DATOS_EXCEL[$j]['pagocesantias'];
                    $cantidad = $_DATOS_EXCEL[$j]['cantidad'];
                    $porcesantias = $_DATOS_EXCEL[$j]['porcesantias'];
                    $pagointereses = $_DATOS_EXCEL[$j]['pagointereses'];

                    // Valido que todos los datos sean numéricos
                    $lb_valido1 = false;
                    $lb_valido2 = false;
                    $lb_valido3 = false;
                    $lb_valido4 = false;

                    $lb_valido1 = $io_fecha->uf_solo_numeros($pagocesantias);
                    $lb_valido2 = $io_fecha->uf_solo_numeros($cantidad);
                    $lb_valido3 = $io_fecha->uf_solo_numeros($porcesantias);
                    $lb_valido4 = $io_fecha->uf_solo_numeros($pagointereses);

                    if(($lb_valido1)&&($lb_valido2)&&($lb_valido3)&&($lb_valido4))
                    {
                        // Almaceno en la tabla
                        $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                                  VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$cantidad.",".$porcesantias.",".$pagointereses.")";
                        $clase->EjecutarSQL($vsql);
        
                        if(mysql_affected_rows() >= 1)
                        {
                            $grabados++;
        
                            // Guardo en la tabla de enlace
                            $vsql = "INSERT INTO primasterceros (tipo, periodonomina, terid, esempleado, esempleadoactivo, extralegal,
                                                                areaid, seccionid, cargoid, bancoid, numcuenta, fecingreso,
                                                                basico, codvende, dni, nombre, epsid, pensionesid)                             
                                          SELECT 'cesantias', '".$codperiodo."', terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid,
                                                 cargoid, bancoid, numcuenta, fecingreso, basico, codvende, dni, 
                                                 CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre,
                                                 epsid, pensionesid
                                            FROM terceros
                                           WHERE terid = ".$terid."";
                            $clase->EjecutarSQL($vsql);
                        }                        
                    }    
                }
            }
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron las cesantías");
            else
            {
                $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
                $clase->Aviso(1,"Se cargaron $grabados cesantías para el periodo $desperiodo");
            }
    
            // Redirecciona el formulario
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel5
    // Creación: 31/01/2022		última modificación: 04/08/2022
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción para grabar los datos importados de la hoja de Excel
    // Última modificación: Inclusión de la estructura de la hoja de Excel que se importará
    //                      (08/02/2022)
    //                      checkbox para eliminar las compras a crédito en el periodo
    //                      (22/02/2022)
    //                      Validación del servidor 248 y .net para realizar el proceso
    //                      (29/06/2022)
    //                      Inclusión del combo para los descuentos ocasionales
    ////////////////////////////////////////////////////////////////////////////////////////          
    if($opcion == "importarexcel5")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=ventanaliquidados" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el código del periodo
            $yeartoday = date("Y");
    
            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;
    
            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";    
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
    
            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }
    
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

            // Combo de Periodos
            $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto
                                    FROM conceptosnomina 
                                   WHERE montoocasional = 'CHECKED'
                                ORDER BY conceptoid ASC";
            $params = ' class="Texto12" ';
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar descuentos ocasionales <br><font color="BLUE">'.strtolower($desperiodo).'</font></b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=importarexcel6" id="theform" enctype="multipart/form-data">
                       concepto: '.$clase->CrearComboEsp("conceptoid",$vsqlcomboconcepto,"conceptoid","nomperiodo",$conceptoid,"N",$params).'
                       <br> <br>
                       <input type="file" name="excel" /><br><br>
                       <input type="checkbox" name="elimnacompras" value="CHECKED"> Eliminar todos los registros de este concepto <br> en el periodo '.strtolower($desperiodo).'</a><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Monto (solo n&uacute;meros) </td> </tr>                 
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocompras.png" width="260" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel6
    // Creación: 31/01/2022	    última modificación: 23/07/2022
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción para grabar los datos de las compras a crédito de la hoja de 
    //              Excel
    // Última modificación: Eliminación de las compras a crédito en el periodo si se marca 
    //                      el checkbox elimnacompras (22/02/2022)
    //                      Procesamiento de los descuentos permanentes, ocasionales y 
    //                      libranzas, validación del monto y verificación del tipo de
    //                      concepto
    ////////////////////////////////////////////////////////////////////////////////////////    
	if($opcion == "importarexcel6")
	{
		set_time_limit(0);
		extract($_POST);
		$conceptoid = $_POST["conceptoid"];        
        $elimnacompras = $_POST["elimnacompras"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['monto'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)&&(strlen($_DATOS_EXCEL[$i]['monto']) == 0)) 
                    $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
      
            // ------------------------------------------------------------------------------------------ //
            // Obtengo el periodo actual
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);

            // ------------------------------------------------------------------------------------------ //
            // Eliminación de las compras a crédito en el periodo si se marca el checkbox correspondiente
            if($elimnacompras == "CHECKED")
            {
                $vsql = "DELETE FROM detallenomina WHERE pernominaid = ".$periodoid." AND conceptoid = ".$conceptoid;
                $clase->EjecutarSQL($vsql);
            }

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;
            for($j=1; $j < $i; $j++)
            {
                $valreg = 0;
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");
                
                if($terid != "")
                {
                    $monto = $_DATOS_EXCEL[$j]['monto'];

                    // llamado al procedimiento para validar el monto
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($monto);
                    if($lb_valido)
                    {
                        // Valido que el concepto asignado a un empleado no esté repetido
                        $vsql3 = "SELECT count(*) AS valreg
                                    FROM detallenomina
                                   WHERE pernominaid = ".$periodoid."
                                         AND terid = ".$terid."
                                         AND conceptoid = ".$conceptoid;
                        $valreg = $clase->SeleccionarUno($vsql3);

                        if($valreg==0)
                        {
                            // Obtengo el número de registros de la tabla detallenomina
                            $vsql = "SELECT MAX(detalleid) FROM detallenomina";
                            $numeroid = $clase->SeleccionarUno($vsql);
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
            
                            // Incremento el contados de registros almacenados
                            if(mysql_affected_rows() >= 1)
                                $grabados++;
                        }
                    }
                }
            }
      
            // Elimino el Archivo
            unlink($destino);

            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los registros de $nomconcepto para el periodo $descripcion");
            else
                $clase->Aviso(1,"Se cargaron $grabados registros de $nomconcepto para el periodo $descripcion");            
    
            // Redirecciona el formulario
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel7
    // Creación: 04/03/2022		última modificación: 29/06/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para grabar los datos importados de la hoja de Excel de las 
    //              dotaciones de uniformes
    // Última modificación: Validación del servidor 248 y .net para realizar el proceso
    ////////////////////////////////////////////////////////////////////////////////////////          
    if($opcion == "importarexcel7")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red> para poder importar dotaciones </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=ventanaliquidados" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el código del periodo
            $yeartoday = date("Y");
    
            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;
    
            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";    
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
    
            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }
    
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar dotaciones <br> <font color="BLUE">'.strtolower($desperiodo).'</font></b></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=importarexcel8" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>
                       <input type="checkbox" name="elimnadotaciones" value="CHECKED"> Eliminar dotaciones del periodo '.strtolower($desperiodo).'</a><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Monto </td> </tr>                 
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplodotaciones.png" width="260" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel8
    // Creación: 04/03/2022	    última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para grabar los datos de las dotaciones importados de la hoja de 
    //              Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
	if($opcion == "importarexcel8")
	{
		set_time_limit(0);
		extract($_POST);		
        $elimnadotaciones = $_POST["elimnadotaciones"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['monto'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0) || (strlen($_DATOS_EXCEL[$i]['monto']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
      
            // ------------------------------------------------------------------------------------------ //
            // Obtengo el código del periodo
            $yeartoday = date("Y");

            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;

            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep  = "SELECT codperiodo 
                                 FROM periodos 
                                WHERE anoperiodo = ".$yeartoday." 
                                      AND mesperiodo = ".$nummesval." 
                             ORDER BY orden";
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);

            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep  = "SELECT codperiodo 
                                     FROM periodos 
                                    WHERE anoperiodo = ".$yeartoday." 
                                          AND mesperiodo = ".$nummesval." 
                                 ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }

            // ------------------------------------------------------------------------------------------ //
            // Eliminación de las compras a crédito en el periodo si se marca el checkbox correspondiente
            if($elimnadotaciones == "CHECKED")
            {
                $vsql = "DELETE FROM dotaciones WHERE periodonomina = '".$codperiodo."'";
                $clase->EjecutarSQL($vsql);
            }

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;
            for($j=1; $j < $i; $j++)
            {
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");
                
                if($terid != "")
                {
                    $monto = $_DATOS_EXCEL[$j]['monto'];

                    // llamado al procedimiento para validar el monto
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($monto);
                    if($lb_valido)
                    {
                        // Valido que el concepto asignado a un empleado no esté repetido
                        $vsql3 = "SELECT count(*) AS valreg
                                    FROM dotaciones
                                   WHERE periodonomina = '".$codperiodo."'
                                         AND terid = ".$terid;
                        $valreg = $clase->SeleccionarUno($vsql3);

                        if($valreg==0)
                        {
                            // Almaceno en la tabla
                            $vsql = "INSERT INTO dotaciones (periodonomina, terid, monto) 
                                                     VALUES ('".$codperiodo."',".$terid.",".$monto.")";
                            $clase->EjecutarSQL($vsql);
            
                            if(mysql_affected_rows() >= 1)
                                $grabados++;
                        }
                    }    
                }
            }
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron las dotaciones");
            else
            {
                $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
                $clase->Aviso(1,"Se cargaron satisfactoriamente $grabados dotaciones para el periodo $desperiodo");
            }
    
            // Redirecciona el formulario
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel9
    // Creación: 07/03/2022		última modificación: 29/06/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para grabar los datos importados de la hoja de Excel del 
    //              pago de cesantías
    // Última modificación: Validación del servidor 248 y .net para realizar el proceso
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel9")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red> para poder importar pago de cesant&iacute;as </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=ventanaliquidados" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el código del periodo
            $yeartoday = date("Y");
    
            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;
    
            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";    
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
    
            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }
    
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar pago de cesant&iacute;as <br> <font color="BLUE">'.strtolower($desperiodo).'</font></b></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=importarexcel10" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>
                       <input type="checkbox" name="elimnapagocesan" value="CHECKED"> Eliminar pago de cesant&iacute;as del periodo '.strtolower($desperiodo).'</a><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Monto </td> </tr>                 
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: D&iacute;as </td> </tr>                 
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplopagocesantias.png" width="260" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel10
    // Creación: 04/03/2022	    última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para grabar los datos del pago de cesantías importados de la 
    //              hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
	if($opcion == "importarexcel10")
	{
		set_time_limit(0);
		extract($_POST);		
        $elimnapagocesan = $_POST["elimnapagocesan"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['monto'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['dias'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0) || (strlen($_DATOS_EXCEL[$i]['monto']) == 0) || (strlen($_DATOS_EXCEL[$i]['dias']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
      
            // ------------------------------------------------------------------------------------------ //
            // Obtengo el código del periodo
            $yeartoday = date("Y");

            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;

            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);

            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }

            // ------------------------------------------------------------------------------------------ //
            // Eliminación de las compras a crédito en el periodo si se marca el checkbox correspondiente
            if($elimnapagocesan == "CHECKED")
            {
                $vsql = "DELETE FROM pagocesantias WHERE periodonomina = '".$codperiodo."'";
                $clase->EjecutarSQL($vsql);
            }

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;
            for($j=1; $j < $i; $j++)
            {
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");
                
                if($terid != "")
                {
                    $valreg = 0;
                    $monto = $_DATOS_EXCEL[$j]['monto'];
                    $dias = $_DATOS_EXCEL[$j]['dias'];
    
                    // Validación del monto y de los días
                    $lb_valido = false;
                    $lb_valido2 = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($monto);
                    $lb_valido2 = $io_fecha->uf_solo_numeros($dias);

                    if(($lb_valido)&&($lb_valido2))
                    {
                        // Valido que el concepto asignado a un empleado no esté repetido
                        $vsql3 = "SELECT count(*) AS valreg
                                    FROM pagocesantias
                                   WHERE periodonomina = '".$codperiodo."'
                                         AND terid = ".$terid;
                        $valreg = $clase->SeleccionarUno($vsql3);                        

                        if($valreg==0)
                        {
                            // Almaceno en la tabla
                            $vsql = "INSERT INTO pagocesantias (periodonomina, terid, dias, monto) 
                                                        VALUES ('".$codperiodo."',".$terid.",".$dias.",".$monto.")";
                            $clase->EjecutarSQL($vsql);
            
                            if(mysql_affected_rows() >= 1)
                                $grabados++;
                        }
                    }
                }
            }
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los pagos de cesantías");
            else
            {
                $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
                $clase->Aviso(1,"Se cargaron satisfactoriamente $grabados pagos de cesantías para el periodo $desperiodo");
            }
    
            // Redirecciona el formulario
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel11
    // Creación: 25/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para grabar los datos importados de la hoja de Excel de las 
    //              libranzas y los descuentos permanentes
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel11")
    {
        $periodoidanterior = $_GET["periodoidanterior"];
        $tipodesc = $_GET["tipodesc"];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=ventanaliquidados" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            $descripcionant = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');
            
            $vsql = "SELECT count(*) 
                       FROM detallenomina
                      WHERE pernominaid = ".$periodoidanterior;
            $valorperiodo = $clase->SeleccionarUno($vsql);            

            if($valorperiodo==0)            
                $cont.='<table width="400">
                         <tr class="CabezoteTabla"> 
                          <td align="center"> <b>Periodo no calculado </b></td>
                         </tr> 
                         <tr class="CabezoteTabla"> 
                          <td align="center"> 
                           <font color=red> No se pueden importar estos datos porque <br>el periodo '.strtolower($descripcionant).'<br> no ha sido calculado <br> </font><br>                            
                          </td> 
                         </tr>
                         <tr class="TablaDocsPar">        
                          <td width="100%" align="center"> 
                           <form name="importa" method="post" action="calculoliquidados.php?opcion=ventanaliquidados" id="theform" enctype="multipart/form-data">
                            <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                           </form> 
                          </td>    
                         </tr>
                        </table>';
            else
            {
                // Combo de conceptos
                $params = ' class="Texto12" ';
                $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto
                                        FROM conceptosnomina ";

                if($tipodesc=="ambas")      $vsqlcomboconcepto.= "WHERE eslibranza = 'CHECKED' OR montopermanente = 'CHECKED' ";
                if($tipodesc=="descperm")   $vsqlcomboconcepto.= "WHERE montopermanente = 'CHECKED' ";
                if($tipodesc=="libranza")   $vsqlcomboconcepto.= "WHERE eslibranza = 'CHECKED' ";

                $vsqlcomboconcepto.= " ORDER BY conceptoid ASC";

                // pinto la ventana
                $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                        <script>
                         $(function()
                         {
                          $("#enviarr").on("click",function()
                          {
                            $(this).val("Espere por favor ...")
                            .attr("disabled","disabled");
                            $("#theform").submit();
                          });
                         });
                        </script>
                        <table width="400">
                         <tr class="CabezoteTabla"> ';

                if($tipodesc=="ambas")      $cont.='<td align="center"> <b>Importar libranzas<br> y descuentos permanentes <br>'.strtolower($descripcionant).'</b><br><br></td> ';
                if($tipodesc=="descperm")   $cont.='<td align="center"> <b>Importar descuentos permanentes <br>'.strtolower($descripcionant).'</b><br><br></td> ';
                if($tipodesc=="libranza")   $cont.='<td align="center"> <b>Importar libranzas<br> '.strtolower($descripcionant).'</b><br><br></td> ';

                $cont.=' </tr> 
                        </table>
                        <table width="400">
                         <tr class="TablaDocsPar">        
                          <td width="100%" align="center"> 
                           <form name="importa" method="post" action="calculoliquidados.php?opcion=importarexcel6" id="theform" enctype="multipart/form-data">
                            concepto: '.$clase->CrearComboEsp("conceptoid",$vsqlcomboconcepto,"conceptoid","nomperiodo",$conceptoid,"N",$params).'
                            <br> <br>
                            <input type="file" name="excel" /><br><br>
                            <input type="checkbox" name="elimnacompras" value="CHECKED"> Eliminar todos los registros de este concepto <br> en este periodo</a><br><br>
                            <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                            <input type="hidden" value="upload" name="action" />
                           </form> 
                          </td>    
                         </tr>
                        </table>';
        
                $cont.='<table width="400">
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Monto (solo n&uacute;meros) </td> </tr>                 
                        </table>';
        
                $cont.='<table width="400">
                         <tr class="TablaDocsPar"> 
                          <td align="center"> 
                           <img src="images/iconos/ejemplocompras.png" width="280" height="180" border="0">
                          </td> 
                         </tr>
                         <tr class="TablaDocsPar"> 
                          <td width="100%" align="center"> 
                           <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                          </td> 
                         </tr>
                        </table>';
            }
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel12
    // Creación: 17/08/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para captar los datos para la importación desde una hoja de  
    //              Excel de las novedades
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel12")
    {
        $periodoidanterior = $_GET["periodoidanterior"];
        $tipodesc = $_GET["tipodesc"];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=ventanaliquidados" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            $descripcionant = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');
            
            $vsql = "SELECT count(*) 
                       FROM detallenomina
                      WHERE pernominaid = ".$periodoidanterior;
            $valorperiodo = $clase->SeleccionarUno($vsql);

            if($valorperiodo==0)            
                $cont.='<table width="400">
                         <tr class="CabezoteTabla"> 
                          <td align="center"> <b>Periodo no calculado </b></td>
                         </tr> 
                         <tr class="CabezoteTabla"> 
                          <td align="center"> 
                           <font color=red> No se pueden importar estos datos porque <br>el periodo '.strtolower($descripcionant).'<br> no ha sido calculado <br> </font><br>                            
                          </td> 
                         </tr>
                         <tr class="TablaDocsPar">        
                          <td width="100%" align="center"> 
                           <form name="importa" method="post" action="calculoliquidados.php?opcion=ventanaliquidados" id="theform" enctype="multipart/form-data">
                            <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                           </form> 
                          </td>    
                         </tr>
                        </table>';
            else
            {
                // Combo de conceptos
                $params = ' class="Texto12" ';
                $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto
                                        FROM conceptosnomina 
                                       WHERE eslicencia = 'CHECKED' 
                                    ORDER BY conceptoid ASC";

                // pinto la ventana
                $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                        <script>
                         $(function()
                         {
                          $("#enviarr").on("click",function()
                          {
                            $(this).val("Espere por favor ...")
                            .attr("disabled","disabled");
                            $("#theform").submit();
                          });
                         });
                        </script>
                        <table width="400">
                         <tr class="CabezoteTabla"> 
                          <td align="center"> <b>Importar novedades<br> <font color="BLUE">'.strtolower($descripcionant).'</font></b><br><br></td> 
                         </tr> 
                        </table>
                        <table width="400">
                         <tr class="TablaDocsPar">        
                          <td width="100%" align="center"> 
                           <form name="importa" method="post" action="calculoliquidados.php?opcion=importarexcel13" id="theform" enctype="multipart/form-data">
                            <input type="hidden" name="periodoidanterior" value="'.$periodoidanterior.'">
                            concepto: '.$clase->CrearComboEsp("conceptoid",$vsqlcomboconcepto,"conceptoid","nomperiodo",$conceptoid,"N",$params).'
                            <br> <br>
                            <input type="file" name="excel" /><br><br>                            
                            <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                            <input type="hidden" value="upload" name="action" />
                           </form> 
                          </td>    
                         </tr>
                        </table>';
        
                $cont.='<table width="400">
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Fecha <b>(formato texto)</b> </td> </tr>                 
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: D&iacute;as </td> </tr>                 
                        </table>';
        
                $cont.='<table width="400">
                         <tr class="TablaDocsPar"> 
                          <td align="center"> 
                           <img src="images/iconos/ejemplolicencias.png" width="280" height="180" border="0">
                          </td> 
                         </tr>
                         <tr class="TablaDocsPar"> 
                          <td width="100%" align="center"> 
                           <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                          </td> 
                         </tr>
                        </table>';
            }
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel13
    // Creación: 22/08/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para calcular las novedades de acuerdo a los datos aportados 
    //              desde una hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "importarexcel13")
    {
		set_time_limit(0);
		extract($_POST);
		$conceptoid = $_POST["conceptoid"];
        $periodoidanterior = $_POST["periodoidanterior"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['fecdesde'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i);
                    $_DATOS_EXCEL[$i]['dias'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)||(strlen($_DATOS_EXCEL[$i]['fecdesde']) == 0)||(strlen($_DATOS_EXCEL[$i]['dias']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;
            for($j=1; $j < $i; $j++)
            {
                $valreg = 0;
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");
                
                if($terid != "")
                {
                    $lb_valido = false;
                    $lb_valido2 = false;
                    $lb_valida3 = false;

                    $fecdesde = $_DATOS_EXCEL[$j]['fecdesde'];                    
                    $dias = $_DATOS_EXCEL[$j]['dias'];
                    
                    // Valido la entrada de los datos de la hoja de Excel
                    $lb_valido = $io_fecha->uf_solo_numeros($dias);         // Valido la columna de los días
                    $lb_valido2 = validar_fecha_espanol($fecdesde);         // Valido la columna de la fecha                    
                    
                    if(($lb_valido)&&($lb_valido2))
                    {
                        // Valido que la fecha esté dentro del periodo
                        $fechasta = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','fechasta');
                        $fecdesde2 = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','fecdesde');
                        $fecdesde3 = substr($fecdesde,6,4)."-".substr($fecdesde,3,2)."-".substr($fecdesde,0,2);

                        $lb_valida3 = verifica_rango($fecdesde2,$fechasta,$fecdesde3);

                        if($lb_valida3)
                        {
                            // Valido que el empleado tenga datos en el periodo
                            $vsql = "SELECT count(*) AS numreg FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior;
                            $numreg = $clase->SeleccionarUno($vsql);

                            if($numreg>=1)
                            {
                                // inicialización de variables
                                $difendias = 0;                         $basico = 0;                        $diastrab = 0;
                                $detalleid = 0;                         $numid = 0;                         $formulabasico = "";
                                $formulalice = "";                      $montolicencia = 0;                 $porcbasico = 0;
                                $tipodc = "";                           $repetida = 0;                      $valor = 0;
                                $descuentos = 0;                        $smlv = 0;                          $cargoid = 0;
                                $aplicatransporte = "";                 $auxtrans = 0;                      $formulatransporte = "";
                                $subsidiotransporte = 0;                $numreg = 0;                        $totnovedades = 0;
                                $sueldodeducciones = 0;                 $sueldo = 0;                        $epsid = 0;
                                $pensionesid = 0;                       $aplicapension = "";                $aplicasalud = "";
                                $pension = 0;                           $salud = 0;                         $formulapension = "";
                                $formulasalud = "";                     $idpension = 0;                     $idsalud = 0;
                                $diaspendiente = 0;

                                // días de la licencia
                                $fecha1= new DateTime($fecdesde3);
                                $fecha2= new DateTime($fechasta);
                                $diff = $fecha1->diff($fecha2);
                                
                                $difendias = $diff->days;
                                $difendias += 1;

                                // if($dias>$difendias)
                                //     $dias = $difendias;

                                // ----------------------------------------------------------------------------------------------------------------------------- //                                        
                                $suma = "+".strval($dias-1)." day";
                                $date_fin = strtotime(".$suma.", strtotime($fecdesde3));
                                $date_fin = date('Y-m-d', $date_fin);

                                if($date_fin > $fechasta)
                                {
                                    // Aquí guardo en la tabla correspondiente el exceso en días 
                                    // para ser calculado en próximos periodos
                
                                    $diaspendiente = $dias - $difendias;
                
                                    // --------------------------------------------------------------------------------------------------------- //
                                    $feciniper = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','fecdesde');
                                    $diadesde = substr($feciniper, -2);
                
                                    if($diadesde=="16")
                                    {
                                        $fecfinper = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','fechasta');
                                        $fechaEntera = strtotime($fecfinper);
                                        $valdias = date("d", $fechaEntera);
                
                                        if($valdias=="28")              $diaspendiente -= 2;
                                        if($valdias=="29")              $diaspendiente -= 1;
                                        if($valdias=="31")              $diaspendiente += 1;
                                    }
                                    // --------------------------------------------------------------------------------------------------------- //                
                                    $dias -= $diaspendiente;
                
                                    $procesado = "";
                                    $vsql = "SELECT periodoid 
                                               FROM periodosnomina 
                                              WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE periodoid > $periodoidanterior)";
                                    $periodoapagar = $clase->SeleccionarUno($vsql);
                
                                    $vsql = "INSERT INTO licenciaspendiente (terid,conceptoid,dias,periodoapagar,procesado) 
                                                                     VALUES (".$terid.",".$conceptoid.",".$diaspendiente.",".$periodoapagar.",'".$procesado."')";
                                    $clase->EjecutarSQL($vsql);
                                }                                
                                // ----------------------------------------------------------------------------------------------------------------------------- //

                                // Obtengo el salario básico del empleado
                                $basico = $clase->BDLockup($terid,'terceros','terid','basico');
                    
                                // Obtengo la formula del sueldo
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                                $formulabasico = $clase->SeleccionarUno($vsql);
                    
                                // Obtengo los días trabajados en el periodo
                                $vsql = "SELECT valor
                                           FROM detallenomina 
                                          WHERE conceptoid = 1  
                                                AND pernominaid = ".$periodoidanterior."
                                                AND terid = ".$terid."";
                                $diastrab = $clase->SeleccionarUno($vsql);
                    
                                // Obtengo el ID del registro que se modificará
                                $vsql = "SELECT detalleid
                                           FROM detallenomina 
                                          WHERE conceptoid = 1  
                                                AND pernominaid = ".$periodoidanterior."
                                                AND terid = ".$terid."";
                                $detalleid = $clase->SeleccionarUno($vsql);

                                $diastrab -= $dias;

                                eval("\$sueldo = $formulabasico;");
                                $sueldo = round($sueldo,0);
                    
                                // Almaceno en nuevo sueldo
                                $vsql = "UPDATE detallenomina SET 
                                                devengados = ".$sueldo.", 
                                                valor = ".$diastrab."
                                          WHERE detalleid = ".$detalleid."";
                                $clase->EjecutarSQL($vsql);

                                // Calculo el nuevo ID
                                $vsql = "SELECT max(detalleid) FROM detallenomina";
                                $numid = $clase->SeleccionarUno($vsql);
                                $numid++;

                                // Inserto la nueva licencia

                                // Obtengo la formula de la licencia
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                                $formulalice = $clase->SeleccionarUno($vsql);

                                // Calculo la licencia
                                if($conceptoid!=10)
                                {
                                    eval("\$montolicencia = $formulalice;");
                                    $montolicencia = round($montolicencia,0);
                                }
                                else
                                {
                                    // Calculo la incapacidad

                                    // Obtengo el salario mínimo legal vigente
                                    $smlv = $_SESSION['N_SALMIN2020'];

                                    // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                                    if($basico<=$smlv)
                                    {
                                        $montolicencia = ($smlv*$dias)/30;
                                        $montolicencia = round($montolicencia,0);
                                    }
                                    else
                                    {
                                        $porcbasico = ($basico*66.67)/100;
                                        $porcbasico = round($porcbasico,0);

                                        // Calculo la incapacidad si el básico sea mayor al mínimo
                                        if($porcbasico>$smlv)
                                        {
                                            $montolicencia = ($porcbasico*$dias)/30;
                                            $montolicencia = round($montolicencia,0);
                                        }
                                        else
                                        {
                                            // $montolicencia = ($smlv*$dias)/30;
                                            // $montolicencia = round($montolicencia,0);

                                            if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                            if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                                            $montolicencia = round($montolicencia,0);
                                        }
                                    }
                                }

                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                // ------------------------------------------------------------------------------------------------------------------- //
                                // Determino si el registro existe para modificarlo o incluirlo
                                $vsql = "SELECT COUNT(*) AS repetida 
                                           FROM detallenomina
                                          WHERE pernominaid = ".$periodoidanterior."
                                                AND conceptoid = ".$conceptoid."
                                                AND terid = ".$terid."";
                                $repetida = $clase->SeleccionarUno($vsql);

                                if($repetida==0)
                                {
                                    if($tipodc=="C")
                                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidanterior.",".$montolicencia.",0,".$dias.",".$basico.")";
                                    else
                                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidanterior.",0,".$montolicencia.",".$dias.",".$basico.")";
                                }
                                else
                                {
                                    // Determino el id del registro
                                    $vsql = "SELECT detalleid AS detalleid 
                                               FROM detallenomina
                                              WHERE pernominaid = ".$periodoidanterior."
                                                    AND conceptoid = ".$conceptoid."
                                                    AND terid = ".$terid."";
                                    $detalleid = $clase->SeleccionarUno($vsql);
            
                                    $valor = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');
                                    $valor += $dias;
            
                                    // Actualizo la licencia
                                    if($tipodc=="C")
                                    {
                                        $devengados = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
                                        $devengados += $montolicencia;
                                        
                                        $vsql = "UPDATE detallenomina SET 
                                                        devengados = ".$devengados.", 
                                                        valor = ".$valor."
                                                  WHERE detalleid = ".$detalleid."";
                                    }
                                    else
                                    {
                                        $descuentos = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');
                                        $descuentos += $montolicencia;
            
                                        $vsql = "UPDATE detallenomina SET 
                                                        descuentos = ".$descuentos.", 
                                                        valor = ".$valor."
                                                  WHERE detalleid = ".$detalleid."";
                                    }
                                }            
                                $clase->EjecutarSQL($vsql);

                                if(mysql_affected_rows() < 1)
                                    $lbpaso = false;
                                else
                                {
                                    $lbpaso = true;
                                    $grabados++;
                                }

                                if($lbpaso)
                                {
                                    // ---------------------------------------------------------------------------------------------------------- //
                                    // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos
                        
                                    // Obtengo el salario mínimo legal vigente
                                    $smlv = $_SESSION['N_SALMIN2020'];
    
                                    $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                       // Obtengo el cargo del empleado
                                    $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte
                        
                                    // Variable para la validación del auxilio de transporte
                                    $valsubtrasp = $smlv * 2;
                        
                                    if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                                    {
                                        // Obtengo el ID del registro que se modificará
                                        $vsql = "SELECT detalleid
                                                   FROM detallenomina 
                                                  WHERE conceptoid = 3  
                                                        AND pernominaid = ".$periodoidanterior."
                                                        AND terid = ".$terid."";
                                        $detalleid = $clase->SeleccionarUno($vsql);
                        
                                        // Obtengo la formula del subsidio de transporte
                                        $auxtrans = $_SESSION['N_AUXTRANS2020'];
                                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                                        $formulatransporte = $clase->SeleccionarUno($vsql);
                        
                                        eval("\$subsidiotransporte = $formulatransporte;");
                                        $subsidiotransporte = round($subsidiotransporte,0);
                                    }
                                    else
                                        $subsidiotransporte = 0;
    
                                    // ID transporte
                                    $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 3";
                                    $idtransporte = $clase->SeleccionarUno($vsql);
                            
                                    if($idtransporte!="")        
                                        // Grabo el subsidio de transporte
                                        $vsql = "UPDATE detallenomina SET 
                                                        devengados = ".$subsidiotransporte.",
                                                        valor = ".$diastrab."
                                                  WHERE detalleid = ".$idtransporte."";
                                    else
                                    {
                                        // Obtengo el valor del subsidio de transporte
                                        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
                            
                                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                                        $numreg = $clase->SeleccionarUno($vsql);
                            
                                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoidanterior.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                                    }
                            
                                    $clase->EjecutarSQL($vsql);
    
                                    // ----------------------------------------------------------------------------------------------------------- //
                                    // Ahora recalculo la pensión y la salud
    
                                    // ----------------------------------------------------------------------------------------------------------- //
                                    // Obtengo el total devengado por novedades
                                    $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                               FROM detallenomina d
                                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                              WHERE d.terid = ".$terid."
                                                    AND d.pernominaid = ".$periodoidanterior." 
                                                    AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                                    $totnovedades = $clase->SeleccionarUno($vsql);

                                    $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                               FROM detallenomina d
                                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                              WHERE d.terid = ".$terid."
                                                    AND d.pernominaid = ".$periodoidanterior." 
                                                    AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                                    $totrecargos = $clase->SeleccionarUno($vsql);
                            
                                    // Actualizo el sueldo
                                    $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
    
                                    $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
                                    $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
                                    $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
                                    
                                    if($epsid==NULL)                $epsid=0;
                                    if($pensionesid==NULL)          $pensionesid=0;
    
                                    $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');   // Obtengo el control del cálculo de pensión
                                    $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');   // Obtengo el control del cálculo de salud
    
                                    if($extralegal=="CHECKED")
                                    {
                                        $pension = 0;
                                        $salud = 0;
                                    }
                                    else
                                    {
                                        // Recalculo pensión y salud
                                        if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                            $pension = 0;
                                        else
                                        {
                                            // Obtengo la formula para el descuento por pensión
                                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                            $formulapension = $clase->SeleccionarUno($vsql);
                        
                                            // Calculo la pensión
                                            eval("\$pension = $formulapension;");
                                            $pension = round($pension,0);
                                        }
                        
                                        if(($epsid==37)||($aplicasalud!="CHECKED"))
                                            $salud = 0;
                                        else
                                        {
                                            // Obtengo la formula para el descuento de salud
                                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                            $formulasalud = $clase->SeleccionarUno($vsql);
                                            
                                            // Calculo la salud
                                            eval("\$salud = $formulasalud;");
                                            $salud = round($salud,0);
                                        }
                                    }
    
                                    //  ID pensión
                                    $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 4";
                                    $idpension = $clase->SeleccionarUno($vsql);
                        
                                    if($idpension!="")
                                        // Grabo la pensión
                                        $vsql = "UPDATE detallenomina SET 
                                                        descuentos = ".$pension.",
                                                        saldo = ".$sueldodeducciones."
                                                  WHERE detalleid = ".$idpension."";
                                    else
                                    {
                                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                                        $numreg = $clase->SeleccionarUno($vsql);
                        
                                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoidanterior.",0,".$pension.",0,$sueldodeducciones)";
                                    }
                        
                                    $clase->EjecutarSQL($vsql);
    
                                    // ID salud
                                    $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 5";
                                    $idsalud = $clase->SeleccionarUno($vsql);
                        
                                    if($idsalud!="")
                                        // Grabo la salud
                                        $vsql = "UPDATE detallenomina SET 
                                                        descuentos = ".$salud.",
                                                        saldo = ".$sueldodeducciones."
                                                  WHERE detalleid = ".$idsalud."";
                                    else
                                    {
                                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                                        $numreg = $clase->SeleccionarUno($vsql);
                        
                                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoidanterior.",0,".$salud.",0,$sueldodeducciones)";
                                    }
                        
                                    $clase->EjecutarSQL($vsql);
    
                                    // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                                    $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoidanterior;
                                    $clase->EjecutarSQL($vsql);
                                }
                            }
                        }
                    }
                }
            }
      
            // Elimino el Archivo
            unlink($destino);

            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
            $descripcion = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los registros de $nomconcepto para el periodo $descripcion");
            else
                $clase->Aviso(1,"Se cargaron $grabados registros de $nomconcepto para el periodo $descripcion");
    
            // Redirecciona el formulario
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarprimamanual
    // Creación: 18/01/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para editar las primas que se procesarán manualmente en caso de 
    //              fallar el importar Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarprimamanual")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo FROM periodos WHERE mesperiodo IN (6,12) AND anoperiodo >= 2021 AND orden > 91 ORDER BY orden";
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";
        $monto = 1;

        // Pintamos la ventana        
        $cont.='<table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Edici&oacute;n de primas </b> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardarprimasmanual" name="y" method="POST">
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">Empleado:</label>';

        $cont.= $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,400);
                   
        $cont.='  </td>                  
                 </tr>                 
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">Periodo:</label>';

        $cont.= $clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400);
                    
        $cont.='  </td>                  
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">D&iacute;as:</label>
                   <input type="number" name="cantidad" min="1" class="Texto11New" size="2" autocomplete="off" title="días" value="'.$cantidad.'">                  
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">Pago:</label>
                   <input type="number" name="pagoprimas" min="1" class="Texto11New" size="2" autocomplete="off" title="días" value="'.$pagoprimas.'">                  
                  </td>
                 </tr>
                </table>
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarprimasmanual
    // Creación: 18/01/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los datos de las primas que se procesaron 
    //              manualmente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarprimasmanual")
    {
        $terid = $_POST['terid'];
        $cantidad = $_POST['cantidad'];
        $pagoprimas = $_POST['pagoprimas'];
        $codperiodo = $_POST['codperiodo'];

        // Guardo en la tabla
        $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                  VALUES ('".$codperiodo."',".$terid.",'primas',".$pagoprimas.",".$cantidad.",0,0)";
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Datos almacenados satisfactoriamente");
        else
            $clase->Aviso(3,"No se almacenaron los datos");

        // Redirecciona el formulario
        header("Location: calculoliquidados.php?opcion=ventanaliquidados");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cesantiasmanual
    // Creación: 19/01/2022		última modificación: 21/01/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que capta los datos de las cesantías que se procesarán 
    //              manualmente
    // Última modificación: Inclusión del campo cantidad para los días de cesantías
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "cesantiasmanual")
    {
        // Combos
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo = "SELECT codperiodo, desperiodo 
                               FROM periodos 
                              WHERE mesperiodo = 1 
                                    AND anoperiodo >= 2022
                           ORDER BY orden";
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";

        // Inicialización de variables
        $pagocesantias = 0;
        $porcentaje = 0;
        $pagointereses = 0;
        $cantidad = 0;

        // Pintamos la ventana        
        $cont.='<table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Edici&oacute;n de cesant&iacute;as </b> </td>
                 </tr> 
                </table>                
                <form action="?opcion=almcesantiasmanual" name="y" method="POST">
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">Empleado:</label>';

        $cont.= $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,400);
                   
        $cont.='  </td>                  
                 </tr>                 
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">Periodo:</label>';

        $cont.= $clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400);
                    
        $cont.='  </td>                  
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">Pago:</label>
                   <input type="number" name="pagocesantias" min="0" class="Texto11New" size="2" autocomplete="off" title="Pago de cesantías" value="'.$pagocesantias.'">
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">D&iacute;as:</label>
                   <input type="number" name="cantidad" min="0" class="Texto11New" size="2" autocomplete="off" title="días" value="'.$cantidad.'">
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">Porcentaje:</label>
                   <input type="number" name="porcentaje" min="0" class="Texto11New" size="2" autocomplete="off" title="porcentaje" value="'.$porcentaje.'">  %
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">Intereses:</label>
                   <input type="number" name="pagointereses" min="0" class="Texto11New" size="2" autocomplete="off" title="pago de intereses" value="'.$pagointereses.'">                
                  </td>
                 </tr>
                </table>
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: almcesantiasmanual
    // Creación: 19/01/2022		última modificación: 21/01/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que guarda las cesantías que se procesaran manualmente por no ser 
    //              importadas desde Excel
    // Última modificación: Inclusión de la tabla primasterceros para la impresión de recibo 
    //                      de pago
    ////////////////////////////////////////////////////////////////////////////////////////            
    if($opcion == "almcesantiasmanual")
    {
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $pagocesantias = $_POST['pagocesantias'];
        $porcentaje = $_POST['porcentaje'];
        $pagointereses = $_POST['pagointereses'];
        $cantidad = $_POST['cantidad'];

        // Guardo en la tabla
        $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                  VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$cantidad.",".$porcentaje.",".$pagointereses.")";
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
        {
            $vsql = "INSERT INTO primasterceros (tipo, periodonomina, terid, esempleado, esempleadoactivo, extralegal,
                                                 areaid, seccionid, cargoid, bancoid, numcuenta, fecingreso,
                                                 basico, codvende, dni, nombre, epsid, pensionesid)                             
                          SELECT 'cesantias', '".$codperiodo."', terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid,
                                 cargoid, bancoid, numcuenta, fecingreso, basico, codvende, dni, 
                                 CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre,
                                 epsid, pensionesid
                            FROM terceros
                           WHERE terid = ".$terid."";
            $clase->EjecutarSQL($vsql);

            $clase->Aviso(1,"Datos almacenados satisfactoriamente");
        }
        else
            $clase->Aviso(3,"No se almacenaron los datos");

        // Redirecciona el formulario
        header("Location: calculoliquidados.php?opcion=ventanaliquidados");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editardotacion
    // Creación: 04/03/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para editar las dotaciones que se procesarán manualmente en caso  
    //              de fallar el importar desde Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editardotacion")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo FROM periodos WHERE anoperiodo >= 2022 AND mesperiodo >=2 ORDER BY orden";
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";
        $monto = 1;

        // Pintamos la ventana        
        $cont.='<table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Edici&oacute;n de dotaciones </b> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardardotaciones" name="y" method="POST">
                <table width="500">                 
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Empleado:</label>';

        $cont.= $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,400);
                   
        $cont.='  </td>                  
                 </tr>                 
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Periodo:</label>';

        $cont.= $clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400);
                    
        $cont.='  </td>                  
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Monto:</label>
                   <input type="number" name="monto" min="1" class="Texto11New" size="2" autocomplete="off" title="monto de la dotaci&oacute;n" value="'.$monto.'">                  
                  </td>
                 </tr>
                </table>
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardardotaciones
    // Creación: 04/03/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los datos de las dotaciones que se procesaron 
    //              manualmente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardardotaciones")
    {
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $monto = $_POST['monto'];

        $numregistro = 0;

        if((strlen($terid)==0) || (strlen($codperiodo)==0) || (strlen($monto)==0))
            $clase->Aviso(3,"Debe ingresar todos los datos");
        else
        {
            $vsql2 = "SELECT COUNT(*) AS numregistro
                        FROM dotaciones
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."'";
            $numregistro = $clase->SeleccionarUno($vsql2);

            if($numregistro>0)
            {
                $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid=".$terid."";
                $nombreemp = $clase->SeleccionarUno($vsql);

                $vsql = "SELECT monto FROM dotaciones WHERE terid=".$terid." AND periodonomina = '".$codperiodo."'";
                $monto = $clase->SeleccionarUno($vsql);
                
                $clase->Aviso(3,"$nombreemp ya tiene una dotación en el periodo $codperiodo por un monto de $monto pesos");
            }
            else
            {
                // Guardo en la tabla
                $vsql = "INSERT INTO dotaciones (periodonomina, terid, monto) 
                                         VALUES ('".$codperiodo."',".$terid.",".$monto.")";
                $clase->EjecutarSQL($vsql);
        
                // Emito el mensaje correspondiente
                if(mysql_affected_rows() >= 1)
                    $clase->Aviso(1,"Datos almacenados satisfactoriamente");
                else
                    $clase->Aviso(3,"No se almacenaron los datos");
            }
        }

        // Redirecciona el formulario
        header("Location: calculoliquidados.php?opcion=ventanaliquidados");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarpagocesantia
    // Creación: 07/03/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para editar los pagos de cesantias que se procesarán manualmente 
    //              en caso de fallar el importar desde Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarpagocesantia")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo FROM periodos WHERE anoperiodo >= 2022 AND mesperiodo >=2 ORDER BY orden";
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";
        $monto = 1;
        $dias = 1;

        // Pintamos la ventana        
        $cont.='<table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Edici&oacute;n de pagos de cesant&iacute;as </b> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardarpagoscesan" name="y" method="POST">
                <table width="500">                 
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Empleado:</label>';

        $cont.= $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,400);
                   
        $cont.='  </td>                  
                 </tr>                 
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Periodo:</label>';

        $cont.= $clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400);
                    
        $cont.='  </td>                  
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">D&iacute;as:</label>
                   <input type="number" name="dias" min="1" class="Texto11New" size="2" autocomplete="off" title="d&iacute;as de  cesant&iacute;as" value="'.$dias.'"> 
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Monto:</label>
                   <input type="number" name="monto" min="1" class="Texto11New" size="2" autocomplete="off" title="monto de la dotaci&oacute;n" value="'.$monto.'">                  
                  </td>
                 </tr>
                </table>
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarpagoscesan
    // Creación: 07/03/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los datos de los pagos de cesantias que se  
    //              procesaron manualmente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarpagoscesan")
    {
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $dias = $_POST['dias'];
        $monto = $_POST['monto'];

        $numregistro = 0;

        // Valido que los datos estén llenos
        if((strlen($terid)==0) || (strlen($codperiodo)==0) || (strlen($monto)==0) || (strlen($dias)==0))
            $clase->Aviso(3,"Debe ingresar todos los datos");
        else
        {
            // Valido que el pago a un empleado no esté duplicado
            $vsql2 = "SELECT COUNT(*) AS numregistro
                        FROM pagocesantias
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."'";
            $numregistro = $clase->SeleccionarUno($vsql2);

            if($numregistro>0)
            {
                $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid=".$terid."";
                $nombreemp = $clase->SeleccionarUno($vsql);

                $vsql = "SELECT monto FROM pagocesantias WHERE terid=".$terid." AND periodonomina = '".$codperiodo."'";
                $monto = $clase->SeleccionarUno($vsql);
                
                $clase->Aviso(3,"$nombreemp ya tiene una dotación en el periodo $codperiodo por un monto de $monto pesos");
            }
            else
            {
                // Guardo en la tabla
                $vsql = "INSERT INTO pagocesantias (periodonomina, terid, dias, monto) 
                                         VALUES ('".$codperiodo."',".$terid.",".$dias.",".$monto.")";
                $clase->EjecutarSQL($vsql);
        
                // Emito el mensaje correspondiente
                if(mysql_affected_rows() >= 1)
                    $clase->Aviso(1,"Datos almacenados satisfactoriamente");
                else
                    $clase->Aviso(3,"No se almacenaron los datos");
            }
        }

        // Redirecciona el formulario
        header("Location: calculoliquidados.php?opcion=ventanaliquidados");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: precalconliq
    // Creación: 17/03/2022		última modificación: 24/06/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que obtiene los datos básicos y los filtros para el cálculo de 
    //              cesantías, primas y vacaciones
    // Última modificación: Validación si el empleado trabajó en cada periodo (11/04/2011)
    //                      Fechas de ingreso y retiro y salario básico tomados del 
    //                      histórico de contrato
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "precalconliq")
    {
        $terid = $_GET['terid'];
        $codperiodo = $_GET['codperiodo'];
        $periodoid = $_GET['periodoid'];

        // Inicialización de variables
        $diasps = 0;                    $diasss = 0;                    $tienecambio = false;
        $promsueldoact = 0;             $sueldointegralact = 0;         $basico = 0;
        $yearingreso = 0;               $nombreemp = "";

        // $fecingreso = $clase->BDLockup($terid,'terceros','terid','fecingreso');             // fecha de ingreso
        // $basico = $clase->BDLockup($terid,'terceros','terid','basico');                     // sueldo básico

        // Obtengo el salario básico del empleado
        $vsql17 = "SELECT hc.ultsueldo 
                     FROM histcontrato hc
                    WHERE hc.terid = ".$terid." 
                          AND hc.id = (SELECT MAX(id)
                                         FROM histcontrato
                                        WHERE terid = ".$terid.")";
        $basico = $clase->SeleccionarUno($vsql17);

        // fechas de ingreso y retiro
        $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
        $idhistorico = $clase->SeleccionarUno($vsql18);

        $vsql21 = "SELECT hc.fecingreso
                     FROM histcontrato hc
                    WHERE hc.terid = ".$terid." 
                          AND hc.id = ".$idhistorico;
        $fecingreso = $clase->SeleccionarUno($vsql21);

        $vsql21 = "SELECT hc.fecretiro 
                     FROM histcontrato hc
                    WHERE hc.terid = ".$terid." 
                          AND hc.id = ".$idhistorico;
        $fecretiro = $clase->SeleccionarUno($vsql21);

        $yearingreso = intval(substr($fecingreso,0,4));                                     // año de la fecha de ingreso

        // Nombre del empleado
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                   FROM terceros 
                  WHERE terid = ".$terid."";
        $nombreemp = $clase->SeleccionarUno($vsql);

        // // Obtengo el id del último contrato
        // $vsql = "SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid;
        // $id = $clase->SeleccionarUno($vsql);
        // $fecretiro = $clase->BDLockup($id,'histcontrato','id','fecretiro');

        // if(($fecretiro == NULL) || ($fecretiro == '0000-00-00') || ($fecretiro == ''))
        //     $fecretiro = $clase->BDLockup($terid,'terceros','terid','fecharetiro');

        // validación del subsidio de transporte
        $smlv = $_SESSION['N_SALMIN2020'];
        $valtransporte = $smlv * 2;

        if($basico > $valtransporte)
            $auxtrans = 0;
        else
            $auxtrans = $_SESSION['N_AUXTRANS2020'];

        // ------------------------------------------------------------------------------------------- //
        // Determino si hubo un cambio de salario en los últimos tres meses
        $tienecambio = tienecambiosalario($terid,$fecretiro);

        // echo $tienecambio; exit();

        if($tienecambio)
        {
            $promsueldoact = calsueldopromedio($terid,$fecingreso);
            $basico = $promsueldoact;
        }
        
        // año anterior
        $yearprev = date("Y") - 1;

        if($yearingreso>$yearprev)
        {
            $basicoant = 0;
            $auxtransant = 0;
            $diasyearant = 0;
            $sueldointegralant = 0;
        }
        else
        {
            // máximo periodo del año anterior
            $vsql = " SELECT MAX(periodoid) AS periodoidant FROM periodosnomina WHERE YEAR(fechasta) = ".$yearprev." ";
            $periodoidant = $clase->SeleccionarUno($vsql);            
    
            // básico de año anterior
            $vsql = "SELECT saldo 
                       FROM hisdetallenomina 
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoidant." 
                            AND conceptoid IN (1,10,11,12,13,31,38,43)";
            $basicoant = $clase->SeleccionarUno($vsql);

            // ------------------------------------------------------------------------------------------- //
            $vsql25 = "SELECT MIN(periodoid) permin2
                         FROM periodosnomina 
                        WHERE fecdesde >= '".$fecingreso."' 
                              AND YEAR(fecdesde) = ".$yearprev." 
                              AND cerrado = 'CHECKED' ";
            $permin2 = $clase->SeleccionarUno($vsql25);

            if(strlen($permin2) == 0)
            {
                $vsql25 = "SELECT MIN(periodoid) permin2
                             FROM periodosnomina 
                            WHERE fecdesde >= '".$fecingreso."'
                                  AND cerrado = 'CHECKED' ";
                $permin2 = $clase->SeleccionarUno($vsql25);
                $permin2--;
            }
            
            $vsql26 = "SELECT MAX(periodoid) permax2
                         FROM periodosnomina 
                        WHERE fecdesde >= '".$fecingreso."' 
                              AND YEAR(fecdesde) = ".$yearprev." 
                              AND cerrado = 'CHECKED' ";
            $permax2 = $clase->SeleccionarUno($vsql26);

            if(strlen($permax2) == 0)
                $permax2 = $permin2;

            // ------------------------------------------------------------------------------------------- //
    
            if(($basicoant==0)||($basicoant==NULL))
            {
                $basicoant = 0;
                $auxtransant = 0;
                $diasyearant = 0;
                $sueldointegralant = 0;
            }
            else
            {
                // auxilio de transporte del año anterior
                $vsql = "SELECT saldo FROM hisdetallenomina WHERE conceptoid = 3 AND pernominaid = ".$periodoidant." AND terid = ".$terid;
                $auxtransant = $clase->SeleccionarUno($vsql);
    
                // Sueldo integral del año anterior
                $sueldointegralant = $basicoant + $auxtransant;                
    
                // días laborados el año anterior
                $vsql = "SELECT periodoid
                           FROM periodosnomina
                          WHERE fecdesde <= '".$fecingreso."'
                                AND fechasta >= '".$fecingreso."'";
                $eneroant = $clase->SeleccionarUno($vsql);                
        
                $vsql = "SELECT SUM(valor) AS diasyearant 
                           FROM hisdetallenomina 
                          WHERE terid = ".$terid." 
                                AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                AND pernominaid BETWEEN ".$eneroant." AND ".$periodoidant." 
                                AND pernominaid NOT IN (SELECT pernominaid 
                                                          FROM periodoterceros 
                                                         WHERE periodoterceros.terid = ".$terid." 
                                                               AND periodoterceros.pernominaid BETWEEN ".$permin2." AND ".$permax2." 
                                                               AND periodoterceros.extralegal = 'CHECKED')";
                $diasyearant = $clase->SeleccionarUno($vsql);
            }
        }

        // ----------------------------------------------------------------------------------------------- //
        // Días laborados en el primer trimestre del año actual
        $yeartoday = date("Y");

        $comienzoprimersemestre = $yeartoday."-01-01";
        $finprimersemestre = $yeartoday."-06-30";

        // si el empleado ingresó en este periodo
        if($fecingreso>=$comienzoprimersemestre)
        {
            $vsql = " SELECT MAX(periodoid) AS primeroenero FROM periodosnomina WHERE fecdesde <= '".$fecingreso."' ";
            $primeroenero = $clase->SeleccionarUno($vsql);
    
            $vsql = " SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."' ";
            $treintajunio = $clase->SeleccionarUno($vsql);
    
            // Días en el histórico
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                       FROM hisdetallenomina 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio." 
                            AND pernominaid NOT IN (SELECT pernominaid 
                                                      FROM periodoterceros
                                                     WHERE periodoterceros.terid = ".$terid." 
                                                           AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                           AND periodoterceros.extralegal = 'CHECKED')";
            $diasps = $clase->SeleccionarUno($vsql);
    
            // Días en la liquidación
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                       FROM detalleliquidacion 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
            $diasliq = $clase->SeleccionarUno($vsql);
    
            $diasps += $diasliq;
        }

        if(($fecingreso<$comienzoprimersemestre)&&($diasyearant>0))
        {
            $diasliq = 0;
            $vsql = " SELECT periodoid AS primeroenero FROM periodosnomina WHERE fecdesde = '".$comienzoprimersemestre."' ";
            $primeroenero = $clase->SeleccionarUno($vsql);

            $vsql = " SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."' ";
            $treintajunio = $clase->SeleccionarUno($vsql);
    
            // Días en el histórico
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                       FROM hisdetallenomina 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                            AND pernominaid NOT IN (SELECT pernominaid 
                                                      FROM periodoterceros
                                                     WHERE periodoterceros.terid = ".$terid." 
                                                           AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                           AND periodoterceros.extralegal = 'CHECKED')";
            $diasps = $clase->SeleccionarUno($vsql);
    
            // Días en la liquidación
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                       FROM detalleliquidacion 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40)
                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
            $diasliq = $clase->SeleccionarUno($vsql);
    
            $diasps += $diasliq;
        }

        // Días laborados en el segundo semestre del año
        $inisegsemestre = $yeartoday."-07-01";
        $finsegsemestre = $yeartoday."-12-31";

        // si el empleado ingresó en este periodo
        if($fecingreso>=$inisegsemestre)
        {
            $vsql = " SELECT MAX(periodoid) AS primerojulio FROM periodosnomina WHERE fecdesde <= '".$fecingreso."' ";
            $primerojulio = $clase->SeleccionarUno($vsql);

            $vsql = " SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."' ";
            $treintayuno = $clase->SeleccionarUno($vsql);
    
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                       FROM hisdetallenomina 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                            AND pernominaid NOT IN (SELECT pernominaid 
                                                      FROM periodoterceros
                                                     WHERE periodoterceros.terid = ".$terid." 
                                                           AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                           AND periodoterceros.extralegal = 'CHECKED')";
            $diasss = $clase->SeleccionarUno($vsql);
    
            // Días en la liquidación
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                       FROM detalleliquidacion 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
            $diasliq = $clase->SeleccionarUno($vsql);
    
            $diasss += $diasliq;
        }

        if(($fecingreso<$inisegsemestre)&&($diasps>0))
        {
            $vsql = " SELECT periodoid AS primerojulio FROM periodosnomina WHERE fecdesde = '".$inisegsemestre."' ";
            $primerojulio = $clase->SeleccionarUno($vsql);

            $vsql = " SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."' ";
            $treintayuno = $clase->SeleccionarUno($vsql);
    
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                       FROM hisdetallenomina 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                            AND pernominaid NOT IN (SELECT pernominaid 
                                                      FROM periodoterceros
                                                     WHERE periodoterceros.terid = ".$terid." 
                                                           AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                           AND periodoterceros.extralegal = 'CHECKED')";
            $diasss = $clase->SeleccionarUno($vsql);
    
            // Días en la liquidación
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                       FROM detalleliquidacion 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
            $diasliq = $clase->SeleccionarUno($vsql);
    
            $diasss += $diasliq;
        }

        $cesantiasant = "";                 $cesantiasact = "CHECKED";                  $intcesant = "";
        $intcesact = "CHECKED";             $chkvacaciones = "CHECKED";                 $chkprimasps = "CHECKED";
        $chkprimasss = "CHECKED";           $chklimpiar = "";

        if($diasyearant==0)     $disabled1 = "disabled";
        else                    $disabled1 = "";

        $ingreso = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
        $retiro = substr($fecretiro,8,2)."/".substr($fecretiro,5,2)."/".substr($fecretiro,0,4);

        $cont.='<table width="400">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="center"> 
                  <b>Calcular<br>cesant&iacute;as, primas y vacaciones</b>
                  </td>
                 </tr> 
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left">                    
                   Empleado: <font color="BLUE">'.$nombreemp.'</font><br><br>
                   Fecha de ingreso: <font color="BLUE">'.$ingreso.'</font><br>
                   Fecha de retiro: <font color="BLUE">'.$retiro.'</font><br><br>
                   D&iacute;as laborados año anterior: <font color="BLUE">'.$diasyearant.'</font><br>
                   D&iacute;as laborados primer semestre: <font color="BLUE">'.$diasps.'</font><br>
                   D&iacute;as laborados segundo semestre: <font color="BLUE">'.$diasss.'</font><br><br>
                   Sueldo b&aacute;sico año anterior: <font color="BLUE">'.number_format($basicoant).'</font><br>
                   Auxilio de transporte año anterior: <font color="BLUE">'.number_format($auxtransant).'</font><br>
                   Sueldo integral año anterior: <font color="BLUE">'.number_format($sueldointegralant).'</font><br><br>
                   Sueldo b&aacute;sico año actual: <font color="BLUE">'.number_format($basico).'</font><br>
                   Auxilio de transporte año actual: <font color="BLUE">'.number_format($auxtrans).'</font><br>
                   Sueldo integral año actual: <font color="BLUE">'.number_format($basico).'</font><br><br>
                  </td>
                 </tr> 
                </table>
                <form action="?opcion=calconliq" name="y" method="POST">
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">                
                <!-- <input type="hidden" name="sueldointegralact" value="'.$sueldointegralact.'"> -->
                <input type="hidden" name="sueldointegralant" value="'.$sueldointegralant.'">
                <input type="hidden" name="diasyearant" value="'.$diasyearant.'">
                <input type="hidden" name="diasps" value="'.$diasps.'">
                <input type="hidden" name="diasss" value="'.$diasss.'">
                <input type="hidden" name="fecingreso" value="'.$fecingreso.'">
                <input type="hidden" name="basico" value="'.$basico.'">
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left">
                   <input type="checkbox" value="CHECKED" name="cesantiasant" class="Texto11" '.$cesantiasant.' '.$disabled1.'> Cesantías causadas año anterior <br>
                   <input type="checkbox" value="CHECKED" name="cesantiasact" class="Texto11" '.$cesantiasact.'> Cesantías causadas año actual <br>
                   <input type="checkbox" value="CHECKED" name="intcesant" class="Texto11" '.$intcesant.' '.$disabled1.'> Intereses cesantías año anterior <br>
                   <input type="checkbox" value="CHECKED" name="intcesact" class="Texto11" '.$intcesact.'> Intereses cesantías año actual <br>
                   <input type="checkbox" value="CHECKED" name="chkvacaciones" class="Texto11" '.$chkvacaciones.'> Vacaciones <br>
                   <input type="checkbox" value="CHECKED" name="chkprimasps" class="Texto11" '.$chkprimasps.'> Primas primer semestre <br>
                   <input type="checkbox" value="CHECKED" name="chkprimasss" class="Texto11" '.$chkprimasss.'> Primas segundo semestre <br><br>
                   <input type="checkbox" value="CHECKED" name="chklimpiar" class="Texto11" '.$chklimpiar.'> Limpiar datos anteriores <br><br>
                  </td>
                 </tr>
                </table> 
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: calconliq
    // Creación: 18/03/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que calcula las vacaciones, primas y cesantías
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "calconliq")
    {
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $periodoid = $_POST['periodoid'];
        $sueldointegralant = $_POST['sueldointegralant'];
        $diasyearant = $_POST['diasyearant'];
        $diasps = $_POST['diasps'];
        $diasss = $_POST['diasss'];
        $cesantiasant = $_POST['cesantiasant'];
        $cesantiasact = $_POST['cesantiasact'];
        $intcesant = $_POST['intcesant'];
        $intcesact = $_POST['intcesact'];
        $chkvacaciones = $_POST['chkvacaciones'];
        $chkprimasps = $_POST['chkprimasps'];
        $chkprimasss = $_POST['chkprimasss'];
        $chklimpiar = $_POST['chklimpiar'];
        $fecingreso = $_POST['fecingreso'];        
        $basico = $_POST['basico'];
        // $sueldointegralact = $_POST['sueldointegralact'];
        
        // Inicialización de variables
        $pagocenact = 0;                            $cantidad = 0;                          $porcentaje = 0;                        $pagointereses = 0;
        $pagovaca = 0;                              $diasvaca = 0;                          $diasprima = 0;                         $pagoprimasps = 0;
        $lbprocesado = false;                       $pagocesant = 0;                        $cantidadact = 0;                       $cantidadant = 0;
        $pagocesantias = 0;                         $interesesact = 0;                      $interesesant = 0;                      $pagoprimasss = 0;
        $pagoprimas = 0;                            $recarnonocturno = 0;                   $ultimobasico = 0;                      $auxtrans = $_SESSION['N_AUXTRANS2020'];
        $ultimoperbasico = 0;

        // ---------------------------------------------------------- //
        // Limpio los datos de cesantías, primas y vacaciones que 
        // existieran antes de este cálculo para evitar duplicados
        if($chklimpiar == "CHECKED")
        {
            // Limpio la tabla liquidación
            $vsql = "DELETE FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."'";
            $clase->EjecutarSQL($vsql);

            // Limpio la tabla para la impresión de la liquidación
            $vsql = "DELETE FROM impresionliquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."'";
            $clase->EjecutarSQL($vsql);
        }

        // ---------------------------------------------------------- //
        // Cálculo de cesantías
        if(($cesantiasact == "CHECKED")||($cesantiasant == "CHECKED")||($intcesact == "CHECKED")||($intcesant == "CHECKED"))
        {
            // Cálculo de cesantías del año actual
            if($cesantiasact == "CHECKED")
            {
                $cantidadact = $diasps + $diasss;
                // $pagocenact = $sueldointegralact * $cantidadact / 360;
                $pagocenact = ($basico + $auxtrans) * $cantidadact / 360;
            }
            else
            {
                $pagocenact = 0;
                $cantidadact = 0;
            }
            
            // Cálculo de cesantías del año anterior
            if($cesantiasant == "CHECKED")
            {
                // $pagocesant = $sueldointegralant * $diasyearant / 360;
                $pagocesant = ($sueldointegralant + $auxtrans) * $diasyearant / 360;
                $cantidadant = $diasyearant;
            }
            else
            {
                $pagocesant = 0;
                $cantidadant = 0;
            }
            
            // sub totales
            $pagocesantias = $pagocenact + $pagocesant;
            $pagocesantias = round($pagocesantias,2);
            $cantidad = $cantidadact + $cantidadant;
            $porcentaje = 12;

            // Intereses año actual
            if($intcesact == "CHECKED")
                $interesesact = (($pagocenact * ($diasps + $diasss)) * 0.12 / 360);
            else
                $interesesact = 0;

            // intereses del año anterior
            if($intcesant == "CHECKED")
                $interesesant = (($pagocesant * $diasyearant) * 0.12 / 360);
            else
                $interesesant = 0;

            $pagointereses = $interesesact + $interesesant;
            $pagointereses = round($pagointereses,2);

            // Guardo en la tabla
            $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                      VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$cantidad.",".$porcentaje.",".$pagointereses.")";
            $clase->EjecutarSQL($vsql);

            if(mysql_affected_rows() >= 1)
                $lbprocesado = true;
        }

        // ---------------------------------------------------------- //
        // Cálculo de vacaciones
        if($chkvacaciones == "CHECKED")
        {
            // Determino si hay vacaciones canceladas previamente
            $vsql22 = "SELECT MIN(periodoid) permin
                         FROM periodosnomina 
                        WHERE fecdesde >= '".$fecingreso."' 
                              AND cerrado = 'CHECKED' ";
            $permin = $clase->SeleccionarUno($vsql22);

            // Determino si hay vacaciones canceladas previamente
            $vsql23 = "SELECT MAX(periodoid) permax
                         FROM periodosnomina 
                        WHERE fecdesde >= '".$fecingreso."' 
                              AND cerrado = 'CHECKED' ";
            $permax = $clase->SeleccionarUno($vsql23);

            $vsql24 = "SELECT pernominaid pervacaciones
                         FROM hisdetallenomina 
                        WHERE terid = ".$terid."         
                              AND conceptoid = 38 
                              AND pernominaid >= ".$permin." AND pernominaid <= ".$permax."";
            $pervacaciones = $clase->SeleccionarUno($vsql24);

            if(strlen($pervacaciones) > 0)
            {
                $pervacaciones++;

                $vsql31 = "SELECT IFNULL(SUM(valor),0) AS diasvaca  
                             FROM hisdetallenomina 
                            WHERE terid = ".$terid."         
                                  AND (pernominaid >= ".$pervacaciones." AND pernominaid <= ".$permax.")  
                                  AND conceptoid IN (1,10,11,12,13,23,31,38,40)";
                $diasvaca = $clase->SeleccionarUno($vsql31);
            }
            else
                $diasvaca = $diasyearant + $diasps + $diasss;
            
            // ---------------------------------------------------------- //
            
            // sueldo básico
            // $basico = $clase->BDLockup($terid,'terceros','terid','basico');
            // $pagovaca = $basico * ($diasyearant + $diasps + $diasss) / 720;

            $vsql19 = "SELECT saldo FROM detalleliquidacion WHERE conceptoid = 1 AND pernominaid = ".$periodoid." AND terid = ".$terid;
            $ultimobasico = $clase->SeleccionarUno($vsql19);
            
            if($ultimobasico == 0)
            {
                $vsql20 = "SELECT MAX(pernominaid) FROM detallenomina WHERE conceptoid = 1 AND terid = ".$terid;
                $ultimoperbasico = $clase->SeleccionarUno($vsql20);

                $vsql19 = "SELECT saldo FROM detallenomina WHERE conceptoid = 1 AND pernominaid = ".$ultimoperbasico." AND terid = ".$terid;
                $ultimobasico = $clase->SeleccionarUno($vsql19);
            }

            // busco recargo nocturno
            $recarnonocturno = buscarrecargonoc($terid,$periodoid);

            $pagovaca = ($ultimobasico + $recarnonocturno) * $diasvaca / 720;

            $pagovaca = round($pagovaca,2);
            // $diasvaca = $diasyearant + $diasps + $diasss;

            // Almaceno en la tabla
            $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                      VALUES ('".$codperiodo."',".$terid.",'vacaciones',".$pagovaca.",".$diasvaca.",0,0)";
            $clase->EjecutarSQL($vsql);

            if(mysql_affected_rows() >= 1)
                $lbprocesado = true;
        }
        
        // ---------------------------------------------------------- //
        // Cálculo de primas
        if(($chkprimasps == "CHECKED") || ($chkprimasss == "CHECKED"))
        {
            // Primas primer semestre
            if($chkprimasps == "CHECKED")
            {
                $diasprima += $diasps;
                $pagoprimasps = ($basico + $auxtrans) * $diasps / 360;
            }

            // Primas segundo semestre
            if($chkprimasss == "CHECKED")
            {
                $diasprima += $diasss;
                $pagoprimasss = ($basico + $auxtrans) * $diasss / 360;
            }

            $pagoprimas = $pagoprimasps + $pagoprimasss;
            $pagoprimas = round($pagoprimas,2);

            // Almaceno en la tabla
            $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                      VALUES ('".$codperiodo."',".$terid.",'primas',".$pagoprimas.",".$diasprima.",0,0)";
            $clase->EjecutarSQL($vsql);

            if(mysql_affected_rows() >= 1)
                $lbprocesado = true;
        }

        // -------------------------------------------------------------------------- //
        // Guardo la configuración de impresión y emito el mensaje correspondiente
        if($lbprocesado)
        {
            // limpio
            $vsql2 = "DELETE FROM impresionliquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."'";
            $clase->EjecutarSQL($vsql2);

            // guardo
            $vsql = "INSERT INTO impresionliquidacion (periodonomina,terid,cesantiasant,cesantiasact,intcesant,intcesact,vacaciones,primasps,primasss) 
                                                VALUE ('".$codperiodo."',".$terid.",'".$cesantiasant."','".$cesantiasact."','".$intcesant."',
                                                       '".$intcesact."','".$chkvacaciones."','".$chkprimasps."','".$chkprimasss."')";
            $clase->EjecutarSQL($vsql);

            // mensaje
            $clase->Aviso(1,"Datos almacenados satisfactoriamente");
        }
        else
            $clase->Aviso(3,"No se almacenaron los datos");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=ventanareprocesarliq&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confimpresion
    // Creación: 24/03/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para configurar la impresión de la liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confimpresion")
    {
        $cont.='<table width="400">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="center"> <b>Configurar impresi&oacute;n</b> </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"> 
                   ¿qu&eacute; vas a imprimir? 
                   &nbsp;
                   <img src="images/basicas/print.png" width="15" height="15" border="0"> 
                  </td>
                 </tr>
                </table>
                <form action="?opcion=calconliq" name="y" method="POST">
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">                
                <input type="hidden" name="sueldointegralact" value="'.$sueldointegralact.'">
                <input type="hidden" name="sueldointegralant" value="'.$sueldointegralant.'">
                <input type="hidden" name="diasyearant" value="'.$diasyearant.'">
                <input type="hidden" name="diasps" value="'.$diasps.'">
                <input type="hidden" name="diasss" value="'.$diasss.'">
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left">
                   <input type="checkbox" value="CHECKED" name="cesantiasant" class="Texto11" '.$cesantiasant.' '.$disabled1.'> cesant&iacute;as causadas año anterior <br>
                   <input type="checkbox" value="CHECKED" name="cesantiasact" class="Texto11" '.$cesantiasact.'> cesant&iacute;as causadas año actual <br>
                   <input type="checkbox" value="CHECKED" name="intcesant" class="Texto11" '.$intcesant.' '.$disabled1.'> intereses cesant&iacute;as año anterior <br>
                   <input type="checkbox" value="CHECKED" name="intcesact" class="Texto11" '.$intcesact.'> intereses cesant&iacute;as año actual <br>
                   <input type="checkbox" value="CHECKED" name="chkvacaciones" class="Texto11" '.$chkvacaciones.'> vacaciones <br>
                   <input type="checkbox" value="CHECKED" name="chkprimasps" class="Texto11" '.$chkprimasps.'> primas primer semestre <br>
                   <input type="checkbox" value="CHECKED" name="chkprimasss" class="Texto11" '.$chkprimasss.'> primas segundo semestre <br><br>                   
                  </td>
                 </tr>
                </table> 
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: imprimirliq
    // Creación: 22/03/2022		última modificación: 01/07/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que imprime en formato pdf una liquidación
    // Última modificación: Encabezado en la impresión no calculada
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "imprimirliq")
    {
        $terid = $_GET['terid'];
        $codperiodo = $_GET['codperiodo'];
        $periodoid = $_GET['periodoid'];

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Cédula o documento del empleado
        $dni = $clase->BDLockup($terid,'terceros','terid','dni');

        // El cargo
        $vsqldatos = "SELECT c.descripcioncargo 
                        FROM terceros t
                             INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                       WHERE t.terid = ".$terid;
        $cargo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // fecha de ingreso
        $fecingreso = $clase->BDLockup($terid,'terceros','terid','fecingreso');
        $ingreso  = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);

        // Fecha de retiro
        $vsql = "SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid;
        $id = $clase->SeleccionarUno($vsql);
        $fecretiro = $clase->BDLockup($id,'histcontrato','id','fecretiro');
        $retiro  = substr($fecretiro,8,2)."/".substr($fecretiro,5,2)."/".substr($fecretiro,0,4);            // Variable para el nombre de empleado
        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Cédula o documento del empleado
        $dni = $clase->BDLockup($terid,'terceros','terid','dni');

        // El cargo
        $vsqldatos = "SELECT c.descripcioncargo 
                        FROM terceros t
                             INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                       WHERE t.terid = ".$terid;
        $cargo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // fecha de ingreso
        $fecingreso = $clase->BDLockup($terid,'terceros','terid','fecingreso');
        $ingreso  = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);

        // Fecha de retiro
        $vsql = "SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid;
        $id = $clase->SeleccionarUno($vsql);
        $fecretiro = $clase->BDLockup($id,'histcontrato','id','fecretiro');
        $retiro  = substr($fecretiro,8,2)."/".substr($fecretiro,5,2)."/".substr($fecretiro,0,4);

        // ------------------------------------------------------------------------------------------------ //
        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        $clase = new Sistema();
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF();

        $pdf->AddPage("");

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

        // Coordenadas iniciales
        $x = 35;
        $y = 15;

        // Encabezado
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."";

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+125,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "LIQUIDACION CONTRATO DE TRABAJO";
        $pdf->Text($x,$y+6,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "EMPLEADO: ".$nombreemp;
        $pdf->Text($x,$y+12,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "DOCUMENTO: ".$dni;
        $pdf->Text($x,$y+18,$enc);

        $x = 10;

        // Datos de empleado
        $pdf->SetFont('Arial','',8);
        $enc= "CARGO: ".$cargo;
        $pdf->Text($x,$y+26,$enc);

        $enc= "FECHA DE INGRESO: ".$ingreso;
        $pdf->Text($x+90,$y+26,$enc);

        $enc= "FECHA DE RETIRO: ".$retiro;
        $pdf->Text($x+143,$y+26,$enc);

        $mensaje1 = "El suscrito trabajador declara que ha recibido a entera satisfaccion la suma de dinero a que hace referencia la siguiente liquidacion.";
        $pdf->Text($x,$y+32,$mensaje1);

        // Consulta para determinar el tipo de impresión de la liquidación
        $vsqldatos = "SELECT COUNT(*) AS numreg 
                        FROM impresionliquidacion 
                       WHERE terid = ".$terid." 
                             AND periodonomina = '".$codperiodo."'";
        $numreg = $clase->SeleccionarUno($vsqldatos);

        // Determino si la liquidación fue calculada o digitada
        if($numreg>0)
        {
            // Obtengo el id de la configuración de impresión calculada
            $vsqldatos = "SELECT id FROM impresionliquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."'";
            $id = $clase->SeleccionarUno($vsqldatos);

            // Obtengo la configuración de la impresión de la liquidación
            $cesantiasant = $clase->BDLockup($id,'impresionliquidacion','id','cesantiasant');
            $cesantiasact = $clase->BDLockup($id,'impresionliquidacion','id','cesantiasact');
            $intcesant = $clase->BDLockup($id,'impresionliquidacion','id','intcesant');
            $intcesact = $clase->BDLockup($id,'impresionliquidacion','id','intcesact');
            $vacaciones = $clase->BDLockup($id,'impresionliquidacion','id','vacaciones');
            $primasps = $clase->BDLockup($id,'impresionliquidacion','id','primasps');
            $primasss = $clase->BDLockup($id,'impresionliquidacion','id','primasss');

            // inicialización de variables
            $asignaciones = 0;              $salariotrab = 0;                   $transporte = 0;               $pagovacaciones = 0;                     $pagocesant = 0;
            $pagocenact = 0;                $pagoprimasps = 0;                  $pagoprimasss = 0;             $deducciones = 0;                        $pension = 0;
            $salud = 0;                     $otrasdeduc = 0;                    $neto = 0;                     $asignaciones = 0;                       $deducciones = 0;
            $diasprima = 0;                 $indemnizacion = 0;

            // ------------------------------------------------------------------------------------------------ //
            // año anterior
            $yearprev = date("Y") - 1;

            // máximo periodo del año anterior
            $vsql = " SELECT MAX(periodoid) AS periodoidant FROM periodosnomina WHERE YEAR(fechasta) = ".$yearprev." ";
            $periodoidant = $clase->SeleccionarUno($vsql);

            // básico de año anterior
            $vsql = "SELECT saldo FROM hisdetallenomina WHERE conceptoid = 1 AND pernominaid = ".$periodoidant." AND terid = ".$terid;
            $basicoant = $clase->SeleccionarUno($vsql);

            if(($basicoant==0)||($basicoant==NULL))
            {
                $basicoant = 0;
                $auxtransant = 0;
                $diasyearant = 0;
                $sueldointegralant = 0;
            }
            else
            {
                // auxilio de transporte del año anterior
                $vsql = "SELECT saldo FROM hisdetallenomina WHERE conceptoid = 3 AND pernominaid = ".$periodoidant." AND terid = ".$terid;
                $auxtransant = $clase->SeleccionarUno($vsql);

                // Sueldo integral del año anterior
                $sueldointegralant = $basicoant + $auxtransant;

                // días laborados el año anterior
                $vsql = "SELECT periodoid
                           FROM periodosnomina
                          WHERE fecdesde <= '".$fecingreso."'
                                AND fechasta >= '".$fecingreso."'";
                $eneroant = $clase->SeleccionarUno($vsql);
        
                $vsql = "SELECT IFNULL(SUM(valor),0) AS diasyearant 
                           FROM hisdetallenomina 
                          WHERE terid = ".$terid." 
                                AND conceptoid = 1 
                                AND pernominaid BETWEEN ".$eneroant." AND ".$periodoidant."";
                $diasyearant = $clase->SeleccionarUno($vsql);
            }

            // Días laborados en el primer trimestre del año actual
            $yeartoday = date("Y");

            $comienzoprimersemestre = $yeartoday."-01-01";
            $finprimersemestre = $yeartoday."-06-30";
            
            $vsql = " SELECT periodoid AS primeroenero FROM periodosnomina WHERE fecdesde = '".$comienzoprimersemestre."' ";
            $primeroenero = $clase->SeleccionarUno($vsql);

            $vsql = " SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."' ";
            $treintajunio = $clase->SeleccionarUno($vsql);

            // Días en el histórico
            $vsql = "SELECT SUM(valor) AS diasps
                       FROM hisdetallenomina 
                      WHERE terid = ".$terid." 
                            AND conceptoid = 1 
                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
            $diasps = $clase->SeleccionarUno($vsql);

            // Días en la liquidación
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                       FROM detalleliquidacion 
                      WHERE terid = ".$terid." 
                            AND conceptoid = 1 
                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
            $diasliq = $clase->SeleccionarUno($vsql);

            $diasps += $diasliq;

            // Días laborados en el segundo semestre del año
            $inisegsemestre = $yeartoday."-07-01";
            $finsegsemestre = $yeartoday."-12-31";

            $vsql = " SELECT periodoid AS primerojulio FROM periodosnomina WHERE fecdesde = '".$inisegsemestre."' ";
            $primerojulio = $clase->SeleccionarUno($vsql);
            
            $vsql = " SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."' ";
            $treintayuno = $clase->SeleccionarUno($vsql);

            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                       FROM hisdetallenomina 
                      WHERE terid = ".$terid." 
                            AND conceptoid = 1 
                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
            $diasss = $clase->SeleccionarUno($vsql);

            // Días en la liquidación        
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                       FROM detalleliquidacion 
                      WHERE terid = ".$terid." 
                            AND conceptoid = 1 
                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
            $diasliq = $clase->SeleccionarUno($vsql);

            $diasss += $diasliq;

            // sueldo básico
            $basico = $clase->BDLockup($terid,'terceros','terid','basico');

            $auxtrans = $_SESSION['N_AUXTRANS2020'];                                            // auxilio de transporte
            $sueldointegralact = $basico + $auxtrans;                                           // sueldo integral año actual

            // cesantías del año anterior
            if($cesantiasant=="CHECKED")            $pagocesant = $sueldointegralant * $diasyearant / 360;

            // cesantías del año actual
            if($cesantiasact=="CHECKED")            $pagocenact = $sueldointegralact * ($diasps + $diasss) / 360;

            // Primas primer semestre
            if($primasps=="CHECKED")
            {
                $diasprima += $diasps;
                $pagoprimasps = $sueldointegralact * $diasps / 360;
            }

            // Primas segundo semestre
            if($pagoprimasss=="CHECKED")
            {
                $diasprima += $diasss;
                $pagoprimasss = $sueldointegralact * $diasss / 360;
            }

            // vacaciones
            if($vacaciones=="CHECKED")
            {
                $vsqldatos = "SELECT IFNULL(pago,0) AS pagovacaciones
                                FROM liquidacion 
                               WHERE terid = ".$terid." 
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'vacaciones'";
                $pagovacaciones = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
            }

            // Salario de la última quincena
            $vsqldatos = "SELECT IFNULL(devengados,0) AS salariotrab 
                            FROM detalleliquidacion 
                           WHERE terid = ".$terid." 
                                 AND conceptoid = 1
                                 AND pernominaid = ".$periodoid."";
            $salariotrab = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // pensión de la última quincena
            $vsqldatos = "SELECT IFNULL(descuentos,0) AS pension 
                            FROM detalleliquidacion 
                           WHERE terid = ".$terid." 
                                 AND conceptoid = 4
                                 AND pernominaid = ".$periodoid."";
            $pension = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // salud
            $vsqldatos = "SELECT IFNULL(descuentos,0) AS salud 
                            FROM detalleliquidacion 
                           WHERE terid = ".$terid." 
                                 AND conceptoid = 5
                                 AND pernominaid = ".$periodoid."";
            $salud = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // otras deducciones
            $vsqldatos = "SELECT IFNULL(SUM(descuentos),0) AS otrasdeduc 
                            FROM detalleliquidacion 
                           WHERE terid = ".$terid."                              
                                 AND pernominaid = ".$periodoid."
                                 AND conceptoid NOT IN (4,5)";
            $otrasdeduc = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Auxilio de transporte última quincena
            $vsqldatos = "SELECT IFNULL(devengados,0) AS transporte 
                            FROM detalleliquidacion 
                           WHERE terid = ".$terid." 
                                 AND conceptoid = 3
                                 AND pernominaid = ".$periodoid."";
            $transporte = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Indemnización:
            $vsqldatos = "SELECT IFNULL(pago,0) AS indemnizacion
                            FROM liquidacion 
                           WHERE terid = ".$terid." 
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'indemnizacion'";
            $indemnizacion = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // intereses del año anterior
            if($intcesant=="CHECKED")               $interesesant = (($pagocesant * $diasyearant) * 0.12 / 360);

            // Intereses año actual
            if($intcesact=="CHECKED")               $interesesact = (($pagocenact * ($diasps + $diasss)) * 0.12 / 360);

            // Línea para la impresión del detalle de la liquidación            
            $y = 47;

            // Impresión de los días laborados en el año anterior
            if((($cesantiasant=="CHECKED")||($intcesant=="CHECKED")||($vacaciones=="CHECKED"))&&($diasyearant>0))
            {
                $y += 6;
                $det= "DIAS LABORADOS ".$yearprev.":";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen($diasyearant);
                if($longitud==1)        $pdf->Text($x+132,$y,$diasyearant);
                if($longitud==2)        $pdf->Text($x+130,$y,$diasyearant);
                if($longitud==3)        $pdf->Text($x+128,$y,$diasyearant);
            }

            // Impresión de los días laborados en el primer semestre del año en curso
            if((($cesantiasact=="CHECKED")||($intcesact=="CHECKED")||($vacaciones=="CHECKED")||($primasps=="CHECKED"))&&($diasps>0))
            {
                $y += 6;
                // Datos de la liquidación
                $det= "DIAS LABORADOS PRIMER SEMESTRE ".$yeartoday.":";
                $pdf->Text($x,$y,$det);

                $longitud = strlen($diasps);
                if($longitud==1)        $pdf->Text($x+132,$y,$diasps);
                if($longitud==2)        $pdf->Text($x+130,$y,$diasps);
                if($longitud==3)        $pdf->Text($x+128,$y,$diasps);
            }

            // Impresión de los días laborados en el segundo semestre del año en curso
            if((($cesantiasact=="CHECKED")||($intcesact=="CHECKED")||($vacaciones=="CHECKED")||($primasss=="CHECKED"))&&($diasss>0))
            {
                $y += 6;
                $det= "DIAS LABORADOS SEGUNDO SEMESTRE ".$yeartoday.": ";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen($diasss);
                if($longitud==1)        $pdf->Text($x+132,$y,$diasss);
                if($longitud==2)        $pdf->Text($x+130,$y,$diasss);
                if($longitud==3)        $pdf->Text($x+128,$y,$diasss);
            }

            // Impresión del salario, auxilio de transporte y total devengado en año anterior
            if((($cesantiasant=="CHECKED")||($intcesant=="CHECKED")||($vacaciones=="CHECKED"))&&($diasyearant>0))
            {
                $y += 6;
                $det= "SALARIO ".$yearprev.":";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($basicoant));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($basicoant));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($basicoant));
    
                $y += 6;
                $det= "AUXILIO DE TRANSPORTE ".$yearprev.":";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($auxtransant));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($auxtransant));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($auxtransant));
    
                $y += 6;
                $det= "TOTAL DEVENGADO ".$yearprev.":";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($sueldointegralant));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($sueldointegralant));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($sueldointegralant));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($sueldointegralant));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($sueldointegralant));
            }

            // Impresión del salario, auxilio de transporte y total devengado en año actual
            $y += 6;
            $det= "SALARIO ".$yeartoday.":";
            $pdf->Text($x,$y,$det);
            
            $longitud = strlen(number_format($basico));
            if($longitud==6)        $pdf->Text($x+125,$y,number_format($basico));
            if($longitud==7)        $pdf->Text($x+123,$y,number_format($basico));
            if($longitud==8)        $pdf->Text($x+121,$y,number_format($basico));
            if($longitud==9)        $pdf->Text($x+120,$y,number_format($basico));

            $y += 6;
            $det= "AUXILIO DE TRANSPORTE ".$yeartoday.":";
            $pdf->Text($x,$y,$det);

            $longitud = strlen(number_format($auxtrans));
            if($longitud==6)        $pdf->Text($x+125,$y,number_format($auxtrans));
            if($longitud==7)        $pdf->Text($x+123,$y,number_format($auxtrans));

            $y += 6;
            $det= "TOTAL DEVENGADO ".$yeartoday.":";
            $pdf->Text($x,$y,$det);

            $longitud = strlen(number_format($sueldointegralact));
            if($longitud==6)        $pdf->Text($x+125,$y,number_format($sueldointegralact));
            if($longitud==7)        $pdf->Text($x+123,$y,number_format($sueldointegralact));
            if($longitud==8)        $pdf->Text($x+121,$y,number_format($sueldointegralact));
            if($longitud==9)        $pdf->Text($x+120,$y,number_format($sueldointegralact));

            // Cesantías año anterior
            if(($cesantiasant=="CHECKED") && ($pagocesant>0))
            {
                $y += 6;
                $det= "CESANTIAS CAUSADAS ".$yearprev.":";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($pagocesant,2));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($pagocesant,2));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($pagocesant,2));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($pagocesant,2));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($pagocesant,2));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($pagocesant,2));
            }

            // Cesantías año actual
            if(($cesantiasact=="CHECKED") && ($pagocenact>0))
            {
                $y += 6;
                $det= "CESANTIAS CAUSADAS ".$yeartoday.":";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($pagocenact,2));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($pagocenact,2));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($pagocenact,2));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($pagocenact,2));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($pagocenact,2));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($pagocenact,2));
            }
            
            // Intereses de cesantías año anterior
            if(($intcesant=="CHECKED") && ($interesesant>0))
            {
                $y += 6;
                $det= "INTERESES DE CESANTIAS CAUSADAS ".$yearprev.":";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($interesesant,2));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($interesesant,2));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($interesesant,2));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($interesesant,2));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($interesesant,2));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($interesesant,2));
            }

            // Intereses de cesantías año actual
            if(($intcesact=="CHECKED") && ($interesesact>0))
            {
                $y += 6;
                $det= "INTERESES DE CESANTIAS CAUSADAS ".$yeartoday.":";
                $pdf->Text($x,$y,$det);

                $longitud = strlen(number_format($interesesact,2));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($interesesact,2));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($interesesact,2));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($interesesact,2));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($interesesact,2));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($interesesact,2));
            }

            // Primas primer semestre
            if(($primasps=="CHECKED") && ($pagoprimasps>0))
            {
                $y += 6;
                $det= "PRIMA DE SERVICIO PRIMER SEMESTRE:";
                $pdf->Text($x,$y,$det);

                $longitud = strlen(number_format($pagoprimasps,2));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($pagoprimasps,2));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($pagoprimasps,2));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($pagoprimasps,2));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($pagoprimasps,2));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($pagoprimasps,2));
            }
            
            // Primas segundo semestre
            if(($pagoprimasss=="CHECKED") && ($pagoprimasss>0))
            {
                $y += 6;
                $det= "PRIMA DE SERVICIO SEGUNDO SEMESTRE:";
                $pdf->Text($x,$y,$det);

                $longitud = strlen(number_format($pagoprimasss,2));
                if($longitud==3)        $pdf->Text($x+130,$y,number_format($pagoprimasss,2));
                if($longitud==4)        $pdf->Text($x+129,$y,number_format($pagoprimasss,2));
                if($longitud==5)        $pdf->Text($x+127,$y,number_format($pagoprimasss,2));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($pagoprimasss,2));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($pagoprimasss,2));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($pagoprimasss,2));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($pagoprimasss,2));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($pagoprimasss,2));
            }

            // Vacaciones
            if(($vacaciones=="CHECKED") && ($pagovacaciones>0))
            {
                $y += 6;
                $det= "VACACIONES: ";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($pagovacaciones,2));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($pagovacaciones,2));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($pagovacaciones,2));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($pagovacaciones,2));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($pagovacaciones,2));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($pagovacaciones,2));
            }

            // Indemnización
            if($indemnizacion>0)
            {
                $y += 6;
                $det= "INDEMNIZACION: ";
                $pdf->Text($x,$y,$det);
                
                $longitud = strlen(number_format($indemnizacion));
                if($longitud==0)        $pdf->Text($x+132,$y,0);
                if($longitud==1)        $pdf->Text($x+132,$y,number_format($indemnizacion));
                if($longitud==2)        $pdf->Text($x+131,$y,number_format($indemnizacion));
                if($longitud==3)        $pdf->Text($x+131,$y,number_format($indemnizacion));
                if($longitud==4)        $pdf->Text($x+129,$y,number_format($indemnizacion));
                if($longitud==5)        $pdf->Text($x+127,$y,number_format($indemnizacion));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($indemnizacion));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($indemnizacion));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($indemnizacion));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($indemnizacion));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($indemnizacion));
            }

            // Salario de la última quincena laborada
            $y += 6;
            $det= "SALARIO: ";
            $pdf->Text($x,$y,$det);

            $longitud = strlen(number_format($salariotrab));
            if($longitud==6)        $pdf->Text($x+125,$y,number_format($salariotrab));
            if($longitud==7)        $pdf->Text($x+123,$y,number_format($salariotrab));
            if($longitud==8)        $pdf->Text($x+121,$y,number_format($salariotrab));
            if($longitud==9)        $pdf->Text($x+120,$y,number_format($salariotrab));
            if($longitud==10)       $pdf->Text($x+119,$y,number_format($salariotrab));

            // Auxilio de transporte de la última quincena laborada
            if($transporte>0)
            {
                $y += 6;
                $det= "AUX. TRANSPORTE: ";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($transporte));
                if($longitud==3)        $pdf->Text($x+129,$y,number_format($transporte));
                if($longitud==4)        $pdf->Text($x+128,$y,number_format($transporte));
                if($longitud==5)        $pdf->Text($x+127,$y,number_format($transporte));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($transporte));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($transporte));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($transporte));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($transporte));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($transporte));
            }
            
            // Pensión de la última quincena laborada
            $y += 6;
            $det= "APORTES PARA PENSION (4%):";
            $pdf->Text($x,$y,$det);

            $longitud = strlen(number_format($pension));
            if($longitud==3)        $pdf->Text($x+146,$y,number_format($pension));
            if($longitud==4)        $pdf->Text($x+144,$y,number_format($pension));
            if($longitud==5)        $pdf->Text($x+142,$y,number_format($pension));
            if($longitud==6)        $pdf->Text($x+140,$y,number_format($pension));
            if($longitud==7)        $pdf->Text($x+138,$y,number_format($pension));
            if($longitud==8)        $pdf->Text($x+137,$y,number_format($pension));
            if($longitud==9)        $pdf->Text($x+136,$y,number_format($pension));
            if($longitud==10)       $pdf->Text($x+135,$y,number_format($pension));

            // Salud de la última quincena laborada
            $y += 6;
            $det= "APORTES PARA SALUD (4%):";
            $pdf->Text($x,$y,$det);

            $longitud = strlen(number_format($salud));
            if($longitud==3)        $pdf->Text($x+146,$y,number_format($salud));
            if($longitud==4)        $pdf->Text($x+144,$y,number_format($salud));
            if($longitud==5)        $pdf->Text($x+142,$y,number_format($salud));
            if($longitud==6)        $pdf->Text($x+140,$y,number_format($salud));
            if($longitud==7)        $pdf->Text($x+138,$y,number_format($salud));
            if($longitud==8)        $pdf->Text($x+137,$y,number_format($salud));
            if($longitud==9)        $pdf->Text($x+136,$y,number_format($salud));
            if($longitud==10)       $pdf->Text($x+135,$y,number_format($salud));

            // Otras deducciones de la última quincena laborada
            if($otrasdeduc>0)
            {
                $y += 6;
                $det= "OTRAS DEDUCCIONES:";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($otrasdeduc));
                if($longitud==1)        $pdf->Text($x+150,$y,number_format($otrasdeduc));
                if($longitud==2)        $pdf->Text($x+148,$y,number_format($otrasdeduc));
                if($longitud==3)        $pdf->Text($x+146,$y,number_format($otrasdeduc));
                if($longitud==4)        $pdf->Text($x+144,$y,number_format($otrasdeduc));
                if($longitud==5)        $pdf->Text($x+142,$y,number_format($otrasdeduc));
                if($longitud==6)        $pdf->Text($x+140,$y,number_format($otrasdeduc));
                if($longitud==7)        $pdf->Text($x+138,$y,number_format($otrasdeduc));
                if($longitud==8)        $pdf->Text($x+137,$y,number_format($otrasdeduc));
                if($longitud==9)        $pdf->Text($x+136,$y,number_format($otrasdeduc));
                if($longitud==10)       $pdf->Text($x+135,$y,number_format($otrasdeduc));
            }

            // Totales
            $asignaciones = $salariotrab + $transporte + $pagovacaciones + $pagocesant + $pagocenact + $pagoprimasps + $pagoprimasss + $interesesant + $interesesact + $indemnizacion;
            $deducciones = $pension + $salud + $otrasdeduc;
            $neto = $asignaciones - $deducciones;

            $y += 6;
            $pdf->SetFont('Arial','B',10);
            $det= "NETO A PAGAR:";
            $pdf->Text($x,$y,$det);

            $longitud = strlen(number_format($neto,2));
            if($longitud==4)        $pdf->Text($x+173,$y,number_format($neto,2));
            if($longitud==5)        $pdf->Text($x+172,$y,number_format($neto,2));
            if($longitud==6)        $pdf->Text($x+171,$y,number_format($neto,2));
            if($longitud==7)        $pdf->Text($x+170,$y,number_format($neto,2));
            if($longitud==8)        $pdf->Text($x+169,$y,number_format($neto,2));
            if($longitud==9)        $pdf->Text($x+168,$y,number_format($neto,2));
            if($longitud==10)       $pdf->Text($x+167,$y,number_format($neto,2));
            if($longitud==11)       $pdf->Text($x+166,$y,number_format($neto,2));
            if($longitud==12)       $pdf->Text($x+165,$y,number_format($neto,2));
        }
        else
        {
            // Impresión digitada
            $vsqldatos = "";                    $pagovacaciones = 0;                $pagoprimas = 0;                    $pagocesantias = 0;
            $pagointereses = 0;                 $basico = 0;                        $auxtrans = 0;                      $sueldointegralact = 0;
            $auxtrans = 0;                      $salariotrab = 0;                   $pension = 0;                       $salud = 0;
            $otrasdeduc = 0;                    $transporte = 0;                    $indemnizacion = 0;

            // Vacaciones
            $vsqldatos = "SELECT IFNULL(pago,0) AS pagovacaciones
                            FROM liquidacion 
                           WHERE terid = ".$terid." 
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'vacaciones'";
            $pagovacaciones = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Primas
            $vsqldatos = "SELECT IFNULL(pago,0) AS pagoprimas
                            FROM liquidacion 
                           WHERE terid = ".$terid." 
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'primas'";
            $pagoprimas = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Pago de cesantías
            $vsqldatos = "SELECT IFNULL(pago,0) AS pagocesantias
                            FROM liquidacion 
                           WHERE terid = ".$terid." 
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'cesantias'";
            $pagocesantias = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Intereses de cesantías
            $vsqldatos = "SELECT IFNULL(pagointereses,0) AS pagointereses
                            FROM liquidacion 
                           WHERE terid = ".$terid." 
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'cesantias'";
            $pagointereses = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // sueldo básico
            $basico = $clase->BDLockup($terid,'terceros','terid','basico');

            $auxtrans = $_SESSION['N_AUXTRANS2020'];                                            // auxilio de transporte
            $sueldointegralact = $basico + $auxtrans;                                           // sueldo integral año actual

            // Salario de la última quincena
            $vsqldatos = "SELECT IFNULL(devengados,0) AS salariotrab 
                            FROM detalleliquidacion 
                           WHERE terid = ".$terid." 
                                 AND conceptoid = 1
                                 AND pernominaid = ".$periodoid."";
            $salariotrab = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // pensión de la última quincena
            $vsqldatos = "SELECT IFNULL(descuentos,0) AS pension 
                            FROM detalleliquidacion 
                           WHERE terid = ".$terid." 
                                 AND conceptoid = 4
                                 AND pernominaid = ".$periodoid."";
            $pension = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // salud
            $vsqldatos = "SELECT IFNULL(descuentos,0) AS salud 
                            FROM detalleliquidacion 
                           WHERE terid = ".$terid." 
                                 AND conceptoid = 5
                                 AND pernominaid = ".$periodoid."";
            $salud = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // otras deducciones
            $vsqldatos = "SELECT IFNULL(SUM(descuentos),0) AS otrasdeduc 
                            FROM detalleliquidacion 
                           WHERE terid = ".$terid."                              
                                 AND pernominaid = ".$periodoid."
                                 AND conceptoid NOT IN (4,5)";
            $otrasdeduc = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Auxilio de transporte última quincena
            $vsqldatos = "SELECT IFNULL(devengados,0) AS transporte 
                            FROM detalleliquidacion 
                           WHERE terid = ".$terid." 
                                 AND conceptoid = 3
                                 AND pernominaid = ".$periodoid."";
            $transporte = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Indemnización:
            $vsqldatos = "SELECT IFNULL(pago,0) AS indemnizacion
                            FROM liquidacion 
                           WHERE terid = ".$terid." 
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'indemnizacion'";
            $indemnizacion = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // encabezado
            $y = 55;
            $pdf->SetFont('Arial','B',10);
            $det= "CONCEPTO";
            $pdf->Text($x,$y,$det);
            $det= "MONTO";
            $pdf->Text($x+122,$y,$det);

            // Línea para la impresión del detalle de la liquidación            
            $y = 61;
            $pdf->SetFont('Arial','',10);

            // Impresión de salario básico
            $det= "SALARIO BASICO:";
            $pdf->Text($x,$y,$det);
            
            $longitud = strlen(number_format($basico));
            if($longitud==6)        $pdf->Text($x+125,$y,number_format($basico));
            if($longitud==7)        $pdf->Text($x+123,$y,number_format($basico));
            if($longitud==8)        $pdf->Text($x+121,$y,number_format($basico));
            if($longitud==9)        $pdf->Text($x+120,$y,number_format($basico));

            // Impresión del sueldo trabajado en la última quincena trabajada
            if($salariotrab>0)
            {
                $y += 6;
                $det= "SALARIO TRABAJADO: ";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($salariotrab));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($salariotrab));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($salariotrab));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($salariotrab));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($salariotrab));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($salariotrab));
            }

            // Impresión del auxilio de transporte en la última quincena trabajada
            if($transporte>0)
            {
                $y += 6;
                $det= "AUX. TRANSPORTE: ";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($transporte));
                if($longitud==3)        $pdf->Text($x+129,$y,number_format($transporte));
                if($longitud==4)        $pdf->Text($x+128,$y,number_format($transporte));
                if($longitud==5)        $pdf->Text($x+127,$y,number_format($transporte));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($transporte));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($transporte));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($transporte));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($transporte));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($transporte));
            }

            // Impresión de la pensión en la última quincena trabajada
            if($pension>0)
            {
                $y += 6;
                $det= "APORTES PARA PENSION (4%):";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($pension));
                if($longitud==3)        $pdf->Text($x+146,$y,number_format($pension));
                if($longitud==4)        $pdf->Text($x+144,$y,number_format($pension));
                if($longitud==5)        $pdf->Text($x+142,$y,number_format($pension));
                if($longitud==6)        $pdf->Text($x+140,$y,number_format($pension));
                if($longitud==7)        $pdf->Text($x+138,$y,number_format($pension));
                if($longitud==8)        $pdf->Text($x+137,$y,number_format($pension));
                if($longitud==9)        $pdf->Text($x+136,$y,number_format($pension));
                if($longitud==10)       $pdf->Text($x+135,$y,number_format($pension));
            }

            // Impresión de la salud en la última quincena trabajada
            if($salud>0)
            {
                $y += 6;
                $det= "APORTES PARA SALUD (4%):";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($salud));
                if($longitud==3)        $pdf->Text($x+146,$y,number_format($salud));
                if($longitud==4)        $pdf->Text($x+144,$y,number_format($salud));
                if($longitud==5)        $pdf->Text($x+142,$y,number_format($salud));
                if($longitud==6)        $pdf->Text($x+140,$y,number_format($salud));
                if($longitud==7)        $pdf->Text($x+138,$y,number_format($salud));
                if($longitud==8)        $pdf->Text($x+137,$y,number_format($salud));
                if($longitud==9)        $pdf->Text($x+136,$y,number_format($salud));
                if($longitud==10)       $pdf->Text($x+135,$y,number_format($salud));
            }

            // Impresión de otras deducciones
            if($otrasdeduc>0)
            {
                $y += 6;
                $det= "OTRAS DEDUCCIONES:";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($otrasdeduc));
                if($longitud==1)        $pdf->Text($x+150,$y,number_format($otrasdeduc));
                if($longitud==2)        $pdf->Text($x+148,$y,number_format($otrasdeduc));
                if($longitud==3)        $pdf->Text($x+146,$y,number_format($otrasdeduc));
                if($longitud==4)        $pdf->Text($x+144,$y,number_format($otrasdeduc));
                if($longitud==5)        $pdf->Text($x+142,$y,number_format($otrasdeduc));
                if($longitud==6)        $pdf->Text($x+140,$y,number_format($otrasdeduc));
                if($longitud==7)        $pdf->Text($x+138,$y,number_format($otrasdeduc));
                if($longitud==8)        $pdf->Text($x+137,$y,number_format($otrasdeduc));
                if($longitud==9)        $pdf->Text($x+136,$y,number_format($otrasdeduc));
                if($longitud==10)       $pdf->Text($x+135,$y,number_format($otrasdeduc));
            }

            // Impresión del pago de vacaciones
            if($pagovacaciones>0)
            {
                $y += 6;
                $det= "VACACIONES: ";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($pagovacaciones,2));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($pagovacaciones,2));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($pagovacaciones,2));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($pagovacaciones,2));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($pagovacaciones,2));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($pagovacaciones,2));
            }

            // Impresión del pago de primas de servicio
            if($pagoprimas>0)
            {
                $y += 6;
                $det= "PRIMA DE SERVICIO:";
                $pdf->Text($x,$y,$det);

                $longitud = strlen(number_format($pagoprimas,2));
                if($longitud==3)        $pdf->Text($x+130,$y,number_format($pagoprimas,2));
                if($longitud==4)        $pdf->Text($x+129,$y,number_format($pagoprimas,2));
                if($longitud==5)        $pdf->Text($x+127,$y,number_format($pagoprimas,2));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($pagoprimas,2));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($pagoprimas,2));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($pagoprimas,2));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($pagoprimas,2));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($pagoprimas,2));
            }

            // Impresión del pago de cesantías
            if($pagocesantias>0)
            {
                $y += 6;
                $det= "CESANTIAS CAUSADAS:";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($pagocesantias,2));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($pagocesantias,2));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($pagocesantias,2));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($pagocesantias,2));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($pagocesantias,2));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($pagocesantias,2));
            }

            // Impresión del pago de intereses de cesantías
            if($pagointereses>0)
            {
                $y += 6;
                $det= "INTERESES DE CESANTIAS CAUSADAS:";
                $pdf->Text($x,$y,$det);
    
                $longitud = strlen(number_format($pagointereses,2));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($pagointereses,2));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($pagointereses,2));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($pagointereses,2));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($pagointereses,2));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($pagointereses,2));
            }

            // Impresión del pago de indemnización
            if($indemnizacion>0)
            {
                $y += 6;
                $det= "INDEMNIZACION: ";
                $pdf->Text($x,$y,$det);
                
                $longitud = strlen(number_format($indemnizacion));
                if($longitud==0)        $pdf->Text($x+132,$y,0);
                if($longitud==1)        $pdf->Text($x+132,$y,number_format($indemnizacion));
                if($longitud==2)        $pdf->Text($x+131,$y,number_format($indemnizacion));
                if($longitud==3)        $pdf->Text($x+131,$y,number_format($indemnizacion));
                if($longitud==4)        $pdf->Text($x+129,$y,number_format($indemnizacion));
                if($longitud==5)        $pdf->Text($x+127,$y,number_format($indemnizacion));
                if($longitud==6)        $pdf->Text($x+125,$y,number_format($indemnizacion));
                if($longitud==7)        $pdf->Text($x+123,$y,number_format($indemnizacion));
                if($longitud==8)        $pdf->Text($x+121,$y,number_format($indemnizacion));
                if($longitud==9)        $pdf->Text($x+120,$y,number_format($indemnizacion));
                if($longitud==10)       $pdf->Text($x+119,$y,number_format($indemnizacion));
            }

            // Totales
            $asignaciones = $salariotrab + $transporte + $pagovacaciones + $pagoprimas + $pagocesantias + $pagointereses + $indemnizacion;
            $deducciones = $pension + $salud + $otrasdeduc;
            $neto = $asignaciones - $deducciones;

            $y += 6;
            $pdf->SetFont('Arial','B',10);
            $det= "NETO A PAGAR:";
            $pdf->Text($x,$y,$det);

            $longitud = strlen(number_format($neto,2));
            if($longitud==1)            $pdf->Text($x+173,$y,number_format($neto,2));
            if($longitud==2)            $pdf->Text($x+172,$y,number_format($neto,2));
            if($longitud==3)            $pdf->Text($x+171,$y,number_format($neto,2));
            if($longitud==4)            $pdf->Text($x+170,$y,number_format($neto,2));
            if($longitud==5)            $pdf->Text($x+169,$y,number_format($neto,2));
            if($longitud==6)            $pdf->Text($x+168,$y,number_format($neto,2));
            if($longitud==7)            $pdf->Text($x+167,$y,number_format($neto,2));
            if($longitud==8)            $pdf->Text($x+166,$y,number_format($neto,2));
            if($longitud==9)            $pdf->Text($x+165,$y,number_format($neto,2));
            if($longitud==10)           $pdf->Text($x+164,$y,number_format($neto,2));
            if($longitud==11)           $pdf->Text($x+163,$y,number_format($neto,2));
            if($longitud==12)           $pdf->Text($x+162,$y,number_format($neto,2));
        }

        $y = 236;
        $pdf->SetFont('Arial','',8);
        $mensaje2 = "LUGAR Y FECHA DE LIQUIDACION: SAN JOSE DE CUCUTA, ".date('d')." ".strtoupper($mesimp)." DE ".date('Y');
        $pdf->Text($x,$y,$mensaje2);
        $y += 6;
        $mensaje3 = "SALARIOS DEVENGADOS. CON LA ANTERIOR LIQUIDACION DROMEDICAS DEL ORIENTE S.A.S NO ME ADEUDA SUMA ALGUNA POR";
        $pdf->Text($x,$y,$mensaje3);
        $y += 6;
        $mensaje4 = "LOS CONCEPTOS DE PRESTACIONES SOCIALES, LEGALES Y EXTRALEGALES, SUELDOS, PRIMAS, PREAVISOS ETC. DECLARO POR";
        $pdf->Text($x,$y,$mensaje4);
        $y += 6;
        $mensaje5 = "LO TANTO DROMEDICAS DEL ORIENTE S.A.S. ESTA A PAZ Y SALVO POR TODO CONCEPTO DE REMUNERACION DERIVADO DE MI";
        $pdf->Text($x,$y,$mensaje5);
        $y += 6;
        $mensaje6 = "CONTRATO DE TRABAJO EL CUAL QUEDA CANCELADO COMPLETAMENTE. ME RETIRO EN PERFECTO ESTADO DE SALUD.";
        $pdf->Text($x,$y,$mensaje6);

        $y += 18;
        $mensaje7 = "EL EMPLEADO:____________________________";
        $pdf->Text($x,$y,$mensaje7);
        $mensaje8 = "EL EMPLEADOR:____________________________";
        $pdf->Text($x+120,$y,$mensaje8);

        $y += 6;
        $mensaje9 = "CC:";
        $pdf->Text($x,$y,$mensaje9);
        $mensaje10 = "NIT: 900265730-0";
        $pdf->Text($x+120,$y,$mensaje10);

        $pdf->Output();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrarliquidacion
    // Creación: 12/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que devuelve el enfoque con el filtro para la tabla liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarliquidacion")
    {
        $codperiodo = $_POST['codperiodo'];
        $tipo  = $_POST['tipo'];	        
        header("Location: calculoliquidados.php?opcion=duplicados&codperiodo=$codperiodo&tipo=$tipo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: duplicados
    // Creación: 08/07/2022		última modificación: 25/04/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se administraran los registros     
    //              duplicados de la tabla liquidacion
    //              Inclusión de la opción para marcar todos los registros (18/07/2022)
    //              A la consulta se le quitó el filtro de pago mayor a cero para poder 
    //              procesar tanto pagos como intereses de cesantías (06/02/2023)
    //              Barra de separación de empleados
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "duplicados")
    {
	    // Control de Permisos
	    if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            $codperiodo = $_GET['codperiodo'];
            $tipo = $_GET['tipo'];
    
            // año actual
            $yeartoday = date("Y");            
            $yearprev = $yeartoday - 1;
    
            // Combo de Periodos
            $vsqlcombo = "SELECT * FROM periodos WHERE anoperiodo = ".$yeartoday." OR codperiodo = '12$yearprev' ORDER BY orden DESC";
            $params    = ' class="Texto11" style="width:140px;height:25px" OnChange="x.submit();"';
    
            // Pintamos la ventana
            $cont = $clase->Header("S","W");
            $cont.='<form action="?opcion=filtrarliquidacion" method="POST" name="x">
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                      <td width="800"> <b>Registros duplicados </b> <font color="blue"> <br>en la tabla liquidacion </font> </td>
                      <td width="10"> &nbsp; </td>
                      <td width="280"> periodo: '.$clase->CrearComboEsp("codperiodo",$vsqlcombo,"codperiodo","nomperiodo",$codperiodo,"N",$params).' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="200"> 
                       <label class="Texto12"> tipo:</label>
                       <SELECT name="tipo" id="tipo" style="width:120px;height:25px" OnChange="x.submit();">';
    
            if(($tipo=="")||($tipo=="vacaciones"))
                $cont.=' <option value="vacaciones" selected> Vacaciones </option> 
                         <option value="cesantias"> Cesant&iacute;as </option>
                         <option value="primas"> Primas </option>
                         <option value="indemnizacion"> Indemnizaci&oacute;n </option>';
    
            if($tipo=="cesantias")
                $cont.=' <option value="vacaciones"> Vacaciones </option> 
                         <option value="cesantias" selected> Cesant&iacute;as </option>
                         <option value="primas"> Primas </option>
                         <option value="indemnizacion"> Indemnizaci&oacute;n </option>';
    
            if($tipo=="primas")
                $cont.=' <option value="vacaciones"> Vacaciones </option> 
                         <option value="cesantias"> Cesant&iacute;as </option>
                         <option value="primas" selected> Primas </option>
                         <option value="indemnizacion"> Indemnizaci&oacute;n </option>';
    
            if($tipo=="indemnizacion")
                $cont.=' <option value="vacaciones"> Vacaciones </option> 
                         <option value="cesantias"> Cesant&iacute;as </option>
                         <option value="primas"> Primas </option>
                         <option value="indemnizacion" selected> Indemnizaci&oacute;n </option>';
    
            $cont.='   </SELECT>
                       </form>
                      </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';
    
            $cont.= permisosespeciales(1);
    
            $cont.='<script language="javascript">
                    <!--
                        function seleccionar_todo()
                        { 
                            valor = document.f2.todos.checked;
                            if(valor)
                                marcartodo();
                            else
                                desmarcartodo();
                        } 
    
                        function marcartodo()
                        {
                            for (i=0;i<document.f2.elements.length;i++) 
                             if(document.f2.elements[i].type == "checkbox")  
                               document.f2.elements[i].checked = 1;
                        }
    
                        function desmarcartodo()
                        {
                            for (i=0;i<document.f2.elements.length;i++) 
                             if(document.f2.elements[i].type == "checkbox") 
                              document.f2.elements[i].checked = 0;
                        }
                    -->
                    </script>
                    
                    <script type="text/javascript" src="lib/sorttable.js"></script> 
                    <form action="calculoliquidados.php?opcion=eliminarliquidacion" method="POST" name="f2">
                    <table width="100%" class="sortable">
                     <thead>
                      <tr class="TituloTabla" style="display:block; padding-top:5px;height:23px;"> 
                       <th width="10"> &nbsp; </th>
                       <th width="110" align="left">idliquidacion</th>
                       <th width="130" align="left">periodonomina</th>							 
                       <th width="80" align="left"> terid </th>			
                       <th width="270" align="left"> nombre </th>			
                       <th width="105" align="left"> tipo </th>
                       <th width="85" align="left"> pago </th>				 
                       <th width="80" align="left"> cantidad </th>
                       <th width="90" align="left"> porcentaje </th>
                       <th width="120" align="left"> pagointereses </th>
                       <th width="45" align="left"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo();"> </th>	
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';
    
            // Consulta de los registros duplicados
            $vsql = "SELECT l.*,
                            (SELECT COUNT(*) 
                               FROM liquidacion 
                              WHERE liquidacion.terid = l.terid 
                                    AND liquidacion.periodonomina = '".$codperiodo."' 
                                    AND liquidacion.tipo = '".$tipo."') AS numreg, 
                            CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                            t.dni        
                       FROM liquidacion l
                            INNER JOIN terceros t ON (l.terid = t.terid)
                      WHERE l.periodonomina = '".$codperiodo."' 
                            AND l.tipo = '".$tipo."'
                     HAVING numreg > 1
                   ORDER BY l.terid";
    
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;

                // Barra de separación de empleados
                if($i == 1)
                    $teridant = $row['terid'];
                else
                {
                    if($row['terid'] != $teridant)
                        $cont.='<tr class="TituloTabla" style="display:block; padding-top:5px; height:5px;"> </tr>';
                    
                    $teridant = $row['terid'];
                }

                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
    
                $cont.=' <td width="10"> &nbsp; </td>
                         <td width="115" align="left">'.$row['idliquidacion'].'</td>
                         <td width="130" align="left">'.$row['periodonomina'].'</td>				  
                         <td width="80" align="left">'.$row['terid'].'</td>
                         <td width="255" align="left">
                          <b> '.substr($row['nombreemp'],0,30).' </b>
                          <br> c&eacute;dula: <span> <font color="#CC66FF"> '.$row['dni'].' </font> </span>
                         </td>
                         <td width="105" align="left">'.$row['tipo'].'</td>
                         <td width="85" align="left"> '.number_format($row['pago'],2).'</td>				  
                         <td width="80" align="left"> '.number_format($row['cantidad'],0).' </td>	
                         <td width="100" align="left"> '.number_format($row['porcentaje'],0).' </td>	
                         <td width="120" align="left"> '.number_format($row['pagointereses'],0).' </td>
                         <td width="30" align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['idliquidacion'].'" value="S"> </td>
                        </tr>';
            }
            
            $cont.=' </tbody>
                    </table>
                    <table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="261"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="222"> &nbsp; </td>
                     </tr>
                    </table>                    
                    <br>
                    <center>
                    <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar"></a>
                    </form>                    
                    <a href="calculoliquidados.php?opcion=ventanaactdatos"><input type="button" value="ATRAS" class="button red"></a>                    
                    <a href="calculoliquidados.php?opcion=duplicatercerosactual"><input type="button" value="SIGUIENTE" class="button blue"></a>';
    
            mysql_free_result($result);
            mysql_close($conex);
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido"); 
            header("Location: calculoliquidados.php?opcion=ventanaliquidados"); 
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarliquidacion
    // Creación: 12/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina masivamente los registros de la tabla liquidación 
    //              previamente seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarliquidacion")
    {
        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT idliquidacion FROM liquidacion";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result)) 
        {
            if($_POST['LIN-'.$row['idliquidacion']] == "S")
            {
                $lista.= $row['idliquidacion'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // Elimino los registros
        $vsql2 = "DELETE FROM liquidacion WHERE idliquidacion IN (".$lista.")";
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli registros eliminados exitosamente");
        else
            $clase->Aviso(3,"No se eliminaron los registros");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=duplicados");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrardetalleliq
    // Creación: 13/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que devuelve el enfoque con el filtro para la tabla 
    //              detalleliquidacion
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "filtrardetalleliq")
    {
        $periodoid = $_POST['periodoid'];
        $conceptoid  = $_POST['conceptoid'];	        
        header("Location: calculoliquidados.php?opcion=detalleliq&periodoid=$periodoid&conceptoid=$conceptoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: detalleliq
    // Creación: 13/07/2022		última modificación: 28/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se administraran los registros     
    //              duplicados de la tabla detalleliquidacion
    //              Inclusión de la opción para marcar todos los registros (18/07/2022)
    //              Inclusión de las dos últimas quincenas del año anterior
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "detalleliq")
    {
        $periodoid = $_GET['periodoid'];
        $conceptoid = $_GET['conceptoid'];

        // año actual
        $yeartoday = date("Y");        
        $yearprev = $yeartoday - 1;

        $vsqld = "SELECT MAX(periodoid) FROM periodosnomina WHERE YEAR(fecdesde) = ".$yearprev."";
        $priquiant = $clase->SeleccionarUno($vsqld);

        $segquinat = $priquiant - 1;

        $params    = ' class="Texto11" style="height:25px" OnChange="x.submit();"';        

        // Combo de Periodos
        $vsqlcomboperiodo = "SELECT periodoid, descripcion FROM periodosnomina WHERE YEAR(fecdesde) = ".$yeartoday." OR periodoid IN ($priquiant,$segquinat) ORDER BY periodoid DESC";

        // combo de conceptos
        $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto FROM conceptosnomina ORDER BY conceptoid";

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<form action="?opcion=filtrardetalleliq" method="POST" name="x">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                  <td width="300"> <b>Registros duplicados </b> <font color="blue"> <br>en la tabla detalleliquidacion </font> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="400"> periodo: '.$clase->CrearComboEsp("periodoid",$vsqlcomboperiodo,"periodoid","descripcion",$periodoid,"N",$params).' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="400"> concepto: '.$clase->CrearComboEsp("conceptoid",$vsqlcomboconcepto,"conceptoid","nomconcepto",$conceptoid,"N",$params).' </td>
                  </form>                  
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.= permisosespeciales(2);

        $cont.='<script language="javascript">
                <!--
                    function seleccionar_todo()
                    { 
                        valor = document.f2.todos.checked;
                        if(valor)
                            marcartodo();
                        else
                            desmarcartodo();
                    } 

                    function marcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox")  
                          document.f2.elements[i].checked = 1;
                    }

                    function desmarcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                          if(document.f2.elements[i].type == "checkbox") 
                            document.f2.elements[i].checked = 0;
                    }  
                -->
                </script>
        
                <script type="text/javascript" src="lib/sorttable.js"></script> 
                <form action="calculoliquidados.php?opcion=eliminardetalleliq" method="POST" name="f2">
                <table width="100%" class="sortable">
                 <thead>
                  <tr class="TituloTabla" style="display:block; padding-top:5px;height:25px;"> 
                   <th width="10"> &nbsp; </th>
                   <th width="80" align="left">detalleid</th>
                   <th width="90" align="left"> terid </th>			
                   <th width="270" align="left"> nombre </th>
                   <th width="95" align="left"> conceptoid</th>							 
                   <th width="110" align="left"> pernominaid </th>
                   <th width="115" align="left"> devengados </th>				 
                   <th width="110" align="left"> descuentos </th>
                   <th width="90" align="left"> valor </th>
                   <th width="120" align="left"> saldo </th>
                   <th width="45" align="left"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo();"> </th>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';

        // Consulta de los registros duplicados
        $vsql = "SELECT d.*,
                        (SELECT COUNT(*) 
                           FROM detalleliquidacion 
                          WHERE detalleliquidacion.terid = d.terid 
                                AND detalleliquidacion.pernominaid = ".$periodoid."
                                AND detalleliquidacion.conceptoid = ".$conceptoid.") AS numreg, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        t.dni
                   FROM detalleliquidacion d
                        INNER JOIN terceros t ON (d.terid = t.terid) 
                  WHERE d.pernominaid = ".$periodoid." 
                        AND d.conceptoid = ".$conceptoid."
                 HAVING numreg > 1
               ORDER BY d.terid, d.conceptoid ";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
                
            $cont.=' <td width="10"> &nbsp; </td>
                     <td width="80" align="left">'.$row['detalleid'].'</td>
                     <td width="85" align="left">'.$row['terid'].'</td>
                     <td width="260" align="left">
                      <b> '.substr($row['nombreemp'],0,30).' </b>
                      <br> c&eacute;dula: <span> <font color="#CC66FF"> '.$row['dni'].' </font> </span>
                     </td>
                     <td width="100" align="left">'.$row['conceptoid'].'</td>			
                     <td width="120" align="left">'.$row['pernominaid'].'</td>
                     <td width="115" align="left"> '.number_format($row['devengados'],0).'</td>				  
                     <td width="110" align="left"> '.number_format($row['descuentos'],0).' </td>
                     <td width="90" align="left"> '.number_format($row['valor'],0).' </td>	
                     <td width="110" align="left"> '.number_format($row['saldo'],0).' </td>
                     <td width="30" align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['detalleid'].'" value="S"> </td>
                    </tr>';
        }

        $cont.=' </tbody>
                </table>
                <table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>                
                <br>
                <center>
                <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar"></a>
                </form>
                <a href="calculoliquidados.php?opcion=ventanaactdatos" ><input type="button" value="ATRAS" class="button red"></a>
                <a href="calculoliquidados.php?opcion=duplicatercerosactual"><input type="button" value="SIGUIENTE" class="button blue"></a>';
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminardetalleliq
    // Creación: 14/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina masivamente los registros de la tabla  
    //              detalleliquidacion previamente seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "eliminardetalleliq")
    {
        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT detalleid FROM detalleliquidacion";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result)) 
        {
            if($_POST['LIN-'.$row['detalleid']] == "S")
            {
                $lista.= $row['detalleid'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // Elimino los registros
        $vsql2 = "DELETE FROM detalleliquidacion WHERE detalleid IN (".$lista.")";
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli registros eliminados exitosamente");
        else
            $clase->Aviso(3,"No se eliminaron los registros");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=duplicados");        
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrardetallenom
    // Creación: 14/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que devuelve el enfoque con el filtro para la tabla 
    //              detallenomina
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "filtrardetallenom")
    {
        $periodoid = $_POST['periodoid'];
        $conceptoid  = $_POST['conceptoid'];	        
        header("Location: calculoliquidados.php?opcion=detallenom&periodoid=$periodoid&conceptoid=$conceptoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: detallenom
    // Creación: 14/07/2022		última modificación: 28/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se administraran los registros     
    //              duplicados de la tabla detallenomina
    //              Inclusión de la opción para marcar todos los registros (18/07/2022)
    //              Inclusión de las dos últimas quincenas del año anterior
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "detallenom")
    {
        $periodoid = $_GET['periodoid'];
        $conceptoid = $_GET['conceptoid'];

        // año actual
        $yeartoday = date("Y");        
        $yearprev = $yeartoday - 1;

        $vsqld = "SELECT MAX(periodoid) FROM periodosnomina WHERE YEAR(fecdesde) = ".$yearprev."";
        $priquiant = $clase->SeleccionarUno($vsqld);

        $segquinat = $priquiant - 1;        

        $params    = ' class="Texto11" style="height:25px" OnChange="x.submit();"';

        // Combo de Periodos
        $vsqlcomboperiodo = "SELECT periodoid, descripcion FROM periodosnomina WHERE YEAR(fecdesde) = ".$yeartoday." OR periodoid IN ($priquiant,$segquinat) ORDER BY periodoid DESC";

        // combo de conceptos
        $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto FROM conceptosnomina ORDER BY conceptoid";

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<form action="?opcion=filtrardetallenom" method="POST" name="x">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                  <td width="300"> <b>Registros duplicados </b> <font color="blue"> <br>en la tabla detallenomina </font> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="400"> periodo: '.$clase->CrearComboEsp("periodoid",$vsqlcomboperiodo,"periodoid","descripcion",$periodoid,"N",$params).' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="400"> concepto: '.$clase->CrearComboEsp("conceptoid",$vsqlcomboconcepto,"conceptoid","nomconcepto",$conceptoid,"N",$params).' </td>
                  </form>                  
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.= permisosespeciales(3);

        $cont.='<script language="javascript">
                <!--
                    function seleccionar_todo()
                    { 
                        valor = document.f2.todos.checked;
                        if(valor)
                            marcartodo();
                        else
                            desmarcartodo();
                    } 

                    function marcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox")  
                          document.f2.elements[i].checked = 1;
                    }

                    function desmarcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox") 
                          document.f2.elements[i].checked = 0;
                    }  
                -->
                </script>
        
                <script type="text/javascript" src="lib/sorttable.js"></script> 
                <form action="calculoliquidados.php?opcion=eliminardetallenom" method="POST" name="f2">
                <table width="100%" class="sortable">
                 <thead>
                  <tr class="TituloTabla" style="display:block; padding-top:5px;height:25px;"> 
                   <th width="10"> &nbsp; </th>
                   <th width="80" align="left">detalleid</th>
                   <th width="90" align="left"> terid </th>			
                   <th width="270" align="left"> nombre </th>
                   <th width="95" align="left"> conceptoid</th>							 
                   <th width="110" align="left"> pernominaid </th>
                   <th width="115" align="left"> devengados </th>				 
                   <th width="110" align="left"> descuentos </th>
                   <th width="90" align="left"> valor </th>
                   <th width="120" align="left"> saldo </th>
                   <th width="45" align="left"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo();"> </th>			 				 
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';

        // Consulta de los registros duplicados
        $vsql = "SELECT d.*,
                        (SELECT COUNT(*) 
                           FROM detallenomina 
                          WHERE detallenomina.terid = d.terid 
                                AND detallenomina.pernominaid = ".$periodoid."
                                AND detallenomina.conceptoid = ".$conceptoid.") AS numreg, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                        t.dni  
                   FROM detallenomina d
                        INNER JOIN terceros t ON (d.terid = t.terid) 
                  WHERE d.pernominaid = ".$periodoid." 
                        AND d.conceptoid = ".$conceptoid."
                 HAVING numreg > 1
               ORDER BY d.terid, d.conceptoid ";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="10"> &nbsp; </td>
                     <td width="80" align="left">'.$row['detalleid'].'</td>
                     <td width="85" align="left"> '.$row['terid'].' </td>
                     <td width="260" align="left">
                      <b> '.substr($row['nombreemp'],0,30).' </b>
                      <br> c&eacute;dula: <span> <font color="#CC66FF"> '.$row['dni'].' </font> </span>
                     </td>
                     <td width="100" align="left">'.$row['conceptoid'].'</td>			
                     <td width="120" align="left">'.$row['pernominaid'].'</td>
                     <td width="115" align="left"> '.number_format($row['devengados'],0).'</td>				  
                     <td width="110" align="left"> '.number_format($row['descuentos'],0).' </td>
                     <td width="90" align="left"> '.number_format($row['valor'],0).' </td>	
                     <td width="110" align="left"> '.number_format($row['saldo'],0).' </td>
                     <td width="30" align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['detalleid'].'" value="S"> </td>
                    </tr>';
        }

        $cont.=' </tbody>
                </table>
                <table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>
                <br>
                <center>
                <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar"></a>
                </form>
                <a href="calculoliquidados.php?opcion=ventanaactdatos" ><input type="button" value="ATRAS" class="button red"></a>
                <a href="calculoliquidados.php?opcion=duplicatercerosactual"><input type="button" value="SIGUIENTE" class="button blue"></a>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminardetallenom
    // Creación: 14/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina masivamente los registros de la tabla  
    //              detallenomina previamente seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "eliminardetallenom")
    {
        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT detalleid FROM detallenomina";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result)) 
        {
            if($_POST['LIN-'.$row['detalleid']] == "S")
            {
                $lista.= $row['detalleid'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // Elimino los registros
        $vsql2 = "DELETE FROM detallenomina WHERE detalleid IN (".$lista.")";
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli registros eliminados exitosamente");
        else
            $clase->Aviso(3,"No se eliminaron los registros");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=duplicados");
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrarhisdetnom
    // Creación: 13/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que devuelve el enfoque con el filtro para la tabla 
    //              hisdetallenomina
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "filtrarhisdetnom")
    {
        $periodoid = $_POST['periodoid'];
        $conceptoid  = $_POST['conceptoid'];	        
        header("Location: calculoliquidados.php?opcion=hisdetnom&periodoid=$periodoid&conceptoid=$conceptoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: hisdetnom
    // Creación: 14/07/2022		última modificación: 28/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se administraran los registros     
    //              duplicados de la tabla hisdetallenomina
    //              Inclusión de la opción para marcar todos los registros (18/07/2022)
    //              Inclusión de las dos últimas quincenas del año anterior
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "hisdetnom")
    {
        $periodoid = $_GET['periodoid'];
        $conceptoid = $_GET['conceptoid'];

        // año actual
        $yeartoday = date("Y");
        $yearprev = $yeartoday - 1;

        $vsqld = "SELECT MAX(periodoid) FROM periodosnomina WHERE YEAR(fecdesde) = ".$yearprev."";
        $priquiant = $clase->SeleccionarUno($vsqld);

        $segquinat = $priquiant - 1;        

        $params    = ' class="Texto11" style="height:25px" OnChange="x.submit();"';

        // Combo de Periodos
        $vsqlcomboperiodo = "SELECT periodoid, descripcion FROM periodosnomina WHERE YEAR(fecdesde) = ".$yeartoday." OR periodoid IN ($priquiant,$segquinat) ORDER BY periodoid DESC";

        // combo de conceptos
        $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto FROM conceptosnomina ORDER BY conceptoid";

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<form action="?opcion=filtrarhisdetnom" method="POST" name="x">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                  <td width="300"> <b>Registros duplicados </b> <font color="blue"> <br>en la tabla hisdetallenomina </font> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="400"> periodo: '.$clase->CrearComboEsp("periodoid",$vsqlcomboperiodo,"periodoid","descripcion",$periodoid,"N",$params).' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="400"> concepto: '.$clase->CrearComboEsp("conceptoid",$vsqlcomboconcepto,"conceptoid","nomconcepto",$conceptoid,"N",$params).' </td>
                  </form>                  
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.= permisosespeciales(4);

        $cont.='<script language="javascript">
                <!--
                    function seleccionar_todo()
                    { 
                        valor = document.f2.todos.checked;
                        if(valor)
                            marcartodo();
                        else
                            desmarcartodo();
                    } 

                    function marcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox")  
                          document.f2.elements[i].checked = 1;
                    }

                    function desmarcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox") 
                          document.f2.elements[i].checked = 0;
                    }  
                -->
                </script>
        
                <script type="text/javascript" src="lib/sorttable.js"></script> 
                <form action="calculoliquidados.php?opcion=eliminarhisdetnom" method="POST" name="f2">
                <table width="100%" class="sortable">
                 <thead>
                  <tr class="TituloTabla" style="display:block; padding-top:5px;height:25px;"> 
                   <th width="10"> &nbsp; </th>
                   <th width="80" align="left">detalleid</th>
                   <th width="90" align="left"> terid </th>			
                   <th width="270" align="left"> nombre </th>
                   <th width="95" align="left"> conceptoid</th>							 
                   <th width="110" align="left"> pernominaid </th>
                   <th width="115" align="left"> devengados </th>				 
                   <th width="110" align="left"> descuentos </th>
                   <th width="90" align="left"> valor </th>
                   <th width="120" align="left"> saldo </th>
                   <th width="45" align="left"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo();"> </th>			 				 
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';

        // Consulta de los registros duplicados
        $vsql = "SELECT d.*,
                        (SELECT COUNT(*) 
                           FROM hisdetallenomina 
                          WHERE hisdetallenomina.terid = d.terid 
                                AND hisdetallenomina.pernominaid = ".$periodoid."
                                AND hisdetallenomina.conceptoid = ".$conceptoid.") AS numreg, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                        t.dni
                   FROM hisdetallenomina d
                        INNER JOIN terceros t ON (d.terid = t.terid) 
                  WHERE d.pernominaid = ".$periodoid." 
                        AND d.conceptoid = ".$conceptoid."
                 HAVING numreg > 1
               ORDER BY d.terid, d.conceptoid ";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
                
            $cont.=' <td width="10"> &nbsp; </td>
                     <td width="80" align="left">'.$row['detalleid'].'</td>
                     <td width="85" align="left">'.$row['terid'].'</td>
                     <td width="260" align="left">
                      <b> '.substr($row['nombreemp'],0,30).' </b>
                      <br> c&eacute;dula: <span> <font color="#CC66FF"> '.$row['dni'].' </font> </span>
                     </td>
                     <td width="100" align="left">'.$row['conceptoid'].'</td>			
                     <td width="120" align="left">'.$row['pernominaid'].'</td>
                     <td width="115" align="left"> '.number_format($row['devengados'],0).' </td>				  
                     <td width="110" align="left"> '.number_format($row['descuentos'],0).' </td>
                     <td width="90" align="left"> '.number_format($row['valor'],0).' </td>	
                     <td width="110" align="left"> '.number_format($row['saldo'],0).' </td>
                     <td width="30" align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['detalleid'].'" value="S"> </td>
                    </tr>';
        }

        $cont.=' </tbody>
                </table>
                <table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>                
                <br>
                <center>
                <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar"></a>
                </form>
                <a href="calculoliquidados.php?opcion=ventanaactdatos" ><input type="button" value="ATRAS" class="button red"></a>
                <a href="calculoliquidados.php?opcion=duplicatercerosactual"><input type="button" value="SIGUIENTE" class="button blue"></a>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarhisdetnom
    // Creación: 14/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina masivamente los registros de la tabla  
    //              hisdetallenomina previamente seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "eliminarhisdetnom")
    {
        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT detalleid FROM hisdetallenomina";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            if($_POST['LIN-'.$row['detalleid']] == "S")
            {
                $lista.= $row['detalleid'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // Elimino los registros
        $vsql2 = "DELETE FROM hisdetallenomina WHERE detalleid IN (".$lista.")";
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli registros eliminados exitosamente");
        else
            $clase->Aviso(3,"No se eliminaron los registros");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=duplicados");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrarpagces
    // Creación: 14/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que devuelve el enfoque con el filtro para la tabla pagocesantias
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarpagces")
    {
        $codperiodo = $_POST['codperiodo'];
        header("Location: calculoliquidados.php?opcion=pagocesan&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: pagocesan
    // Creación: 14/07/2022		última modificación: 18/07/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se administraran los registros     
    //              duplicados de la tabla pagocesantias
    //              Inclusión de la opción para marcar todos los registros
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "pagocesan")
    {
        $codperiodo = $_GET['codperiodo'];

        // año actual
        $yeartoday = date("Y");

        // Combo de Periodos
        $vsqlcombo = "SELECT * FROM periodos WHERE anoperiodo = ".$yeartoday." ORDER BY orden DESC";
        $params    = ' class="Texto11" style="height:25px" OnChange="x.submit();"';

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<form action="?opcion=filtrarpagces" method="POST" name="x">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                  <td width="400"> <b>Registros duplicados </b> <font color="blue"> <br>en la tabla pagocesantias </font>  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="280"> periodo: '.$clase->CrearComboEsp("codperiodo",$vsqlcombo,"codperiodo","nomperiodo",$codperiodo,"N",$params).' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="600"> &nbsp; </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </form>
                </table>';

        $cont.= permisosespeciales(5);

        $cont.='<script language="javascript">
                <!--
                    function seleccionar_todo()
                    { 
                        valor = document.f2.todos.checked;
                        if(valor)
                            marcartodo();
                        else
                            desmarcartodo();
                    } 

                    function marcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox")  
                          document.f2.elements[i].checked = 1;
                    }

                    function desmarcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox") 
                          document.f2.elements[i].checked = 0;
                    }  
                -->
                </script>
        
                <script type="text/javascript" src="lib/sorttable.js"></script> 
                <form action="calculoliquidados.php?opcion=eliminarpagces" method="POST" name="f2">
                <table width="100%" class="sortable">
                 <thead>
                  <tr class="TituloTabla" style="display:block; padding-top:5px;height:23px;"> 
                   <th width="10"> &nbsp; </th>
                   <th width="120" align="left"> idpagocesantia</th>
                   <th width="130" align="left"> periodonomina</th>							 
                   <th width="90" align="left"> terid </th>			
                   <th width="270" align="left"> nombre </th>			
                   <th width="105" align="left"> dias </th>
                   <th width="125" align="left"> monto </th>				                    
                   <th width="310" align="left"> &nbsp; </th>
                   <th width="45" align="left"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo();"> </th>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';

        // Consulta de los registros duplicados
        $vsql = "SELECT p.*,
                        (SELECT COUNT(*) 
                           FROM pagocesantias 
                          WHERE pagocesantias.terid = p.terid 
                                AND pagocesantias.periodonomina = '".$codperiodo."') AS numreg, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                        t.dni         
                   FROM pagocesantias p
                        INNER JOIN terceros t ON (p.terid = t.terid)
                  WHERE p.periodonomina = '".$codperiodo."'
                 HAVING numreg > 1
               ORDER BY p.terid";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="10"> &nbsp; </td>
                     <td width="130" align="left">'.$row['idpagocesantia'].'</td>
                     <td width="135" align="left">'.$row['periodonomina'].'</td>
                     <td width="80" align="left">'.$row['terid'].'</td>
                     <td width="245" align="left"> 
                      <b> '.substr($row['nombreemp'],0,30).' </b>
                      <br> c&eacute;dula: <span> <font color="#CC66FF"> '.$row['dni'].' </font> </span>
                     </td>
                     <td width="95" align="left">'.$row['dias'].'</td>
                     <td width="85" align="left"> '.number_format($row['monto'],2).'</td>				  
                     <td width="300" align="left"> &nbsp; </td>	
                     <td width="30" align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['idpagocesantia'].'" value="S"> </td>
                    </tr>';
        }
        
        $cont.=' </tbody>
                </table>
                <table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>                
                <br>
                <center>
                <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar"></a>
                </form>
                <a href="calculoliquidados.php?opcion=ventanaactdatos" ><input type="button" value="ATRAS" class="button red"></a>
                <a href="calculoliquidados.php?opcion=duplicatercerosactual"><input type="button" value="SIGUIENTE" class="button blue"></a>';

        mysql_free_result($result);
        mysql_close($conex);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarpagces
    // Creación: 14/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina masivamente los registros de la tabla pagocesantias 
    //              previamente seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarpagces")
    {        
        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT idpagocesantia FROM pagocesantias";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            if($_POST['LIN-'.$row['idpagocesantia']] == "S")
            {
                $lista.= $row['idpagocesantia'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // Elimino los registros
        $vsql2 = "DELETE FROM pagocesantias WHERE idpagocesantia IN (".$lista.")";
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli registros eliminados exitosamente");
        else
            $clase->Aviso(3,"No se eliminaron los registros");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=duplicados");
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrardota
    // Creación: 14/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que devuelve el enfoque con el filtro para la tabla pagocesantias
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrardota")
    {
        $codperiodo = $_POST['codperiodo'];
        header("Location: calculoliquidados.php?opcion=dotaciones&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: dotaciones
    // Creación: 14/07/2022		última modificación: 18/07/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se administraran los registros     
    //              duplicados de la tabla dotaciones
    //              Inclusión de la opción para marcar todos los registros
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "dotaciones")
    {
        $codperiodo = $_GET['codperiodo'];

        // año actual
        $yeartoday = date("Y");

        // Combo de Periodos
        $vsqlcombo = "SELECT * FROM periodos WHERE anoperiodo = ".$yeartoday." ORDER BY orden DESC";
        $params    = ' class="Texto11" style="height:25px" OnChange="x.submit();"';

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<form action="?opcion=filtrardota" method="POST" name="x">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                  <td width="400"> <b>Registros duplicados </b> <font color="blue"> <br>en la tabla dotaciones </font> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="280"> periodo: '.$clase->CrearComboEsp("codperiodo",$vsqlcombo,"codperiodo","nomperiodo",$codperiodo,"N",$params).' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="600"> &nbsp; </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </form>
                </table>';

        $cont.= permisosespeciales(6);

        $cont.='<script language="javascript">
                <!--
                    function seleccionar_todo()
                    { 
                        valor = document.f2.todos.checked;
                        if(valor)
                            marcartodo();
                        else
                            desmarcartodo();
                    } 

                    function marcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox")  
                          document.f2.elements[i].checked = 1;
                    }

                    function desmarcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox") 
                          document.f2.elements[i].checked = 0;
                    }  
                -->
                </script>
        
                <script type="text/javascript" src="lib/sorttable.js"></script> 
                <form action="calculoliquidados.php?opcion=eliminardota" method="POST" name="f2">
                <table width="100%" class="sortable">
                 <thead>
                  <tr class="TituloTabla" style="display:block; padding-top:5px;height:23px;"> 
                   <th width="10"> &nbsp; </th>
                   <th width="120" align="left"> iddotacion</th>
                   <th width="130" align="left"> periodonomina</th>							 
                   <th width="90" align="left"> terid </th>			
                   <th width="270" align="left"> nombre </th>			
                   <th width="125" align="left"> monto </th>                   
                   <th width="415" align="left"> &nbsp; </th>
                   <th width="45" align="left"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo();"> </th>				 				 
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';

        // Consulta de los registros duplicados
        $vsql = "SELECT p.*,
                        (SELECT COUNT(*) 
                           FROM dotaciones 
                          WHERE dotaciones.terid = p.terid 
                                AND dotaciones.periodonomina = '".$codperiodo."') AS numreg, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        t.dni         
                   FROM dotaciones p
                        INNER JOIN terceros t ON (p.terid = t.terid)
                  WHERE p.periodonomina = '".$codperiodo."'
                 HAVING numreg > 1
               ORDER BY p.terid";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="10"> &nbsp; </td>
                     <td width="120" align="left">'.$row['iddotacion'].'</td>
                     <td width="135" align="left">'.$row['periodonomina'].'</td>
                     <td width="85" align="left">'.$row['terid'].'</td>
                     <td width="250" align="left"> 
                      <b> '.substr($row['nombreemp'],0,30).' </b>
                      <br> c&eacute;dula: <span> <font color="#CC66FF"> '.$row['dni'].' </font> </span>
                     </td>
                     <td width="85" align="left"> '.number_format($row['monto'],2).'</td>				                       
                     <td width="395" align="left"> &nbsp; </td>	
                     <td width="30" align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['iddotacion'].'" value="S"> </td>
                    </tr>';
        }
        
        $cont.=' </tbody>
                </table>
                <table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>                
                <br>
                <center>
                <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar"></a>
                </form>
                <a href="calculoliquidados.php?opcion=ventanaactdatos" ><input type="button" value="ATRAS" class="button red"></a>
                <a href="calculoliquidados.php?opcion=duplicatercerosactual"><input type="button" value="SIGUIENTE" class="button blue"></a>';

        mysql_free_result($result);
        mysql_close($conex);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminardota
    // Creación: 14/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina masivamente los registros de la tabla pagocesantias 
    //              previamente seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminardota")
    {        
        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT iddotacion FROM dotaciones";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            if($_POST['LIN-'.$row['iddotacion']] == "S")
            {
                $lista.= $row['iddotacion'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // Elimino los registros
        $vsql2 = "DELETE FROM dotaciones WHERE iddotacion IN (".$lista.")";
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli registros eliminados exitosamente");
        else
            $clase->Aviso(3,"No se eliminaron los registros");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=duplicados");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrarnoliquida
    // Creación: 21/07/2022		última modificación: 
    // Creador: Luis Flórez		    modificado por: 
    // Descripción: Opción que devuelve el enfoque con el filtro para la tabla noliquida
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarnoliquida")
    {
        $codperiodo = $_POST['codperiodo'];
        $tipo  = $_POST['tipo'];
        header("Location: calculoliquidados.php?opcion=noliquida&codperiodo=$codperiodo&tipo=$tipo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: noliquida
    // Creación: 21/07/2022		última modificación: 19/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para actualizar la información de la tabla noliquida
    // Última modificación: Inclusión de la opción nómina electrónica en el combo de tipo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "noliquida")
    {
        $codperiodo = $_GET['codperiodo'];
        $tipo = $_GET['tipo'];

        // año actual
        $yeartoday = date("Y");

        // Combo de Periodos
        $vsqlcombo = "SELECT * FROM periodos WHERE anoperiodo = ".$yeartoday." OR (anoperiodo = ".$yeartoday." - 1 AND mesperiodo = 12) ORDER BY orden DESC";
        $params    = ' class="Texto11" style="width:140px;height:25px" OnChange="x.submit();"';

        // Combo de Periodos
        $vsqlcomboperiodo = "SELECT periodoid, descripcion FROM periodosnomina WHERE YEAR(fecdesde) = ".$yeartoday." ORDER BY periodoid DESC";

        // combo de conceptos
        $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto FROM conceptosnomina ORDER BY conceptoid";

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<form action="?opcion=filtrarnoliquida" method="POST" name="x">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                  <td width="300"> <b> Registros duplicados </b> <font color="blue"> <br> Control de registros tabla noliquida </font> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="280"> periodo: '.$clase->CrearComboEsp("codperiodo",$vsqlcombo,"codperiodo","nomperiodo",$codperiodo,"N",$params).' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="200"> 
                   <label class="Texto12"> tipo:</label>
                   <select name="tipo" id="tipo" style="width:140px;height:25px" OnChange="x.submit();">';

        if(($tipo=="")||($tipo=="vacaciones"))
            $cont.=' <option value="vacaciones" selected> vacaciones </option> 
                     <option value="cesantias"> cesant&iacute;as </option>
                     <option value="primas"> primas </option>
                     <option value="indemnizacion"> indemnizaci&oacute;n </option>
                     <option value="nominaelec"> n&oacute;mina electr&oacute;nica </option>';

        if($tipo=="cesantias")
            $cont.=' <option value="vacaciones"> vacaciones </option> 
                     <option value="cesantias" selected> cesant&iacute;as </option>
                     <option value="primas"> primas </option>
                     <option value="indemnizacion"> indemnizaci&oacute;n </option>
                     <option value="nominaelec"> n&oacute;mina electr&oacute;nica </option>';

        if($tipo=="primas")
            $cont.=' <option value="vacaciones"> vacaciones </option> 
                     <option value="cesantias"> cesant&iacute;as </option>
                     <option value="primas" selected> primas </option>
                     <option value="indemnizacion"> indemnizaci&oacute;n </option>
                     <option value="nominaelec"> n&oacute;mina electr&oacute;nica </option>';

        if($tipo=="indemnizacion")
            $cont.=' <option value="vacaciones"> vacaciones </option> 
                     <option value="cesantias"> cesant&iacute;as </option>
                     <option value="primas"> primas </option>
                     <option value="indemnizacion" selected> indemnizaci&oacute;n </option>
                     <option value="nominaelec"> n&oacute;mina electr&oacute;nica </option>';

        if($tipo=="nominaelec")
            $cont.=' <option value="vacaciones"> vacaciones </option> 
                    <option value="cesantias"> cesant&iacute;as </option>
                    <option value="primas"> primas </option>
                    <option value="indemnizacion"> indemnizaci&oacute;n </option>
                    <option value="nominaelec" selected> n&oacute;mina electr&oacute;nica </option>';

        $cont.='   </select>
                   </form>
                  </td>
                  <td width="27">
                   <a href="?opcion=nuevonoliquida" rel="facebox"> 
                    <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="incluir un nuevo registro"> 
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.= permisosespeciales(7);

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead>
                  <tr class="TituloTabla" style="display:block; padding-top:5px;height:23px;"> 
                   <th width="10"> &nbsp; </th>
                   <th width="90" align="left"> idnoliquida </th>
                   <th width="120" align="left"> periodonomina </th>
                   <th width="80" align="left"> terid </th>	
                   <th width="95" align="left"> cedula</th>	
                   <th width="270" align="left"> nombre </th>
                   <th width="105" align="left"> tipo </th>	
                   <th width="110" align="left"> &nbsp; </th>
                   <th width="90" align="left"> &nbsp; </th>
                   <th width="120" align="left"> &nbsp; </th>
                   <th width="45" align="left"> &nbsp; </th>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';

        // Consulta de los registros 
        $vsql = "SELECT n.*, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        t.dni AS cedula
                   FROM noliquida n
                        INNER JOIN terceros t ON (n.terid = t.terid)
                  WHERE n.periodonomina = '".$codperiodo."'
                        AND n.tipo = '".$tipo."'";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
                
            $cont.=' <td width="10"> &nbsp; </td>
                     <td width="100" align="left">'.$row['idnoliquida'].'</td>
                     <td width="120" align="left">'.$row['periodonomina'].'</td>
                     <td width="80" align="left">'.$row['terid'].'</td>
                     <td width="95" align="left">'.$row['cedula'].'</td>
                     <td width="280" align="left">'.substr($row['nombreemp'],0,30).'</td>
                     <td width="105" align="left"> '.$row['tipo'].'</td>				  
                     <td width="110" align="left"> &nbsp; </td>
                     <td width="90" align="left"> &nbsp; </td>	
                     <td width="110" align="left"> &nbsp; </td>
                     <td width="30" align="center"> 
                      <a href="?opcion=confirmarelinoliquida&idnoliquida='.$row['idnoliquida'].'" rel="facebox" title="eliminar este registro">
                       <img src="images/basicas/iconoborrar.png" border="0">
                      </a>
                     </td>
                    </tr>';
        }

        $cont.=' </tbody>
                </table>
                <table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>
                <center>
                <br>
                <a href="calculoliquidados.php?opcion=ventanaactdatos" ><input type="button" value="ATRAS" class="button red"></a>
                <a href="calculoliquidados.php?opcion=duplicatercerosactual"><input type="button" value="SIGUIENTE" class="button blue"></a>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nuevonoliquida
    // Creación: 21/07/2022		última modificación: 19/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción con la ventana donde se captan los datos para los registros que 
    //              se incluirán como no liquidados
    // Última modificación: Inclusión de la opción nómina electrónica en el combo de tipo    
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nuevonoliquida")
    {
        $params = ' class="Texto10" ';
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";

        // año actual
        $yeartoday = date("Y");            
        $yearprev = $yeartoday - 1;

        // Combo de Periodos
        $vsqlcomboperiodo = "SELECT * FROM periodos WHERE anoperiodo = ".$yeartoday." OR codperiodo = '12$yearprev' ORDER BY orden DESC";
        $comboperiodos = $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombreemp","terid","","N",$params,470);

        // Pintamos la ventana
        $cont.='<table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Incluir registro en la tabla noliquida</b> <br><br> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardarnewnoliquida" name="y" method="POST">
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"> <label class="Texto12"> Empleado:&nbsp;&nbsp; </label> <br> '.$comboperiodos.' <br><br> </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left">                  
                   <label class="Texto12"> Periodo:&nbsp;&nbsp; </label> <br> 
                   '.$clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"descripcion","codperiodo","","N",$params,350).'
                   <br><br>
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left">                  
                   <label class="Texto12">Tipo:&nbsp;&nbsp;</label><br>
                    <select name="tipo" id="tipo" style="width:120px;height:25px"">
                     <option value="vacaciones" selected> vacaciones </option> 
                     <option value="cesantias"> cesant&iacute;as </option>
                     <option value="primas"> primas </option>
                     <option value="indemnizacion"> indemnizaci&oacute;n </option>
                     <option value="nominaelec"> n&oacute;mina electr&oacute;nica </option> 
                    </select>
                  </td>
                 </tr>
                </table> 
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarnewnoliquida
    // Creación: 22/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que guarda un nuevo registro en la tabla noliquida
    // Última modificación:     
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarnewnoliquida")
    {
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $tipo = $_POST['tipo'];

        // Construyo la instrucción para la inclusión del registro
        $vsql = "INSERT INTO noliquida (periodonomina, terid, tipo) VALUE ('".$codperiodo."',".$terid.",'".$tipo."')";

        // Almaceno la información
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Registro incluido satisfactoriamente");
        else
            $clase->Aviso(3,"No se incluyó el registro");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=noliquida");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarelinoliquida
    // Creación: 22/07/2022		última modificación: 19/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la venta para la confirmación de la eliminación de un 
    //              no liquidado
    // Última modificación: Botón de cancelar 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "confirmarelinoliquida")
    {
        $idnoliquida = $_GET['idnoliquida'];
        $terid = $clase->BDLockup($idnoliquida,'noliquida','idnoliquida','terid');
        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        
        $periodonomina = $clase->BDLockup($idnoliquida,'noliquida','idnoliquida','periodonomina');
        $tipo = $clase->BDLockup($idnoliquida,'noliquida','idnoliquida','tipo');
        $codperiodo = $periodonomina;
        
        // pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <br> <label class="Texto12"> <b> Eliminar un no liquidado </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center">
                   <label class="Texto12"> ¿Confirma que desea eliminar el no liquidado <br><b>'.$nombreemp.'</b> <br> del periodo <b>'.$periodonomina.'</b> tipo <b> '.$tipo.' </b>? </label>
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>                  
                   <form action="?opcion=elimarnoliquida&idnoliquida='.$idnoliquida.'" method="POST">
                   <input type="hidden" name="idnoliquida" value="'.$idnoliquida.'">
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="calculoliquidados.php?opcion=noliquida&codperiodo='.$codperiodo.'&tipo='.$tipo.'"> <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: elimarnoliquida
    // Creación: 22/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un registro de la tabla noliquida
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "elimarnoliquida")
    {
        $idnoliquida = $_POST['idnoliquida'];

        $vsql = "DELETE FROM noliquida WHERE idnoliquida = ".$idnoliquida;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Registro eliminado satisfactoriamente");
        else
            $clase->Aviso(3,"No se eliminó el registro");

        // Redirecciona el formulario
        header("Location: calculoliquidados.php?opcion=noliquida");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: liquidaconceptos
    // Creación: 28/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que capta los datos para eliminar los conceptos de liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "liquidaconceptos")
    {
	    // Control de Permisos
	    if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            // año actual
            $yeartoday = date("Y");
    
            // Combo de Periodos
            $vsqlcombo = "SELECT * FROM periodos WHERE anoperiodo = ".$yeartoday." ORDER BY orden DESC";
            $params    = ' class="Texto12" style="width:200px;height:25px;"';
    
            // Pintamos la ventana
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/eliminardoc.png" width="32" height="32" border="0"> </td>
                      <td width="840"> <b> Eliminar todos los registros de un concepto <br> en la tabla liquidacion </b> </td>
                      <td width="24"> 
                       <a href="calculoliquidados.php?opcion=ventanaactdatos">
                        <input type="button" value="<<" class="button blue">
                       </a> 
                      </td>
                      <td width="10"> &nbsp; </td>
                     </tr>
                    </table>';
    
            $cont.='<form action="?opcion=confirmaeliconpliq" method="POST" name="x">                
                    <table width="100%">
                     <tr class="BarraDocumentos" style="height:50px;Important!">
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <td width="840"> periodo: '.$clase->CrearComboEsp("codperiodo",$vsqlcombo,"codperiodo","nomperiodo",$codperiodo,"N",$params).' </td>
                      <td width="10"> &nbsp; </td>
                     </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!">
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <td width="840"> 
                       <label class="Texto12"> tipo:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</label>
                       <select name="tipo" id="tipo" style="width:120px;height:25px">
                        <option value="vacaciones" SELECTED> Vacaciones </option> 
                        <option value="cesantias"> Cesant&iacute;as </option>
                        <option value="primas"> Primas </option>
                        <option value="indemnizacion"> Indemnizaci&oacute;n </option>
                       </select>
                      </td>
                      <td width="10"> &nbsp; </td>
                     </tr>
                    </table>                    
                    <!--
                    <br>
                    <center>
                    <a href="#" OnClick="x.submit();"><input type="button" class="button blue" value="eliminar"></a>
                    </form>
                    -->
                    <table width="100%">
                     <tr class="BarraDocumentos" style="height:50px;Important!">
                      <td align="center">                    
                       <input type="submit" value="eliminar" class="button blue">
                       </form>
                      </td>
                     </tr>
                    </table>';

            // Pie de página
            $cont.='<table width="100%"> 
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                    </table>';
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido"); 
            header("Location: calculoliquidados.php?opcion=ventanaliquidados"); 
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmaeliconpliq
    // Creación: 28/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que confirma la eliminación de los registros de liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmaeliconpliq")
    {
        $codperiodo = $_POST['codperiodo'];
        $tipo = $_POST['tipo'];

        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        $vsqldatos = "SELECT COUNT(*)
                        FROM liquidacion
                       WHERE periodonomina = '".$codperiodo."' 
                             AND tipo = '".$tipo."'";
        $numregelim = $clase->SeleccionarUno($vsqldatos);

        // Validación del concepto
        if($numregelim==0)
        {
            $clase->Aviso(3,"No existen $tipo en el periodo $desperiodo");
            header("Location: calculoliquidados.php?opcion=liquidaconceptos");
        }
        else
        {
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br> <b> Eliminaci&oacute;n de registros de liquidaci&oacute;n </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="100%">
                     <tr class="TablaDocsPar">       
                      <td width="400" align="center"> <label class="Texto12"> ¿Confirma que desea eliminar <b>'.$numregelim.'</b>  registros </b> </label> <br> </td>
                     </tr>
                     <tr class="TablaDocsPar">                        
                      <td width="400" align="center"> <label class="Texto12"> del periodo <b>'.$desperiodo.' </label> </b> <br> </td>                        
                     </tr>
                     <tr class="TablaDocsPar">                        
                      <td width="400" align="center"> <label class="Texto12"> de tipo <b>'.$tipo.'</b>? </label> </td>
                     </tr>
                     <tr class="TablaDocsPar">       
                      <td width="400" align="center"><br><br>
                       <form action="?opcion=eliminaconpliquida" method="POST">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="tipo" value="'.$tipo.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                       <a href="calculoliquidados.php?opcion=liquidaconceptos" > <input type="button" value="CANCELAR" class="button blue"> </a>
                       </form>
                       <br>
                      </td>        
                     </tr>
                    </table>';

            // Pie de página
            $cont.='<table width="100%"> 
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                    </table>';
            echo $cont.$clase->PiePagina();
            exit();
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminaconpliquida
    // Creación: 28/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que realiza la eliminación física de los registros de liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminaconpliquida")
    {
        $tipo = $_POST['tipo'];
        $codperiodo = $_POST['codperiodo'];

        // Elimino los registros de la tabla liquidación
        $vsql = "DELETE FROM liquidacion WHERE periodonomina='".$codperiodo."' AND tipo = '".$tipo."'";
        $clase->EjecutarSQL($vsql);

        $regafectados = mysql_affected_rows();

        if($regafectados == 0)
            $clase->Aviso(3,"No se eliminaron los registros");
        else
            $clase->Aviso(1,"$regafectados registros eliminados satisfactoriamente");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=liquidaconceptos");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcelcedulas
    // Creación: 30/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para captar la hoja de Excel desde donde se actualizarán los 
    //              empleados activos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcelcedulas")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b> </td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder ejecutar este proceso </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=ventanaliquidados" id="theform" enctype="multipart/form-data">
                       <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" /> 
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el periodo actual
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);
    
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b> Activar empleados masivamente <br> en el periodo <br> <font color="BLUE"> '.strtolower($descripcion).' </font> </b> </td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=importacionexcelesempleado" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>                       
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocedulas.png" width="240" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx </font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importacionexcelesempleado
    // Creación: 30/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que actualiza masivamente a los empleados activos desde una hoja 
    //              de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
	if($opcion == "importacionexcelesempleado")
	{
		set_time_limit(0);
		extract($_POST);
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                
                    if(strlen($_DATOS_EXCEL[$i]['dni']) == 0)
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;
            $esempleadoactivo = "CHECKED";

            for($j=1; $j < $i; $j++)
            {
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");
                
                if($terid != "")
                {
                    $vsql4 = "UPDATE terceros SET esempleadoactivo = '".$esempleadoactivo."' WHERE terid = ".$terid;
                    $clase->EjecutarSQL($vsql4);

                    if(mysql_affected_rows() >= 1)
                        $grabados++;
                }
            }
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se activaron los empleados");
            else
                $clase->Aviso(1,"Se activaron $grabados empleados");            
    
            // Redirecciona el formulario
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarextraleal
    // Creación: 30/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para la hoja de Excel desde donde se marcarán como extralegales 
    //              a los empleados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "importarextraleal")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder ejecutar este proceso </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="calculoliquidados.php?opcion=ventanaliquidados" id="theform" enctype="multipart/form-data">
                       <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
            else
            {
                // Obtengo el periodo actual
                $vsql = "SELECT periodoid
                           FROM periodosnomina 
                          WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
                $periodoid = $clase->SeleccionarUno($vsql);
        
                $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
      
                // pinto la ventana
                $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                        <script>
                         $(function()
                         {
                          $("#enviarr").on("click",function()
                          {
                            $(this).val("Espere por favor ...")
                            .attr("disabled","disabled");
                            $("#theform").submit();
                          });
                         });
                        </script>
                        <table width="400">
                         <tr class="CabezoteTabla"> 
                          <td align="center"> <b>Marcar como extralegal <br> masivamente en el periodo <br> <font color="BLUE">'.strtolower($descripcion).'</font></b></td> 
                         </tr> 
                        </table>
                        <table width="400">
                         <tr class="TablaDocsPar">        
                          <td width="100%" align="center"> 
                           <form name="importa" method="post" action="?opcion=importacionextralegal" id="theform" enctype="multipart/form-data">
                           <input type="file" name="excel" /><br><br>                         
                           <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                           <input type="hidden" value="upload" name="action" />                  
                           </form> 
                          </td>    
                         </tr>
                        </table>';
      
                $cont.='<table width="400">
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                        </table>';
      
                $cont.='<table width="400">
                         <tr class="TablaDocsPar"> 
                          <td align="center"> 
                           <img src="images/iconos/ejemplocedulas.png" width="240" height="180" border="0">
                          </td> 
                         </tr>
                         <tr class="TablaDocsPar"> 
                          <td width="100%" align="center"> 
                           <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx </font>
                          </td> 
                         </tr>
                        </table>';
            }
  
            echo $cont;
            exit();
      }
      
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importacionextralegal
    // Creación: 30/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que marca masivamente como extralegales a los empleados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importacionextralegal")
    {
        set_time_limit(0);
        extract($_POST);
        $archivo = $_FILES['excel']['name'];
        $tipo = $_FILES['excel']['type'];
        $destino = "recursos/xls/bak_".$archivo;
  
        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);
  
        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
          
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                  
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                
                    if(strlen($_DATOS_EXCEL[$i]['dni']) == 0)
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
  
                // ------------------------------------------------------------------------------------------ //
                //Teniendo la Informacion en el Array la inserto en la Base de Datos
                $errores = 0;
                $grabados = 0;
                $extralegal = "CHECKED";
    
                for($j=1; $j < $i; $j++)
                {
                    $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");
                    
                    if($terid != "")
                    {
                        $vsql5 = "UPDATE terceros SET extralegal = '".$extralegal."' WHERE terid = ".$terid;
                        $clase->EjecutarSQL($vsql5);
    
                        if(mysql_affected_rows() >= 1)
                            $grabados++;
                    }
                }
            
                // Elimino el Archivo
                unlink($destino);
        
                // Emito el mensaje correspondiente
                if($grabados==0)
                    $clase->Aviso(3,"No se marcó ningún empleado como extralegal");
                else
                    $clase->Aviso(1,"$grabados empleados se marcaron como extralegal");
        
                // Redirecciona el formulario
                header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaactdatos
    // Creación: 26/12/2022		última modificación: 30/09/2025
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se selecciona los datos que se 
    //              editarán como administrador del sistema
    // Última modificación: Redireccionamiento a la ventana de motivo para la actualización 
    //                      de datos del periodo anterior como administrador (05/01/2023)
    //                      Acceso a los formularios de crud de periodos dian y corrección 
    //                      de registros de reportados (13/10/2023)
    //                      Validación del acceso a la ventana del motivo del ajuste 
    //                      extemporáneo (07/12/2023)
    //                      Inclusión del botón para acceder al formulaio para actualizar 
    //                      los empleados activos con cupos de crédito en cero
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaactdatos")
    {
	    // Control de Permisos
	    if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            // Obtengo el nombre del periodo a procesar
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);
    
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            // código del periodo
            $monthtoday = date("m") - 1;
            $yeartoday = date("Y");

            $vsql33 = "SELECT codperiodo FROM periodos WHERE mesperiodo = ".$monthtoday." AND anoperiodo = ".$yeartoday;
            $codperiodo = $clase->SeleccionarUno($vsql33);

            // Determino si se puede hacer el ajuste extemporáneo
            $segundaq = ($periodoid - 1);
            $primeraq = ($periodoid - 2);

            $vsql34 = "SELECT COUNT(*) AS permod FROM periodosnomina WHERE periodoid IN ($primeraq,$segundaq) AND transmitido <> 'CHECKED'";
            $permod = $clase->SeleccionarUno($vsql34);

            $origen="actdatos";

            if($permod > 0)
                $ajusteexttxt = '<a href="?opcion=venteditarperant&periodoid='.$periodoid.'&origen='.$origen.'" title="editar periodo cerrado" rel="facebox">
                                  <img src="images/iconos/horario.png" border="0"> 
                                  <br>ajuste extemporáneo
                                 </a>';
            else
                $ajusteexttxt = '<img src="images/iconos/horario.png" border="0"> <br> <font color="gray"> ajuste extemporáneo </font>';

            // pinto la ventana        
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/clientes.png" width="32" height="32" border="0"> </td>
                      <td width="850"> <b> Actualizaci&oacute;n de datos para administrador del periodo <br> <font color="blue"> '.$descripcion.' </font> </b> </td>
                      <td width="10"> &nbsp; </td>                  
                      <td width="24"> &nbsp; </td>
                      <td width="250" align="right"> <a href="calculoliquidados.php?opcion=ventanaliquidados"> <input type="button" class="button blue" value="<<"> </a> </td>                  
                      <td width="10"> &nbsp; </td>
                     </tr>
                    </table>';
    
            $origen = "actdatos";

            $cont.='<center>
                    <table width="900" border="0">
                     <tr height="120">
                      <td width="25%" align="center">                         
                       '.$ajusteexttxt.'
                      </td>
                      <td width="25%" align="center">
                       <a href="?opcion=liquidaconceptos"  target="_blank">
                        <img src="images/iconos/eliminardoc.png" border="0" width="38" height="38">
                        <br> eliminar conceptos <br> de liquidaciones duplicados
                       </a>
                      </td>
                      <td width="25%" align="center"> 
                       <a href="?opcion=duplicados" target="_blank"> 
                        <img src="images/iconos/Folder docs.png" border="0" width="38" height="38">
                        <br> eliminar registros <br> duplicados
                       </a>
                      </td>
                      <td width="25%" align="center">                         
                       <a href="crudnomina.php?opcion=crudcondicionemp" target="_blank">
                        <img src="images/iconos/atributos.png" border="0" width="38" height="38">
                        <br> crud para condición <br> de empleados
                       </a>
                      </td> 
                     </tr>
                     <tr height="120">
                      <td width="25%" align="center"> 
                       <a href="ajusteextemporaneo.php?opcion=seldatosext" target="_blank">
                        <img src="images/iconos/agenda.png" border="0" width="38" height="38">
                        <br> editar datos <br> periodos anteriores
                       </a>
                      </td>
                      <td width="25%" align="center">
                       <a href="ajusteextemporaneo.php?opcion=seldatospriter" target="_blank">
                        <img src="images/iconos/clientesgenerales.png" border="0" width="38" height="38">
                        <br> editar datos <br> de la tabla <br> primasterceros
                       </a>
                      </td>
                      <td width="25%" align="center">
                       <a href="?opcion=infmotivos" target="_blank">
                        <img src="images/iconos/asignacursos.png" border="0" width="38" height="38">
                        <br> cambios en periodos <br> cerrados 
                       </a>
                      </td>
                      <td width="25%" align="center">
                       <a href="?opcion=ventusuarios" target="_blank">
                        <img src="images/iconos/docentes.png" border="0" width="38" height="38">
                        <br> asociación de tercero <br> a usuario
                       </a>
                      </td>
                     </tr>
                     <tr height="120">
                      <td width="25%" align="center"> 
                       <a href="?opcion=selpersaldobase" target="_blank">
                        <img src="images/iconos/remisionessal.png" border="0" width="38" height="38">
                        <br> corregir saldos/base <br> en sueldo por periodos
                       </a>
                      </td>
                      <td width="25%" align="center">
                       <a href="nominaelectronica.php?opcion=crudperiodos&codperiodo='.$codperiodo.'" target="_blank"> 
                        <img src="images/iconos/guardardoc.png" border="0" width="38" height="38"> 
                        <br> crud de periodos dian
                       </a>
                      </td>
                      <td width="25%" align="center">
                       <a href="nominaelectronica.php?opcion=corregirnom" target="_blank"> 
                        <img src="images/iconos/aspectos.png" border="0" width="38" height="38"> 
                        <br> corregir registros del periodo
                       </a>
                      </td>
                      <td width="25%" align="center">                      
                       <a href="?opcion=ventanaverjson" target="_blank"> 
                        <img src="images/iconos/vertodo.png" border="0" width="38" height="38"> 
                        <br> ver json <br> n&oacute;mina electr&oacute;nica
                       </a>
                      </td>
                     </tr>
                     <tr height="120">
                      <td width="25%" align="center"> 
                       <a href="?opcion=cerrarliquidaciones" target="_blank">
                        <img src="images/iconos/cerrar.png" border="0" width="38" height="38">
                        <br> cerrar liquidaciones
                       </a>
                      </td>
                      <td width="25%" align="center">
                       <a href="crudnomina.php?opcion=crudbancos" target="_blank">
                        <img src="images/iconos/pagos.png" border="0" width="38" height="38">
                        <br> entidades bancarias
                       </a>
                      </td>
                      <td width="25%" align="center">
                       <a href="empleadosperiodo.php?opcion=ventanasincronizacion" target="_blank">
                        <img src="images/iconos/inventario.png" border="0" width="38" height="38">
                        <br> empleados desincronizados
                       </a>
                      </td>
                      <td width="25%" align="center">
                       <a href="informesnomina.php?opcion=cuposencero" target="_blank">
                        <img src="images/iconos/mpcredito.png" border="0" width="38" height="38">
                        <br> empleados activos con<br>cupos cr&eacute;dito en cero
                       </a>
                      </td>
                     </tr>
                    </table>';
            echo $cont.$clase->PiePagina();
            exit();
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido"); 
            header("Location: calculoliquidados.php?opcion=ventanaliquidados"); 
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: venteditarperant
    // Creación: 02/01/2023		última modificación: 05/01/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para seleccionar el empleado en la edición 
    //              de empleados para los usuarios que no sean administradores
    // Última modificación: Redireccionamiento a la ventana de editar datos de acuerdo al 
    //                      usuario
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "venteditarperant")
    {
        $periodoid  = $_GET['periodoid'];
        $origen = $_GET['origen'];

        if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
            $cont='<form action="ajusteextemporaneo.php" method="POST">';
        else
            $cont='<form action="ajusteextemporaneo.php?opcion=editarextnomina" method="POST">';

        $cont.='<input type="hidden" name="periodoid" value="'.$periodoid.'">
                <input type="hidden" name="origen" value="'.$origen.'">
                <table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Digite el motivo del cambio que se realizar&aacute; </b> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="motivo" cols="50" rows="5"></textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <input type="submit" value="Guardar y Continuar" class="button"> </form> </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: infmotivos
    // Creación: 05/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que imprime el informe con las operaciones realizadas en periodos 
    //              cerrados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "infmotivos")
    {
        $cont = $clase->HeaderBlanco("Informe de motivos");
        $cont.='<table width="1300">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> </td>
                  <td width="37"> <img src="images/iconos/asignacursos.png" width="32" height="32" border="0"> </td>
                  <td width="850"> <b> Cambios en periodos cerrados </b> </td>
                  <td width="50"> &nbsp; <td>
                  <td width="30" align="center"> &nbsp; </td>
                  <td width="10" align="center"> 
                   <a href="?opcion=motivosxls" title="salida a excel del informe de cambios en periodos cerrados" target="_blank"> 
                    <img src="images/iconos/exportarexcel2.png" border="0"> 
                   </a> 
                  </td>
                  <td width="15"> &nbsp; </td>
                  <td width="10" align="center"> 
                   <a href="?opcion=motivospdf" title="salida en pdf del informe de cambios en periodos cerrados" target="_blank"> 
                    <img src="images/iconos/exportarpdf2.png" border="0"> 
                   </a> 
                  </td>
                  <td width="15"> &nbsp; </td>
                  <td width="10" align="center">
                   <a href="?opcion=ventanaactdatos"> <input type="button" value="<<" class="button" title="ventana anterior"> </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="1250" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="20"> &nbsp; </td>
                   <td width="260" align="left"> Periodo </td>				 				 
                   <td width="735" align="left"><p>Motivo</p></td>				 				                                     
                   <td width="135" align="left">Fecha</B> </td>
                   <td width="55" align="left">Usuario </td>
                   <td width="20">&nbsp;</td>	
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1300px; height:620px; overflow-Y:scroll">';

        // consulta del informe
        $vsql = "SELECT p.descripcion, l.motivo, l.momento, l.creador FROM logcambiosnomina l INNER JOIN periodosnomina p ON (l.valor = p.periodoid)";

        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $momento = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4).substr($row['momento'],10,strlen($row['momento']));

            $cont.=' <td width="20">&nbsp;</td>
                     <td width="290" align="left"> '.$row['descripcion'].' </td>
                     <td width="830" align="left">'.$row['motivo'].'</td>
                     <td width="5" align="left">&nbsp;</td>
                     <td width="140" align="left">'.$momento.'</td>
                     <td width="5" align="left">&nbsp;</td>
                     <td width="140" align="left">'.$row['creador'].'</td>
                    </tr>';
        }

        $cont.=' </tbody> 
                </table>';

        // impresión de los totales
        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="20"> &nbsp; </td>
                  <td width="375" align="left"> <font color="WHITE"> <b> Total cambios: </b> '.number_format($i).' </font> </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="616" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: motivosxls
    // Creación: 16/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida a Excel del informe de cambios en periodos 
    //              cerrados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "motivosxls")
    {
        // consulta del informe
        $vsql = "SELECT p.descripcion, l.motivo, l.momento, l.creador FROM logcambiosnomina l INNER JOIN periodosnomina p ON (l.valor = p.periodoid)";

        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("cambios cerrados - DROPOS")
                                     ->setSubject("cambios cerrados - DROPOS")
                                     ->setDescription("cambios cerrados - DROPOS")
                                     ->setKeywords("cambios cerrados - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'CAMBIOS EN PERIODOS CERRADOS')
                    ->setCellValue('A3', 'PERIODO')
                    ->setCellValue('B3', 'MOTIVO')
                    ->setCellValue('C3', 'FECHA')
                    ->setCellValue('D3', 'USUARIO');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 4;
        while($row = mysql_fetch_array($result))
        {
            $momento = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4).substr($row['momento'],10,strlen($row['momento']));

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['descripcion'])
                        ->setCellValue('B'.$i, $row['motivo'])
                        ->setCellValue('C'.$i, $momento)
                        ->setCellValue('D'.$i, $row['creador']);
            $i++;            
        }

        $rangoEncabezado = 'A3:D3';
        $rangoCeldas     = 'A3:D'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('periodos');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //                
        $nombrearcexcel = "cambios en periodos cerrados.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: motivospdf
    // Creación: 16/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida en pdf del informe de cambios en periodos 
    //              cerrados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "motivospdf")
    {
        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";
        
        // Procedo a construir el encabezado del recibo
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        // $pdf=new FPDF();
        $pdf=new FPDF('L','mm','A4');
        
        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

        // Imprimo el encabezado del informe
        $x = 25;
        $y = 13;
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+205,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "CAMBIOS EN PERIODOS CERRADOS";               $pdf->Text($x,$y+5,$enc);
        
        // Encabezado del informe
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(5,26,284,8,'F');

        $pdf->SetFont('Arial','B',9);
        $enc= "PERIODO";                         $pdf->Text($x-17,$y+18,$enc);
        $enc= "MOTIVO";                          $pdf->Text($x+44,$y+18,$enc);
        $enc= "FECHA";                           $pdf->Text($x+205,$y+18,$enc);
        $enc= "USUARIO";                         $pdf->Text($x+236,$y+18,$enc);

        // consulta del informe
        $vsql = "SELECT p.descripcion, l.motivo, l.momento, l.creador, l.logid FROM logcambiosnomina l INNER JOIN periodosnomina p ON (l.valor = p.periodoid)";

        $x = 8;
        $y = 39;
        $i = 0;        
        $y1 = 39;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            $linmotivo = 0;
            if($i%38==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+205,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "CAMBIOS EN PERIODOS CERRADOS";               $pdf->Text($x,$y+5,$enc);
                
                // Encabezado del informe
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(5,26,284,8,'F');

                $pdf->SetFont('Arial','B',9);
                $enc= "PERIODO";                         $pdf->Text($x-17,$y+18,$enc);
                $enc= "MOTIVO";                          $pdf->Text($x+44,$y+18,$enc);
                $enc= "FECHA";                           $pdf->Text($x+205,$y+18,$enc);
                $enc= "USUARIO";                         $pdf->Text($x+236,$y+18,$enc);
                
                $x = 8;
                $y = 39;
            }

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y,$row['descripcion']);

            $longmotivo = strlen($row['motivo']);
            $linmotivo = $longmotivo / 90;
            $linmotivo = round($linmotivo,0);

            $j = 0;
            $x1 = 0;
            while($j <= $linmotivo)
            {
                $pdf->Text($x+61,$y1,substr($row['motivo'],$x1,90));
                $j++;
                $x1 = $x1 + 90;
                $y1 = $y1 + 6;
            }
            // $y1 = $y1 - 6;

            $momento = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4).substr($row['momento'],10,strlen($row['momento']));
            $pdf->Text($x+222,$y,$momento);

            $pdf->Text($x+254,$y,$row['creador']);

            if($linmotivo > 1)
            {
                $y1 = $y1 - 6;
                $y = $y1;
            }
            else
                $y+=6;
        }
        $pdf->Output();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventusuarios
    // Creación: 17/05/2023		última modificación: 30/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para actualizar los terceros a usuarios
    // Última modificación: Inclusión de la búsqueda de usuarios (25/05/2023)
    //                      Cambio del botón de anular última búsqueda, ajuste de la caja de 
    //                      texto para buscar usuario y acceso directo a formulario de 
    //                      usuarios
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventusuarios")
    {
        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/docentes.png" width="32" height="32" border="0"> </td>
                  <td width="850"> <b>Asociación de tercero a usuario</b> </td>
                  <form action="?opcion=encontrar" method="POST" name="x">
                  <td> <input type="text" name="criterio" size="30" style="width:250px;height:25px;" placeholder="usuario a buscar" tabindex="1" id="default"> </td>
                  <td> <input type="submit" value="Encontrar" class="button"> </form> </td>';

        if($_SESSION['SQL_USUTERCERO'] != "")
            $cont.='<td width="10"> &nbsp; </td>
                    <td width="30"> <a href="?opcion=nofiltro"> <img src="images/iconos/devoluciones.png" width="32" height="32" border="0" title="anular &uacute;ltima b&uacute;squeda""> </a> </td>
                    <td width="10"> &nbsp; </td>';

        $cont.='  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="admusuarios.php"  title="acceder a la ficha de usuarios" target="_blank"> 
                    <img src="images/iconos/terceros.png" border="0" width="32" height="32"> 
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="10"> 
                   <a href="calculoliquidados.php?opcion=ventanaactdatos"> 
                    <input type="button" class="button" value="<<"> 
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        // detalle de la ventana
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="11">&nbsp;</td>
                   <td width="305" align="left"> Usuario </td>                   
                   <td width="35" align="left"> &nbsp; </td>
                   <td width="159" align="left"> Tercero </td>
                   <td width="183" align="left"> &nbsp; </td>
                   <td width="12"> &nbsp; </td>	
                   <td width="190" align="left"> &nbsp; </td>
                   <td width="20"> &nbsp; </td>
                   <td width="6"> &nbsp; </td>
                   <td width="32"> &nbsp; </td>
                   <td width="32"> &nbsp; </td>
                   <td width="26"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:550px; overflow-Y:scroll">';

        // consulta del formulario
        if($_SESSION['SQL_USUTERCERO'] == "")
            $vsql = "SELECT u.usuid, u.username, 
                            (SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)
                               FROM terceros
                              WHERE terid = u.terid) AS nombreemp 
                       FROM usuarios u 
                      WHERE u.activo = 'S' 
                   ORDER BY 2";
        else
            $vsql = $_SESSION['SQL_USUTERCERO'];

        $i = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $nombreemp = $row['nombreemp'];

            if($nombreemp == "")
                $nombreemp2 = '<font color="red"> NO TIENE TERCERO ASIGNADO </font>';
            else
                $nombreemp2 = '<font color="green"> '.substr($nombreemp,0,60).' </font>';

            $cont.=' <td width="15"> &nbsp; </td>
                     <td width="360" align="left"> '.$row['username'].' </td>
                     <td width="300" align="left"> '.$nombreemp2.' </td>
                     <td width="133" align="left"> &nbsp; </td>
                     <td width="12"> &nbsp; </td>
                     <td width="218" align="left"> &nbsp; </td>
                     <td width="14"> &nbsp; </td>
                     <td width="6" align="center"> &nbsp; </td> 
                     <td width="30" align="center"> &nbsp; </td> 
                     <td width="30" align="center"> 
                      <a href="?opcion=venasigter&usuid='.$row['usuid'].'">
                       <img src="images/basicas/iconobuscar.png" title="editar secci&oacute;n" border="0">
                      </a>
                     </td>
                    </tr>';
        }

        $cont.=' </tbody>
                </table>';

        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="20"> &nbsp; </td>
                  <td width="375" align="left"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="616" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: encontrar
    // Creación: 25/05/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para encontrar un usuario especifico
    // Última modificación:
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "encontrar")
    {
        $criterio = strtolower($_POST['criterio']);
        $vsql = "SELECT u.usuid, u.username, 
                        (SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)
                           FROM terceros
                          WHERE terid = u.terid) AS nombreemp
                   FROM usuarios u
                  WHERE u.activo = 'S'
                        AND u.username LIKE '%".$criterio."%'
               ORDER BY 2";
        $_SESSION['SQL_USUTERCERO'] = $vsql;
        header("Location: calculoliquidados.php?opcion=ventusuarios");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: nofiltro
    // Creación: 25/05/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para restablecer todos los usuarios en la ventana principal
    // Última modificación:
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {        
        $vsql = "SELECT u.usuid, u.username, 
                        (SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)
                           FROM terceros
                          WHERE terid = u.terid) AS nombreemp
                   FROM usuarios u
                  WHERE u.activo = 'S'
               ORDER BY 2";
        $_SESSION['SQL_USUTERCERO'] = "";
        header("Location: calculoliquidados.php?opcion=ventusuarios");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: venasigter
    // Creación: 17/05/2023		última modificación: 30/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para realizar la asociación de terceros a usuario
    // Última modificación: Ajuste del texto con el nombre del usuario
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "venasigter")
    {
        $usuid = $_GET['usuid'];
        $params = ' class="Texto11" ';

        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/docentes.png" width="32" height="32" border="0"> </td>
                  <td width="990"> <b>Asociación de tercero a usuario</b> </td>
                  <td width="24"> <a href="calculoliquidados.php?opcion=ventusuarios"> <input type="button" value="<<" class="button"> </a> </td>
                  <td width="10"> &nbsp; </td>
                 </tr> 
                </table>
                <br><center>';
        
        $vsql = "SELECT * FROM usuarios WHERE usuid = ".$usuid;

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        if($row = mysql_fetch_array($result))
        {
            $usuid = $row['usuid'];

            $username = $clase->BDLockup($usuid,'usuarios','usuid','username');
            $terid = $clase->BDLockup($usuid,'usuarios','usuid','terid');

            // combo de empleado
            $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp
                               FROM terceros 
                              WHERE esempleadoactivo = 'CHECKED' 
                                    AND basico > 0 
                                    AND (primernombre <> '' AND primerapellido <> '') 
                           ORDER BY primernombre";
            $comboemp  = $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombreemp","terid",$terid,"S",$params,500);

            // pinto la ventana con los datos
            $cont.='<center>
                    <form action="?opcion=guardartercero" method="POST">
                    <input type="hidden" name="usuid" value="'.$usuid.'">
                    <fieldset style="width: 530px; height: 220px;" class="grupos">
                    <legend class="titgrupos"> Datos </legend>
                    <table width="350">
                     <tr height="55">
                      <td> 
                       <h2> <b> Usuario:</b> <br> '.$row['username'].' </h2>
                      </td>
                     </tr>
                     <tr height="55">
                      <td> 
                       <label class="Texto12"> <b> Tercero: </b> </label> <br>  
                       '.$comboemp.'
                      </td>
                     </tr>
                    </table>
                    <table width="350">
                     <tr height="55">
                      <td align="center">
                       <input type="submit" value="guardar" class="button blue"> 
                      </td>
                     </tr>
                    </table>
                    <br>
                    </fieldset>';
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardartercero
    // Creación: 17/05/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para almacenar el tercero a un usuario
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardartercero")
    {
        $usuid = $_POST['usuid'];
        $terid = $_POST['terid'];

        if($terid == "")
            $terid = 0;

        // Almaceno la modificación
        $vsql = "UPDATE usuarios SET terid = ".$terid." WHERE usuid = ".$usuid;
        $clase->EjecutarSQL($vsql);

        $clase->Aviso(1,"Cambios guardados exitosamente");
        header("Location: calculoliquidados.php?opcion=ventusuarios");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: 
    // Creación: 20/09/2023 		última modificación: 
    // Creador: Luis Flórez		    modificado por: 
    // Descripción: Opción que devuelve el enfoque con el filtro para la tabla 
    //              seccionterceros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarseccionterceros")
    {
        $seccionid = $_POST['seccionid'];
        header("Location: calculoliquidados.php?opcion=duplicaseccionterceros&seccionid=$seccionid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: duplicaseccionterceros
    // Creación: 20/09/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para actualizar la información de la tabla seccionterceros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "duplicaseccionterceros")
    {
        if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            $seccionid = $_GET['seccionid'];

            // Combo de secciones
            $vsqlcomboseccion = "SELECT seccionid, descripcionsec FROM seccion ORDER BY seccionid ASC";
            $params    = ' class="Texto11" style="width:200px;height:25px" OnChange="x.submit();"';

            // Pintamos la ventana
            $cont = $clase->Header("S","W");
            $cont.='<form action="?opcion=filtrarseccionterceros" method="POST" name="x">
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                      <td width="800"> <b>Registros duplicados </b> <font color="blue"> <br>en la tabla seccionterceros </font> </td>
                      <td width="10"> &nbsp; </td>
                      <td width="380"> secci&oacute;n: '.$clase->CrearComboEsp("seccionid",$vsqlcomboseccion,"seccionid","descripcionsec",$seccionid,"N",$params).' </form> </td>
                      <td width="10"> &nbsp; </td>
                      <td width="100"> &nbsp; </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';

            $cont.= permisosespeciales(9);

            $cont.='<script language="javascript">
                    <!--
                        function seleccionar_todo()
                        { 
                            valor = document.f2.todos.checked;
                            if(valor)
                                marcartodo();
                            else
                                desmarcartodo();
                        } 
    
                        function marcartodo()
                        {
                            for (i=0;i<document.f2.elements.length;i++) 
                             if(document.f2.elements[i].type == "checkbox")  
                               document.f2.elements[i].checked = 1;
                        }
    
                        function desmarcartodo()
                        {
                            for (i=0;i<document.f2.elements.length;i++) 
                             if(document.f2.elements[i].type == "checkbox") 
                              document.f2.elements[i].checked = 0;
                        }
                    -->
                    </script>
                    
                    <script type="text/javascript" src="lib/sorttable.js"></script> 
                    <form action="calculoliquidados.php?opcion=eliminarseccionterceros" method="POST" name="f2">
                    <table width="100%" class="sortable">
                     <thead>
                      <tr class="TituloTabla" style="display:block; padding-top:5px;height:23px;"> 
                       <th width="10"> &nbsp; </th>
                       <th width="190" align="left"> secciontercerosid </th>
                       <th width="130" align="left"> seccionid </th>							 
                       <th width="165" align="left"> terid </th>			
                       <th width="585" align="left"> nombre </th>
                       <th width="45" align="left"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo();"> </th>	
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';

            // Consulta de los registros duplicados
            $vsql = "SELECT st.*,  
                            (SELECT COUNT(seccionterceros.terid) 
                               FROM seccionterceros 
                              WHERE seccionterceros.terid = st.terid 
                                    AND seccionterceros.seccionid = ".$seccionid.") AS repetido,
                            CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                            t.dni 
                       FROM seccionterceros st  
                            INNER JOIN terceros t ON (st.terid = t.terid)
                      WHERE st.seccionid = ".$seccionid."    
                     HAVING repetido > 1   
                   ORDER BY st.seccionid, st.terid";

            $i = 0;
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';

                $cont.=' <td width="10"> &nbsp; </td>
                         <td width="200" align="left"> '.$row['secciontercerosid'].' </td>
                         <td width="130" align="left"> '.$row['seccionid'].' </td>
                         <td width="165" align="left"> '.$row['terid'].' </td>	
                         <td width="575" align="left"> 
                          <b> '.substr($row['nombreemp'],0,30).' </b>
                          <br> c&eacute;dula: <span> <font color="#CC66FF"> '.$row['dni'].' </font> </span>
                         </td>
                         <td width="30" align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['secciontercerosid'].'" value="S"> </td>
                        </tr>';
            }

            $cont.=' </tbody>
                    </table>
                    <table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="261"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="222"> &nbsp; </td>
                     </tr>
                    </table>
                    <br>
                    <center>
                    <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar"></a>
                    </form>
                    <a href="calculoliquidados.php?opcion=ventanaactdatos" ><input type="button" value="ATRAS" class="button red"></a>
                    <a href="calculoliquidados.php?opcion=duplicatercerosactual"><input type="button" value="SIGUIENTE" class="button blue"></a>';

            mysql_free_result($result);
            mysql_close($conex);
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido"); 
            header("Location: calculoliquidados.php?opcion=ventanaliquidados"); 
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarseccionterceros
    // Creación: 20/09/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina físicamente los registros seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarseccionterceros")
    {
        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT secciontercerosid FROM seccionterceros";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            if($_POST['LIN-'.$row['secciontercerosid']] == "S")
            {
                $lista.= $row['secciontercerosid'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // Elimino los registros
        $vsql2 = "DELETE FROM seccionterceros WHERE secciontercerosid IN (".$lista.")";        
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli registros eliminados exitosamente");
        else
            $clase->Aviso(3,"No se eliminaron los registros");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=duplicados");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: duplicatercerosactual
    // Creación: 18/11/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que muestra los registros duplicados de la tabla tercerosactual
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "duplicatercerosactual")
    {
        // Control de Permisos
	    if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            // Valido la opción para ver los registros duplicados completos
            $vsql5 = "SELECT ta.*, (SELECT COUNT(tercerosactual.idteract) FROM tercerosactual WHERE tercerosactual.terid = ta.terid) AS repetido 
                        FROM tercerosactual ta
                      HAVING repetido > 1";

            $conex  = $clase->Conectar();
            $result5 = mysql_query($vsql5,$conex);
            $numrepetido = mysql_num_rows($result5);
    
            @mysql_free_result($result5);
            @mysql_close($conex);

            if($numrepetido > 0)
                $vercompletos = '   <a href="?opcion=vercompletostercerosact" title="ver registros completos" rel="facebox">
                                     <img src="images/iconos/notas.png" border="0" width="38" height="38">
                                    </a>';
            else
                $vercompletos = '&nbsp;';

            // Pintamos la ventana
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                      <td width="870"> <b>Registros duplicados </b> <font color="blue"> <br>en la tabla tercerosactual </font> </td>
                      <td width="20"> '.$vercompletos.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="20"> 
                       <a href="?opcion=duplicatercerosactual" title="actualizar la ventana"> 
                        <img src="images/iconos/refrescar.png" border="0" width="38" height="38">  
                       </a> 
                      </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';
                    
            $cont.= permisosespecialesdos(1);

            $cont.='<script language="javascript">
                    <!--
                        function seleccionar_todo()
                        { 
                            valor = document.f2.todos.checked;
                            if(valor)
                                marcartodo();
                            else
                                desmarcartodo();
                        } 

                        function marcartodo()
                        {
                            for (i=0;i<document.f2.elements.length;i++) 
                            if(document.f2.elements[i].type == "checkbox")  
                            document.f2.elements[i].checked = 1;
                        }

                        function desmarcartodo()
                        {
                            for (i=0;i<document.f2.elements.length;i++) 
                            if(document.f2.elements[i].type == "checkbox") 
                                document.f2.elements[i].checked = 0;
                        }  
                    -->
                    </script>
                    <script type="text/javascript" src="lib/sorttable.js"></script> 
                    <form action="calculoliquidados.php?opcion=eliminartercerosactual" method="POST" name="f2">
                    <table width="100%" class="sortable">
                     <thead>
                      <tr class="TituloTabla" style="display:block; padding-top:5px;height:25px;"> 
                       <th width="10"> &nbsp; </th>
                       <th width="80" align="left"> idteract </th>
                       <th width="130" align="left"> pernominaid </th>
                       <th width="160" align="left"> terid </th>
                       <th width="180" align="left"> esempleadoactivo </th>
                       <th width="240" align="left"> primernombre </th>
                       <th width="240" align="left"> segundonombre </th>
                       <th width="240" align="left"> primerapellido </th>
                       <th width="230" align="left"> segundoapellido </th>
                       <th width="55" align="left"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo();"> </th>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';

            // Consulta de los registros duplicados
            $vsql = "SELECT ta.*, 
                            (SELECT COUNT(tercerosactual.idteract) FROM tercerosactual WHERE tercerosactual.terid = ta.terid) AS repetido
                       FROM tercerosactual ta
                     HAVING repetido > 1   
                   ORDER BY ta.idteract";

            $i = 0;
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';

                $cont.=' <td width="10"> &nbsp; </td>
                         <td width="85" align="left"> '.$row['idteract'].' </td>
                         <td width="175" align="left"> '.$row['pernominaid'].' </td>
                         <td width="100" align="left"> '.$row['terid'].' </td>
                         <td width="215" align="left"> '.$row['esempleadoactivo'].' </td>
                         <td width="245" align="left"> '.$row['primernombre'].' </td>
                         <td width="240" align="left"> '.$row['segundonombre'].' </td>
                         <td width="220" align="left"> '.$row['primerapellido'].' </td>
                         <td width="230" align="left"> '.$row['segundoapellido'].' </td>
                         <td width="30" align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['idteract'].'" value="S"> </td>
                        </tr>';
            }

            $cont.=' </tbody>
                    </table>
                    <table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="261"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="222"> &nbsp; </td>
                     </tr>
                    </table>
                    <br>
                    <center>
                    <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar"></a>
                    </form>
                    <a href="calculoliquidados.php?opcion=duplicados" ><input type="button" value="ATRAS" class="button red"></a>';
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vercompletostercerosact
    // Creación: 22/11/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que permite ver los registros duplicados completos con todos los 
    //              campos de la tabla tercerosactual
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vercompletostercerosact")
    {
        // Consulta de los registros duplicados
        $vsql = "SELECT ta.*, 
                        (SELECT COUNT(tercerosactual.idteract) FROM tercerosactual WHERE tercerosactual.terid = ta.terid) AS repetido 
                   FROM tercerosactual ta 
                 HAVING repetido > 1   
               ORDER BY ta.idteract";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant = mysql_num_rows($result);

        // Pinto la ventana
        $cont ='<form action="calculoliquidados.php?opcion=duplicatercerosactual" method="POST" name="x">
                <table width="1800">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><b> Registros duplicados en la tabla tercerosactual </b> </td> 
                 </tr> 
                </table>';

        // Determino si hay registros duplicados para este periodo
        if($cant <= 0)
            $cont.='<table width="1800"> <center><h2> No existen registros duplicados en la tabla tercerosactual en este periodo </h2>';
        else
        {
            $cont.='<table width="1800">
                     <tr class="TituloTabla">
                      <td width="10" align="center"> &nbsp; </td>
                      <td width="100" align="left"> idteract </td>
                      <td width="120" align="left"> pernominaid </td>
                      <td width="120" align="left"> terid </td>
                      <td width="100" align="left"> esempleado </td>
                      <td width="140" align="left"> esempleadoactivo </td>
                      <td width="120" align="left"> extralegal </td>
                      <td width="80" align="left"> areaid </td>
                      <td width="80" align="left"> seccionid </td>
                      <td width="80" align="left"> cargoid </td>
                      <td width="80" align="left"> bancoid </td>
                      <td width="110" align="left"> numcuenta </td>
                      <td width="90" align="left"> fecingreso </td>
                      <td width="120" align="left"> basico </td>
                      <td width="80" align="left"> codvende </td>
                      <td width="110" align="left"> dni </td>
                      <td width="220" align="left"> primernombre </td>
                      <td width="220" align="left"> segundonombre </td>
                      <td width="220" align="left"> primerapellido </td>
                      <td width="220" align="left"> segundoapellido </td>
                      <td width="80" align="left"> epsid </td>
                      <td width="80" align="left"> pensionesid </td>
                     </tr>';

            $i=0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
                        
                $cont.=' <td width="10" align="center"> &nbsp; </td>
                         <td width="100" align="left"> '.$row['idteract'].' </td>
                         <td width="120" align="left"> '.$row['pernominaid'].' </td>
                         <td width="120" align="left"> '.$row['terid'].' </td>
                         <td width="100" align="left"> '.$row['esempleado'].' </td>
                         <td width="140" align="left"> '.$row['esempleadoactivo'].' </td>
                         <td width="120" align="left"> '.$row['extralegal'].' </td>
                         <td width="80" align="left"> '.$row['areaid'].' </td>
                         <td width="80" align="left"> '.$row['seccionid'].' </td>
                         <td width="80" align="left"> '.$row['cargoid'].' </td>
                         <td width="80" align="left"> '.$row['bancoid'].' </td>
                         <td width="110" align="left"> '.$row['numcuenta'].' </td>
                         <td width="90" align="left"> '.$row['fecingreso'].' </td>
                         <td width="120" align="left"> '.number_format($row['basico']).' </td>
                         <td width="80" align="left"> '.$row['codvende'].' </td>
                         <td width="110" align="left"> '.$row['dni'].' </td>
                         <td width="220" align="left"> '.substr($row['primernombre'],0,30).' </td>
                         <td width="220" align="left"> '.substr($row['segundonombre'],0,30).' </td>
                         <td width="220" align="left"> '.substr($row['primerapellido'],0,30).' </td>
                         <td width="220" align="left"> '.substr($row['segundoapellido'],0,30).' </td>
                         <td width="80" align="left"> '.$row['epsid'].' </td>
                         <td width="80" align="left"> '.$row['pensionesid'].' </td>
                        </tr>';
            }
        }

        $cont.='</table><br><center><input type="submit" value="aceptar" class="button blue"></form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminartercerosactual
    // Creación: 22/11/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para eliminar físicamente los registros de la tabla 
    //              tercerosactual
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminartercerosactual")
    {
        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT idteract FROM tercerosactual";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            if($_POST['LIN-'.$row['idteract']] == "S")
            {
                $lista.= $row['idteract'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // Elimino los registros
        $vsql2 = "DELETE FROM tercerosactual WHERE idteract IN (".$lista.")";
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli registros eliminados exitosamente");
        else
            $clase->Aviso(3,"No se eliminaron los registros");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=duplicatercerosactual");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función permisosespeciales
    // Parámetro de entrada:    $item --> Nombre de la ficha    
    // Valor de retorno:        $cont --> tabla con el encabezado del formulario
    // Descripción: Función que pinta la ficha con las tablas las cuales serán controladas
    ////////////////////////////////////////////////////////////////////////////////////////
	function permisosespeciales($item)
	{
		$cont='<table width="100%">	
			    <tr class="BarraDocumentos">';
                
        // ficha para la tabla liquidacion
		if($item == 1)
			$cont.='<td width="11%" class="BarraDocumentosSel" align="center"> <b> liquidacion </b> </td>';
		else
			$cont.='<td width="11%" align="center"> <a href="calculoliquidados.php?opcion=duplicados"> liquidacion </a> </td>';

        // ficha para la tabla detalleliquidacion
		if($item == 2)
			$cont.='<td width="11%" class="BarraDocumentosSel" align="center"><b> detalleliquidacion </b> </td>';
		else
			$cont.='<td width="11%" align="center"> <a href="calculoliquidados.php?opcion=detalleliq"> detalleliquidacion </a> </td>';

        // ficha para la tabla detallenomina
		if($item == 3)
			$cont.='<td width="11%" class="BarraDocumentosSel" align="center"> <b> detallenomina </b> </td>';
		else
			$cont.='<td width="11%" align="center"> <a href="calculoliquidados.php?opcion=detallenom"> detallenomina </a> </td>';

        // ficha para la tabla hisdetallenomina
        if($item == 4)
			$cont.='<td width="11%" class="BarraDocumentosSel" align="center"> <b> hisdetallenomina </b> </td>';
		else
			$cont.='<td width="11%" align="center"> <a href="calculoliquidados.php?opcion=hisdetnom"> hisdetallenomina </a> </td>';

        // ficha para la tabla pagocesantias
        if($item == 5)
			$cont.='<td width="11%" class="BarraDocumentosSel" align="center"> <b> pagocesantias </b> </td>';
		else
			$cont.='<td width="11%" align="center"> <a href="calculoliquidados.php?opcion=pagocesan"> pagocesantias </a> </td>';
					
        // ficha para la tabla dotaciones
        if($item == 6)
			$cont.='<td width="11%" class="BarraDocumentosSel" align="center"> <b> dotaciones </b> </td>';
		else
			$cont.='<td width="11%" align="center"> <a href="calculoliquidados.php?opcion=dotaciones"> dotaciones </a> </td>';
            
        // ficha para la tabla dotaciones
        if($item == 7)
			$cont.='<td width="11%" class="BarraDocumentosSel" align="center"> <b> noliquida </b> </td>';
		else
			$cont.='<td width="11%" align="center"> <a href="calculoliquidados.php?opcion=noliquida"> noliquida </a> </td>';

        // ficha para la tabla periodoterceros
        if($item == 8)
			$cont.='<td width="11%" class="BarraDocumentosSel" align="center">  <b> periodoterceros </b> </td>';
		else
			$cont.='<td width="11%" align="center"> <a href="calculoliquidados.php?opcion=duplicaperiodoterceros"> periodoterceros </a> </td>';
        
        // ficha para la tabla seccionterceros
        if($item == 9)
			$cont.='<td width="11%" class="BarraDocumentosSel" align="center">  <b> seccionterceros </b>  </td>';
		else
			$cont.='<td width="11%" align="center"> <a href="calculoliquidados.php?opcion=duplicaseccionterceros"> seccionterceros </a> </td>';

        // ---------------------------------------------------------------------------------------------------------------------------------------- //

		$cont.=' </tr>
                </table>';

		return($cont);
	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función permisosespecialesdos
    // Parámetro de entrada:    $item --> Nombre de la ficha    
    // Valor de retorno:        $cont --> tabla con el encabezado del formulario
    // Descripción: Función que pinta la ficha con las tablas las cuales serán controladas
    ////////////////////////////////////////////////////////////////////////////////////////    
	function permisosespecialesdos($item)
	{
		$cont='<table width="100%">	
			    <tr class="BarraDocumentos">';

        // ficha para la tabla tercerosactual
        if($item == 1)
			$cont.='<td width="25%" class="BarraDocumentosSel" align="center">  <b> tercerosactual </b> </td>';
		else
			$cont.='<td width="25%" align="center"> <a href="calculoliquidados.php?opcion=duplicatercerosactual"> tercerosactual </a> </td>';

        // ficha para la tabla primasterceros
        if($item == 2)
			$cont.='<td width="25%" class="BarraDocumentosSel" align="center">  <b> primasterceros </b> </td>';
		else
			$cont.='<td width="25%" align="center"> <a href="calculoliquidados.php?opcion=duplicadosprimasterceros"> primasterceros </a> </td>';

        // ficha para la tabla histcontrato
		if($item == 3)
			$cont.='<td width="25%" class="BarraDocumentosSel" align="center"> <b> histcontrato </b> </td>';
		else
			$cont.='<td width="25%" align="center"> <a href="calculoliquidados.php?opcion=duplicahistcontrato"> histcontrato </a> </td>';

        // // ficha para la tabla dotaciones 
		// if($item == 4)
		// 	$cont.='<td width="25%" class="BarraDocumentosSel" align="center"><b> dotaciones </b> </td>';
		// else
		// 	$cont.='<td width="25%" align="center"> <a href="calculoliquidados.php?opcion=duplicadotaciones"> dotaciones </a> </td>';

        // ---------------------------------------------------------------------------------------------------------------------------------------- //

		$cont.=' </tr>
                </table>';

		return($cont);
	}    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrarperiodoterceros
    // Creación: 08/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que filtra la ventana duplicaperiodoterceros mediante un periodo 
    //              seleccionado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarperiodoterceros")
    {
        $periodoid = $_POST['periodoid'];
        header("Location: calculoliquidados.php?opcion=duplicaperiodoterceros&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: duplicaperiodoterceros
    // Creación: 08/07/2023		última modificación: 28/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se muestran los registros duplicados 
    //              de la tabla periodoterceros
    // Última modificación: Inclusión de las dos últimas quincenas del año anterior
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "duplicaperiodoterceros")
    {
        // Control de Permisos
	    if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            $periodoid = $_GET['periodoid'];

            // año actual
            $yeartoday = date("Y");
            $yearprev = $yeartoday - 1;

            $vsqld = "SELECT MAX(periodoid) FROM periodosnomina WHERE YEAR(fecdesde) = ".$yearprev."";
            $priquiant = $clase->SeleccionarUno($vsqld);
    
            $segquinat = $priquiant - 1;            
    
            // Combo de Periodos
            $vsqlcomboperiodo = "SELECT periodoid, descripcion FROM periodosnomina WHERE YEAR(fecdesde) = ".$yeartoday." OR periodoid IN ($priquiant,$segquinat) ORDER BY periodoid DESC";
            $params    = ' class="Texto11" style="width:250px;height:25px" OnChange="x.submit();"';

            // Pintamos la ventana
            $cont = $clase->Header("S","W");
            $cont.='<form action="?opcion=filtrarperiodoterceros" method="POST" name="x">
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                      <td width="830"> <b>Registros duplicados </b> <font color="blue"> <br>en la tabla periodoterceros </font> </td>
                      <td width="20">
                       <a href="?opcion=vercompletos&periodoid='.$periodoid.'" title="registros completos" rel="facebox">
                        <img src="images/iconos/notas.png" border="0" width="38" height="38">
                       </a>
                      </td>
                      <td width="20"> &nbsp; </td>                                            
                      <td width="400"> periodo: '.$clase->CrearComboEsp("periodoid",$vsqlcomboperiodo,"periodoid","descripcion",$periodoid,"N",$params).' </td>
                      </form>
                      <td width="10"> &nbsp; </td>
                      </tr>
                     </table>';

            $cont.= permisosespeciales(8);

            $cont.='<script language="javascript">
                    <!--
                        function seleccionar_todo()
                        { 
                            valor = document.f2.todos.checked;
                            if(valor)
                                marcartodo();
                            else
                                desmarcartodo();
                        } 

                        function marcartodo()
                        {
                            for (i=0;i<document.f2.elements.length;i++) 
                            if(document.f2.elements[i].type == "checkbox")  
                            document.f2.elements[i].checked = 1;
                        }

                        function desmarcartodo()
                        {
                            for (i=0;i<document.f2.elements.length;i++) 
                            if(document.f2.elements[i].type == "checkbox") 
                                document.f2.elements[i].checked = 0;
                        }  
                    -->
                    </script>            
                    <script type="text/javascript" src="lib/sorttable.js"></script> 
                    <form action="calculoliquidados.php?opcion=eliminarperiodoterceros" method="POST" name="f2">
                    <table width="100%" class="sortable">
                     <thead>
                      <tr class="TituloTabla" style="display:block; padding-top:5px;height:25px;"> 
                       <th width="10"> &nbsp; </th>
                       <th width="80" align="left">idperter</th>
                       <th width="110" align="left"> pernominaid </th>
                       <th width="80" align="left"> terid </th>		                       
                       <th width="110" align="left"> esempleado </th>                       
                       <th width="150" align="left"> esempleadoactivo </th>							 
                       <th width="90" align="left"> extralegal </th>
                       <th width="320" align="left"> nombre </th>
                       <th width="75" align="left"> areaid </th>				 
                       <th width="90" align="left"> seccionid </th>                       
                       <th width="45" align="left"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo();"> </th>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';

            // Consulta de los registros duplicados
            $vsql = "SELECT pt.*, 
                            (SELECT COUNT(*)
                               FROM periodoterceros
                              WHERE periodoterceros.pernominaid = ".$periodoid."
                                    AND periodoterceros.terid = pt.terid) AS numreg
                       FROM periodoterceros pt
                            INNER JOIN periodosnomina p ON (pt.pernominaid = p.periodoid) 
                      WHERE pt.pernominaid = ".$periodoid." 
                     HAVING numreg > 1
                   ORDER BY pt.terid";

            $i = 0;
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
                    
                $cont.= ' <td width="10"> &nbsp; </td>
                          <td width="80" align="left"> '.$row['idperter'].' </td>
                          <td width="120" align="left"> '.$row['pernominaid'].' </td>
                          <td width="75" align="left"> '.$row['terid'].' </td>
                          <td width="115" align="left"> '.$row['esempleado'].' </td>
                          <td width="160" align="left"> '.$row['esempleadoactivo'].' </td>
                          <td width="95" align="left"> '.$row['extralegal'].' </td>
                          <td width="295" align="left"> 
                           <b> '.substr($row['nombre'],0,30).' </b>
                           <br> c&eacute;dula: <span> <font color="#CC66FF"> '.$row['dni'].' </font> </span>
                          </td>
                          <td width="75" align="left"> '.$row['areaid'].' </td>
                          <td width="90" align="left"> '.$row['seccionid'].' </td>
                          <td width="30" align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['idperter'].'" value="S"> </td>';
            }

            $cont.=' </tbody>
                    </table>
                    <table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="261"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="222"> &nbsp; </td>
                     </tr>
                    </table>                
                    <br>
                    <center>
                    <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar"></a>
                    </form>
                    <a href="calculoliquidados.php?opcion=ventanaactdatos" ><input type="button" value="ATRAS" class="button red"></a>
                    <a href="calculoliquidados.php?opcion=duplicatercerosactual"><input type="button" value="SIGUIENTE" class="button blue"></a>';
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarperiodoterceros
    // Creación: 10/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para eliminar físicamente los registros de la tabla 
    //              periodoterceros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarperiodoterceros")
    {
        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT idperter FROM periodoterceros";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result)) 
        {
            if($_POST['LIN-'.$row['idperter']] == "S")
            {
                $lista.= $row['idperter'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // Elimino los registros
        $vsql2 = "DELETE FROM periodoterceros WHERE idperter IN (".$lista.")";
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli registros eliminados exitosamente");
        else
            $clase->Aviso(3,"No se eliminaron los registros");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=duplicaperiodoterceros");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vercompletos
    // Creación: 10/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que permite ver los registros duplicados completos con todos los 
    //              campos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vercompletos")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Consulta de la ventana
        $vsql = "SELECT pt.*, 
                        (SELECT COUNT(*) 
                           FROM periodoterceros 
                          WHERE periodoterceros.pernominaid = ".$periodoid." 
                                AND periodoterceros.terid = pt.terid) AS numreg 
                   FROM periodoterceros pt 
                        INNER JOIN periodosnomina p ON (pt.pernominaid = p.periodoid) 
                  WHERE pt.pernominaid = ".$periodoid." 
                 HAVING numreg > 1 
               ORDER BY pt.terid";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant = mysql_num_rows($result);

        // Pinto la ventana
        $cont ='<form action="?opcion=duplicaperiodoterceros&periodoid='.$periodoid.'" method="POST" name="x">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <table width="1600">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><b> Registros duplicados en la tabla periodoterceros en el periodo <font color="blue">'.$descripcion.' </font></b> </td> 
                 </tr> 
                </table>';
               
        // Determino si hay registros duplicados para este periodo
        if($cant <= 0)
            $cont.='<table width="1600"> <center><h2> No existen registros duplicados en la tabla periodoterceros en este periodo </h2>';
        else
        {
            $cont.='<table width="1600">
                     <tr class="TituloTabla">
                      <td width="10" align="center"> &nbsp; </td>
                      <td width="100" align="left"> idperter </td>
                      <td width="120" align="left"> pernominaid </td>
                      <td width="120" align="left"> terid </td>
                      <td width="100" align="left"> esempleado </td>
                      <td width="140" align="left"> esempleadoactivo </td>
                      <td width="120" align="left"> extralegal </td>
                      <td width="80" align="left"> areaid </td>
                      <td width="80" align="left"> seccionid </td>
                      <td width="80" align="left"> cargoid </td>
                      <td width="80" align="left"> bancoid </td>
                      <td width="110" align="left"> numcuenta </td>
                      <td width="90" align="left"> fecingreso </td>
                      <td width="120" align="left"> basico </td>
                      <td width="80" align="left"> codvende </td>
                      <td width="110" align="left"> dni </td>
                      <td width="220" align="left"> nombre </td>
                      <td width="80" align="left"> epsid </td>
                      <td width="80" align="left"> pensionesid </td>
                     </tr>';

            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
                        
                $cont.=' <td width="10" align="center"> &nbsp; </td>
                         <td width="100" align="left"> '.$row['idperter'].' </td>
                         <td width="120" align="left"> '.$row['pernominaid'].' </td>
                         <td width="120" align="left"> '.$row['terid'].' </td>
                         <td width="100" align="left"> '.$row['esempleado'].' </td>
                         <td width="140" align="left"> '.$row['esempleadoactivo'].' </td>
                         <td width="120" align="left"> '.$row['extralegal'].' </td>
                         <td width="80" align="left"> '.$row['areaid'].' </td>
                         <td width="80" align="left"> '.$row['seccionid'].' </td>
                         <td width="80" align="left"> '.$row['cargoid'].' </td>
                         <td width="80" align="left"> '.$row['bancoid'].' </td>
                         <td width="110" align="left"> '.$row['numcuenta'].' </td>
                         <td width="90" align="left"> '.$row['fecingreso'].' </td>
                         <td width="120" align="left"> '.number_format($row['basico']).' </td>
                         <td width="80" align="left"> '.$row['codvende'].' </td>
                         <td width="110" align="left"> '.$row['dni'].' </td>
                         <td width="220" align="left"> '.substr($row['nombre'],0,30).' </td>
                         <td width="80" align="left"> '.$row['epsid'].' </td>
                         <td width="80" align="left"> '.$row['pensionesid'].' </td>
                        </tr>';
            }
        }

        $cont.='</table><br><center><input type="submit" value="aceptar" class="button blue"></form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: selpersaldobase
    // Creación: 29/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para seleccionar el periodo a corregir la 
    //              diferencia el saldo/base y el sueldo básico
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "selpersaldobase")
    {
        // Preparo el combo de periodos
        $params = ' class="Texto11" ';

        $vsqlcomboperiodo  = "SELECT periodoid, descripcion
                                FROM periodosnomina 
                               WHERE cerrado = 'CHECKED' OR calculado = 'CHECKED'
                            ORDER BY periodoid ASC";

        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/remisionessal.png" width="32" height="32" border="0"> </td> 
                  <td width="840"> <b> Corregir saldos/base en sueldo por periodos </b> </td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<form action="?opcion=ventcorregirsaldobase" method="POST" name="x" target="_blank">                 
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Periodo: </td>
                  <td width="120"> '.$clase->CrearComboBuscar("periodoid",$vsqlcomboperiodo,"descripcion","periodoid","","N",$params,400).' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>';

        // botón aceptar
        $cont.='<table width="100%">
                 <tr class="BarraDocumentos"> 
                  <td width="260"> &nbsp; </td> 
                  <td width="100" alling="center">
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventcorregirsaldobase
    // Creación: 29/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que muestra los empleados con diferencia en el saldo/base y 
    //              sueldo en el periodo seleccionado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventcorregirsaldobase")
    {
        $periodoid = $_POST['periodoid'];

        if(strlen($periodoid) == 0)
            $periodoid = $_GET['periodoid'];

        $cerrado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','cerrado');
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Construyo la consulta según sea el caso
        if($cerrado == "CHECKED")
            $vsql = "SELECT d.detalleid, t.dni, t.nombre AS nombreemp, 
                            d.devengados, d.saldo, t.basico, d.terid  
                       FROM hisdetallenomina d 
                            INNER JOIN periodoterceros t ON (d.terid = t.terid AND d.pernominaid = t.pernominaid) 
                      WHERE d.pernominaid = ".$periodoid." 
                            AND d.conceptoid = 1 
                            AND d.saldo <> t.basico";
        else
            $vsql = "SELECT d.detalleid, t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                            d.devengados, d.saldo, t.basico, d.terid  
                       FROM detallenomina d 
                            INNER JOIN tercerosactual t ON (d.terid = t.terid)
                      WHERE d.pernominaid = ".$periodoid." 
                            AND d.conceptoid = 1 
                            AND d.saldo <> t.basico";
        
        $conex = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $cant = mysql_num_rows($result);

        if($cant == 0)
        {
            $clase->Aviso(2,"No existen diferencias en este periodo $descripcion");
            header("Location: calculoliquidados.php?opcion=selpersaldobase");
        }
        else
        {
            // Uso variable de sesión para guardar la consulta
            $_SESSION['SQL_DIFERENCIASSALDO'] = $vsql;

            // Pinto la ventana
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/remisionessal.png" width="32" height="32" border="0"> </td>
                      <td width="535"> <b>Diferencias en saldo/base y básico en el periodo <br> <font color="blue"> '.$descripcion.' </font></b> </td>
                      <td width="20"> &nbsp; </td>
                      <td width="20" aling="center">
                       <a href="?opcion=corregirallsaldobase&periodoid='.$periodoid.'" target="_blank">
                        <img src="images/iconos/reconciliar.png" width="32" height="32" border="0" title="Corregir todas las diferencias de saldo/base con b&aacute;sico"> 
                       </a>
                      </td>
                      <td width="24"> <a href="calculoliquidados.php?opcion=selpersaldobase"><input type="button" value="<<" class="button"></a> </td>
                     </tr>
                    </table>';

            // títulos
            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                       <td width="20"> &nbsp; </td>
                       <td width="110" align="left"> C&eacute;dula </td>
                       <td width="320" align="left"> Nombre </td>			
                       <td width="340" align="right"> Devengado </td>
                       <td width="260" align="right"> Saldo/base </td>	
                       <td width="290" align="right"> B&aacute;sico </td>
                       <td width="50"> &nbsp; </td>
                       <td width="60"> &nbsp; </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:690px; overflow-Y:scroll">';

            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';

                $detalleid = $row['detalleid'];
                $basico = $row['basico'];
                $terid = $row['terid'];
                
                $cont.=' <td width="20"> &nbsp; </td>
                         <td width="110" align="left"> '.$row['dni'].' </td>
                         <td width="320" align="left"> '.$row['nombreemp'].' </td>			
                         <td width="360" align="right"> '.number_format($row['devengados']).' </td>
                         <td width="280" align="right"> <font color="red">'.number_format($row['saldo']).'</font> </td>	
                         <td width="290" align="right"> <font color="blue">'.number_format($row['basico']).'</font> </td>
                         <td width="40" align="center"> 
                          <a href="?opcion=corregirsaldobaseindividual&detalleid='.$detalleid.'&basico='.$basico.'&cerrado='.$cerrado.'&periodoid='.$periodoid.'&terid='.$terid.'" target="_blank">
                           <img src="images/basicas/actualizar.png" title="corregir diferencia" border="0">
                          </a>
                         </td>
                         <td width="30" align="center">
                          <a href="recibodepago.php?opcion=reciboindividual&terid='.$terid.'&periodoid='.$periodoid.'" target="_blank">
                           <img src="images/basicas/pdf.png" title="tira de pago" border="0">
                          </a>
                         </td>
                        </tr>';
            }

            $cont.=' </tbody>
                    </table>';

            // Totales
            $cont.='<table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="20"> &nbsp; </td>
                      <td width="1588" align="left"> <font color="WHITE"> <b> Total diferencias: </b> '.number_format($i).' </b> </font> </td>
                     </tr>
                    </table>';
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: corregirsaldobaseindividual
    // Creación: 29/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que guarda la corrección del campo saldo de la tabla 
    //              correspondiente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "corregirsaldobaseindividual")
    {
        $detalleid = $_GET['detalleid'];
        $basico = $_GET['basico'];
        $cerrado = $_GET['cerrado'];
        $periodoid = $_GET['periodoid'];
        $terid = $_GET['terid'];
        
        if($cerrado == "CHECKED")
        {
            $vsql = "UPDATE hisdetallenomina SET saldo = ".$basico." WHERE detalleid = ".$detalleid;
            $clase->EjecutarSQL($vsql);

            // Corrijo en la tabla detallenomina
            $vsql2 = "SELECT detalleid AS detalleidant FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
            $detalleidant = $clase->SeleccionarUno($vsql2);

            $vsql3 = "UPDATE detallenomina SET saldo = ".$basico." WHERE detalleid = ".$detalleidant;
            $clase->EjecutarSQL($vsql3);
        }
        else
        {
            $vsql = "UPDATE detallenomina SET saldo = ".$basico." WHERE detalleid = ".$detalleid;
            $clase->EjecutarSQL($vsql);
        }

        // Emito el mensaje correspondiente
        $clase->Aviso(1,"Proceso culminado satisfactoriamente");

        // Redireccciono el formulario
        header("Location: calculoliquidados.php?opcion=ventcorregirsaldobase&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: corregirallsaldobase
    // Creación: 30/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que corrige todas las diferencias saldo/base y básico en un 
    //              periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "corregirallsaldobase")
    {
        $periodoid = $_GET['periodoid'];
        $vsql = $_SESSION['SQL_DIFERENCIASSALDO'];
        
        $i = 0;
        $conex = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $detalleid = $row['detalleid'];
            $basico = $row['basico'];
            $terid = $row['terid'];

            // Corrijo en el historial
            $vsql4 = "UPDATE hisdetallenomina SET saldo = ".$basico." WHERE detalleid = ".$detalleid;
            $clase->EjecutarSQL($vsql4);

            // Corrijo en la tabla detallenomina
            $vsql2 = "SELECT detalleid AS detalleidant FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
            $detalleidant = $clase->SeleccionarUno($vsql2);

            $vsql3 = "UPDATE detallenomina SET saldo = ".$basico." WHERE detalleid = ".$detalleidant;
            $clase->EjecutarSQL($vsql3);
        }

        // Emito el mensaje correspondiente
        $clase->Aviso(1,"Proceso culminado satisfactoriamente");
        
        // Redireccciono el formulario
        header("Location: calculoliquidados.php?opcion=selpersaldobase");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrarprimasterceros
    // Creación: 28/12/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que filtra la ventana duplicadosprimasterceros mediante un  
    //              periodo seleccionado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarprimasterceros")
    {
        $codperiodo = $_POST['codperiodo'];
        $tipo  = $_POST['tipo'];	        
        header("Location: calculoliquidados.php?opcion=duplicadosprimasterceros&codperiodo=$codperiodo&tipo=$tipo");
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: duplicadosprimasterceros
    // Creación: 28/12/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana donde se muestran los registros duplicados 
    //              de la tabla primasterceros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "duplicadosprimasterceros")
    {
	    // Control de Permisos
	    if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            $codperiodo = $_GET['codperiodo'];
            $tipo = $_GET['tipo'];

            if(strlen($codperiodo) == 0)
                $codperiodo = $_POST['codperiodo'];

            if(strlen($tipo) == 0)
                $tipo = $_POST['tipo'];
    
            // año actual
            $yeartoday = date("Y");
            $yearprev = $yeartoday - 1;

            // Combo de Periodos
            $vsqlcombo = "SELECT * FROM periodos WHERE anoperiodo = ".$yeartoday." OR codperiodo = '12$yearprev' ORDER BY orden DESC";
            $params    = ' class="Texto11" style="width:140px;height:25px" OnChange="x.submit();"';
            
            // Pintamos la ventana
            $cont = $clase->Header("S","W");
            $cont.='<form action="?opcion=filtrarprimasterceros" method="POST" name="x">
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                      <td width="760"> <b>Registros duplicados </b> <font color="blue"> <br>en la tabla primasterceros </font> </td>
                      <td width="10"> &nbsp; </td>
                      <td width="20">
                       <a href="?opcion=vercompletosprimasterceros&codperiodo='.$codperiodo.'&tipo='.$tipo.'" title="registros completos" rel="facebox">
                        <img src="images/iconos/notas.png" border="0" width="38" height="38">
                       </a>
                      </td>
                      <td width="20"> &nbsp; </td>
                      <td width="280"> periodo: '.$clase->CrearComboEsp("codperiodo",$vsqlcombo,"codperiodo","nomperiodo",$codperiodo,"N",$params).' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="200"> 
                       <label class="Texto12"> tipo: </label>
                       <select name="tipo" id="tipo" style="width:120px;height:25px" OnChange="x.submit();">';
    
            if(($tipo=="")||($tipo=="vacaciones"))
                $cont.=' <option value="vacaciones" selected> Vacaciones </option> 
                         <option value="cesantias"> Cesant&iacute;as </option>
                         <option value="primas"> Primas </option>
                         <option value="indemnizacion"> Indemnizaci&oacute;n </option>';
    
            if($tipo=="cesantias")
                $cont.=' <option value="vacaciones"> Vacaciones </option> 
                         <option value="cesantias" selected> Cesant&iacute;as </option>
                         <option value="primas"> Primas </option>
                         <option value="indemnizacion"> Indemnizaci&oacute;n </option>';
    
            if($tipo=="primas")
                $cont.=' <option value="vacaciones"> Vacaciones </option> 
                         <option value="cesantias"> Cesant&iacute;as </option>
                         <option value="primas" selected> Primas </option>
                         <option value="indemnizacion"> Indemnizaci&oacute;n </option>';
    
            if($tipo=="indemnizacion")
                $cont.=' <option value="vacaciones"> Vacaciones </option> 
                         <option value="cesantias"> Cesant&iacute;as </option>
                         <option value="primas"> Primas </option>
                         <option value="indemnizacion" selected> Indemnizaci&oacute;n </option>';
    
            $cont.='   </select>
                       </form>
                      </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';            

            // $cont.= permisosespeciales(11);

            $cont.= permisosespecialesdos(2);            

            $cont.='<script language="javascript">
                    <!--
                        function seleccionar_todo()
                        { 
                            valor = document.f2.todos.checked;
                            if(valor)
                                marcartodo();
                            else
                                desmarcartodo();
                        } 

                        function marcartodo()
                        {
                            for (i=0;i<document.f2.elements.length;i++) 
                            if(document.f2.elements[i].type == "checkbox")  
                            document.f2.elements[i].checked = 1;
                        }

                        function desmarcartodo()
                        {
                            for (i=0;i<document.f2.elements.length;i++) 
                            if(document.f2.elements[i].type == "checkbox") 
                                document.f2.elements[i].checked = 0;
                        }  
                    -->
                    </script>            
                    <script type="text/javascript" src="lib/sorttable.js"></script> 
                    <form action="calculoliquidados.php?opcion=eliminarprimasterceros" method="POST" name="f2">
                    <table width="100%" class="sortable">
                     <thead>
                      <tr class="TituloTabla" style="display:block; padding-top:5px;height:25px;"> 
                       <th width="10"> &nbsp; </th>
                       <th width="80" align="left">idpriter</th>
                       <th width="80" align="left"> tipo </th>
                       <th width="120" align="left"> periodonomina </th>
                       <th width="80" align="left"> terid </th>		                       
                       <th width="110" align="left"> esempleado </th>                       
                       <th width="150" align="left"> esempleadoactivo </th>							 
                       <th width="320" align="left"> nombre </th>
                       <th width="75" align="left"> areaid </th>				 
                       <th width="90" align="left"> seccionid </th>                       
                       <th width="45" align="left"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo();"> </th>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';

            // Consulta de los registros duplicados
            $vsql = "SELECT l.*,
                            (SELECT COUNT(*) 
                               FROM primasterceros 
                              WHERE primasterceros.terid = l.terid 
                                    AND primasterceros.periodonomina = '".$codperiodo."' 
                                    AND primasterceros.tipo = '".$tipo."') AS numreg, 
                            CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                            t.dni        
                       FROM primasterceros l
                            INNER JOIN terceros t ON (l.terid = t.terid)
                      WHERE l.periodonomina = '".$codperiodo."' 
                            AND l.tipo = '".$tipo."'
                     HAVING numreg > 1
                   ORDER BY l.terid";

            $i = 0;
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
                    
                $cont.=' <td width="10"> &nbsp; </td>
                         <td width="80" align="left"> '.$row['idpriter'].' </td>
                         <td width="85" align="left"> '.$row['tipo'].' </td>
                         <td width="130" align="left"> '.$row['periodonomina'].' </td>
                         <td width="75" align="left"> '.$row['terid'].' </td>
                         <td width="115" align="left"> '.$row['esempleado'].' </td>
                         <td width="160" align="left"> '.$row['esempleadoactivo'].' </td>
                         <td width="295" align="left"> 
                          <b> '.substr($row['nombre'],0,30).' </b>
                          <br> c&eacute;dula: <span> <font color="#CC66FF"> '.$row['dni'].' </font> </span>
                         </td>
                         <td width="75" align="left"> '.$row['areaid'].' </td>
                         <td width="90" align="left"> '.$row['seccionid'].' </td>
                         <td width="30" align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['idpriter'].'" value="S"> </td>
                        </tr>';
            }
    
            $cont.=' </tbody>
                    </table>
                    <table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="261"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="222"> &nbsp; </td>
                     </tr>
                    </table>                
                    <br>
                    <center>
                    <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar"></a>
                    </form>
                    <a href="calculoliquidados.php?opcion=duplicados" ><input type="button" value="ATRAS" class="button red"></a>';
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarprimasterceros
    // Creación: 28/12/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para eliminar físicamente los registros de la tabla 
    //              primasterceros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarprimasterceros")
    {
        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT idpriter FROM primasterceros";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result)) 
        {
            if($_POST['LIN-'.$row['idpriter']] == "S")
            {
                $lista.= $row['idpriter'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // Elimino los registros
        $vsql2 = "DELETE FROM primasterceros WHERE idpriter IN (".$lista.")";        
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli registros eliminados exitosamente");
        else
            $clase->Aviso(3,"No se eliminaron los registros");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=duplicados");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vercompletosprimasterceros
    // Creación: 28/12/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que permite ver los registros duplicados completos con todos los 
    //              campos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vercompletosprimasterceros")
    {
        $codperiodo = $_GET['codperiodo'];
        $tipo = $_GET['tipo'];
        
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Consulta de los registros duplicados
        $vsql = "SELECT l.*,
                        (SELECT COUNT(*) 
                            FROM primasterceros 
                           WHERE primasterceros.terid = l.terid 
                                 AND primasterceros.periodonomina = '".$codperiodo."' 
                                 AND primasterceros.tipo = '".$tipo."') AS numreg, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                        t.dni        
                   FROM primasterceros l
                        INNER JOIN terceros t ON (l.terid = t.terid)
                  WHERE l.periodonomina = '".$codperiodo."' 
                        AND l.tipo = '".$tipo."'
                 HAVING numreg > 1
               ORDER BY l.terid";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant = mysql_num_rows($result);

        // Pinto la ventana
        $cont ='<form action="?opcion=duplicadosprimasterceros" method="POST" name="x">
                <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                <input type="hidden" name="tipo" value="'.$tipo.'">
                <table width="1700">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Registros duplicados en la tabla primasterceros en el periodo <font color="blue"> '.$desperiodo.' </font> </b> </td> 
                 </tr> 
                </table>';

        // Determino si hay registros duplicados para este periodo
        if($cant <= 0)
            $cont.='<table width="1700"> <center><h2> No existen registros duplicados en la tabla primasterceros en este periodo </h2>';
        else
        {
            $cont.='<table width="1700">
                     <tr class="TituloTabla">
                      <td width="10" align="center"> &nbsp; </td>
                      <td width="100" align="left"> idpriter </td>
                      <td width="120" align="left"> tipo </td>
                      <td width="120" align="left"> periodonomina </td>
                      <td width="100" align="left"> terid </td>
                      <td width="120" align="left"> esempleado </td>
                      <td width="140" align="left"> esempleadoactivo </td>
                      <td width="80" align="left"> extralegal </td>
                      <td width="80" align="left"> areaid </td>
                      <td width="80" align="left"> seccionid </td>
                      <td width="80" align="left"> cargoid </td>
                      <td width="90" align="left"> bancoid </td>
                      <td width="110" align="left"> numcuenta </td>
                      <td width="120" align="left"> fecingreso </td>
                      <td width="80" align="left"> basico </td>
                      <td width="110" align="left"> codvende </td>
                      <td width="180" align="left"> dni </td>
                      <td width="120" align="left"> nombre </td>
                      <td width="80" align="left"> epsid </td>
                      <td width="80" align="left"> pensionesid </td>
                     </tr>';

            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
                        
                $cont.=' <td width="10" align="center"> &nbsp; </td>
                         <td width="100" align="left"> '.$row['idpriter'].' </td>
                         <td width="120" align="left"> '.$row['tipo'].' </td>
                         <td width="120" align="left"> '.$row['periodonomina'].' </td>
                         <td width="100" align="left"> '.$row['terid'].' </td>
                         <td width="130" align="left"> '.$row['esempleado'].' </td>
                         <td width="130" align="left"> '.$row['esempleadoactivo'].' </td>
                         <td width="80" align="left"> '.$row['extralegal'].' </td>
                         <td width="80" align="left"> '.$row['areaid'].' </td>
                         <td width="80" align="left"> '.$row['seccionid'].' </td>
                         <td width="80" align="left"> '.$row['cargoid'].' </td>
                         <td width="90" align="left"> '.$row['bancoid'].' </td>
                         <td width="110" align="left"> '.$row['numcuenta'].' </td>
                         <td width="90" align="left"> '.$row['fecingreso'].' </td>
                         <td width="120" align="left"> '.number_format($row['basico']).' </td>
                         <td width="80" align="left"> '.$row['codvende'].' </td>
                         <td width="70" align="left"> '.$row['dni'].' </td>
                         <td width="260" align="left"> '.substr($row['nombre'],0,30).' </td>
                         <td width="80" align="left"> '.$row['epsid'].' </td>
                         <td width="80" align="left"> '.$row['pensionesid'].' </td>
                        </tr>';
            }
        }

        $cont.='</table><br><center><input type="submit" value="aceptar" class="button blue"></form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaverjson
    // Creación: 12/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para seleccionar el empleado y el periodo 
    //              al cual se le consultará el json de nómina electrónica
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaverjson")
    {
        // configuración de los combos
        $params = ' class="Texto11" ';

        // consulta de empleados
		$vsqlcomboemp = "SELECT dni, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";
        
        // combo de empleados
        $comboempleado = $clase->CrearComboBuscar("dni",$vsqlcomboemp,"nombres","dni","","S",$params,550);

        // consulta de periodos reportados a la dian
        $vsqlperiododian = "SELECT pd.periodonomina, p.desperiodo FROM periododian pd INNER JOIN periodos p ON (pd.periodonomina = p.codperiodo)";

        // combo de periodos de periodos reportados a la dian
        $comboperiododian = $clase->CrearComboBuscar("periodonomina",$vsqlperiododian,"desperiodo","periodonomina","","S",$params,250);

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/vertodo.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b> Ver json <br> n&oacute;mina electr&oacute;nica </b> </td>
                  <td width="20">
                   <a href="calculoliquidados.php?opcion=ventanaactdatos">
                    <input type="button" value="<<" class="button">
                   </a> 
                  </td>
                  <td width="20"> &nbsp; </td>
                 </tr>
                </table>';

        // selección de empleado y periodo
        $cont.='<form action="?opcion=verjsonempleado" method="POST" name="x" rel="facebox">
                <table width="100%">
                 <tr class="BarraDocumentos">
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="700"> <label class="Texto12"> Empleado: </label>
                   '.$comboempleado.'
                  </td>
                 </tr>
                 <tr class="BarraDocumentos"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="700"> <label class="Texto12"> Periodo: </label>
                   &nbsp;&nbsp;
                   '.$comboperiododian.'
                  </td>
                 </tr>
                </table>';

        // botón aceptar
        $cont.='<table width="100%">
                 <tr class="BarraDocumentos">
                  <td align="center">
                   <input type="submit" value="acaptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: verjsonempleado
    // Creación: 12/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para visualizar el archivo json de nómina electrónica
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "verjsonempleado")
    {
        $dni = $_POST['dni'];
        $periodonomina = $_POST['periodonomina'];

        // inicialización de variables
        $archivojson = "nominaelectronica/".$periodonomina."/".$dni.".json";
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE dni = '".$dni."'";
        $nombreemp = $clase->SeleccionarUno($vsql);
        $json = "";

        // Valido la existencia del archivo
        if(!file_exists($archivojson))
        {
            $desperiodo = $clase->BDLockup($periodonomina,'periodos','codperiodo','desperiodo');
            $clase->Aviso(3,"$nombreemp no laboró en el periodo $desperiodo");
            header("Location: calculoliquidados.php?opcion=ventanaverjson");
        }
        else
        {
            $plantilla = fopen($archivojson,"r") or die("error al leer archivo");
    
            // datos del json
            while(!feof($plantilla))
            {
                $plantillaFinal = fgets($plantilla);
                $plantillaFinal = nl2br($plantillaFinal);
                $json.= $plantillaFinal;
            }
            $json = trim(str_replace("<br />","",$json));
            
            // Pintamos la ventana
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/vertodo.png" width="32" height="32" border="0"> </td>
                      <td width="900"> <b> Ver json <br> n&oacute;mina electr&oacute;nica </b> </td>
                      <td width="20">
                       <a href="calculoliquidados.php?opcion=ventanaverjson">
                        <input type="button" value="<<" class="button">
                       </a> 
                      </td>
                      <td width="20"> &nbsp; </td>
                     </tr>
                    </table>';
    
            // datos del empleado
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <b> Archivo json de <br> <font color="blue"> '.$nombreemp.' </font> <br> en el periodo <font color="blue"> '.$periodonomina.' </font> </b> 
                      </td> 
                     </tr>
                    </table>';
    
            // impresión del json
            $cont.='<table width="100%">
                     <tr class="BarraDocumentos" style="height:50px;Important!">
                      <td align="center"> <textarea name="txt" cols="140" rows="38" disabled> '.$json.' </textarea> </td>
                     </tr>
                    </table>';
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarlicencia
    // Creación: 02/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar los datos de la novedad
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarlicencia")
    {
        $periodoid = $_GET['periodoid'];
        $terid = $_GET['terid'];

        // Nombre del periodo
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // // Variable para el nombre de empleado
        // $vsqldatos = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        // $nombreemp = $clase->SeleccionarUno($vsqldatos);
        // $vsqldatos = "";

        // Nombre del empleado
        $sqlnomemp = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                        FROM terceros 
                       WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($sqlnomemp);        

        // Combo de licencias
        $vsqlcombolic = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE eslicencia='CHECKED' ORDER BY conceptoid";

        // Configuración
        $params = ' class="Texto11" ';
        $dias = 1;

        // Fechas del periodo
        $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');        
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Liquidaci&oacute;n del periodo <font color="blue"> <br> '.$descripcion.' </font> <br> Novedades </td>                  
                  <td width="24"> &nbsp; </td>
                  <td width="24"> 
                   <a href="?opcion=ventanareprocesarliq&periodoid='.$periodoid.'&terid='.$terid.'"> <input type="button" value="<<" class="button"></a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=almlicencias" method="POST">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <input type="hidden" name="terid" value="'.$terid.'">
                 <fieldset style="width: 530px; height: 325px;" class="grupos">
                 <legend class="titgrupos"> Datos </legend>
                 <table width="350">
                  <tr height="55">
                   <td> 
                    <label class="Texto12"> <b>Empleado: </b></label><br>
                    <h2> '.$nombreemp.' </h2>
                   </td>                   
                  </tr>                    
                  <tr height="55">
                   <td> <label class="Texto12"> <b>Licencia:</b></label><br>'.$clase->CrearComboBuscar("conceptoid",$vsqlcombolic,"nombres","conceptoid","","N",$params,420).' </td>                   
                  </tr>
                  <tr height="55">
                   <td> ';

        $variab = 'G_NOFECHALIC';
        $nofechalic = $clase->BDLockup($variab,'configuraciones','variab','contenido');

        if($nofechalic == "CHECKED")
            $cont.=' <label class="Texto12"> <b><font color="gray">Fecha desde:</label></b></label><br> 
                     <input type="date" name="fecdesde" class="Texto12New" autocomplete="off" value = "'.$fecdesde.'" disabled>';
        else
            $cont.=' <label class="Texto12"> <b>Fecha desde:</b></label><br>
                     <input type="date" name="fecdesde" class="Texto12New" autocomplete="off" min="'.$fecdesde.'" max = "'.$fechasta.'">';

        $cont.='    </td>                   
                  </tr>
                  <tr height="55">
                  <td> <label class="Texto12"> <b>D&iacute;as:</b></label><br>
                   <input type="number" name="dias" min="1" max="180" class="Texto12New" size="12" autocomplete="off" title="días de la licencia" value="'.$dias.'"> 
                  </td>                   
                 </tr>
                 <tr height="55">
                  <td align="center"><br><br> 
                   <input type="submit" value="guardar" class="button blue"> 
                  </td>
                 </tr>
                </table>
                </form>
                <br><br>
                </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: almlicencias
    // Creación: 02/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena la licencia ejecutando todos los cálculos 
    //              correspondientes
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "almlicencias")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $dias = $_POST['dias'];
        $conceptoid = $_POST['conceptoid'];
        $fecdesde = $_POST['fecdesde'];

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Inicialización de variables
        $valorperiodo = 0;
        $valorconcepto = 0;
        $diff = 0;
        $difendias = 0;
        $diaspendiente = 0;

        $lbpendiente = false;
        $periodoapagar = 0;
        $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

        // Calculo la diferencia en días
        $fecha1= new DateTime($fecdesde);
        $fecha2= new DateTime($fechasta);
        $diff = $fecha1->diff($fecha2);
        
        $difendias = $diff->days;
        $difendias += 1;

        // ---------------------------------------------------------------------- //
        $suma = "+".strval($dias-1)." day";
        $date_fin = strtotime(".$suma.", strtotime($fecdesde));
        $date_fin = date('Y-m-d', $date_fin);
        
        if($date_fin > $fechasta)
        {
            // ---------------------------------------------------------------------- //
            // Aquí guardo en la tabla correspondiente el exceso en días
            // para ser calculado en próximos periodos
            $diaspendiente = $dias - $difendias;

            // --------------------------------------------------------------------------------------------------------- //
            $feciniper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
            $diadesde = substr($feciniper, -2);

            if($diadesde=="16")
            {
                $fecfinper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                $fechaEntera = strtotime($fecfinper);
                $valdias = date("d", $fechaEntera);

                if($valdias=="28")
                    $diaspendiente -= 2;

                if($valdias=="29")
                    $diaspendiente -= 1;

                if($valdias=="31")
                    $diaspendiente += 1;
            }
            // --------------------------------------------------------------------------------------------------------- //

            $dias -= $diaspendiente;

            $procesado = "";
            $vsql = "SELECT periodoid 
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE periodoid > $periodoid)";
            $periodoapagar = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO licenciaspendiente (terid,conceptoid,dias,periodoapagar,procesado) 
                                             VALUES (".$terid.",".$conceptoid.",".$diaspendiente.",".$periodoapagar.",'".$procesado."')";
            $clase->EjecutarSQL($vsql);
            $lbpendiente = true;
        }

        // Inicializo las variables
        $basico = 0;                            $formulabasico = "";                            $diastrab = 0;
        $detalleid = 0;                         $sueldo = 0;                                    $numid = 0;
        $licencianorem = 0;                     $formulatransporte = "";                        $subsidiotransporte = 0;
        $lbpaso = false;                        $formulasuspencion = "";                        $suspension = 0;
        $formulaincapacidad = "";               $incapacidad = 0;                               $formulapaternidad = "";
        $paternidad = 0;                        $totnovedades = 0;                              $sueldostr = "";
        $centenas = "";                         $centenasnum = 0;                               $sueldodeducciones = 0;
        $formulapension = "";                   $pension = 0;                                   $detalleid = 0;
        $formulasalud = "";                     $salud = 0;

        // Obtengo el salario básico del empleado
        $vsqldatos = "SELECT basico FROM terceros WHERE terid = ".$terid;
        $basico = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Obtengo la formula del sueldo
        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
        $formulabasico = $clase->SeleccionarUno($vsql);        

        // Obtengo los días trabajados en el periodo
        $vsql = "SELECT valor
                   FROM detalleliquidacion  
                  WHERE conceptoid = 1  
                        AND pernominaid = ".$periodoid."
                        AND terid = ".$terid."";
        $diastrab = $clase->SeleccionarUno($vsql);

        // Obtengo el ID del registro que se modificará
        $vsql = "SELECT detalleid
                   FROM detalleliquidacion  
                  WHERE conceptoid = 1  
                        AND pernominaid = ".$periodoid."
                        AND terid = ".$terid."";
        $detalleid = $clase->SeleccionarUno($vsql);
        
        $diastrab -= $dias;

        eval("\$sueldo = $formulabasico;");
        $sueldo = round($sueldo,0);

        // Almaceno en nuevo sueldo
        $vsql = "UPDATE detalleliquidacion SET 
                        devengados = ".$sueldo.", 
                        valor = ".$diastrab."
                  WHERE detalleid = ".$detalleid."";
        $clase->EjecutarSQL($vsql);        

        // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
        // Calculo el nuevo ID
        $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
        $numid = $clase->SeleccionarUno($vsql);
        $numid++;

        // Inserto la nueva licencia

        // Obtengo la formula de la licencia
        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
        $formulalice = $clase->SeleccionarUno($vsql);

        // Calculo la licencia
        if($conceptoid!=10)
        {
            eval("\$montolicencia = $formulalice;");
            $montolicencia = round($montolicencia,0);
        }
        else
        {
            // Calculo la incapacidad

            // Obtengo el salario mínimo legal vigente
            $smlv = $_SESSION['N_SALMIN2020'];

            // Valido si el sueldo básico sea menor al salario mínimo legal vigente
            if($basico<=$smlv)
            {
                $montolicencia = ($smlv*$dias)/30;
                $montolicencia = round($montolicencia,0);
            }
            else
            {
                $porcbasico = ($basico*66.67)/100;
                $porcbasico = round($porcbasico,0);

                // Calculo la incapacidad si el básico sea mayor al mínimo
                if($porcbasico>$smlv)
                {
                    $montolicencia = ($porcbasico*$dias)/30;
                    $montolicencia = round($montolicencia,0);
                }
                else
                {
                    if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                    if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                    $montolicencia = round($montolicencia,0);
                }
            }
        }

        // ------------------------------------------------------------------------------------------------------------------- //
        // Obtengo el tipo de licencia
        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

        // en detallenomina

        // ------------------------------------------------------------------------------------------------------------------- //
        // Determino si el registro existe para modificarlo o incluirlo
        $vsql = "SELECT COUNT(*) AS repetida 
                   FROM detalleliquidacion
                  WHERE pernominaid = ".$periodoid."
                        AND conceptoid = ".$conceptoid."
                        AND terid = ".$terid."";
        $repetida = $clase->SeleccionarUno($vsql);

        // ------------------------------------------------------------------------------------------------------------------- //
        if($repetida==0)
        {
            if($tipodc=="C")
                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
            else
                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
        }
        else
        {
            // Determino el id del registro
            $vsql = "SELECT detalleid AS detalleid 
                       FROM detalleliquidacion
                      WHERE pernominaid = ".$periodoid."
                            AND conceptoid = ".$conceptoid."
                            AND terid = ".$terid."";
            $detalleid = $clase->SeleccionarUno($vsql);

            $valor = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','valor');
            $valor += $dias;

            // Actualizo la licencia
            if($tipodc=="C")
            {
                $devengados = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','devengados');
                $devengados += $montolicencia;
                
                $vsql = "UPDATE detalleliquidacion SET 
                                devengados = ".$devengados.", 
                                valor = ".$valor."
                          WHERE detalleid = ".$detalleid."";
            }
            else
            {
                $descuentos = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','descuentos');
                $descuentos += $montolicencia;

                $vsql = "UPDATE detalleliquidacion SET 
                                descuentos = ".$descuentos.", 
                                valor = ".$valor."
                          WHERE detalleid = ".$detalleid."";
            }
        }
        $clase->EjecutarSQL($vsql);

        // ---------------------------------------------------------------------------------------------------------- //
        // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos

        // Obtengo el salario mínimo legal vigente
        $smlv = $_SESSION['N_SALMIN2020'];

        // Obtengo el cargo del empleado
        $vsqldatos = "SELECT cargoid FROM terceros WHERE terid = ".$terid;
        $cargoid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Obtengo el control del cálculo de subsidio de transporte
        $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');

        // Variable para la validación del auxilio de transporte
        $valsubtrasp = $smlv * 2;        

        if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
        {
            // Obtengo el ID del registro que se modificará
            $vsql = "SELECT detalleid
                       FROM detalleliquidacion 
                      WHERE conceptoid = 3  
                            AND pernominaid = ".$periodoid."
                            AND terid = ".$terid."";
            $detalleid = $clase->SeleccionarUno($vsql);

            // Obtengo la formula del subsidio de transporte
            $auxtrans = $_SESSION['N_AUXTRANS2020'];
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
            $formulatransporte = $clase->SeleccionarUno($vsql);

            eval("\$subsidiotransporte = $formulatransporte;");
            $subsidiotransporte = round($subsidiotransporte,0);
        }
        else
            $subsidiotransporte = 0;

        // ID transporte
        $vsql = "SELECT detalleid AS idtransporte FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
        $idtransporte = $clase->SeleccionarUno($vsql);

        // Grabo el subsidio de transporte
        if($idtransporte!="")
            $vsql = "UPDATE detalleliquidacion SET 
                            devengados = ".$subsidiotransporte.",
                            valor = ".$diastrab."
                      WHERE detalleid = ".$idtransporte."";
        else
        {
            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$auxtrans)";
        }
        $clase->EjecutarSQL($vsql);        
        
        // Obtengo el total devengado por novedades
        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                   FROM detalleliquidacion d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
        $totnovedades = $clase->SeleccionarUno($vsql);

        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
        $totrecargos = $clase->SeleccionarUno($vsql);

        // Actualizo el sueldo
        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

        // Determino si es extralegal
        $vsqldatos = "SELECT extralegal FROM terceros WHERE terid = ".$terid;
        $extralegal = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Determino la eps
        $vsqldatos = "SELECT epsid FROM terceros WHERE terid = ".$terid;
        $epsid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Fondo de pensiones
        $vsqldatos = "SELECT pensionesid FROM terceros WHERE terid = ".$terid;
        $pensionesid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";
        
        if($epsid==NULL)                $epsid=0;
        if($pensionesid==NULL)          $pensionesid=0;

        $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
        $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

        if($extralegal=="CHECKED")
        {
            $pension = 0;
            $salud = 0;
        }
        else
        {
            // Recalculo pensión y salud
            if(($pensionesid==5)||($aplicapension!="CHECKED"))
                $pension = 0;
            else
            {
                // Obtengo la formula para el descuento por pensión
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                $formulapension = $clase->SeleccionarUno($vsql);

                // Calculo la pensión
                eval("\$pension = $formulapension;");
                $pension = round($pension,0);
            }

            if(($epsid==37)||($aplicasalud!="CHECKED"))
                $salud = 0;
            else
            {
                // Obtengo la formula para el descuento de salud
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                $formulasalud = $clase->SeleccionarUno($vsql);
                
                // Calculo la salud
                eval("\$salud = $formulasalud;");
                $salud = round($salud,0);
            }
        }

        //  ID pensión
        $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
        $idpension = $clase->SeleccionarUno($vsql);

        // Grabo la pensión
        if($idpension!="")
            $vsql = "UPDATE detalleliquidacion SET 
                            descuentos = ".$pension.",
                            saldo = ".$sueldodeducciones."
                      WHERE detalleid = ".$idpension."";
        else
        {
            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
        }
        $clase->EjecutarSQL($vsql);

        // ID salud
        $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
        $idsalud = $clase->SeleccionarUno($vsql);

        // Grabo la salud
        if($idsalud!="")
            $vsql = "UPDATE detalleliquidacion SET 
                            descuentos = ".$salud.",
                            saldo = ".$sueldodeducciones."
                      WHERE detalleid = ".$idsalud."";
        else
        {
            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
        }
        $clase->EjecutarSQL($vsql);

        // ----------------------------------------------------------------------------------------------------------- //
        // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
        $vsql = "DELETE FROM detalleliquidacion WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid =".$periodoid;
        $clase->EjecutarSQL($vsql);

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=ventanareprocesarliq&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaelimconp
    // Creación: 02/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para seleccionar el concepto que se 
    //              eliminará
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaelimconp")
    {
        $listaperiodos = $_GET['listaperiodos'];
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];

        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        
        // Nombre del periodo
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if(strlen($nombreemp) == 0)
        {
            $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) nombreemp FROM terceros WHERE terid = ".$terid;
            $nombreemp = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";            
        }

        // Consulta para los conceptos
        $vsqlcombocon = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) 
                           FROM conceptosnomina 
                          WHERE eslicencia='CHECKED' 
                                OR eslibranza ='CHECKED' 
                                OR montoocasional ='CHECKED' 
                                OR montopermanente ='CHECKED' 
                       ORDER BY conceptoid";

        // Configuración
        $params = ' class="Texto11" ';
        $dias = 1;
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Liquidaci&oacute;n del periodo </b><font color="blue"> <br> '.$descripcion.' </font> <br> Eliminar concepto </td> 
                  <td width="24"> &nbsp; </td>
                  <td width="24"> 
                   <a href="ajusteextemporaneo.php?opcion=ventanaajusteext&periodoid='.$periodoid.'&terid='.$terid.'"> <input type="button" value="<<" class="button"></a> 
                  </td>
                  <td width="10"> &nbsp; </td>                  
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=eliminaconpemp" method="POST">
                <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                 <input type="hidden" name="periodoid" value="'.$periodoid.'">
                 <input type="hidden" name="terid" value="'.$terid.'">
                  <fieldset style="width: 530px; height: 240px;" class="grupos">
                  <legend class="titgrupos"> Datos </legend>
                  <table width="350">
                   <tr height="55">
                    <td> 
                     <label class="Texto12"> <b>Empleado: </b></label>
                     <h2> '.$nombreemp.' </h2>
                    </td>                   
                  </tr>                    
                  <tr height="55">
                   <td> 
                    <label class="Texto12"> <b>Concepto:</b></label><br>
                    '.$clase->CrearComboBuscar("conceptoid",$vsqlcombocon,"nombres","conceptoid","","N",$params,420).'
                   </td>                   
                  </tr>
                  <tr height="55">
                   <td align="center"><br><br> 
                    <input type="submit" value="aceptar" class="button blue"> 
                   </td>
                  </tr>
                 </table>
                </form>
                <br><br>
                </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminaconpemp
    // Creación: 02/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un concepto y realiza los cálculos en caso de ser 
    //              necesario
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminaconpemp")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $conceptoid = $_POST['conceptoid'];
        $listaperiodos = $_POST['listaperiodos'];

        // Inicializo las variables
        $diasconcepto = 0;                          $diastrab = 0;                      $detalleid = 0;
        $formulabasico = "";                        $sueldo = 0;                        $basico = 0;
        $smlv = 0;                                  $valsubtrasp = 0;                   $auxtrans = 0;
        $formulatransporte = "";                    $subsidiotransporte = 0;            $lb_grabosueldo = false;
        $numlicpendientes = 0;

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT nombre FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Nombre del concepto
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');        

        // Obtengo los días del concepto que se eliminará
        $vsql = "SELECT SUM(valor) AS diasconcepto FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
        $diasconcepto = $clase->SeleccionarUno($vsql);

        $vsql = "DELETE FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid IN ($listaperiodos)";
        $clase->EjecutarSQL($vsql);

        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se eliminó el concepto $nomconcepto al eempleado $nombreemp");
        else
        {
            // Determino el ámbito del concepto
            $eslicencia = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','eslicencia');

            // Valido si es una libranza o licencia para recalcular lo correspondiente a ese caso
            if($eslicencia=="CHECKED")
            {
                // Obtengo el salario básico del empleado
                $vsqldatos = "SELECT basico FROM terceros WHERE terid = ".$terid;
                $basico = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // en detallenomina
    
                // Obtengo los días trabajados en el periodo
                $vsql = "SELECT valor
                           FROM detalleliquidacion 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $diastrab = $clase->SeleccionarUno($vsql);
    
                // Obtengo el ID del registro que se modificará
                $vsql = "SELECT detalleid
                           FROM detalleliquidacion 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $detalleid = $clase->SeleccionarUno($vsql);
    
                // Obtengo la formula del sueldo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                $formulabasico = $clase->SeleccionarUno($vsql);
    
                // Recalculo el sueldo del periodo
                $diastrab = $diastrab + $diasconcepto;
                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);
    
                // Almaceno en nuevo sueldo
                $vsql = "UPDATE detalleliquidacion SET 
                                devengados = ".$sueldo.", 
                                valor = ".$diastrab."
                          WHERE detalleid = ".$detalleid."";
                $clase->EjecutarSQL($vsql);
    
                // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
                if(mysql_affected_rows() < 1)
                    $clase->Aviso(3,"No se procesó correctamente la eliminación del concepto, comuníquese con el administrador del sistema ERROR 1541");
                else
                {
                    // Ahora voy a recalcular el subsidio de transporte si es necesario
                    $lb_grabosueldo=true;       // Variable que controla el mensaje correspondiente
        
                    // Obtengo el salario mínimo legal vigente
                    $smlv = $_SESSION['N_SALMIN2020'];
        
                    // Variable para la validación del auxilio de transporte
                    $valsubtrasp = $smlv * 2;

                    // Obtengo el cargo del empleado
                    $vsqldatos = "SELECT cargoid FROM terceros WHERE terid = ".$terid;
                    $cargoid = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";

                    // Obtengo el control del cálculo de subsidio de transporte
                    $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');

                    if(($basico <= $valsubtrasp) && ($aplicatransporte=="CHECKED"))
                    {        
                        // Obtengo la formula del subsidio de transporte
                        $auxtrans = $_SESSION['N_AUXTRANS2020'];
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                        $formulatransporte = $clase->SeleccionarUno($vsql);
        
                        eval("\$subsidiotransporte = $formulatransporte;");
                        $subsidiotransporte = round($subsidiotransporte,0);
                    }
                    else
                        $subsidiotransporte = 0;

                    // ID transporte
                    $vsql = "SELECT detalleid AS idtransporte FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                    $idtransporte = $clase->SeleccionarUno($vsql);
            
                    if($idtransporte!="")
                        // Grabo el subsidio de transporte
                        $vsql = "UPDATE detalleliquidacion SET 
                                        devengados = ".$subsidiotransporte.",
                                        valor = ".$diastrab."
                                  WHERE detalleid = ".$idtransporte."";
                    else
                    {
                        // Obtengo el valor del subsidio de transporte
                        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
            
                        $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                        $numreg = $clase->SeleccionarUno($vsql);
            
                        $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                    }
                    $clase->EjecutarSQL($vsql);

                    // ----------------------------- //
                    // Recalculo la pensión y la salud

                    // ------------------------------------------------------------------------------------------------------------- //
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);

                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);

                    // Determino si es extralegal
                    $vsqldatos = "SELECT extralegal FROM terceros WHERE terid = ".$terid;
                    $extralegal = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";

                    // Determino la eps
                    $vsqldatos = "SELECT epsid FROM terceros WHERE terid = ".$terid;
                    $epsid = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";

                    // Fondo de pensiones
                    $vsqldatos = "SELECT pensionesid FROM terceros WHERE terid = ".$terid;
                    $pensionesid = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";
                    
                    if($epsid==NULL)                    $epsid=0;
                    if($pensionesid==NULL)              $pensionesid=0;

                    // ----------------------------------------------------------------------------------------------------------- //
                    $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                    $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud                    

                    $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                               FROM detalleliquidacion d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                    $totnovedades = $clase->SeleccionarUno($vsql);

                    $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                    $totrecargos = $clase->SeleccionarUno($vsql);                    

                    // Actualizo el sueldo
                    // $sueldo += $totnovedades;
                    $sueldo = $sueldo + $totnovedades + $totrecargos;
                    $sueldodeducciones = $sueldo;
        
                    if($extralegal=="CHECKED")
                    {
                        $pension = 0;
                        $salud = 0;
                    }
                    else
                    {
                        // Recalculo pensión y salud
                        if(($pensionesid==5)||($aplicapension!="CHECKED"))
                            $pension = 0;
                        else
                        {
                            // Obtengo la formula para el descuento por pensión
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                            $formulapension = $clase->SeleccionarUno($vsql);
        
                            // Calculo la pensión
                            eval("\$pension = $formulapension;");
                            $pension = round($pension,0);
                        }
        
                        if(($epsid==37)||($aplicasalud!="CHECKED"))
                            $salud = 0;
                        else
                        {
                            // Obtengo la formula para el descuento de salud
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                            $formulasalud = $clase->SeleccionarUno($vsql);
                            
                            // Calculo la salud
                            eval("\$salud = $formulasalud;");
                            $salud = round($salud,0);
                        }
                    }                    
        
                    //  ID pensión
                    $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                    $idpension = $clase->SeleccionarUno($vsql);
        
                    // Grabo la pensión
                    if($idpension!="")
                        $vsql = "UPDATE detalleliquidacion SET 
                                        descuentos = ".$pension.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idpension."";
                    else
                    {
                        $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                        $numreg = $clase->SeleccionarUno($vsql);
        
                        $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                    }        
                    $clase->EjecutarSQL($vsql);
        
                    // ID salud
                    $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                    $idsalud = $clase->SeleccionarUno($vsql);
        
                    // Grabo la salud
                    if($idsalud!="")
                        $vsql = "UPDATE detalleliquidacion SET 
                                        descuentos = ".$salud.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idsalud."";
                    else
                    {
                        $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                        $numreg = $clase->SeleccionarUno($vsql);
        
                        $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                    }
                    $clase->EjecutarSQL($vsql);
                }
                $lb_grabosueldo=true;
            }
            else
            {
                $vsql = "DELETE FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = ".$conceptoid."";
                $clase->EjecutarSQL($vsql);

                $lb_grabosueldo=true;
            }
        }

        // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
        $vsql = "DELETE FROM detalleliquidacion WHERE devengados = 0 AND descuentos = 0 AND pernominaid IN ($listaperiodos) AND terid = ".$terid."";
        $clase->EjecutarSQL($vsql);

        if($lb_grabosueldo==true)
            $clase->Aviso(1,"Se eliminó exitosamente el concepto $nomconcepto al empleado $nombreemp");

        header("Location: calculoliquidados.php?opcion=ventanareprocesarliq&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: actincapacidadarl
    // Creación: 02/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que re calcula la pensión y la salud para una incapacidad en 
    //              caso de ser necesario
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "actincapacidadarl")
    {
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];
        $diastrab = $_GET['diastrab'];       

        $detalleid = 0;            $dias = 0;                      $smlv = 0;
        $basico = 0;               $montolicencia = 0;             $dias = $diastrab;

        // Determino si el empleado tiene una incapacidad para ser recalculada
        $vsql = "SELECT detalleid
                   FROM detalleliquidacion 
                  WHERE conceptoid = 10  
                        AND pernominaid = ".$periodoid."
                        AND terid = ".$terid."";
        $detalleid = $clase->SeleccionarUno($vsql);

        if(strlen($detalleid) == 0)
        {
            $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
            $nombreemp = $clase->SeleccionarUno($vsql);

            $clase->Aviso(3,"$nombreemp no tiene incapacidades en este periodo");
        }
        else
        {
            // Obtengo los días de incapacidad
            $vsql2 = "SELECT valor AS dias
                        FROM detalleliquidacion 
                       WHERE detalleid = ".$detalleid;
            $dias = $clase->SeleccionarUno($vsql2);

    
            // Obtengo el salario mínimo legal vigente
            $smlv = $_SESSION['N_SALMIN2020'];
    
            // Obtengo el salario básico del empleado
            $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
            if($basico>=$smlv)
            {
                $montolicencia = ($basico*$dias)/30;
                $montolicencia = round($montolicencia,0);
            }
    
            // // Almaceno la modificación
            // $vsql = "UPDATE detalleliquidacion SET 
            //                 devengados = ".$montolicencia."
            //           WHERE detalleid = ".$detalleid;
            // $clase->EjecutarSQL($vsql);
    
            // Procedo a recalcular pensión y salud
    
            // Obtengo la formula del sueldo
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
            $formulabasico = $clase->SeleccionarUno($vsql);
    
            // Calculo el sueldo básico
            eval("\$sueldo = $formulabasico;");
            $sueldo = round($sueldo,0);
    
            // Determino si el empleado es de condición extralegal
            $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
            $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
            $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
            $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                       // Obtengo el cargo del empleado
            
            if($epsid==NULL)                $epsid=0;
            if($pensionesid==NULL)          $pensionesid=0;
    
            // Consulta para el total de devengados
            $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                       FROM detalleliquidacion d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
            $totnovedades = $clase->SeleccionarUno($vsql);

            $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
            $totrecargos = $clase->SeleccionarUno($vsql);

            // $sueldodeducciones = $sueldo + $totnovedades;
            // $sueldodeducciones = $sueldo + $montolicencia;
            $sueldodeducciones = $sueldo + $montolicencia + $totrecargos;
    
            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');             // Obtengo el control del cálculo de pensión
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');                 // Obtengo el control del cálculo de salud
            
            if($extralegal=="CHECKED")
            {
                $pension = 0;
                $salud = 0;
            }
            else
            {
                // Recalculo pensión y salud
                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                    $pension = 0;
                else
                {
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);
    
                    // Calculo la pensión
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
                }
    
                if(($epsid==37)||($aplicasalud!="CHECKED"))
                    $salud = 0;
                else
                {
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
                    
                    // Calculo la salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($salud,0);
                }
            }
            // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
            //  ID pensión
            $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $idpension = $clase->SeleccionarUno($vsql);
    
            // Grabo la pensión
            if($idpension!="")            
                $vsql = "UPDATE detalleliquidacion SET 
                                descuentos = ".$pension.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idpension."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
            }    
            $clase->EjecutarSQL($vsql);
    
            // ID salud
            $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $idsalud = $clase->SeleccionarUno($vsql);
    
            // Grabo la salud
            if($idsalud!="")
                $vsql = "UPDATE detalleliquidacion SET 
                                descuentos = ".$salud.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idsalud."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
            }    
            $clase->EjecutarSQL($vsql);

            // Aquí depuro los conceptos que estén en cero
            $vsql = "DELETE FROM detalleliquidacion WHERE devengados = 0 AND descuentos = 0 AND pernominaid = ".$periodoid." AND terid =".$terid."";
            $clase->EjecutarSQL($vsql);
        }

        // Redirecciono a la ventana reprocesar
        header("Location: calculoliquidados.php?opcion=ventanareprocesarliq&terid=$terid&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: recalcularliq
    // Creación: 15/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que recalcula los datos básicos de una quincena de liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "recalcularliq")
    {
        $terid = $_GET['terid'];
        $basico = $_GET['basico'];
        $periodoid = $_GET['periodoid'];
        $diastrab = $_GET['diastrab'];

        // Obtengo el salario mínimo legal vigente
        $smlv = $_SESSION['N_SALMIN2020'];

        // Obtengo la formula del sueldo
        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
        $formulabasico = $clase->SeleccionarUno($vsql);

        // Calculo el sueldo básico
        eval("\$sueldo = $formulabasico;");
        $sueldo = round($sueldo,0);

        // ID  del sueldo
        $vsql = "SELECT detalleid AS idtransporte FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
        $idsueldo = $clase->SeleccionarUno($vsql);

        if($idsueldo!="")
        {
            // Grabo el sueldo y los días trabajados
            $vsql = "UPDATE detalleliquidacion SET 
                            devengados = ".$sueldo.",
                            valor = ".$diastrab."
                      WHERE detalleid = ".$idsueldo."";
            $clase->EjecutarSQL($vsql);
        }
        else
        {
            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",$basico)";
            $clase->EjecutarSQL($vsql);
        }

        if($diastrab > 0)
        {
            // Recalculo el subsidio de transporte
            $valsubtrasp = $smlv * 2;       // Variable para la validación del auxilio de transporte

            // Obtengo la formula para el subsidio de transporte
            $auxtrans = $_SESSION['N_AUXTRANS2020'];
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
            $formulatransporte = $clase->SeleccionarUno($vsql);

            // ------------------------------------------------------------------------------------------------------------------------------------ //
            $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                       // Obtengo el cargo del empleado
            $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte

            if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
            {            
                // Calculo el subsidio de transporte
                eval("\$subsidiotransporte = $formulatransporte;");
                $subsidiotransporte = round($subsidiotransporte,0);
            }
            else
                $subsidiotransporte = 0;
        }
        else
            $subsidiotransporte = 0;

        // ID transporte
        $vsql = "SELECT detalleid AS idtransporte FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
        $idtransporte = $clase->SeleccionarUno($vsql);

        if($idtransporte!="")
        {
            // Grabo el subsidio de transporte
            $vsql = "UPDATE detalleliquidacion SET 
                            devengados = ".$subsidiotransporte.",
                            valor = ".$diastrab."
                      WHERE detalleid = ".$idtransporte."";
            $clase->EjecutarSQL($vsql);
        }
        else
        {
            // Obtengo el valor del subsidio de transporte
            $valsubtransporte = $_SESSION['N_AUXTRANS2020'];

            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
            $clase->EjecutarSQL($vsql);
        }

        // Determino si el empleado es de condición extralegal
        $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
        $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
        $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
        
        if($epsid==NULL)                $epsid=0;
        if($pensionesid==NULL)          $pensionesid=0;

        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                   FROM detalleliquidacion d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
        $totnovedades = $clase->SeleccionarUno($vsql);

        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
        $totrecargos = $clase->SeleccionarUno($vsql);

        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

        // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
        $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');   // Obtengo el control del cálculo de pensión
        $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');   // Obtengo el control del cálculo de salud

        if($extralegal=="CHECKED")
        {
            $pension = 0;
            $salud = 0;
        }
        else
        {
            // Recalculo pensión y salud
            if(($pensionesid==5)||($aplicapension!="CHECKED"))
                $pension = 0;
            else
            {
                // Obtengo la formula para el descuento por pensión
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                $formulapension = $clase->SeleccionarUno($vsql);

                // Calculo la pensión
                eval("\$pension = $formulapension;");
                $pension = round($pension,0);
            }

            if(($epsid==37)||($aplicasalud!="CHECKED"))
                $salud = 0;
            else
            {   
                // Obtengo la formula para el descuento de salud
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                $formulasalud = $clase->SeleccionarUno($vsql);
                
                // Calculo la salud
                eval("\$salud = $formulasalud;");
                $salud = round($salud,0);
            }                    
        }

        // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
        //  ID pensión
        $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
        $idpension = $clase->SeleccionarUno($vsql);

        if($idpension!="")            
            // Grabo la pensión
            $vsql = "UPDATE detalleliquidacion SET 
                            descuentos = ".$pension.",
                            saldo = ".$sueldodeducciones."
                        WHERE detalleid = ".$idpension."";
        else
        {
            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
        }
        $clase->EjecutarSQL($vsql);

        // ID salud
        $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
        $idsalud = $clase->SeleccionarUno($vsql);

        if($idsalud!="")
            // Grabo la salud
            $vsql = "UPDATE detalleliquidacion SET 
                            descuentos = ".$salud.",
                            saldo = ".$sueldodeducciones."
                        WHERE detalleid = ".$idsalud."";
        else
        {
            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
        }
        $clase->EjecutarSQL($vsql);

        // Aquí depuro los conceptos que estén en cero
        $vsql = "DELETE FROM detalleliquidacion WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid =".$terid."";
        $clase->EjecutarSQL($vsql);

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=ventanareprocesarliq&periodoid=$periodoid&terid=$terid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrarliquidacionporperiodo
    // Creación: 17/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que filtra por periodo la opción cerrarliquidaciones
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarliquidacionporperiodo")
    {
        $codperiodo = $_POST['codperiodo'];        
        header("Location: calculoliquidados.php?opcion=cerrarliquidaciones&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cerrarliquidaciones
    // Creación: 17/02/2024		última modificación: 27/06/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para cerrar para recalculo las liquidaciones
    // Última modificación: Inclusión de los botones para la actualización de los parámetros 
    //                      de liquidación y de editar liquidación
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "cerrarliquidaciones")
    {
	    // Control de Permisos
	    if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            $codperiodo = $_GET['codperiodo'];

            if(strlen($codperiodo) == 0)
                $codperiodo = date("m").date("Y");

            // año actual
            $yeartoday = date("Y");
            $yearlast = $yeartoday - 1;

            // determino la lista de periodos
            $listaperiodos = generarlistaper($codperiodo);
    
            // Combo de Periodos
            // $vsqlcombo = "SELECT * FROM periodos WHERE anoperiodo >= ".$yeartoday." ORDER BY orden DESC";
            $vsqlcombo = "SELECT * FROM periodos WHERE anoperiodo = ".$yeartoday." OR codperiodo IN (SELECT MAX(codperiodo) FROM periodos WHERE anoperiodo = ".$yearlast.") ORDER BY orden DESC";
            $params    = ' class="Texto11" style="width:140px;height:25px" OnChange="x.submit();"';

            // -------------------------------------------------------------------------------------------------------------------------------------------------------- //
            // // actualizar liquidaciones
            // $vsql1 = "SELECT DISTINCT terid 
            //             FROM liquidacion 
            //            WHERE periodonomina = '".$codperiodo."' 
            //                  AND terid NOT IN (SELECT terid 
            //                                      FROM parametrosliquidacion
            //                                     WHERE codperiodo = '".$codperiodo."')";
            // $conex  = $clase->Conectar();
            // $result1 = mysql_query($vsql1,$conex);
            // $valact = mysql_num_rows($result1);

            // if($valact == 0)
            //     $htmlact = '<img src="images/iconos/atributos.png" width="34" height="34" border="0" title="no existen liquidaciones pendientes">';
            // else
            //     $htmlact = '<a href="?opcion=completarliq&codperiodo='.$codperiodo.'" title="completar '.$valact.' liquidaciones que faltan" target="_blank">
            //                  <img src="images/iconos/atributos.png" width="34" height="34" border="0"> 
            //                 </a>';

            $htmlact = '';
            // -------------------------------------------------------------------------------------------------------------------------------------------------------- //

            // consulta de la ventana
            $vsql = "SELECT p.idparaliquida, t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, p.norecalcular, p.nroquincena, t.terid  
                       FROM parametrosliquidacion p 
                            INNER JOIN terceros t ON (p.terid = t.terid)
                      WHERE p.codperiodo = '".$codperiodo."'";

            // Pintamos la ventana
            $cont = $clase->Header("S","W");
            $cont.='<form action="?opcion=filtrarliquidacionporperiodo" method="POST" name="x">
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/cerrar.png" width="32" height="32" border="0"> </td>
                      <td width="780"> <b>Cerrar liquidaciones para recalculo </b> </td>
                      <td width="10"> &nbsp; </td>
                      <td width="200"> &nbsp; </td>
                      <td width="20"> '.$htmlact.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="280"> periodo: '.$clase->CrearComboEsp("codperiodo",$vsqlcombo,"codperiodo","nomperiodo",$codperiodo,"N",$params).' </form> </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';

            $cont.='<script language="javascript">
                     <!--
                         function seleccionar_todo()
                         { 
                             valor = document.f2.todos.checked;
                             if(valor)
                                 marcartodo();
                             else
                                 desmarcartodo();
                         } 
     
                         function marcartodo()
                         {
                             for (i=0;i<document.f2.elements.length;i++) 
                              if(document.f2.elements[i].type == "checkbox")  
                                document.f2.elements[i].checked = 1;
                         }
     
                         function desmarcartodo()
                         {
                             for (i=0;i<document.f2.elements.length;i++) 
                              if(document.f2.elements[i].type == "checkbox") 
                               document.f2.elements[i].checked = 0;
                         }
                     -->
                    </script>';

            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <form action="?opcion=nocalliqui" method="POST" name="f2">
                    <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                    <table id="fixTableV" class="sortable">
                     <tr class="TituloTabla">
                      <th width="40"> # </th>
                      <th width="120"> C&eacute;dula </th>
                      <th width="600"> Nombre </th>
                      <th width="30"> Configurar </th>
                      <th width="30"> Editar </th>
                      <th width="30"> Reabrir </th>
                      <th width="30"> Recalcular </th>
                      <th width="30"> <input type="checkbox" name="todos" value="S" style="width:18px;height:20px;" onClick="javascript:seleccionar_todo();"> </th>
                     </tr>';

            // impresión del detalle
            $i = 0;
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
                
                $nroquincena = $row['nroquincena'];

                if($nroquincena == 1)
                    $periodoid = intval(substr($listaperiodos,0,2));

                if($nroquincena == 2)
                    $periodoid = intval(substr($listaperiodos,3,2));

                $norecalcular = $row['norecalcular'];

                if($norecalcular == "CHECKED")
                {
                    $iconoreabrir = '<a href="?opcion=abrirliquidacion&idparaliquida='.$row['idparaliquida'].'&codperiodo='.$codperiodo.'"> 
                                      <img src="images/basicas/cambiar.png" title="reabrir liquidaci&oacute;n" border="0" width="20" height="20"> 
                                     </a> ';
                    $iconoestatus = '<img src="images/basicas/bloqueado.png" title="liquidaci&oacute;n cerrada para recalculo" border="0" width="20" height="20">';
                }
                else
                {
                    $iconoreabrir = '';
                    $iconoestatus = '<img src="images/basicas/exitoso.png" title="liquidaci&oacute;n para recalcular" border="0" width="20" height="20">';
                }
                
                $cont.=' <td align="center"> '.$i.' </td>
                         <td align="center"> '.$row['dni'].' </td>
                         <td align="center"> '.$row['nombreemp'].' </td>
                         <td align="center"> 
                          <a href="?opcion=ventanaeditarparametros&idparaliquida='.$row['idparaliquida'].'&codperiodo='.$codperiodo.'" title="editar par&aacute;metros de liquidaci&oacute;n" rel="facebox"> 
                           <img src="images/basicas/local.png" border="0" width="20" height="20">  
                          </a>                         
                         </td>
                         <td align="center"> 
                          <a href="liquidados.php?opcion=editarliquidacion&terid='.$row['terid'].'&codperiodo='.$codperiodo.'" target="_blank">
                           <img src="images/basicas/validar.png" border="0" width="20" height="20">  
                          </a>                         
                         </td>
                         <td align="center"> '.$iconoreabrir.' </td>
                         <td align="center"> '.$iconoestatus.' </td>
                         <td align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['idparaliquida'].'" style="width:18px;height:20px;" value="S"> </td>
                        </tr>';
            }

            // totales y botones
            $cont.='<table width="100%"> 
                     <tr class="TituloTabla"> 
                      <td width="20"> &nbsp; </td> 
                      <td width="1588"> <font color="white"> <b> Total liquidaciones: '.number_format($i).' </b> </font> </td> 
                     </tr>
                    </table>
                    <br>
                    <br>
                    <center>
                    <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="cerrar"></a>
                    </form>
                    <a href="calculoliquidados.php?opcion=ventanaactdatos" ><input type="button" value="CANCELAR" class="button red"></a>
                    <a href="calculoliquidados.php?opcion=reabrirtodas&codperiodo='.$codperiodo.'" ><input type="button" value="reabrir todas" class="button green"></a>';

            mysql_free_result($result);
            mysql_close($conex);
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nocalliqui
    // Creación: 17/02/2024		última modificación: 19/02/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que cierra las liquidaciones seleccionadas
    // Última modificación: Optimización del redireccionamiento del formulario
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nocalliqui")
    {
        $codperiodo = $_POST['codperiodo'];

        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT idparaliquida FROM parametrosliquidacion";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result)) 
        {
            if($_POST['LIN-'.$row['idparaliquida']] == "S")
            {
                $lista.= $row['idparaliquida'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // actualizo los registros
        $vsql2 = "UPDATE parametrosliquidacion SET norecalcular = 'CHECKED' WHERE idparaliquida IN (".$lista.")";
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli liquidaciones cerradas");
        else
            $clase->Aviso(3,"No se cerraron las liquidaciones");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=cerrarliquidaciones&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: abrirliquidacion
    // Creación: 17/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que reabre una liquidación para recalculo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "abrirliquidacion")
    {
        $idparaliquida = $_GET['idparaliquida'];
        $codperiodo = $_GET['codperiodo'];

        // instrucción para reabrir una liquidación
        $vsql2 = "UPDATE parametrosliquidacion SET norecalcular = '' WHERE idparaliquida = ".$idparaliquida;
        $clase->EjecutarSQL($vsql2);

        // emito el mensaje correspondiente
        $clase->Aviso(1,"Liquidación reabierta");

        // redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=cerrarliquidaciones&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: reabrirtodas
    // Creación: 197/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para reabrir todas las liquidaciones del periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "reabrirtodas")
    {
        $codperiodo = $_GET['codperiodo'];
     
        // reabro todas las liquidaciones del periodo
        $vsql2 = "UPDATE parametrosliquidacion SET norecalcular = '' WHERE codperiodo = '".$codperiodo."' ";
        $clase->EjecutarSQL($vsql2);

        // emito el mensaje correspondiente
        $clase->Aviso(1,"Liquidaciones reabiertas");

        // redirecciono el formulario        
        header("Location: calculoliquidados.php?opcion=cerrarliquidaciones&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: completarliq
    // Creación: 04/04/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que completa las liquidaciones que faltan en la tabla 
    //              parametrosliquidacion
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "completarliq")
    {
        $codperiodo = $_GET['codperiodo'];

        // actualiza los registros que faltan
        $vsql = "INSERT INTO parametrosliquidacion (terid,codperiodo,cesantiasyearanterior,cesantiasyearactual,intcesantiasyearanterior,intcesantiasyearactual,
                                                    vacaciones,primasprimersemestre,primassegundosemestre,calcularquin,nroquincena,norecalcular) 
                      SELECT DISTINCT terid, '".$codperiodo."' codperiodo, '' cesantiasyearanterior, '' cesantiasyearactual, '' intcesantiasyearanterior, '' intcesantiasyearactual, 
                                      '' vacaciones, '' primasprimersemestre, '' primassegundosemestre, 'NO' calcularquin, 1 nroquincena, '' norecalcular
                        FROM liquidacion 
                       WHERE periodonomina = '".$codperiodo."' 
                             AND terid NOT IN (SELECT terid 
                                                 FROM parametrosliquidacion
                                                WHERE codperiodo = '".$codperiodo."')";
        $clase->EjecutarSQL($vsql);

        // emito el mensaje correspondiente
        $clase->Aviso(1,"Liquidaciones actualizadas");

        // redirecciono el formulario        
        header("Location: calculoliquidados.php?opcion=cerrarliquidaciones&codperiodo=$codperiodo");
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: duplicahistcontrato
    // Creación: 22/04/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana con los empleados con contratos repetidos 
    //              en el histórico
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "duplicahistcontrato")
    {
        // Control de Permisos
	    if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            // Pintamos la ventana
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/Folder docs.png" width="32" height="32" border="0"> </td>
                      <td width="870"> <b>Registros duplicados </b> <font color="blue"> <br>en la tabla histcontrato </font> </td>                      
                      <td width="10"> &nbsp; </td>
                      <td width="20"> 
                       <a href="?opcion=duplicahistcontrato" title="actualizar la ventana"> 
                        <img src="images/iconos/refrescar.png" border="0" width="38" height="38">  
                       </a> 
                      </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';

            $cont.= permisosespecialesdos(3);

            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>                     
                    <table width="100%" class="sortable">
                     <thead>
                      <tr class="TituloTabla" style="display:block; padding-top:5px;height:25px;"> 
                       <th width="10"> &nbsp; </th>                       
                       <th width="130" align="left"> terid </th>
                       <th width="340" align="left"> Nombre </th>                       
                       <th width="160" align="right"> Ingreso </th>
                       <th width="160" align="right"> Retiro </th>
                       <th width="120" align="right"> Condici&oacute;n </th>
                       <th width="130" align="right"> &Uacute;ltimo sueldo </th>
                       <th width="55" align="center"> &nbsp; </th>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';

            // consulta de los registros duplicados
            $vsql61 = "SELECT hc.terid, hc.fecingreso, hc.fecretiro, hc.ultsueldo, hc.idcondicion, 
                              CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                              t.dni, COUNT(*)
                         FROM histcontrato hc
                              INNER JOIN terceros t ON (hc.terid = t.terid)
                     GROUP BY 1,2,3,4  
                       HAVING COUNT(*) > 1";

                    //    echo $vsql61; exit ();

            $conex = $clase->Conectar();
            $result61 = mysql_query($vsql61,$conex);
            while($row = mysql_fetch_array($result61))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';

                // formatos de fecha
                $fecingreso = substr($row['fecingreso'],8,2)."/".substr($row['fecingreso'],5,2)."/".substr($row['fecingreso'],0,4);
                $fecretiro = substr($row['fecretiro'],8,2)."/".substr($row['fecretiro'],5,2)."/".substr($row['fecretiro'],0,4);

                $cont.=' <td width="10"> &nbsp; </td>                         
                         <td width="130" align="left"> '.$row['terid'].' </td>
                         <td width="340" align="left">
                          <b> '.substr($row['nombreemp'],0,40).' </b>
                          <br> c&eacute;dula: <span> <font color="#CC66FF"> '.$row['dni'].' </font> </span>                         
                         </td>                       
                         <td width="160" align="right"> '.$fecingreso.' </td>
                         <td width="160" align="right"> '.$fecretiro.' </td>
                         <td width="120" align="right"> '.$row['idcondicion'].' </td>
                         <td width="130" align="right"> '.number_format($row['ultsueldo']).' </td>
                         <td width="40" align="center">
                          <a href="?opcion=verduplicadoshc&terid='.$row['terid'].'" rel="facebox">
                           <img src="images/basicas/iconobuscar.png" title="editar secci&oacute;n" border="0">
                          </a>                         
                         </td>
                        </tr>';
            }

            $cont.=' </tbody>
                    </table>
                    <table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="261"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="222"> &nbsp; </td>
                     </tr>
                    </table>
                    <br>
                    <center>
                    <a href="calculoliquidados.php?opcion=duplicados" ><input type="button" value="ATRAS" class="button red"></a>';
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido");
            header("Location: calculoliquidados.php?opcion=ventanaliquidados");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: verduplicadoshc
    // Creación: 24/04/2024		última modificación: 09/10/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que muestra los contratos de un empleado
    // Última modificación: Impresión del número de documento en el encabezado del 
    //                      formulario (08/10/2024)
    //                      Inclusión de los botones de la ficha terceros y del histórico 
    //                      de contratos e inserción de las últimas fechas de ingreso y 
    //                      retiro en el encabezado
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "verduplicadoshc")
    {
        $terid = $_GET['terid'];

        // Nombre del empleado
        $vsql21 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql21);

        // documento del empleado
        $dni = $clase->BDLockup($terid,'terceros','terid','dni');

        // Últimas fechas de ingreso y retiro
        $fecingreso = $clase->BDLockup($terid,'terceros','terid','fecingreso');
        $fecharetiro = $clase->BDLockup($terid,'terceros','terid','fecharetiro');

        // pinto la ventana
        $cont ='<table width="700">
                 <tr class="BarraDocumentos" style="height:50px;Important!">                   
                  <td align="center"> <h3> Contratos Duplicados </h3> </td> 
                 </tr> 
                </table>
                <table width="700">
                 <tr class="BarraDocumentos" style="height:25px;Important!"> 
                  <td width="10" align="left"> &nbsp </td> 
                  <td width="690" align="left"> <font color="blue"> <b> '.$nombreemp.' </font> </b> </td> 
                 </tr>
                 <tr class="BarraDocumentos" style="height:25px;Important!"> 
                  <td width="10" align="left"> &nbsp </td> 
                  <td width="690" align="left"> <font color="blue"> <b> Documento: '.$dni.' </font> </b> </td> 
                 </tr>
                 <tr class="BarraDocumentos" style="height:25px;Important!"> 
                  <td width="10" align="left"> &nbsp </td> 
                  <td width="690" align="left"> <font color="blue"> <b> &Uacute;ltimo ingreso: '.$fecingreso.' &nbsp&nbsp &Uacute;ltimo retiro: '.$fecharetiro.' </font> </b> </td> 
                 </tr>
                </table>                                

                <script language="javascript">
                <!--
                    function seleccionar_todo()
                    { 
                        valor = document.f2.todos.checked;
                        if(valor)
                            marcartodo();
                        else
                            desmarcartodo();
                    } 

                    function marcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox")  
                           document.f2.elements[i].checked = 1;
                    }

                    function desmarcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox") 
                          document.f2.elements[i].checked = 0;
                    }
                -->
                </script>
                
                <script type="text/javascript" src="lib/sorttable.js"></script> 
                <form action="?opcion=eliminarhistcontrato" method="POST" name="f2">
                <table width="700" class="sortable">
                 <thead>
                  <tr class="TituloTabla" style="display:block; padding-top:5px;height:23px;"> 
                   <th width="10"> &nbsp; </th>
                   <th width="110" align="left"> id </th>
                   <th width="80" align="left"> terid </th>			
                   <th width="130" align="left"> fecingreso </th>
                   <th width="130" align="left"> fecretiro </th>			
                   <th width="130" align="left"> ultsueldo </th>
                   <th width="85" align="left"> idcondicion </th>				 
                   <th width="45" align="left"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo();"> </th>	
                  </tr>
                 </thead>
                 <tbody style="display:block; width:700px; height:320px; overflow-Y:scroll">';

        // consulta de la ventana
        $vsql= "SELECT * FROM histcontrato WHERE terid = ".$terid;

        // impresión del detalle
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="10" align="left"> &nbsp; </td> 
                     <td width="110" align="left"> '.$row['id'].' </td> 
                     <td width="80" align="left"> '.$row['terid'].' </td> 
                     <td width="130" align="left"> '.$row['fecingreso'].' </td> 
                     <td width="135" align="left"> '.$row['fecretiro'].' </td>
                     <td width="125" align="left"> '.number_format($row['ultsueldo']).' </td>
                     <td width="75" align="right"> '.$row['idcondicion'].' </td>
                     <td width="35" align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['id'].'" value="S"> </td>
                    </tr>';
        }

        $tiposalida = "vista";
        
        $cont.=' </tbody>
                </table>
                <table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>
                <br>
                <center>
                <a href="infhistcont.php?opcion=listadocontratos&terid='.$terid.'&tiposalida='.$tiposalida.'" title="hist&oacute;rico de contratos" target="_blank">
                 <img src="images/iconos/agenda.png" width="34" height="34" border="0"> 
                </a>
                &nbsp;&nbsp;
                <a href="terceros.php?opcion=detalles2&id='.$terid.'" title="editar ficha del empleado" target="_blank">
                 <img src="images/iconos/clientes.png" width="34" height="34" border="0"> 
                </a>
                <br><br>
                <center>
                <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar"></a>
                </form>
                <a href="calculoliquidados.php?opcion=duplicahistcontrato"><input type="button" value="CANCELAR" class="button red"></a>';

        echo $cont; exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarhistcontrato
    // Creación: 24/04/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina contratos seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarhistcontrato")
    {
        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT id FROM histcontrato";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result)) 
        {
            if($_POST['LIN-'.$row['id']] == "S")
            {
                $lista.= $row['id'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // Elimino los registros
        $vsql2 = "DELETE FROM histcontrato WHERE id IN (".$lista.")";
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli registros eliminados exitosamente");
        else
            $clase->Aviso(3,"No se eliminaron los registros");

        // Redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=duplicahistcontrato");        
    }

    // if($opcion == "filtrardotaciones")
    // {
    //     $periodonomina = $_POST['periodonomina'];
    //     header("Location: calculoliquidados.php?opcion=duplicadotaciones&periodonomina=$periodonomina");
    // }

    // if($opcion == "duplicadotaciones")
    // {
        
    // }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaeditarparametros
    // Creación: 27/06/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para editar los campos de la tabla 
    //              parametrosliquidacion
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaeditarparametros")
    {
        $idparaliquida = $_GET['idparaliquida'];
        $codperiodo = $_GET['codperiodo'];

        // nombre del empleado
        $terid = $clase->BDLockup($idparaliquida,'parametrosliquidacion','idparaliquida','terid');
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid=".$terid."";
        $nombreemp = $clase->SeleccionarUno($vsql);

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Datos en la tabla parametrosliquidacion
        $cesantiasyearanterior = $clase->BDLockup($idparaliquida,'parametrosliquidacion','idparaliquida','cesantiasyearanterior');
        if($cesantiasyearanterior == "SI")
            $chkcesantiasyearanterior = "CHECKED";
        else
            $chkcesantiasyearanterior = "";

        $cesantiasyearactual = $clase->BDLockup($idparaliquida,'parametrosliquidacion','idparaliquida','cesantiasyearactual');
        if($cesantiasyearactual == "SI")
            $chkcesantiasyearactual = "CHECKED";
        else
            $chkcesantiasyearactual = "";

        $intcesantiasyearanterior = $clase->BDLockup($idparaliquida,'parametrosliquidacion','idparaliquida','intcesantiasyearanterior');
        if($intcesantiasyearanterior == "SI")
            $chkintcesantiasyearanterior = "CHECKED";
        else
            $chkintcesantiasyearanterior = "";

        $intcesantiasyearactual = $clase->BDLockup($idparaliquida,'parametrosliquidacion','idparaliquida','intcesantiasyearactual');
        if($intcesantiasyearactual == "SI")
            $chkintcesantiasyearactual = "CHECKED";
        else
            $chkintcesantiasyearactual = "";

        $vacaciones = $clase->BDLockup($idparaliquida,'parametrosliquidacion','idparaliquida','vacaciones');
        if($vacaciones == "SI")
            $chkvacaciones = "CHECKED";
        else
            $chkvacaciones = "";

        $primasprimersemestre = $clase->BDLockup($idparaliquida,'parametrosliquidacion','idparaliquida','primasprimersemestre');
        if($primasprimersemestre == "SI")
            $chkprimasprimersemestre = "CHECKED";
        else
            $chkprimasprimersemestre = "";

        $primassegundosemestre = $clase->BDLockup($idparaliquida,'parametrosliquidacion','idparaliquida','primassegundosemestre');
        if($primassegundosemestre == "SI")
            $chkprimassegundosemestre = "CHECKED";
        else
            $chkprimassegundosemestre = "";

        $calcularquin = $clase->BDLockup($idparaliquida,'parametrosliquidacion','idparaliquida','calcularquin');
        if($calcularquin == "SI")
            $chkcalcularquin = "CHECKED";
        else
            $chkcalcularquin = "";

        $nroquincena = $clase->BDLockup($idparaliquida,'parametrosliquidacion','idparaliquida','nroquincena');

        // pinto la ventana
        $cont.='<table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/configuracion.png" width="34" height="34" border="0"> </td>
                  <td align="center"> <b> Edici&oacute;n de par&aacute;metros de liquidaci&oacute;n <br> '.$desperiodo.' </b> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardarparametros" name="y" method="POST">
                <input type="hidden" name="idparaliquida" value="'.$idparaliquida.'">
                <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left"> <font color="blue"> <label class="Texto14"> Empleado: '.$nombreemp.' </label> </font> </td> 
                 </tr> 
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left">
                   <input type="checkbox" value="CHECKED" name="cesantiasyearanterior" class="Texto11" style="width:20px;height:20px;" '.$chkcesantiasyearanterior.'> 
                   <label class="Texto14"> cesant&iacute;as del a&ntilde;o anterior </label>
                  </td> 
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left">
                   <input type="checkbox" value="CHECKED" name="intcesantiasyearanterior" class="Texto11" style="width:20px;height:20px;" '.$chkintcesantiasyearanterior.'> 
                   <label class="Texto14"> intereses de cesant&iacute;as del a&ntilde;o anterior </label>
                  </td> 
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left">
                   <input type="checkbox" value="CHECKED" name="cesantiasyearactual" class="Texto11" style="width:20px;height:20px;" '.$chkcesantiasyearactual.'> 
                   <label class="Texto14"> cesant&iacute;as del a&ntilde;o actual </label>
                  </td> 
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left">
                   <input type="checkbox" value="CHECKED" name="intcesantiasyearactual" class="Texto11" style="width:20px;height:20px;" '.$chkintcesantiasyearactual.'> 
                   <label class="Texto14"> intereses de cesant&iacute;as del a&ntilde;o actual </label>
                  </td> 
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left">
                   <input type="checkbox" value="CHECKED" name="vacaciones" class="Texto11" style="width:20px;height:20px;" '.$chkvacaciones.'> 
                   <label class="Texto14"> vacaciones </label>
                  </td> 
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left">
                   <input type="checkbox" value="CHECKED" name="primasprimersemestre" class="Texto11" style="width:20px;height:20px;" '.$chkprimasprimersemestre.'> 
                   <label class="Texto14"> primas primer semestre </label>
                  </td> 
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left">
                   <input type="checkbox" value="CHECKED" name="primassegundosemestre" class="Texto11" style="width:20px;height:20px;" '.$chkprimassegundosemestre.'> 
                   <label class="Texto14"> primas segundo semestre </label>
                  </td> 
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left">
                   <input type="checkbox" value="CHECKED" name="calcularquin" class="Texto11" style="width:20px;height:20px;" '.$chkcalcularquin.'> 
                   <label class="Texto14"> calcular quincena </label>
                  </td> 
                 </tr>                 
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left">                   
                   <label class="Texto14"> Quincena: </label>
                   <input type="number" name="nroquincena" min="1" max="2" class="Texto12New" size="12" style="width:50px;height:25px;" title="n&nacute;mero de la quincena" value="'.$nroquincena.'"> 
                  </td> 
                 </tr>
                </table>
                <table width="500">
                 <tr class="BarraDocumentos" style="height:40px;Important!">
                  <td align="center">
                   <input type="submit" value="guardar" class="button blue"> 
                   </form>
                   <br><br>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarparametros
    // Creación: 27/06/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que guarda los cambios de la tabla parametrosliquidacion
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarparametros")
    {
        $idparaliquida = $_POST['idparaliquida'];
        $cesantiasyearanterior = $_POST['cesantiasyearanterior'];
        $cesantiasyearactual = $_POST['cesantiasyearactual'];
        $intcesantiasyearanterior = $_POST['intcesantiasyearanterior'];
        $intcesantiasyearactual = $_POST['intcesantiasyearactual'];
        $vacaciones = $_POST['vacaciones'];
        $primasprimersemestre = $_POST['primasprimersemestre'];
        $primassegundosemestre = $_POST['primassegundosemestre'];
        $calcularquin = $_POST['calcularquin'];
        $nroquincena = $_POST['nroquincena'];
        $codperiodo = $_POST['codperiodo'];

        if($cesantiasyearanterior == "CHECKED")
            $auxcesantiasyearanterior = "SI";
        else
            $auxcesantiasyearanterior = "NO";

        if($cesantiasyearactual == "CHECKED")
            $auxcesantiasyearactual = "SI";
        else
            $auxcesantiasyearactual = "NO";

        if($intcesantiasyearanterior == "CHECKED")
            $auxintcesantiasyearanterior = "SI";
        else
            $auxintcesantiasyearanterior = "NO";

        if($intcesantiasyearactual == "CHECKED")
            $auxintcesantiasyearactual = "SI";
        else
            $auxintcesantiasyearactual = "NO";

        if($vacaciones == "CHECKED")
            $auxvacaciones = "SI";
        else
            $auxvacaciones = "NO";

        if($primasprimersemestre == "CHECKED")
            $auxprimasprimersemestre = "SI";
        else
            $auxprimasprimersemestre = "NO";

        if($primassegundosemestre == "CHECKED")
            $auxprimassegundosemestre = "SI";
        else
            $auxprimassegundosemestre = "NO";

        if($calcularquin == "CHECKED")
            $auxcalcularquin = "SI";
        else
            $auxcalcularquin = "NO";
        
        // guardo los cmbio
        $vsql = "UPDATE parametrosliquidacion SET
                        cesantiasyearanterior = '".$auxcesantiasyearanterior."', 
                        cesantiasyearactual = '".$auxcesantiasyearactual."', 
                        intcesantiasyearanterior = '".$auxintcesantiasyearanterior."', 
                        intcesantiasyearactual = '".$auxintcesantiasyearactual."', 
                        vacaciones = '".$auxvacaciones."', 
                        primasprimersemestre = '".$auxprimasprimersemestre."', 
                        primassegundosemestre = '".$auxprimassegundosemestre."', 
                        calcularquin = '".$auxcalcularquin."', 
                        nroquincena = ".$nroquincena." 
                  WHERE idparaliquida = ".$idparaliquida;
        $clase->EjecutarSQL($vsql);

        // mensaje correspondiente
        echo'<SCRIPT languague="javascript">
              <!--
               alert("Datos actualizados");
               window.history.back();
              -->
             </SCRIPT>';
        exit;

        // redirecciono el formulario
        header("Location: calculoliquidados.php?opcion=cerrarliquidaciones&codperiodo=$codperiodo");
    }    
        

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función validar_fecha_espanol
    // Parámetro de entrada:    $fecha --> Fecha que se va a evaluar
    // Valor de retorno:        true o false
    // Descripción: Función que valida el formato de fecha dd/mm/aaaa
    ////////////////////////////////////////////////////////////////////////////////////////
    function validar_fecha_espanol($fecha)
    {
        $valores = explode('/', $fecha);
        if(count($valores) == 3 && checkdate($valores[1], $valores[0], $valores[2]))
        {
            return true;
        }
        return false;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función verifica_rango
    // Parámetro de entrada:    $date_inicio --> Fecha de inicio del periodo
    //                          $date_fin    --> Fecha fin del periodo
    //                          $date_nueva  --> Fecha que se va a evaluar
    // Valor de retorno:        true o false
    // Descripción: Función que valida si una fecha está en un rango especifico
    ////////////////////////////////////////////////////////////////////////////////////////
    function verifica_rango($date_inicio, $date_fin, $date_nueva) 
    {
        $date_inicio = strtotime($date_inicio);
        $date_fin = strtotime($date_fin);
        $date_nueva = strtotime($date_nueva);

        if (($date_nueva >= $date_inicio) && ($date_nueva <= $date_fin))
            return true;
        else
            return false;
     }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función tienecambiosalario
    // Parámetros de entrada:    $terid --> ID del empelado
    //                           $fecretiro --> Fecha de retiro
    // Valor de retorno:         $tienecambio --> true o false si tiene cambio de salario
    // Descripción: Función que determina si un empleado tiene cambio de salario en los 
    //              últimos tres meses
    ////////////////////////////////////////////////////////////////////////////////////////
    function tienecambiosalario($terid,$fecretiro)
    {
        $clase2 = new Sistema();

        $vsql28 = "SELECT MAX(periodoid) maxper4 FROM periodosnomina WHERE fechasta <= '".$fecretiro."'";
        $maxper4 = $clase2->SeleccionarUno($vsql28);        

        // --------------------------------------------------------------------------------------------------------------------------------------------------- //
        $maxper4++;                

        $i = 1;
        $tienecambio = false;
        $recarnonocturno = 0;

        // consulta de los últimos tres meses o seis quincenas laboradas
        $vsql29 = "SELECT pernominaid, basico saldo 
                     FROM periodoterceros 
                    WHERE terid = ".$terid."
                          AND pernominaid <= ".$maxper4."
                    UNION ALL
                   SELECT pernominaid, saldo 
                     FROM detalleliquidacion 
                    WHERE terid = ".$terid." 
                          AND conceptoid IN (1,10,11,12,13,31,38,43) 
                          AND pernominaid <= ".$maxper4."
                 ORDER BY 1 DESC LIMIT 0,6";

        $conex = $clase2->Conectar();
        $result3 = mysql_query($vsql29,$conex);
        while($row3 = mysql_fetch_array($result3))
        {
            $saldo = $row3['saldo'];
            $pernominaid = $row3['pernominaid'];

            // busco recargo nocturno
            $recarnonocturno = buscarrecargonoc($terid,$pernominaid);
            $saldo += $recarnonocturno;

            // determino si existe variación
            if($i == 1)
                $auxcambio = $saldo;
            else
            {
                if($saldo > 0)
                {
                    if($saldo != $auxcambio)
                        $tienecambio = true;
                    
                    $auxcambio = $saldo;
                }
            }
            $i++;
        }
        
        // --------------------------------------------------------------------------------------------------------------------------------------------------- //
        // $maxper5 = $maxper4 - 1;
        // $minper5 = $maxper4 - 6;        

        // $yearretiro = intval(substr($fecretiro,0,4));
        // $tienecambio = false;        

        // $i = 1;

        // $vsql29 = "SELECT periodoid FROM periodosnomina WHERE periodoid BETWEEN ".$minper5." AND ".$maxper5." AND YEAR(fechasta) = ".$yearretiro."";        
        // $conex = $clase2->Conectar();
        // $result3 = mysql_query($vsql29,$conex);        

        // while($row3 = mysql_fetch_array($result3))
        // {
        //     $periodoid2 = $row3['periodoid'];

        //     $vsql30 = "SELECT saldo 
        //                  FROM hisdetallenomina 
        //                 WHERE terid = ".$terid." 
        //                       AND conceptoid = 1 
        //                       AND pernominaid = ".$periodoid2."";
        //     $saldo = $clase2->SeleccionarUno($vsql30);            

        //     if($i == 1)
        //         $auxcambio = $saldo;
        //     else
        //     {
        //         if($saldo > 0)
        //         {
        //             if($saldo != $auxcambio)
        //                 $tienecambio = true;
                    
        //             $auxcambio = $saldo;
        //         }
        //     }
        //     $i++;
        // }
        // --------------------------------------------------------------------------------------------------------------------------------------------------- //        

        return $tienecambio;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función buscarrecargonoc
    // Parámetros de entrada:    $terid --> ID del empelado
    //                           $fecretiro --> ID del periodo
    // Valor de retorno:         $recargonocper --> Monto del recargo nocturno
    // Descripción: Función que busca el recargo nocturno de un empleado en un periodo
    ////////////////////////////////////////////////////////////////////////////////////////
    function buscarrecargonoc($terid,$pernominaid)
    {
        $clase2 = new Sistema();

        $recargonochis = 0;                 $recargonocliq = 0;                 $recargonocper = 0;
        $vsql11 = "";                       $vsql12 = "";

        $vsql11 = "SELECT IFNULL(devengados,0) recargonochis FROM hisdetallenomina WHERE terid = ".$terid." AND  pernominaid = ".$pernominaid." AND conceptoid = 47";
        $recargonochis = $clase2->SeleccionarUno($vsql11);

        $vsql12 = "SELECT IFNULL(devengados,0) recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND  pernominaid = ".$pernominaid." AND conceptoid = 47";
        $recargonocliq = $clase2->SeleccionarUno($vsql12);

        $recargonocper = $recargonochis + $recargonocliq;

        return $recargonocper;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función calsueldopromedio
    // Parámetro2 de entrada:    $terid --> ID del empelado
    //                           $fecingreso --> fecha de ingreso
    // Valor de retorno:         $salpromedio --> salario promedio
    // Descripción: Función que calcula el sueldo promedio de un empleado en el año actual
    ////////////////////////////////////////////////////////////////////////////////////////    
    function calsueldopromedio($terid,$fecingreso)
    {
        $clase2 = new Sistema();

        // inicializaión de variables
        $yearactual2 = date("Y");           $acumsueldo = 0;
        $nroquinceda = 0;                   $cant1 = 0;
        $cant2 = 0;                         $salpromedio = 0;
        $recarnonocturno = 0;

        // rango de periodos 
        $vsql36 = "SELECT MIN(periodoid) permin3
                     FROM periodosnomina 
                    WHERE fecdesde >= '".$fecingreso."' 
                          AND YEAR(fecdesde) = ".$yearactual2." 
                          AND calculado = 'CHECKED'";
        $permin3 = $clase2->SeleccionarUno($vsql36);        
        
        $vsql37 = "SELECT MAX(periodoid) permax3
                     FROM periodosnomina 
                    WHERE fecdesde >= '".$fecingreso."' 
                          AND YEAR(fecdesde) = ".$yearactual2." 
                          AND calculado = 'CHECKED'";
        $permax3 = $clase2->SeleccionarUno($vsql37);

        // promedio en hisdetallenomina
        $vsql38 = "SELECT pernominaid, saldo 
                     FROM hisdetallenomina 
                    WHERE terid = ".$terid." 
                          AND conceptoid IN (1,6,10,11,12,13,23,31,40,43,46) 
                          AND (pernominaid >= ".$permin3." AND pernominaid <= ".$permax3.") 
                 ORDER BY pernominaid";

        $conex = $clase2->Conectar();
        $result4 = mysql_query($vsql38,$conex);
        $cant1 = mysql_num_rows($result4);

        if($cant1 > 0)
        {
            $saldo = 0;
            while($row4 = mysql_fetch_array($result4))
            {
                $nroquinceda++;
                $saldo = $row4['saldo'] / 2;
                $pernominaid = $row4['pernominaid'];

                // busco recargo nocturno
                $recarnonocturno = buscarrecargonoc($terid,$pernominaid);
                $saldo += $recarnonocturno;
    
                $acumsueldo += $saldo;
            }
        }                

        // promedio en detalleliquidacion
        $permax3++;
        $vsql39 = "SELECT pernominaid, saldo 
                     FROM detalleliquidacion  
                    WHERE terid = ".$terid." 
                          AND conceptoid IN (1,6,10,11,12,13,23,31,40,43,46) 
                          AND (pernominaid >= ".$permin3." AND pernominaid <= ".$permax3.")
                 ORDER BY pernominaid";

        $conex = $clase2->Conectar();
        $result6 = mysql_query($vsql39,$conex);
        $cant2 = mysql_num_rows($result6);

        if($cant2 > 0)
        {
            $saldo = 0;
            while($row5 = mysql_fetch_array($result6))
            {
                $nroquinceda++;
                $saldo = $row5['saldo'] / 2;
                $pernominaid = $row5['pernominaid'];

                // busco recargo nocturno
                $recarnonocturno = buscarrecargonoc($terid,$pernominaid);
                $saldo += $recarnonocturno;                
    
                $acumsueldo += $saldo;
            }
        }

        // cálculo el sueldo promedio
        $salpromedio = $acumsueldo / $nroquinceda;
        $salpromedio = intval($salpromedio) * 2;

        return $salpromedio;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función generarlistaper
    // Parámetro de entrada:    $codperiodo    --> código del periodo
    // Valor de retorno:        $listaperiodos --> lista de periodos de nómina del periodo
    // Descripción: Función que devuelve la lista de periodos de nómina del periodo que se 
    //              está procesando
    ////////////////////////////////////////////////////////////////////////////////////////
    function generarlistaper($codperiodo)
    {
        $clase2 = new Sistema();

        $yeartoday = date("Y");

        $monthtoday = date("m");
        $daytoday = date("j");
        if(($monthtoday=="01")&&($daytoday<=16))   $yeartoday--;
        // ------------------------------------------------------------- //

        // Determino los periodos de nómina que se eliminarán
        $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                         FROM periodosnomina 
                        WHERE consecutivone <> ''
                              AND YEAR(fechasta) = ".$yeartoday."";
        $nummesval = $clase2->SeleccionarUno($vsqlmesval);
        
        $nummesval++;

        if($nummesval==13)      $nummesval = 1;

        $vsqlcodmesrep  = "SELECT codperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
        $codperiodo = $clase2->SeleccionarUno($vsqlcodmesrep);

        if(($codperiodo=="")||($codperiodo==NULL))
        {
            $yeartoday--;
            $nummesval--;
            $vsqlcodmesrep = "SELECT codperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
            $codperiodo = $clase2->SeleccionarUno($vsqlcodmesrep);
        }

        $vsqldesmesrep  = "SELECT desperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
        $desmesrep = $clase2->SeleccionarUno($vsqldesmesrep);

        $desperiodo = $clase2->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        $mesperiodo = substr($desperiodo,0,-5);

        // fechas del periodo
        $fecinicio = substr($desperiodo,-4)."-".substr($codperiodo,0,2)."-01";
        $fecfinal = date("Y-m-t", strtotime($fecinicio));

        // Consulta de los periodos de nómina
        $vsql = "SELECT periodoid 
                   FROM periodosnomina 
                  WHERE descripcion LIKE '%".$mesperiodo."%' 
                        AND descripcion LIKE '%".$yeartoday."%'";
        $conex  = $clase2->Conectar();
        $result = mysql_query($vsql,$conex);
        $periodosreportar = mysql_num_rows($result);

        // Periodos a procesar
        if($periodosreportar>0)
        {
            $j = 0;
            while($row = mysql_fetch_array($result))
            {
                $listaperiodos.= $row['periodoid'].",";
                $segundaquinper = $row['periodoid'];

                $j++;
                if($j==1)   $pquin = $row['periodoid'];
                if($j==2)   $squin = $row['periodoid'];
            }
            $listaperiodos = substr($listaperiodos, 0, -1);
        }
        return($listaperiodos);
    }    

    ////////////////////////////////
    echo $cont.$clase->PiePagina();
?>