<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>CRUD de Usuarios</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-4">
        
        <!-- Tabla para mostrar usuarios -->
        <div class="card">
            <div class="card-header"> 
               <div class="row">
                  <div class="col-10">
                    <h4> Lista de Usuarios APP </h4>
                  </div>
                  <div class="col-2">
                     <a href="crear_usuario.php" class="btn btn-sm btn-success">+ Crear Nuevo </a>
                  </div>
               </div>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Usuario</th>
                            <th>Nombre Completo</th>
                            <th>Bodega</th>
                            <th>Activo</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // Incluir la biblioteca de funciones
                        include '../funciones_crud.php';

                        // Leer todos los usuarios
                        $conn = conectarODBC("DSN-WEB-JE", "SYSDBA", "masterkey");
                        $usuarios = leerRegistros($conn, 'USUARIOSAPP');

                        foreach ($usuarios as $usuario) {
                            echo "<tr>";
                            echo "<td>{$usuario['USERNAME']}</td>";
                            echo "<td>{$usuario['NOMUSUARIO']}</td>";
                            echo "<td>{$usuario['CODBODEGA']}</td>";
                            echo "<td>" . ($usuario['ACTIVO'] == 1 ? 'Activo' : 'Inactivo') . "</td>";
                            echo '<td>
                                    <a href="editar_usuario.php?username=' . urlencode($usuario['USERNAME']) . '" class="btn btn-sm btn-warning">Editar</a>
                                    <a href="eliminar_usuario.php?username=' . urlencode($usuario['USERNAME']) . '" class="btn btn-sm btn-danger">Eliminar</a>
                                  </td>';
                            echo "</tr>";
                        }
                        odbc_close($conn);
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS y dependencias opcionales -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@1.16.0/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
