<?php
// Incluir la biblioteca de funciones
include '../funciones_crud.php';

// Verificar si se ha proporcionado un username
if (!isset($_GET['username'])) {
    header("Location: index.php");
    exit();
}

$username = $_GET['username'];

// Leer todos los usuarios
$conn = conectarODBC("DSN-WEB-JE", "SYSDBA", "masterkey");

// Obtener los datos del usuario
$usuario = leerRegistros($conn, 'USUARIOSAPP', "USERNAME = '$username'");

if (empty($usuario)) {
    echo "<script>alert('Usuario no encontrado');</script>";
    header("Location: index.php");
    exit();
}

odbc_close($conn);

$usuario = $usuario[0];
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Editar Usuario</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-4">
        <h1 class="mb-4">Editar Usuario</h1>

        <!-- Formulario para editar usuario -->
        <div class="card">
            <div class="card-header">
                Formulario de Edición
            </div>
            <div class="card-body">
                <form action="actualizar_usuario.php" method="post">
                    <input type="hidden" name="username" autocomplete="off" value="<?php echo $usuario['USERNAME']; ?>">
                    <div class="form-group">
                        <label for="password">Contraseña</label>
                        <input type="password" class="form-control" autocomplete="off" id="password" name="password" value="<?php echo $usuario['PASSWORD']; ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="nomusuario">Nombre Completo</label>
                        <input type="text" class="form-control" autocomplete="off" id="nomusuario" name="nomusuario" value="<?php echo $usuario['NOMUSUARIO']; ?>">
                    </div>
                    <div class="form-group">
                        <label for="terid">Cod Bodega</label>
                        <input type="number" class="form-control" id="codbodega" name="codbodega" value="<?php echo $usuario['CODBODEGA']; ?>">
                    </div>
                    <div class="form-group">
                        <label for="activo">Activo</label>
                        <select class="form-control" id="activo" name="activo">
                            <option value="1" <?php if ($usuario['ACTIVO'] == 1) echo 'selected'; ?>>Activo</option>
                            <option value="0" <?php if ($usuario['ACTIVO'] == 0) echo 'selected'; ?>>Inactivo</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="terid">ID Tercero</label>
                        <input type="number" class="form-control" id="terid" name="terid" value="<?php echo $usuario['TERID']; ?>">
                    </div>
                    <div class="form-group">
                        <label for="telmovil">Teléfono Móvil</label>
                        <input type="text" autocomplete="off" class="form-control" id="telmovil" name="telmovil" value="<?php echo $usuario['TELMOVIL']; ?>">
                    </div>
                    <div class="form-group">
                        <label for="email">Correo Electrónico</label>
                        <input type="email" autocomplete="off" class="form-control" id="email" name="email" value="<?php echo $usuario['EMAIL']; ?>">
                    </div>
                    <button type="submit" class="btn btn-primary">Actualizar</button>
                    <a href="index.php" class="btn btn-secondary">Cancelar</a>
                </form>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS y dependencias opcionales -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@1.16.0/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
