<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>CRUD de Usuarios</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-4">
        <h1 class="mb-4">CRUD de Usuarios</h1>

        <!-- Formulario para crear o actualizar usuario -->
        <div class="card">
            <div class="card-header">
                Formulario de Usuario
            </div>
            <div class="card-body">
                <form action="guardar_usuario.php" method="post">
                    <div class="form-group">
                        <label for="username">Nombre de Usuario</label>
                        <input type="text" autocomplete="off" class="form-control" id="username" name="username" required>
                    </div>
                    <div class="form-group">
                        <label for="password">Contraseña</label>
                        <input type="password" autocomplete="off" class="form-control" id="password" name="password" required>
                    </div>
                    <div class="form-group">
                        <label for="nomusuario">Nombre Completo</label>
                        <input type="text" autocomplete="off" class="form-control" id="nomusuario" name="nomusuario">
                    </div>
                    <div class="form-group">
                        <label for="terid">ID Tercero</label>
                        <input type="number" class="form-control" id="terid" name="terid">
                    </div>
                    <div class="form-group">
                        <label for="activo">Activo</label>
                        <select class="form-control" id="activo" name="activo">
                            <option value="1" selected>Activo</option>
                            <option value="0">Inactivo</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="telmovil">Teléfono Móvil</label>
                        <input type="text" autocomplete="off" class="form-control" id="telmovil" name="telmovil">
                    </div>
                    <div class="form-group">
                        <label for="email">Correo Electrónico</label>
                        <input type="email" autocomplete="off" class="form-control" id="email" name="email">
                    </div>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </form>
            </div>
        </div>

        <hr>

        <!-- Tabla para mostrar usuarios -->
        <div class="card">
            <div class="card-header">
                Lista de Usuarios
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Usuario</th>
                            <th>Nombre Completo</th>
                            <th>ID Tercero</th>
                            <th>Activo</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // Incluir la biblioteca de funciones
                        include '../funciones_crud.php';

                        // Leer todos los usuarios
                        $conn = conectarODBC("DSN-WEB-JE", "SYSDBA", "masterkey");
                        $usuarios = leerRegistros($conn, 'USUARIOSAPP');

                        foreach ($usuarios as $usuario) {
                            echo "<tr>";
                            echo "<td>{$usuario['USERNAME']}</td>";
                            echo "<td>{$usuario['NOMUSUARIO']}</td>";
                            echo "<td>{$usuario['TERID']}</td>";
                            echo "<td>" . ($usuario['ACTIVO'] == 1 ? 'Activo' : 'Inactivo') . "</td>";
                            echo '<td>
                                    <a href="editar_usuario.php?username=' . urlencode($usuario['USERNAME']) . '" class="btn btn-sm btn-warning">Editar</a>
                                    <a href="eliminar_usuario.php?username=' . urlencode($usuario['USERNAME']) . '" class="btn btn-sm btn-danger">Eliminar</a>
                                  </td>';
                            echo "</tr>";
                        }
                        odbc_close($conn);
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS y dependencias opcionales -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@1.16.0/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
