<?php
/// Defino la Hora del sistema a Bogota
date_default_timezone_set('America/Bogota');

//////////////////////////////////////////////////////////////////
/// FUNCION CREAR ENCABEZADO FACTURA
///  Genera un Recibo de Caja sin Asentar a favor de Un Tercero
///  Recibe : Terid del Tercero - Valor del Recibo
///  Retorna : 1 Si Fue Exitoso  -  0 Si fue Error
//////////////////////////////////////////////////////////////////
function CrearEncabezadoFactura($terid)
{
    $pre = 'PO';
    $num = '*'.rand(11111,99990);
    $fec = date("m/d/Y");
    $per = date("m");
    $hor = date("h:i");
    $usu = $_SESSION['USERNAME'];
    $nus = $_SESSION['NOMUSUARIO'];

    $vsql = "INSERT INTO KARDEX(CODCOMP,CODPREFIJO,NUMERO,FECHA,PERIODO,CENID,AREADID,SUCID,CLIENTE,VENDEDOR,FORMAPAGO,BCOID,RETIVA,RETICA,RETFTE,
             VRBASE,VRIVA,VRICONSUMO,TOTAL,FPCONTADO,FPCREDITO,USUARIO,HORA,FACTORCONV,DESXCAMBIO,PRONTOPAGO,HORACREA,PROPINA,USUACREA,CODVEN,NOMVENDEDOR,
             VRTOTAL,DESPACHAR_A) 
             VALUES('FV','".$pre."','".$num."','".$fec."','".$per."',1,1,1,'".$terid."',1,'CO',1,0,0,0,
             0,0,0,0,0,0,'".$usu."','".$hor."',0,0,0,'".$hor."',0,'".$usu."','00','".$nus."',0,'".$terid."')";  
//echo $vsql;
    //// Me Conecto y Ejecuto
    $conn = conectarODBC("DSN-WEB-JE", "SYSDBA", "masterkey");
    $res = ejecutarSQL($conn,$vsql);

    //// Busco el KardexID Recien Insertado
    $result = odbc_exec($conn, "SELECT KARDEXID FROM KARDEX WHERE CODCOMP = 'FV' AND CODPREFIJO = '".$pre."' AND NUMERO = '".$num."'");
    $row = odbc_fetch_array($result);
    $NKARDEXID = $row['KARDEXID'];

    odbc_close($conn);
    
    /// Retorno que se realizó Exitosamente
    return($NKARDEXID);
}

//////////////////////////////////////////////////////////////////
/// FUNCION CREAR DETALLES FACTURA
///  Genera un Recibo de Caja sin Asentar a favor de Un Tercero
///  Recibe : Terid del Tercero - Valor del Recibo
///  Retorna : 1 Si Fue Exitoso  -  0 Si fue Error
//////////////////////////////////////////////////////////////////
function CrearDetalleFactura($kardexid,$matid,$cantidad,$precio)
{
    $bod = 1;
    $par = 0+($cantidad*$precio);
    $fec = date("m/d/Y");
    $per = date("m");
    $hor = date("h:i");
    $usu = $_SESSION['USERNAME'];
    $nus = $_SESSION['NOMUSUARIO'];
    $retorno = 0;

    if(($cantidad>0)&&($precio>0))
    {
        $vsql = "INSERT INTO DEKARDEX(KARDEXID,MATID,BODID,PRIORIDAD,REMTOTFAC,TIPUND,PORCIVA,DESCUENTO,CANLISTA,CANMAT,PRECIOLISTA,PRECIOVTA,PRECIOBASE,PRECIOIVA,
                 PRECIONETO,PARCVTA,DCTOADIC,CAMBIO,CALIDAD,PRECIOTASA,PARCTASA)
                 VALUES('".$kardexid."','".$matid."','".$bod."',7,0,'D',0,0,'".$cantidad."','".$cantidad."','".$precio."','".$precio."','".$precio."',0,
                 '".$precio."','".$par."',0,0,0,'".$precio."','".$par."')"; 
    
        //// Me Conecto y Ejecuto
        $conn = conectarODBC("DSN-WEB-JE", "SYSDBA", "masterkey");
        $res = ejecutarSQL($conn,$vsql);
        odbc_close($conn);

        $retorno = 1;
    }

    //// ReTotalizo las Facturas
    totalizarFactura($kardexid);
    
    /// Retorno que se realizó Exitosamente
    return($retorno);
}


//////////////////////////////////////////////////////////////////
/// FUNCION CREAR DETALLES FACTURA
///  Genera un Recibo de Caja sin Asentar a favor de Un Tercero
///  Recibe : Terid del Tercero - Valor del Recibo
///  Retorna : 1 Si Fue Exitoso  -  0 Si fue Error
//////////////////////////////////////////////////////////////////
function FinalizarFactura($kardexid)
{
    $fecasent = date("m/d/Y");
    $prefijo = "PO";
    
    //// Me Conecto y Ejecuto
    $conn = conectarODBC("DSN-WEB-JE", "SYSDBA", "masterkey");

    //// Valido que la Factura esté SIN ASENTAR
    $vsql    = "SELECT KARDEXID , FECASENTAD FROM KARDEX WHERE KARDEXID = ".$kardexid;
    //echo $vsql."<br>";
    $result  = odbc_exec($conn, $vsql);
    $row = odbc_fetch_array($result);
    $EXISTE = $row['KARDEXID'];
    $FECASENTAD = $row['FECASENTAD'];
    
    if(($EXISTE != "")&&($FECASENTAD == ""))
    {
        //// Re Totalizo la Factura
        totalizarFactura($kardexid);
    
        //// Busco el Numero de los Consecutivos Actual
        $vsql    = "SELECT CONSECUTIVO FROM CONSECUTIVO WHERE CODCOMP = 'FV' AND CODPREFIJO = '".$prefijo."'";
        $result  = odbc_exec($conn, $vsql);
        $row = odbc_fetch_array($result);
        $NUMEROFACTURA = $row['CONSECUTIVO'];
        $nconsec = 0+($NUMEROFACTURA+1);
    
        //echo $vsql."<br>";
        //// Actualizo el Consecutivo al Siguiente
        $vsql = "UPDATE CONSECUTIVO SET CONSECUTIVO = '".$nconsec."' WHERE CODCOMP = 'FV' AND CODPREFIJO = '".$prefijo."'";
        $result = odbc_exec($conn, $vsql);
       // echo $vsql."<br>";
    
        //// Actualizo el Consecutivo en la Factura
        $vsql = "UPDATE KARDEX SET NUMERO = '".$nconsec."' WHERE KARDEXID = ".$kardexid;
        $result = odbc_exec($conn, $vsql);
        //echo $vsql."<br>";
    
        //// Asiento la Factura
        $vsql = "UPDATE KARDEX SET FECASENTAD = '01/01/2000' WHERE KARDEXID = ".$kardexid;
       // $result = odbc_exec($conn, $vsql);
       // echo $vsql."<br>";
    }

    // Me Desconecto 
    odbc_close($conn);
    
    /// Retorno que se realizó Exitosamente
    return($res);
}

//////////////////////////////////////////////////////////////////
/// FUNCION CREAR DETALLES FACTURA
///  Genera un Recibo de Caja sin Asentar a favor de Un Tercero
///  Recibe : Terid del Tercero - Valor del Recibo
///  Retorna : 1 Si Fue Exitoso  -  0 Si fue Error
//////////////////////////////////////////////////////////////////
function totalizarFactura($kardexid)
{
    $conn = conectarODBC("DSN-WEB-JE", "SYSDBA", "masterkey");

    //// Sumo los totales de las Lineas
    $vsql    = "SELECT SUM(PARCVTA) SUBTOTAL FROM DEKARDEX WHERE KARDEXID = ".$kardexid;
    $result  = odbc_exec($conn, $vsql);
    $row = odbc_fetch_array($result);
    $subtotal = 0+$row['SUBTOTAL'];

    //// Actualizo el Encabezado
    ejecutarSQL($conn,"UPDATE KARDEX SET TOTAL = ".$subtotal." WHERE KARDEXID = ".$kardexid);
    odbc_close($conn);

    return(1);
}


//////////////////////////////////////////////////////////////////
/// FUNCION CREAR DETALLES FACTURA
///  Genera un Recibo de Caja sin Asentar a favor de Un Tercero
///  Recibe : Terid del Tercero - Valor del Recibo
///  Retorna : 1 Si Fue Exitoso  -  0 Si fue Error
//////////////////////////////////////////////////////////////////
function eliminarLineaFactura($dekardexid)
{
    $conn = conectarODBC("DSN-WEB-JE", "SYSDBA", "masterkey");
    eliminarRegistro($conn, 'DEKARDEX', "DEKARDEXID = ".$dekardexid);
    odbc_close($conn);
    return(1);
}


//////////////////////////////////////////////////////////////////
/// FUNCION GENERARRECIBOCAJA
///  Genera un Recibo de Caja sin Asentar a favor de Un Tercero
///  Recibe : Terid del Tercero - Valor del Recibo
///  Retorna : 1 Si Fue Exitoso  -  0 Si fue Error
//////////////////////////////////////////////////////////////////
function GenerarReciboCaja($terid,$valor2)
{
    $pre = 'FE';
    $num = '*'.rand(11111,99990);
    $fec = date("m/d/Y");
    $per = date("m");
    $hor = date("h:i");
    $tot = $valor2;
    $det = "RC Generado desde APP";
    $usu = $_SESSION['USERNAME'];
    $nus = $_SESSION['NOMUSUARIO'];

    $vsql = "INSERT INTO RECIBO(TIPOIE,CODCOMP,CODPREFIJO,NUMERO,FECHA,DETALLE,TERID,TOTAL,TOTDESC,
             NETO,SUCID,PERIODO,FECASENT,AREADID,CENID,TOTALFP,COBRADOR,USUARIO,HORA,FACTORCONV) 
             VALUES('I','RC','".$pre."','".$num."','".$fec."','".$det."','".$terid."','".$tot."',0,
             '".$tot."',1,'".$per."','".$fec."',1,1,'".$tot."',1,'".$usu."','".$hor."',1)";  

    //// Me Conecto y Ejecuto
    $conn = conectarODBC("DSN-WEB-JE", "SYSDBA", "masterkey");
    $res = ejecutarSQL($conn,$vsql);

    //// Busco el KardexID Recien Insertado
    $result = odbc_exec($conn, "SELECT RECIBOID FROM RECIBO WHERE CODCOMP = 'RC' AND CODPREFIJO = '".$pre."' AND NUMERO = '".$num."'");
    $row = odbc_fetch_array($result);
    $NRECIBOID = $row['RECIBOID'];

    $vsql = "INSERT INTO DERECIBO(RECIBOID,DEDOCUMID,CONCID,VALOR,AREADID,VALBASE) VALUES('".$NRECIBOID."',1,1,'".$tot."',1,0)";  
    $res = ejecutarSQL($conn,$vsql);

    $vsql = "INSERT INTO DERECIFP(RECIBOID,BCOID,VALOR,FORMAPAGO) VALUES('".$NRECIBOID."',1,'".$tot."','EF')";   
    $res = ejecutarSQL($conn,$vsql);

    //// Busco el KardexID Recien Insertado
    $result = odbc_exec($conn, "SELECT MAX(NUMERO) NUMACTUAL FROM RECIBO WHERE CODCOMP = 'RC' AND CODPREFIJO = '".$pre."'");
    $row = odbc_fetch_array($result);
    $numeroactual = $row['NUMACTUAL'];
    $consecutivo = $numeroactual+1;

    //// Le Actualizo el Consecutivo
    $vsql = "UPDATE RECIBO SET NUMERO = '".$consecutivo."' WHERE RECIBOID = ".$NRECIBOID;   
    $res = ejecutarSQL($conn,$vsql);

    odbc_close($conn);
    return(1);
}


// Función para iniciar sesión
function iniciarSesion($usuario) {
    session_start();
    $_SESSION['USERNAME'] = $usuario['USERNAME'];
    $_SESSION['NOMUSUARIO'] = $usuario['NOMUSUARIO'];
    $_SESSION['BODEGAPREDET'] = $usuario['CODBODEGA'];
    $_SESSION['ACTIVO'] = $usuario['ACTIVO'];
    $_SESSION['ROL'] = $usuario['ROL'];
    $_SESSION['EMAIL'] = $usuario['EMAIL'];
}

// Función para cerrar sesión
function cerrarSesion() {
    session_start();
    // Eliminar todas las variables de sesión
    session_unset();
    // Destruir la sesión
    session_destroy();
}

// Función para verificar si hay una sesión iniciada
function sesionIniciada() {
    session_start();
    return isset($_SESSION['USERNAME']);
}

?>
