<?php
require('../../config/functions.php');

$host     = '';
$dbname   = '';
$user     = '';
$password = '';
	
// Configuración de CORS
header('Access-Control-Allow-Origin: *'); // Permite conexiones desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Database credentials
loadconectionparams($host,$dbname,$user,$password);		
$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if(!APIisactiva($pdo)) 
{ 
  http_response_code(401); // Unauthorized
  echo json_encode(['message' => 'API se encuentra Inactiva en este momento']);	
  exit;
} 

// API Endpoints
if (authenticate()) { // Check authentication before processing requests

    try {        

        // Get Request Method
        $method = $_SERVER['REQUEST_METHOD'];

        switch ($method) {
            case 'GET': // Read (all or single)
                if (isset($_GET['dni'])) {
                    $dni = $_GET['dni'];
                    $vsqlx = "SELECT cuadroid, recomendado, fechaingresonomina, codigotalentohumano, nombrefoto FROM cuadropersonal WHERE cedulatempo = '".$dni."'";
                    $stmt = $pdo->query($vsqlx);
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                }

                if (isset($_GET['tabla'])) {
                    $tabla = $_GET['tabla'];
                    $stmt = $pdo->query("SELECT AUTO_INCREMENT FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'movimientomul'");
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                }

                if (isset($_GET['cuadroid'])) {
                    $cuadroid = $_GET['cuadroid'];
                    $vsqlx = "SELECT terid, sucursalid FROM cuadropersonal WHERE cuadroid = ".$cuadroid."";
                    $stmt = $pdo->query($vsqlx);
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                }

                if (isset($_GET['idmovimiento'])) {
                    $idmovimiento = $_GET['idmovimiento'];
                    $vsqlx = "SELECT D.demovimientoid, D.movimientoid, D.tipo, S.descripcion sucursal, CONCAT(T.primernombre,' ',T.segundonombre,' ',T.primerapellido,' ',T.segundoapellido) AS nombreempleado, D.aplicado
                                FROM demovimientoscuadro D
	                                 INNER JOIN sucursales S ON (D.sucursalid = S.sucursalid)
			                         INNER JOIN terceros T ON (D.terid = T.terid)
                               WHERE D.movimientoid = ".$idmovimiento."
                            ORDER BY 1 ASC";
                    $stmt = $pdo->query($vsqlx);
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                }

                if (isset($_GET['movimientoidaux'])) {
                    $movimientoidaux = $_GET['movimientoidaux'];
                    $vsqlx = "SELECT COUNT(*) numvacantestemp FROM demovimientoscuadro WHERE tipo = 'VT' AND aplicado = 0 AND movimientoid = ".$movimientoidaux." ";
                    $stmt = $pdo->query($vsqlx);
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                }

                if (isset($_GET['idnundetalle'])) {
                    $idnundetalle = $_GET['idnundetalle'];
                    $vsqlx = "SELECT COUNT(*) nummovimientos FROM demovimientoscuadro WHERE movimientoid = ".$idnundetalle."";
                    $stmt = $pdo->query($vsqlx);
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                }

                if (isset($_GET['terid'])) {
                    $terid = $_GET['terid'];
                    $vsqlx = "SELECT codvende FROM terceros WHERE terid = ".$terid."";
                    $stmt = $pdo->query($vsqlx);
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                }

                if (isset($_GET['codvende'])) {
                    $codvende = $_GET['codvende'];
                    $vsqlx = "SELECT C.cuadroid, T.terid, C.sucursalid, T.cargoid 
                                FROM cuadropersonal C
	                                 INNER JOIN terceros T ON (C.terid = T.terid)
			                         INNER JOIN sucursales S ON (C.sucursalid = S.sucursalid)
                               WHERE T.codvende = ".$codvende."";
                    $stmt = $pdo->query($vsqlx);
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                }                

                header('Content-Type: application/json');
                echo json_encode($result);
                break;

            // case 'POST': // Create
            //     $data = json_decode(file_get_contents("php://input"), true);
            //     $i=0;
            //     while(@$data[$i]['sucursalid'])
            //     {
            //         /// Inserto la Vacante
            //         $vsqlx = "INSERT INTO vacantes (sucursalid, cargoid, codsolicita, codautoriza, fecautorizado, fecseleccionado, estado, creador)
            //                   VALUES (:sucursalid, :cargoid, :codsolicita, :codautoriza, :fecautorizado, :fecseleccionado, :estado, :creador)";
            //         $stmt = $pdo->prepare($vsqlx);
            //         $stmt->execute(['sucursalid' =>  $data[$i]['sucursalid'] , 'cargoid' =>  $data[$i]['cargoid'] , 'codsolicita' =>  $data[$i]['codsolicita'] , 'codautoriza' =>  $data[$i]['codautoriza'] , 'fecautorizado' =>  $data[$i]['fecautorizado'] , 'fecseleccionado' =>  $data[$i]['fecseleccionado'] , 'estado' =>  $data[$i]['estado'] , 'creador' =>  $data[$i]['creador']]);

            //         //// 
            //         $data = $pdo->query("SELECT * FROM vacantes ORDER BY vacanteid DESC LIMIT 0,1")->fetchAll();
            //         foreach ($data as $row) 
            //         {
            //            $vacanteid  = $row['vacanteid'];
            //            $sucursalid = $row['sucursalid'];
            //            $cargoid    = $row['cargoid'];
            //         }

            //         //// Inserto tambien en el Cuadro de Personal                   
            //         $vsqlx = "INSERT INTO cuadropersonal (vacanteid, sucursalid, cargovacanteid , creador , terid) 
            //                   VALUES (:vacanteid , :sucursalid, :cargoid , :creador , 0)";
            //         $stmt = $pdo->prepare($vsqlx);
            //         $stmt->execute(['vacanteid' =>  $vacanteid , 'sucursalid' =>  $sucursalid , 'cargoid' =>  $$cargoid , 'creador' => 'SYSTEM']);

            //         $i++;
            //     }        

            //     header('Content-Type: application/json');
            //     echo json_encode(['message' => 'Se han Creados '.$i.' Registros  con Exito']);
            //     break;

            case 'POST': // Create
                $data = json_decode(file_get_contents("php://input"), true);                
                $i=0;
                while($data[$i]['creador'])
                {
                    $stmt = $pdo->prepare('INSERT INTO movimientomul (creador,momento) VALUES (:creador,:momento)');                    
                    $stmt->execute(['creador' =>  $data[$i]['creador'], 'momento' =>  $data[$i]['momento']]);
                    $i++;
                }        

                header('Content-Type: application/json');
                echo json_encode(['message' => 'Se han Creados '.$i.' Registros  con Exito']);
                break;

            case 'PUT': // Update
                if (isset($_GET['cuadroid'])) {
                    $data = json_decode(file_get_contents("php://input"), true);

                    // //// Validaciones
                    // $vsqlx = "UPDATE terceros SET esempleado = :esempleado , esempleadoactivo = :esempleadoactivo WHERE terid = :terid";
                    // $stmt = $pdo->prepare($vsqlx);
                    // $stmt->execute(['esempleado' =>  $data['esempleado'] , 'esempleadoactivo' =>  $data['esempleadoactivo'] , 'terid' =>  $data['terid'] ]);

                    $vsqlx = "UPDATE cuadropersonal SET vacanteid = '".$data['vidcero']."', terid = '".$data['terid']."', recomendado = '".$data['recomendado']."', fechaingresonomina = '".$data['fechaingresonomina']."', codigotalentohumano = '".$data['codvende']."', nombrefoto = '".$data['nombrefoto']."' , cedulatempo = '".$data['cedulatempo']."' WHERE cuadroid = ".$_GET['cuadroid']."";
                    $stmt = $pdo->prepare($vsqlx);
                    $stmt->execute(['vacanteid' => $data['vidcero'], 'terid' => $data['terid'], 'recomendado' => $data['recomendado'], 'fechaingresonomina' => $data['fechaingresonomina'], 'codigotalentohumano' => $data['codvende'], 'nombrefoto' => $data['nombrefoto'], 'cedulatempo' => $data['cedulatempo'], 'cuadroid' => $data['cuadroid']]);

                    header('Content-Type: application/json');
                    echo json_encode(['message' => 'Record updated']);
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode(['message' => 'cuadroid ID is required for update']);
                }
                break;

            case 'DELETE': // Delete
                if (isset($_GET['id'])) {

                    // eliminación del encabezado
                    $stmt = $pdo->prepare('DELETE FROM cuadropersonal WHERE cuadroid = :id');
                    $stmt->execute(['id' => $_GET['id']]);

                    header('Content-Type: application/json');
                    echo json_encode(['message' => 'Record deleted']);
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode(['message' => 'Vacante ID is required for delete']);
                }
                break;

            default:
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;
        }

    } catch (PDOException $e) {
        http_response_code(500); // Internal Server Error
        echo json_encode(['message' => 'Database error: ' . $e->getMessage()]);
		exit;
    }
	
} else {
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'Authentication failed']);
	exit;
}

?>