<?php
require('../../config/functions.php');

$host     = '';
$dbname   = '';
$user     = '';
$password = '';
	
// Configuración de CORS
header('Access-Control-Allow-Origin: *'); // Permite conexiones desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Database credentials
loadconectionparams($host,$dbname,$user,$password);		
$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if(!APIisactiva($pdo)) 
{ 
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'API se encuentra Inactiva en este momento']);	
    exit;
} 

// API Endpoints
if (authenticate()) { // Check authentication before processing requests

    try {        

        // Get Request Method
        $method = $_SERVER['REQUEST_METHOD'];

        switch ($method) {
            case 'GET': // Read (all or single)
                if (isset($_GET['dni'])) {
                    $dni = $_GET['dni'];
                    $stmt = $pdo->prepare('SELECT terid, momento FROM terceros WHERE dni = :dni');
                    $stmt->execute(['dni' => $dni]);
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                } 


            // case 'GET': // Read (all or single)
                // // if (isset($_GET['id'])) {
                // //     $id = $_GET['id'];
                // //     $stmt = $pdo->prepare('SELECT * FROM seleccionvacantes WHERE idvacante = :id');
                // //     $stmt->execute(['id' => $id]);
                // //     $result = $stmt->fetch(PDO::FETCH_ASSOC);
                // // } else {

                // //     if (isset($_GET['id'])) {
                // //         $id = $_GET['id'];
                // //         $stmt = $pdo->prepare('SELECT * FROM seleccionvacantes WHERE idvacante = :id');
                // //         $stmt->execute(['idvacante' => $id]);
                // //         $result = $stmt->fetch(PDO::FETCH_ASSOC);
                // //     } else {
                // //         $stmt = $pdo->query("SELECT * FROM seleccionvacantes");
                // //         $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                // //     }
                // // }

                // $stmt = $pdo->query("SELECT MAX(codvende) codvende FROM terceros WHERE CAST(codvende AS INT) > 4802");
                // $result = $stmt->fetchAll(PDO::FETCH_ASSOC);                

                header('Content-Type: application/json');
                echo json_encode($result);
                break;

            case 'POST': // Create
                $data = json_decode(file_get_contents("php://input"), true);
                // echo $data[0]['idvacante']."+++++"; 
                $i=0;
                while($data[$i]['terid'])
                {
                    // echo"***". $data[$i]['terid']; exit();

                    $stmt = $pdo->prepare('INSERT INTO terceros (codigo,dni,tipodoc,nombres,apellidos,fecnaci,genero,direccion,telmovil,email,esempleado,esempleadoactivo,codvende,cupocredito,epsid,pensionesid,
                                                                 cesantiasid,basico,fecingreso,primernombre,segundonombre,primerapellido,segundoapellido,ingresoemp,creador)
                                                         VALUES (:codigo,:dni,:tipodoc,:nombres,:apellidos,:fecnaci,:genero,:direccion,:telmovil,:email,:esempleado,:esempleadoactivo,:codvende,:cupocredito,:epsid,
                                                                 :pensionesid,:cesantiasid,:basico,:fecingreso,:primernombre,:segundonombre,:primerapellido,:segundoapellido,:ingresoemp,:creador)');
                    
                    $stmt->execute(['codigo' =>  $data[$i]['codigo'], 'dni' =>  $data[$i]['dni'], 'tipodoc' =>  $data[$i]['tipodoc'], 'nombres' =>  $data[$i]['nombres'], 'apellidos' =>  $data[$i]['apellidos'], 
                                    'fecnaci' =>  $data[$i]['fecnaci'], 'genero' =>  $data[$i]['genero'], 'direccion' =>  $data[$i]['direccion'], 'telmovil' =>  $data[$i]['telmovil'], 'email' =>  $data[$i]['email'], 
                                    'esempleado' =>  $data[$i]['esempleado'], 'esempleadoactivo' =>  $data[$i]['esempleadoactivo'], 'codvende' =>  $data[$i]['codvende'], 'cupocredito' =>  $data[$i]['cupocredito'], 
                                    'epsid' =>  $data[$i]['epsid'], 'pensionesid' =>  $data[$i]['pensionesid'], 'cesantiasid' =>  $data[$i]['cesantiasid'], 'basico' =>  $data[$i]['basico'], 
                                    'fecingreso' =>  $data[$i]['fecingreso'], 'primernombre' =>  $data[$i]['primernombre'], 'segundonombre' =>  $data[$i]['segundonombre'], 
                                    'primerapellido' =>  $data[$i]['primerapellido'], 'segundoapellido' =>  $data[$i]['segundoapellido'], 'ingresoemp' =>  $data[$i]['ingresoemp'], 'creador' =>  $data[$i]['creador']]);
                    $i++;
                }        

                header('Content-Type: application/json');
                echo json_encode(['message' => 'Se han Creados '.$i.' Registros  con Exito']);
                break;

            case 'PUT': // Update
                if (isset($_GET['id'])) {
                    $data = json_decode(file_get_contents("php://input"), true);
                    //// Validaciones
                    // echo"***". $_GET['id']; exit();

                    $vsqlx = "UPDATE cuadropersonal SET terid = :terid, sucursalid = :sucursalid, categoria = :categoria, cargovacanteid = :cargovacanteid, recomendado = :recomendado, 
                                     fechaingresonomina = :fechaingresonomina, codigotalentohumano = :codigotalentohumano, creador = :creador, momento = :momento, cedulatempo = :cedulatempo,
                                     fechaexpediciondoc = :fechaexpediciondoc WHERE vacanteid = :vacanteid";                    

                    $stmt = $pdo->prepare($vsqlx);

                    $stmt->execute(['terid' => $data['terid'], 'sucursalid' => $data['sucursalid'], 'categoria' => $data['categoria'], 'cargovacanteid' => $data['cargovacanteid'], 
                                    'recomendado' => $data['recomendado'],'fechaingresonomina' => $data['fechaingresonomina'], 'codigotalentohumano' => $data['codigotalentohumano'], 
                                    'creador' => $data['creador'], 'momento' => $data['momento'],'cedulatempo' => $data['cedulatempo'], 'fechaexpediciondoc' => $data['fechaexpediciondoc'], 
                                    'vacanteid' => $data['vacanteid']]);

                    // --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
                    // se actualiza el estado de la vacante en el encabezado
                    $stmt = $pdo->prepare("UPDATE vacantes SET estado = :estado WHERE vacanteid =  :vacanteid");
                    $stmt->execute(['estado' => $data['estado'], 'vacanteid' => $data['vacanteid']]);

                    // se actualiza el estado de la vacante en el detalle

                    // selecionado
                    // $vsqlx = "UPDATE seleccionvacantes SET estado = :estadosel WHERE idvacante = :vacanteid AND dni = :cedulatempo";
                    $vsqlx = "UPDATE seleccionvacantes SET estado = '".$data['estadosel']."' WHERE idvacante = ".$data['vacanteid']." AND dni = '".$data['cedulatempo']."'";
                    $stmt = $pdo->prepare($vsqlx);                    
                    $stmt->execute(['estado' => $data['estadosel'], 'idvacante' => $data['vacanteid'], 'dni' => $data['cedulatempo']]);

                    // descartados
                    // $vsqlx = "UPDATE seleccionvacantes SET estado = :estadodes WHERE idvacante = :vacanteid AND dni <> :cedulatempo";
                    $vsqlx = "UPDATE seleccionvacantes SET estado = '".$data['estadodes']."' WHERE idvacante = ".$data['vacanteid']." AND dni <> '".$data['cedulatempo']."'";
                    $stmt = $pdo->prepare($vsqlx);
                    $stmt->execute(['estado' => $data['estadodes'], 'idvacante' => $data['vacanteid'], 'dni' => $data['cedulatempo']]);
                    // --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //

                    header('Content-Type: application/json');
                    echo json_encode(['message' => 'Record updated']);
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode(['message' => 'vacanteid is required for update']);
                }
                break;

            // case 'DELETE': // Delete
            //     if (isset($_GET['id'])) {
            //         $stmt = $pdo->prepare('DELETE FROM seleccionvacantes WHERE idseleccion = :id');
            //         $stmt->execute(['id' => $_GET['id']]);
            //         header('Content-Type: application/json');
            //         echo json_encode(['message' => 'Record deleted']);
            //     } else {
            //         http_response_code(400); // Bad Request
            //         echo json_encode(['message' => 'idmotivo ID is required for delete']);
            //     }
            //     break;

            default:
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;
        }

    } catch (PDOException $e) {
        http_response_code(500); // Internal Server Error
        echo json_encode(['message' => 'Database error: ' . $e->getMessage()]);
		exit;
    }
	
} else {
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'Authentication failed']);
	exit;
}

?>