<?php
require('../../config/functions.php');

$host     = '';
$dbname   = '';
$user     = '';
$password = '';
	
// Configuración de CORS
header('Access-Control-Allow-Origin: *'); // Permite conexiones desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Database credentials
loadconectionparams($host,$dbname,$user,$password);		
$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if(!APIisactiva($pdo)) 
{ 
  http_response_code(401); // Unauthorized
  echo json_encode(['message' => 'API se encuentra Inactiva en este momento']);	
  exit;
} 

// API Endpoints
if (authenticate()) { // Check authentication before processing requests
    try {        

        // Get Request Method
        $method = $_SERVER['REQUEST_METHOD'];

        switch ($method) {
            case 'GET': // Read (all or single)
                if (isset($_GET['id'])) 
                {
                    $id = $_GET['id'];
                    $stmt = $pdo->prepare('SELECT * FROM motivoexpediente WHERE idmotivo = :id');
                    $stmt->execute(['id' => $id]);
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                } 
                else 
                {
                    // $vsql = "SELECT C.cuadroid , T.codvende, CONCAT(T.primernombre,' ',T.segundonombre,' ',T.primerapellido,' ',T.segundoapellido) nombres, T.dni, T.genero, T.fecnaci, CA.descripcioncargo, 
                    //                 S.descripcion sucursal, R.nomregion, Z.nombre zona, DATEDIFF( NOW(),T.fecnaci) edad, T.direccion, T.telmovil, T.email, T.basico, B.codbanco, T.numcuenta, E.descripcioneps eps, 
                    //                 P.descripcionafp pensiones , CS.descripcion cesantias, CP.nombrecaja, T.ingresoemp, DATEDIFF(NOW(),T.ingresoemp) diaslaborados, T.fecingreso, 
                    //                 DATEDIFF(NOW(),T.fecingreso) diasdesdeingres , CI.nombre ciudad, CI.departamento , BC.descripcion banco , C.sucursalid
                    //            FROM cuadropersonal C		
                    //                 INNER JOIN terceros T ON (T.terid = C.terid)    				 				 
                    //                 INNER JOIN cargos CA ON (T.cargoid = CA.cargoid)		  		 
                    //                 INNER JOIN entidadesbancarias B ON (T.bancoid = B.bancoid) 					 
                    //                 INNER JOIN bancos BC ON (T.bancoid = BC.bancoid)				 
                    //                 INNER JOIN pensiones P ON (T.pensionesid = P.pensionesid) 		 
                    //                 INNER JOIN eps E ON (T.epsid = E.epsid)		 
                    //                 INNER JOIN cesantias CS ON (T.cesantiasid = CS.cesantiasid)							 
                    //                 INNER JOIN cajascompensacion CP ON (T.idcajacomp = CP.idcajacomp)					   				 
                    //                 INNER JOIN sucursales S ON (C.sucursalid = S.sucursalid)				 
                    //                 INNER JOIN zonas Z ON (Z.codzona = S.zona)  
                    //                 INNER JOIN regiones R ON (R.codregion = Z.codregion)		
                    //                 INNER JOIN ciudades CI ON (S.ciudadid = CI.ciudadid)
                    //           WHERE T.esempleado = 'CHECKED' AND T.esempleadoactivo = 'CHECKED' AND T.basico > 0 AND S.sucursalid = 3
                    //        ORDER BY S.orden ASC";

                    // $wherex.= " DATE_FORMAT(E.cargado, '%Y-%m-%d') = '".$fecha."'";

                    $vsql = "SELECT C.cuadroid , S.codigo codsuc , S.descripcion sucursal , C.* , VAC.* , T.* , Z.* , R.* , CI.nombre ciudad, CI.departamento , Z.nombre zona , CVA.nombrecargo , BC.descripcion banco , 
                                    T.codvende, CONCAT(T.primernombre,' ',T.segundonombre,' ',T.primerapellido,' ',T.segundoapellido) nombres, T.dni, T.genero, T.fecnaci, CA.descripcioncargo , BC.descripcion banco, 
                                    T.direccion, T.telmovil, T.email, T.basico, B.codbanco,  E.descripcioneps eps, P.descripcionafp pensiones , CS.descripcion cesantias, CP.nombrecaja,  
                                    DATEDIFF(NOW(),T.fecingreso) diasdesdeingres, (DATEDIFF(NOW(),T.fecnaci) / 360) edad, DATEDIFF(NOW(),T.ingresoemp) diastotales, C.sucursalid , SE.descripcionsec seccion,  
                                    CO.aliascoordina, 
                                    CASE
                                        WHEN MONTH(T.fecnaci) = 1 THEN 'ENERO'
                                        WHEN MONTH(T.fecnaci) = 2 THEN 'FEBRERO'
                                        WHEN MONTH(T.fecnaci) = 3 THEN 'MARZO'           
                                        WHEN MONTH(T.fecnaci) = 4 THEN 'ABRIL' 
                                        WHEN MONTH(T.fecnaci) = 5 THEN 'MAYO'
                                        WHEN MONTH(T.fecnaci) = 6 THEN 'JUNIO'         
                                        WHEN MONTH(T.fecnaci) = 7 THEN 'JULIO'
                                        WHEN MONTH(T.fecnaci) = 8 THEN 'AGOSTO'
                                        WHEN MONTH(T.fecnaci) = 9 THEN 'SEPTIEMBRE'
                                        WHEN MONTH(T.fecnaci) = 10 THEN 'OCTUBRE'
                                        WHEN MONTH(T.fecnaci) = 11 THEN 'NOVIEMBRE'
                                        WHEN MONTH(T.fecnaci) = 12 THEN 'DICIEMBRE'
                                    END mescumple                                     
                               FROM cuadropersonal C 
                                    INNER JOIN sucursales S ON (C.sucursalid = S.sucursalid)
                                    LEFT JOIN seccion SE ON (C.seccionid = SE.seccionid)
                                    LEFT JOIN zonas Z ON (Z.codzona = S.zona)  
                                    LEFT JOIN regiones R ON (R.codregion = Z.codregion) 
                                    INNER JOIN coordinaciones CO ON (Z.coordinaid = CO.coordinaid)
                                    INNER JOIN ciudades CI ON (S.ciudadid = CI.ciudadid) 
                                    LEFT JOIN vacantes VAC ON (VAC.vacanteid = C.vacanteid) 
                                    LEFT JOIN cargosvacantes CVA ON (CVA.cargoid = VAC.cargoid) 
                                    LEFT JOIN terceros T ON (T.terid = C.terid) 
                                    LEFT JOIN cargos CA ON (T.cargoid = CA.cargoid)	
                                    LEFT JOIN entidadesbancarias B ON (T.bancoid = B.bancoid) 
                                    LEFT JOIN bancos BC ON (T.bancoid = BC.bancoid)	
                                    LEFT JOIN pensiones P ON (T.pensionesid = P.pensionesid) 
                                    LEFT JOIN eps E ON (T.epsid = E.epsid)	
                                    LEFT JOIN cesantias CS ON (T.cesantiasid = CS.cesantiasid)	
                                    LEFT JOIN cajascompensacion CP ON (T.idcajacomp = CP.idcajacomp) 
                              WHERE 1
                           ORDER BY S.orden ASC";

                    $stmt = $pdo->query($vsql);
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                }

                header('Content-Type: application/json');
                echo json_encode($result);
                break;            

            default:
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;
        }

    } catch (PDOException $e) {
        http_response_code(500); // Internal Server Error
        echo json_encode(['message' => 'Database error: ' . $e->getMessage()]);
		exit;
    }
	
} else {
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'Authentication failed']);
	exit;
}

?>