<?php
require('../../config/functions.php');

$host     = '';
$dbname   = '';
$user     = '';
$password = '';
	
// Configuración de CORS
header('Access-Control-Allow-Origin: *'); // Permite conexiones desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Database credentials
loadconectionparams($host,$dbname,$user,$password);		
$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if(!APIisactiva($pdo)) 
{ 
  http_response_code(401); // Unauthorized
  echo json_encode(['message' => 'API se encuentra Inactiva en este momento']);	
  exit;
} 

// API Endpoints
if (authenticate()) { // Check authentication before processing requests

    try {        

        // Get Request Method
        $method = $_SERVER['REQUEST_METHOD'];

        switch ($method) {
            case 'GET': // Read (all or single)
                if (isset($_GET['terid'])) {
                    $terid = $_GET['terid'];
                    
                    // $vsqlx = "SELECT idexpediente, concepto, motivo, fecha FROM expediente WHERE terid = '".$terid."'";

                    $vsqlx = "SELECT E.idexpediente, C.concepto, M.descripcion motivo, E.fecha
                                FROM expediente E
	                                 INNER JOIN conceptoexpediente C ON (E.idconcepto = C.id)
			                         INNER JOIN motivoexpediente M ON (E.idmotivo = M.idmotivo)
                               WHERE E.terid = '".$terid."'
                            ORDER BY 3 ASC";

                    // echo $vsqlx; exit();

                    $stmt = $pdo->query($vsqlx);
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                }
                else
                {
                    if (isset($_GET['idexpediente'])) {
                        $idexpediente = $_GET['idexpediente'];
                        // $vsqlx = "SELECT concepto, motivo, fecha, motivo FROM expediente WHERE idexpediente = '".$idexpediente."'";

                        $vsqlx = "SELECT C.concepto, M.descripcion motivo, E.fecha, E.idexpediente, E.idconcepto, M.idmotivo
                                    FROM expediente E
	                                     INNER JOIN conceptoexpediente C ON (E.idconcepto = C.id)
			                             INNER JOIN motivoexpediente M ON (E.idmotivo = M.idmotivo)
                                   WHERE E.idexpediente = '".$idexpediente."'";
    
                        // echo $vsqlx; exit();
    
                        $stmt = $pdo->query($vsqlx);
                        $result = $stmt->fetch(PDO::FETCH_ASSOC);  
                    }                  
                }

                header('Content-Type: application/json');
                echo json_encode($result);
                break;

            // case 'POST': // Create
            //     $data = json_decode(file_get_contents("php://input"), true);
            //     $i=0;
            //     while(@$data[$i]['sucursalid'])
            //     {
            //         /// Inserto la Vacante
            //         $vsqlx = "INSERT INTO vacantes (sucursalid, cargoid, codsolicita, codautoriza, fecautorizado, fecseleccionado, estado, creador)
            //                   VALUES (:sucursalid, :cargoid, :codsolicita, :codautoriza, :fecautorizado, :fecseleccionado, :estado, :creador)";
            //         $stmt = $pdo->prepare($vsqlx);
            //         $stmt->execute(['sucursalid' =>  $data[$i]['sucursalid'] , 'cargoid' =>  $data[$i]['cargoid'] , 'codsolicita' =>  $data[$i]['codsolicita'] , 'codautoriza' =>  $data[$i]['codautoriza'] , 'fecautorizado' =>  $data[$i]['fecautorizado'] , 'fecseleccionado' =>  $data[$i]['fecseleccionado'] , 'estado' =>  $data[$i]['estado'] , 'creador' =>  $data[$i]['creador']]);

            //         //// 
            //         $data = $pdo->query("SELECT * FROM vacantes ORDER BY vacanteid DESC LIMIT 0,1")->fetchAll();
            //         foreach ($data as $row) 
            //         {
            //            $vacanteid  = $row['vacanteid'];
            //            $sucursalid = $row['sucursalid'];
            //            $cargoid    = $row['cargoid'];
            //         }

            //         //// Inserto tambien en el Cuadro de Personal                   
            //         $vsqlx = "INSERT INTO cuadropersonal (vacanteid, sucursalid, cargovacanteid , creador , terid) 
            //                   VALUES (:vacanteid , :sucursalid, :cargoid , :creador , 0)";
            //         $stmt = $pdo->prepare($vsqlx);
            //         $stmt->execute(['vacanteid' =>  $vacanteid , 'sucursalid' =>  $sucursalid , 'cargoid' =>  $$cargoid , 'creador' => 'SYSTEM']);

            //         $i++;
            //     }        

            //     header('Content-Type: application/json');
            //     echo json_encode(['message' => 'Se han Creados '.$i.' Registros  con Exito']);
            //     break;

            case 'PUT': // Update
                $data = json_decode(file_get_contents("php://input"), true);
                $i = 0;

                // $vsqlx = "UPDATE expediente SET codvende = '".$data['codvende']."', terid = ".$data['terid'].", fecha = '".$data['fecha']."', concepto = '".$data['concepto']."', motivo = '".$data['motivo']."' WHERE idexpediente = '".$data['idexpediente']."'";

                $vsqlx = "UPDATE expediente SET fecha = '".$data['fecha']."', idconcepto = '".$data['idconcepto']."', idmotivo = '".$data['idmotivo']."' WHERE idexpediente = '".$data['idexpediente']."'";
                $stmt = $pdo->prepare($vsqlx);
                $stmt->execute(['codvende' => $data['codvende'], 'terid' => $data['terid'], 'fecha' => $data['fecha'], 'concepto' => $data['concepto'], 'motivo' => $data['motivo'], 'idexpediente' => $data['idexpediente']]);

                header('Content-Type: application/json');
                echo json_encode(['message' => 'Record updated']);
                break;

            // case 'DELETE': // Delete
            //     if (isset($_GET['id'])) {

            //         // eliminación del encabezado
            //         $stmt = $pdo->prepare('DELETE FROM cuadropersonal WHERE terid = :id');
            //         $stmt->execute(['id' => $_GET['id']]);

            //         header('Content-Type: application/json');
            //         echo json_encode(['message' => 'Record deleted']);
            //     } else {
            //         http_response_code(400); // Bad Request
            //         echo json_encode(['message' => 'Vacante ID is required for delete']);
            //     }
            //     break;

            default:
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;
        }

    } catch (PDOException $e) {
        http_response_code(500); // Internal Server Error
        echo json_encode(['message' => 'Database error: ' . $e->getMessage()]);
		exit;
    }
	
} else {
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'Authentication failed']);
	exit;
}

?>