<?php
require('../../config/functions.php');

$host     = '';
$dbname   = '';
$user     = '';
$password = '';
	
// Configuración de CORS
header('Access-Control-Allow-Origin: *'); // Permite conexiones desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Database credentials
loadconectionparams($host,$dbname,$user,$password);		
$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if(!APIisactiva($pdo)) 
{ 
  http_response_code(401); // Unauthorized
  echo json_encode(['message' => 'API se encuentra Inactiva en este momento']);	
  exit;
} 

// API Endpoints
if (authenticate()) { // Check authentication before processing requests

    try {        

        // Get Request Method
        $method = $_SERVER['REQUEST_METHOD'];

        switch ($method) {
            // case 'GET': // Read (all or single)
            //     if (isset($_GET['id'])) {
            //         $id = $_GET['id'];
            //         $stmt = $pdo->prepare('SELECT * FROM vacantes WHERE vacanteid = :id');
            //         $stmt->execute(['id' => $id]);
            //         $result = $stmt->fetch(PDO::FETCH_ASSOC);
            //     } else {
            //         $stmt = $pdo->query("SELECT * FROM vacantes");
            //         $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            //     }
            //     header('Content-Type: application/json');
            //     echo json_encode($result);
            //     break;

            // case 'POST': // Create
            //     $data = json_decode(file_get_contents("php://input"), true);
            //     $i=0;
            //     while(@$data[$i]['codvende'])
            //     {
            //         /// Inserto la Vacante
            //         // $vsqlx = "INSERT INTO vacantes (sucursalid, cargoid, codsolicita, codautoriza, fecautorizado, fecseleccionado, estado, creador)
            //         //           VALUES (:sucursalid, :cargoid, :codsolicita, :codautoriza, :fecautorizado, :fecseleccionado, :estado, :creador)";

            //         $vsqlx = "INSERT INTO expediente (codvende, terid, fecha, concepto, motivo) VALUES (:codvende, :terid, :fecha, :concepto, :motivo)";

            //         $stmt = $pdo->prepare($vsqlx);
            //         $stmt->execute(['codvende' =>  $data[$i]['codvende'] , 'terid' =>  $data[$i]['terid'] , 'fecha' =>  $data[$i]['fecha'] , 'concepto' =>  $data[$i]['concepto'] , 'motivo' =>  $data[$i]['motivo']]);

            //         // //// 
            //         // $data = $pdo->query("SELECT * FROM vacantes ORDER BY vacanteid DESC LIMIT 0,1")->fetchAll();
            //         // foreach ($data as $row) 
            //         // {
            //         //    $vacanteid  = $row['vacanteid'];
            //         //    $sucursalid = $row['sucursalid'];
            //         //    $cargoid    = $row['cargoid'];
            //         // }

            //         // //// Inserto tambien en el Cuadro de Personal                   
            //         // $vsqlx = "INSERT INTO cuadropersonal (vacanteid, sucursalid, cargovacanteid , creador , terid) 
            //         //           VALUES (:vacanteid , :sucursalid, :cargoid , :creador , 0)";
            //         // $stmt = $pdo->prepare($vsqlx);
            //         // $stmt->execute(['vacanteid' =>  $vacanteid , 'sucursalid' =>  $sucursalid , 'cargoid' =>  $$cargoid , 'creador' => 'SYSTEM']);

            //         $i++;
            //     }        

            //     header('Content-Type: application/json');
            //     echo json_encode(['message' => 'Se han Creados '.$i.' Registros  con Exito']);
            //     break;

            // case 'PUT': // Update
            //     if (isset($_GET['id'])) {
            //         $data = json_decode(file_get_contents("php://input"), true);

            //         // //// Validaciones
            //         // $vsqlx = "UPDATE terceros SET esempleado = :esempleado , esempleadoactivo = :esempleadoactivo WHERE terid = :terid";
            //         // $stmt = $pdo->prepare($vsqlx);
            //         // $stmt->execute(['esempleado' =>  $data['esempleado'] , 'esempleadoactivo' =>  $data['esempleadoactivo'] , 'terid' =>  $data['terid'] ]);

            //         $vsqlx = "UPDATE terceros SET esempleado = '".$data['esempleado']."', esempleadoactivo = '".$data['esempleadoactivo']."' WHERE terid = ".$_GET['id']."";
            //         $stmt = $pdo->prepare($vsqlx);
            //         $stmt->execute(['esempleado' => $data['esempleado'], 'esempleadoactivo' => $data['esempleadoactivo'], 'terid' => $data['terid']]);

            //         header('Content-Type: application/json');
            //         echo json_encode(['message' => 'Record updated']);
            //     } else {
            //         http_response_code(400); // Bad Request
            //         echo json_encode(['message' => 'Vacante ID is required for update']);
            //     }
            //     break;

            case 'DELETE': // Delete
                if (isset($_GET['idexpediente'])) {

                    // eliminación del concepto del expediente
                    $stmt = $pdo->prepare('DELETE FROM expediente WHERE idexpediente = :idexpediente');
                    $stmt->execute(['idexpediente' => $_GET['idexpediente']]);

                    header('Content-Type: application/json');
                    echo json_encode(['message' => 'Record deleted']);
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode(['message' => 'Vacante ID is required for delete']);
                }
                break;

            default:
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;
        }

    } catch (PDOException $e) {
        http_response_code(500); // Internal Server Error
        echo json_encode(['message' => 'Database error: ' . $e->getMessage()]);
		exit;
    }
	
} else {
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'Authentication failed']);
	exit;
}

?>