<?php
header('Content-Type: application/json');
require 'config.php';
require 'Producto.php';

$producto = new Producto($pdo);

$request_method = $_SERVER['REQUEST_METHOD'];
$request_uri = explode('/', trim($_SERVER['REQUEST_URI'], '/'));

switch ($request_method) {
    case 'GET':
        if (isset($request_uri[1])) {
            // Obtener producto por ID
            $id = intval($request_uri[1]);
            $result = $producto->getById($id);
            echo json_encode($result);
        } else {
            // Obtener todos los productos
            $result = $producto->getAll();
            echo json_encode($result);
        }
        break;

    case 'POST':
        // Crear nuevo producto
        $data = json_decode(file_get_contents("php://input"), true);
        $producto->create($data);
        echo json_encode(['message' => 'Producto creado']);
        break;

    case 'PUT':
        // Actualizar producto
        $id = intval($request_uri[1]);
        $data = json_decode(file_get_contents("php://input"), true);
        $producto->update($id, $data);
        echo json_encode(['message' => 'Producto actualizado']);
        break;

    case 'DELETE':
        // Eliminar producto
        $id = intval($request_uri[1]);
        $producto->delete($id);
        echo json_encode(['message' => 'Producto eliminado']);
        break default:
        echo json_encode(['message' => 'Método no permitido']);
        break;
}
?>