<?php
class Producto {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getAll() {
        $stmt = $this->pdo->query("SELECT * FROM productos");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getById($id) {
        $stmt = $this->pdo->prepare("SELECT * FROM productos WHERE productoid = :id");
        $stmt->execute(['id' => $id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function create($data) {
        $stmt = $this->pdo->prepare("INSERT INTO productos (codigo, descripcion, nomcompleto, nomcomercial, nominstitucional, prinactivo, patologia, recambio, detallar, excluido, decreto, bloqueado, recompra, gruposprodid, clasificaprodid, lineaprodid, tipoproducto, codcums, codinvima, codbarra, espos, unidet, unimay, uniglo, unidadmedidaid, cantiunimedida, porcenboni, porcendiadia, porcutilfijo, porreffijo, porcutiles, factor1, factor2, factor3, factorglobal, factorglobal2, duracionesti, eximax, eximin, factortienda, eximinbod, porciva, codtipoiva, cantidadtotal, observacion, observagen, costoprom, costoinf, ultcosto, costoadic, precio1d, precio1m, precio1g, precio2d, precio2m, precio2g, precio3d, precio3m, precio3g, precio4d, precio4m, precio4g, precio5d, precio5m, precio5g, precio6d, precio6m, precio6g, precio7d, precio7m, precio7g, precio8d, precio8m, precio8g, precio9d, precio9m, precio9g, precio10d, precio10m, precio10g, preciobackup, porcenes1, porcenes2, porcenes3, porcenes4, porcenes5, rota30dias, rota60dias, rota90dias, rota100dias, feccreado, fecmodificado, posranking, posrankingsuc, pagodiario, controlado, regulado, rechazocloseup, imgfoto, tablacostoprom, formafarmaid, presentacionid, familia, inactivorep, referencia, activofijo, fotoprincipal, creador, nodevolucion, idtipoclasificacionproducto, idnuevacategoriaprod, idsubcategoriauno, idsubcategoriados, exibodega, beneficio1, beneficio2, storeid, sku, pricestore, permalink, status, inventariostatus, imageurl1, imageurl2, eninflicores, eninfcervezas, enimfgaseosas) VALUES (:codigo, :descripcion, :nomcompleto, :nomcomercial, :nominstitucional, :prinactivo, :patologia, :recambio, :detallar, :excluido, :decreto, :bloqueado, :recompra, :gruposprodid, :clasificaprodid, :lineaprodid, :tipoproducto, :codcums, :codinvima, :codbarra , :espos, :unidet, :unimay, :uniglo, :unidadmedidaid, :cantiunimedida, :porcenboni, :porcendiadia, :porcutilfijo, :porreffijo, :porcutiles, :factor1, :factor2, :factor3, :factorglobal, :factorglobal2, :duracionesti, :eximax, :eximin, :factortienda, :eximinbod, :porciva, :codtipoiva, :cantidadtotal, :observacion, :observagen, :costoprom, :costoinf, :ultcosto, :costoadic, :precio1d, :precio1m, :precio1g, :precio2d, :precio2m, :precio2g, :precio3d, :precio3m, :precio3g, :precio4d, :precio4m, :precio4g, :precio5d, :precio5m, :precio5g, :precio6d, :precio6m, :precio6g, :precio7d, :precio7m, :precio7g, :precio8d, :precio8m, :precio8g, :precio9d, :precio9m, :precio9g, :precio10d, :precio10m, :precio10g, :preciobackup, :porcenes1, :porcenes2, :porcenes3, :porcenes4, :porcenes5, :rota30dias, :rota60dias, :rota90dias, :rota100dias, :feccreado, :fecmodificado, :posranking, :posrankingsuc, :pagodiario, :controlado, :regulado, :rechazocloseup, :imgfoto, :tablacostoprom, :formafarmaid, :presentacionid, :familia, :inactivorep, :referencia, :activofijo, :fotoprincipal, :creador, :nodevolucion, :idtipoclasificacionproducto, :idnuevacategoriaprod, :idsubcategoriauno, :idsubcategoriados, :exibodega, :beneficio1, :beneficio2, :storeid, :sku, :pricestore, :permalink, :status, :inventariostatus, :imageurl1, :imageurl2, :eninflicores, :eninfcervezas, :eninfgaseosas)");
        return $stmt->execute($data);
    }

    public function update($id, $data) {
        $data['id'] = $id;
        $stmt = $this->pdo->prepare("UPDATE productos SET codigo = :codigo, descripcion = :descripcion, nomcompleto = :nomcompleto, nomcomercial = :nomcomercial, nominstitucional = :nominstitucional, prinactivo = :prinactivo, patologia = :patologia, recambio = :recambio, detallar = :detallar, excluido = :excluido, decreto = :decreto, bloqueado = :bloqueado, recompra = :recompra, gruposprodid = :gruposprodid, clasificaprodid = :clasificaprodid, lineaprodid = :lineaprodid, tipoproducto = :tipoproducto, codcums = :codcums, codinvima = :codinvima, codbarra = :codbarra, espos = :espos, unidet = :unidet, unimay = :unimay, uniglo = :uniglo, unidadmedidaid = :unidadmedidaid, cantiunimedida = :cantiunimedida, porcenboni = :porcenboni, porcendiadia = :porcendiadia, porcutilfijo = :porcutilfijo, porreffijo = :porreffijo, porcutiles = :porcutiles, factor1 = :factor1, factor2 = :factor2, factor3 = :factor3, factorglobal = :factorglobal, factorglobal2 = :factorglobal2, duracionesti = :duracionesti, eximax = :eximax, eximin = :eximin, factortienda = :factortienda, eximinbod = :eximinbod, porciva = :porciva, codtipoiva = :codtipoiva, cantidadtotal = :cantidadtotal, observacion = :observacion, observagen = :observagen, costoprom = :costoprom, costoinf = :costoinf, ultcosto = :ultcosto, costoadic = :costoadic, precio1d = :precio1d, precio1m = :precio1m, precio1g = :precio1g, precio2d = :precio2d, precio2m = :precio2m, precio2g = :precio2g, precio3d = :precio3d, precio3m = :precio3m, precio3g = :precio3g, precio4d = :precio4d, precio4m = :precio4m, precio4g = :precio4g, precio5d = :precio5d, precio5m = :precio5m, precio5g = :precio5g, precio6d = :precio6d, precio6m = :precio6m, precio6g = :precio6g, precio7d = :precio7d, precio7m = :precio7m, precio7g = :precio7g, precio8d = :precio8d, precio8m = :precio8m, precio8g = :precio8g, precio9d = :precio9d, precio9m = :precio9m, precio9g = :precio9g, precio10d = :precio10d, precio10m = :precio10m, precio10g = :precio10g, preciobackup = :preciobackup, porcenes1 = :porcenes1, porcenes2 = :porcenes2, porcenes3 = :porcenes3, porcenes4 = :porcenes4, porcenes5 = :porcenes5, rota30dias = :rota30dias, rota60dias = :rota60dias, rota90dias = :rota90dias, rota100dias = :rota100dias, feccreado = :feccreado, fecmodificado = :fecmodificado, posranking = :posranking, posrankingsuc = :posrankingsuc, pagodiario = :pagodiario, controlado = :controlado, regulado = :regulado, rechazocloseup = :rechazocloseup, imgfoto = :imgfoto, tablacostoprom = :tablacostoprom, formafarmaid = :formafarmaid, presentacionid = :presentacionid, familia = :familia, inactivorep = :inactivorep, referencia = :referencia, activofijo = :activofijo, fotoprincipal = :fotoprincipal, creador = :creador, nodevolucion = :nodevolucion, idtipoclasificacionproducto = :idtipoclasificacionproducto, idnuevacategoriaprod = :idnuevacategoriaprod, idsubcategoriauno = :idsubcategoriauno, idsubcategoriados = :idsubcategoriados, exibodega = :exibodega, beneficio1 = :beneficio1, beneficio2 = :beneficio2, storeid = :storeid, sku = :sku, pricestore = :pricestore, permalink = :permalink, status = :status, inventariostatus = :inventariostatus WHERE productoid = :id");
        return $stmt->execute($data);
    }

    public function delete($id) {
        $stmt = $this->pdo->prepare("DELETE FROM productos WHERE productoid = :id");
        return $stmt->execute(['id' => $id]);
    }
}
?>