<?php
class GrupoProd {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getAll() {
        $stmt = $this->pdo->query("SELECT * FROM gruposprod");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getById($id) {
        $stmt = $this->pdo->prepare("SELECT * FROM gruposprod WHERE gruposprodid = :id");
        $stmt->execute(['id' => $id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function create($data) {
        $stmt = $this->pdo->prepare("INSERT INTO gruposprod (codigo, descripcion, porcen, orden, orden2, orden3, orden4, nodevolverexceso, codregioncompra, codregionentrega, compradirecto, observacion, creador, encargado, concurso1, licores, nomcomprador) VALUES (:codigo, :descripcion, :porcen, :orden, :orden2, :orden3, :orden4, :nodevolverexceso, :codregioncompra, :codregionentrega, :compradirecto, :observacion, :creador, :encargado, :concurso1, :licores, :nomcomprador)");
        return $stmt->execute($data);
    }

    public function update($id, $data) {
        $data['id'] = $id;
        $stmt = $this->pdo->prepare("UPDATE gruposprod SET codigo = :codigo, descripcion = :descripcion, porcen = :porcen, orden = :orden, orden2 = :orden2, orden3 = :orden3, orden4 = :orden4, nodevolverexceso = :nodevolverexceso, codregioncompra = :codregioncompra, codregionentrega = :codregionentrega, compradirecto = :compradirecto, observacion = :observacion, creador = :creador, encargado = :encargado, concurso1 = :concurso1, licores = :licores, nomcomprador = :nomcomprador WHERE gruposprodid = :id");
        return $stmt->execute($data);
    }

    public function delete($id) {
        $stmt = $this->pdo->prepare("DELETE FROM gruposprod WHERE gruposprodid = :id");
        return $stmt->execute(['id' => $id]);
    }
}
?>