<?php
header('Content-Type: application/json');
require 'config.php';
require 'Bodega.php';

$bodega = new Bodega($pdo);

$request_method = $_SERVER['REQUEST_METHOD'];
$request_uri = explode('/', trim($_SERVER['REQUEST_URI'], '/'));

switch ($request_method) {
    case 'GET':
        if (isset($request_uri[1])) {
            // Obtener bodega por ID
            $id = intval($request_uri[1]);
            $result = $bodega->getById($id);
            echo json_encode($result);
        } else {
            // Obtener todas las bodegas
            $result = $bodega->getAll();
            echo json_encode($result);
        }
        break;

    case 'POST':
        // Crear nueva bodega
        $data = json_decode(file_get_contents("php://input"), true);
        $bodega->create($data);
        echo json_encode(['message' => 'Bodega creada']);
        break;

    case 'PUT':
        // Actualizar bodega
        $id = intval($request_uri[1]);
        $data = json_decode(file_get_contents("php://input"), true);
        $bodega->update($id , $data);
        echo json_encode(['message' => 'Bodega actualizada']);
        break;

    case 'DELETE':
        // Eliminar bodega
        $id = intval($request_uri[1]);
        $bodega->delete($id);
        echo json_encode(['message' => 'Bodega eliminada']);
        break;

    default:
        echo json_encode(['message' => 'Método no permitido']);
        break;
}
?>