<?php
require('../../config/functions.php');

$host     = '';
$dbname   = '';
$user     = '';
$password = '';
	
// Configuración de CORS
header('Access-Control-Allow-Origin: *'); // Permite conexiones desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Database credentials
loadconectionparams($host,$dbname,$user,$password);		
$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if(!APIisactiva($pdo)) 
{ 
  http_response_code(401); // Unauthorized
  echo json_encode(['message' => 'API se encuentra Inactiva en este momento']);	
  exit;
} 

// API Endpoints
if (authenticate()) { // Check authentication before processing requests

    try {        

        // Get Request Method
        $method = $_SERVER['REQUEST_METHOD'];

        switch ($method) {
            case 'GET': // Read (all or single)
                if (isset($_GET['id'])) {
                    $stmt = $pdo->prepare("SELECT * FROM bodegas WHERE bodegaid = ?");
                    $stmt->execute([$_GET['id']]);
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                } else {
                    $stmt = $pdo->query("SELECT * FROM bodegas");
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                }
                header('Content-Type: application/json');
                echo json_encode($result);
                break;

            case 'POST': // Create
                $data = json_decode(file_get_contents("php://input"), true);

                $stmt = $pdo->prepare("INSERT INTO bodegas (codbodega, nombodega, nomcorto, tipobodega, remidestino, sucursalid, activa, bodespecial, bodprincipal, visibletodos, tipoexistencia, orden) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                
                $stmt->execute([$data['codbodega'], $data['nombodega'], $data['nomcorto'], $data['tipobodega'], $data['remidestino'], $data['sucursalid'], $data['activa'], $data['bodespecial'], $data['bodprincipal'], $data['visibletodos'], $data['tipoexistencia'], $data['orden']]);
                
                header('Content-Type: application/json');
                echo json_encode(['message' => 'Record created']);
                break;

            case 'PUT': // Update
                if (isset($_GET['id'])) {
                    $data = json_decode(file_get_contents("php://input"), true);
                    $stmt = $pdo->prepare("UPDATE bodegas SET codbodega = ?, nombodega = ?, nomcorto = ?, tipobodega = ?, remidestino = ?, sucursalid = ?, activa = ?, bodespecial = ?, bodprincipal = ?, visibletodos = ?, tipoexistencia = ?, orden = ? WHERE bodegaid = ?");
                    $stmt->execute([$data['codbodega'], $data['nombodega'], $data['nomcorto'], $data['tipobodega'], $data['remidestino'], $data['sucursalid'], $data['activa'], $data['bodespecial'], $data['bodprincipal'], $data['visibletodos'], $data['tipoexistencia'], $data['orden'], $_GET['id']]);
                    header('Content-Type: application/json');
                    echo json_encode(['message' => 'Record updated']);
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode(['message' => 'Bodega ID is required for update']);
                }
                break;

            case 'DELETE': // Delete
                if (isset($_GET['id'])) {
                    $stmt = $pdo->prepare("DELETE FROM bodegas WHERE bodegaid = ?");
                    $stmt->execute([$_GET['id']]);
                    header('Content-Type: application/json');
                    echo json_encode(['message' => 'Record deleted']);
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode(['message' => 'Bodega ID is required for delete']);
                }
                break;

            default:
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;
        }

    } catch (PDOException $e) {
        http_response_code(500); // Internal Server Error
        echo json_encode(['message' => 'Database error: ' . $e->getMessage()]);
		exit;
    }
	
} else {
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'Authentication failed']);
	exit;
}

?>