<?php
header('Content-Type: application/json');
require 'config.php';
require 'Tercero.php';

$tercero = new Tercero($pdo);

$request_method = $_SERVER['REQUEST_METHOD'];
$request_uri = explode('/', trim($_SERVER['REQUEST_URI'], '/'));

switch ($request_method) {
    case 'GET':
        if (isset($request_uri[1])) {
            // Obtener tercero por ID
            $id = intval($request_uri[1]);
            $result = $tercero->getById($id);
            echo json_encode($result);
        } else {
            // Obtener todos los terceros
            $result = $tercero->getAll();
            echo json_encode($result);
        }
        break;

    case 'POST':
        // Crear nuevo tercero
        $data = json_decode(file_get_contents("php://input"), true);
        $tercero->create($data);
        echo json_encode(['message' => 'Tercero creado']);
        break;

    case 'PUT':
        // Actualizar tercero
        $id = intval($request_uri[1]);
        $data = json_decode(file_get_contents("php://input"), true);
        $tercero->update($id, $data);
        echo json_encode(['message' => 'Tercero actualizado']);
        break;

    case 'DELETE':
        // Eliminar tercero
        $id = intval($request_uri[1]);
        $tercero->delete($id);
        echo json_encode(['message' => 'Tercero eliminado']);
        break;

    default:
        echo json_encode(['message' => 'Método no permitido']);
        break;
}
?>