<?php
class Consecutivo {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getAll() {
        $stmt = $this->pdo->query("SELECT * FROM consecutivos");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getById($id) {
        $stmt = $this->pdo->prepare("SELECT * FROM consecutivos WHERE consecutivoid = :id");
        $stmt->execute(['id' => $id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function create($data) {
        $stmt = $this->pdo->prepare("INSERT INTO consecutivos 
            (tipoconse, tipodoc, prefijo, numero, descripcion, sucursalid, consecutivoremoto, 
            impresionpos, encab1, encab2, encab3, encab4, encab5, pie1, pie2, pie3, pie4, pie5, 
            num_max, fecha_max, txtresolucion) 
            VALUES 
            (:tipoconse, :tipodoc, :prefijo, :numero, :descripcion, :sucursalid, :consecutivoremoto, 
            :impresionpos, :encab1, :encab2, :encab3, :encab4, :encab5, :pie1, :pie2, :pie3, :pie4, :pie5, 
            :num_max, :fecha_max, :txtresolucion)");
        
        return $stmt->execute($data);
    }

    public function update($id, $data) {
        $data['id'] = $id;
        $stmt = $this->pdo->prepare("UPDATE consecutivos SET 
            tipoconse = :tipoconse,
            tipodoc = :tipodoc,
            prefijo = :prefijo,
            numero = :numero,
            descripcion = :descripcion,
            sucursalid = :sucursalid,
            consecutivoremoto = :consecutivoremoto,
            impresionpos = :impresionpos,
            encab1 = :encab1,
            encab2 = :encab2,
            encab3 = :encab3,
            encab4 = :encab4,
            encab5 = :encab5,
            pie1 = :pie1,
            pie2 = :pie2,
            pie3 = :pie3,
            pie4 = :pie4,
            pie5 = :pie5,
            num_max = :num_max,
            fecha_max = :fecha_max,
            txtresolucion = :txtresolucion
            WHERE consecutivoid = :id");
            
        return $stmt->execute($data);
    }

    public function delete($id) {
        $stmt = $this->pdo->prepare("DELETE FROM consecutivos WHERE consecutivoid = :id");
        return $stmt->execute(['id' => $id]);
    }
}
?>