<?php
header('Content-Type: application/json');
require 'config.php';
require 'Ciudad.php';

$ciudad = new Ciudad($pdo);

$request_method = $_SERVER['REQUEST_METHOD'];
$request_uri = explode('/', trim($_SERVER['REQUEST_URI'], '/'));

switch ($request_method) {
    case 'GET':
        if (isset($request_uri[1])) {
            // Obtener ciudad por ID
            $id = intval($request_uri[1]);
            $result = $ciudad->getById($id);
            echo json_encode($result);
        } else {
            // Obtener todas las ciudades
            $result = $ciudad->getAll();
            echo json_encode($result);
        }
        break;

    case 'POST':
        // Crear nueva ciudad
        $data = json_decode(file_get_contents("php://input"), true);
        $ciudad->create($data);
        echo json_encode(['message' => 'Ciudad creada']);
        break;

    case 'PUT':
        // Actualizar ciudad
        $id = intval($request_uri[1]);
        $data = json_decode(file_get_contents("php://input"), true);
        $ciudad->update($id, $data);
        echo json_encode(['message' => 'Ciudad actualizada']);
        break;

    case 'DELETE':
        // Eliminar ciudad
        $id = intval($request_uri[1]);
        $ciudad->delete($id);
        echo json_encode(['message' => 'Ciudad eliminada']);
        break;

    default:
        echo json_encode(['message' => 'Método no permitido']);
        break;
}
?>