<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 13/12/2021		última modificación: 16/12/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana principal del informe
    // Última modificación: Vistas tipo html y pdf
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        // Combo de empleados
        $params = ' class="Texto11" ';
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE basico > 0
                       ORDER BY primernombre";
    
        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cotizacion.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Acumulado por persona - concepto </b><td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>           
                </table>';
        
        $cont.='<form action="acumpersconp.php?opcion=filtraracum" method="POST" name="x" target="_blank">
                 <center>
                 <table width="100%">
                  <tr class="BarraDocumentos">
                   <td align="center"><br><br><b> Datos del informe <br><br></td>
                  </tr>
                 </table>  
                 <table width="100%">
                  <tr class="BarraDocumentos"> 
                   <td width="200"> &nbsp; </td>
                   <td width="100"> Empleado: </td>
                   <td width="120">';

        $cont.= $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,500);
                    
        $cont.='   </td> 
                   <td width="160"> &nbsp; </td>
                  </tr>
                  <tr class="BarraDocumentos"> 
                   <td width="200"> &nbsp; </td>
                   <td width="100"> Fecha desde: </td>
                   <td width="120"> 
                    <input type="date" name="fecdesde" class="Texto11"  tabindex="4" autocomplete="off"> 
                   </td> 
                   <td width="160"> &nbsp; </td>                
                  </tr>
                  <tr class="BarraDocumentos"> 
                   <td width="200"> &nbsp; </td>
                   <td width="100"> Fecha hasta: </td>
                   <td width="120">
                    <input type="date" name="fechasta" class="Texto11"  tabindex="4" autocomplete="off">
                   </td> 
                   <td width="160"> &nbsp; </td>                
                  </tr>
                 </table>                   
                 <table width="100%">                     
                  <tr class="BarraDocumentos"> 
                   <td width="371" height="50" align="center">&nbsp;  </td>      
                   <td width="164" height="50" align="center"> <input type="submit" value="vista" class="button blue" name="tiposalida"></td>
                   <td width="131" height="50" align="center"> <input type="submit" value="pdf" class="button red" name="tiposalida"></td>
                   <td width="185" height="50" align="center"> <input type="submit" value="excel" class="button blue" name="tiposalida"></td> 
                   <td width="380" height="50" align="center">&nbsp;  </td>
                  </tr>
                 </table> 
                </form>';

        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                </table>';
        echo $cont;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtraracum
    // Creación: 20/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que imprime el informe de acuerdo al tipo de salida seleccionado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion=="filtraracum")
    {
        $terid  = $_POST['terid'];              // Variable para filtrar el periodo        
        $tiposalida = $_POST["tiposalida"];     // Variable que indica qué tipo de informe se mostrará
        $fecdesde  = $_POST['fecdesde'];        // fecha de inicio
        $fechasta  = $_POST['fechasta'];        // fecha final

        // Valido que todos los datos sean digitados
        if(($terid=="")||($fecdesde=="")||($fechasta==""))
        {
            $clase->Aviso(3,"Los datos empleado, fecha desde y fecha hasta deben ser digitados");
            header("Location: acumpersconp.php?opcion=ventanadatos");            
        }
        else
        {
            // Valido que la fecha desde sea menor que la fecha hasta            
            require_once("classes/class_validaciones.php");         // Clase para la validación de las fechas
            $io_fecha=new class_validaciones();
            
            $lb_valido=false;
            $lb_valido=$io_fecha->uf_comparar_fecha($fecdesde,$fechasta);   // llamdo al procedimiento de validación de la fecha
            if(!$lb_valido)
            {
                $clase->Aviso(3,"La fecha hasta debe ser mayor a la fecha desde");
                header("Location: acumpersconp.php?opcion=ventanadatos");                
            }
            else
            {
                // Nombre del empleado
                $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
                $nombreemp = $clase->SeleccionarUno($vsql);

                $fecinicio  = substr($fecdesde,8,2)."/".substr($fecdesde,5,2)."/".substr($fecdesde,0,4);
                $fecfinal  = substr($fechasta,8,2)."/".substr($fechasta,5,2)."/".substr($fechasta,0,4);            
        
                // Valido que el periodo tenga datos para emitir el reporte
                $vsqldatos = "SELECT COUNT(*) AS numreg 
                                FROM hisdetallenomina h
                                     INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)           
                                     INNER JOIN periodosnomina p ON (h.pernominaid = p.periodoid)           
                               WHERE h.terid = ".$terid."
                                     AND p.fechasta BETWEEN '".$fecdesde."' AND '".$fechasta."'
                            ORDER BY c.conceptoid, p.fechasta";
                $numreg = $clase->SeleccionarUno($vsqldatos);
        
                if($numreg==0)
                {    
                    $clase->Aviso(3,"$nombreemp no tiene datos en el periodo entre $fecinicio y $fecfinal");
                    header("Location: acumpersconp.php?opcion=ventanadatos");
                }
                else
                {
                    // Datos del empleado
                    $dni = $clase->BDLockup($terid,'terceros','terid','dni');       // Documento

                    // El cargo
                    $vsqldatos = "SELECT c.descripcioncargo AS cargo 
                                    FROM periodoterceros p
                                         INNER JOIN cargos c ON (p.cargoid = c.cargoid) 
                                   WHERE p.terid = ".$terid;
                    $cargo = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";

                    // La sección
                    $vsqldatos = "SELECT s.descripcionsec 
                                    FROM periodoterceros p
                                         INNER JOIN seccion s ON (p.seccionid = s.seccionid) 
                                   WHERE p.terid = ".$terid;
                    $seccion = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";

                    // El área
                    $vsqldatos = "SELECT a.descripcionarea 
                                    FROM periodoterceros p
                                         INNER JOIN areanomina a ON (p.areaid = a.areaid) 
                                   WHERE p.terid = ".$terid;
                    $area = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";

                    $fechaminima = "2021-02-28";    // Esta fecha se inicializa así porque el dropos tiene datos desde la segunda quincena de febrero

                    // Consulta del informe
                    $vsql = "SELECT p.codigo, p.fechasta, h.valor, c.nomconcepto, h.devengados, h.descuentos, c.tipodc 
                               FROM hisdetallenomina h
                                    INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)           
                                    INNER JOIN periodosnomina p ON (h.pernominaid = p.periodoid)           
                              WHERE h.terid = ".$terid."
                                    AND p.fechasta BETWEEN '".$fecdesde."' AND '".$fechasta."'
                                    AND p.fechasta >= '".$fechaminima."'
                           ORDER BY c.conceptoid, p.fechasta";

                    // Salida en vista html
                    if($tiposalida=="vista")
                    {
                        // pintamos la ventana
                        $cont = $clase->Header("S","W");
                        $cont.='<table width="100%">
                                 <tr class="CabezoteTabla"> 
                                  <td width="10"> &nbsp; </td>
                                  <td width="37"> <img src="images/iconos/cotizacion.png" width="32" height="32" border="0"> </td>
                                  <td width="840"> <b> Acumulado por persona - concepto </b><td>
                                  <td> &nbsp; </td>
                                  <td width="8"> &nbsp; </td>
                                 </tr>           
                                </table>';

                        $cont.='<table width="100%">
                                 <tr class="CabezoteTabla"> 
                                  <td width="10">&nbsp;  </td>
                                  <td width="37">&nbsp;  </td>
                                  <td width="413"><label class="Texto12"><b>Empleado(a):</b></label> '.$nombreemp.'</td>
                                  <td width="227">&nbsp;</td>                  
                                  <td width="359">&nbsp;</td>                  
                                 </tr>
                                 <tr class="CabezoteTabla"> 
                                  <td width="10">&nbsp;  </td>
                                  <td width="37">&nbsp;  </td>
                                  <td width="413"><label class="Texto12"><b>Periodo:</b></label> '.$fecinicio.' al '.$fecfinal.'</td>
                                  <td width="227">&nbsp;</td>                  
                                  <td width="359">&nbsp;</td>                  
                                 </tr>
                                </table>';

                        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                                <table width="100%" class="sortable">
                                 <thead> 
                                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                                   <td width="10">&nbsp;</td>
                                   <td width="70" align="left">Periodo </td>				 				 
                                   <td width="100" align="left">Fecha</td>				 				                  
                                   <td width="290" align="left">Concepto </td>			
                                   <td width="50" align="right">D&iacute;as </td>			
                                   <td width="250" align="right">Devengados </td>			
                                   <td width="250" align="right">Descuentos </td>			                                   					
                                  </tr>
                                 </thead>
                                 <tbody style="display:block; width:1050px; height:490px; overflow-Y:scroll">';

                        // inicializamos las variables
                        $i = 0;
                        $totaldevengado = 0;
                        $totaldescuento = 0;
                        $netoapagar = 0;

                        $conex  = $clase->Conectar();
                        $result = mysql_query($vsql,$conex);
                        while($row = mysql_fetch_array($result))
                        {
                            $i++;
                            if($i%2 == 0)
                                $cont.='<tr class="TablaDocsPar">';
                            else
                                $cont.='<tr class="TablaDocsImPar">';

                            // fecha del pago
                            $fechapago = substr($row['fechasta'],8,2)."/".substr($row['fechasta'],5,2)."/".substr($row['fechasta'],0,4);

                            // días cancelados
                            $dias = $row['valor'];
                            if($dias==0)    $dias = "";

                            $cont.=' <td width="10">&nbsp;</td>
                                     <td width="70" align="left"> '.$row['codigo'].' </td>				 				 
                                     <td width="100" align="left">'.$fechapago.'</td>				 				                  
                                     <td width="290" align="left">'.$row['nomconcepto'].'</td>
                                     <td width="50" align="right">'.$dias.' </td>';
   
                            if($row['tipodc']=="C")
                            {
                                $cont.=' <td width="250" align="right">'.number_format($row['devengados']).' </td>			
                                         <td width="250" align="right">&nbsp; </td>';

                                $totaldevengado += $row['devengados'];
                            }
                            else
                            {
                                $cont.=' <td width="250" align="right">&nbsp; </td>			
                                         <td width="250" align="right">'.number_format($row['descuentos']).'</td>';

                                $totaldescuento += $row['descuentos'];
                            }

                            $cont.=' </tr>'; 
                        }                        

                        $cont.=' </tbody> 
                                </table>';

                        // neto a pagar
                        $netoapagar = $totaldevengado - $totaldescuento;                                

                        // impresión de los totales
                        $cont.='<table width="100%">
                                <tr class="TituloTabla"> 
                                <td width="261"> &nbsp; </td>
                                <td width="375" align="right"> <font color="WHITE"> <b> Total devengado: </b> '.number_format($totaldevengado).' </font> </td>
                                <td width="375" align="right"> <font color="WHITE"> <b> Total descuentos: </b> '.number_format($totaldescuento).' </font> </td>
                                <td width="375" align="right"> <font color="WHITE"> <b> Neto a pagar: </b> '.number_format($netoapagar).' </font> </td>
                                <td width="222"> &nbsp; </td>
                                </tr>
                                </table>';                                

                        echo $cont;
                    }

                    // vista en formato pdf
                    if($tiposalida=="pdf") 
                    {
                        // Traducción al español del mes que devuelve la función date()
                        $mesimp = date('F');
                        if($mesimp=="January")       $mesimp = "Enero";
                        if($mesimp=="February")      $mesimp = "Febrero";
                        if($mesimp=="March")         $mesimp = "Marzo";
                        if($mesimp=="April")         $mesimp = "Abril";
                        if($mesimp=="May")           $mesimp = "Mayo";
                        if($mesimp=="June")          $mesimp = "Junio";
                        if($mesimp=="July")          $mesimp = "Julio";
                        if($mesimp=="August")        $mesimp = "Agosto";
                        if($mesimp=="September")     $mesimp = "Septiembre";
                        if($mesimp=="October")       $mesimp = "Octubre";
                        if($mesimp=="November")      $mesimp = "Noviembre";
                        if($mesimp=="December")      $mesimp = "Diciembre";

                        $clase = new Sistema();
                        ini_set("memory_limit","200M");
                        require('lib/fpdf/fpdf.php');
                        $pdf=new FPDF();                    

                        $pdf->AddPage("");

                        // Logo Dromedicas
                        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                        $x = 35;
                        $y = 15;
                        $pagina = 1;

                        // Impresión del encabezado
                        $pdf->SetFont('Arial','B',10);
                        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                        $pdf->Text($x,$y,$enc);
                        
                        // Fecha y hora de impresión
                        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                        $pdf->SetFont('Arial','',8);
                        $pdf->Text($x+115,$y,$fechoraimp);

                        $pdf->SetFont('Arial','B',10);
                        $enc= "DETALLE ACUMULADO POR PERSONA - CONCEPTO";
                        $pdf->Text(35,$y+6,$enc);

                        $enc= "EMPLEADO(A):";
                        $pdf->Text(35,$y+12,$enc);

                        $pdf->SetFont('Arial','',10);
                        $pdf->Text(63,$y+12,$nombreemp);

                        $pdf->SetFont('Arial','B',10);
                        $enc= "PERIODO: ";
                        $pdf->Text(35,$y+18,$enc);

                        $pdf->SetFont('Arial','',10);
                        $pdf->Text(55,$y+18,$fecinicio);

                        $pdf->SetFont('Arial','B',10);
                        $enc= "AL";
                        $pdf->Text(75,$y+18,$enc);

                        $pdf->SetFont('Arial','',10);
                        $pdf->Text(82,$y+18,$fecfinal);

                        $pdf->SetFillColor(220,220,220);
                        $pdf->Rect(7,$y+23,200,8,'F');

                        $pdf->SetFont('Arial','B',10);
                        $enc= "PERIODO";
                        $pdf->Text(9,$y+28,$enc);

                        $pdf->SetFont('Arial','B',10);
                        $enc= "FECHA";
                        $pdf->Text(28,$y+28,$enc);

                        $enc= "CONCEPTO";
                        $pdf->Text(47,$y+28,$enc);

                        $enc= "DIAS";
                        $pdf->Text(120,$y+28,$enc);

                        $enc= "DEVENGADOS";
                        $pdf->Text(145,$y+28,$enc);

                        $enc= "DESCUENTOS";
                        $pdf->Text(178,$y+28,$enc);

                        // inicialización de variables
                        $x = 9;
                        $y = 51;
                        $totaldevengado = 0;
                        $totaldescuento = 0;
                        $netoapagar = 0;
                        $i = 0;

                        $conex  = $clase->Conectar();
                        $result = mysql_query($vsql,$conex);
                        while($row = mysql_fetch_array($result))
                        {
                            $i++;
                            $pdf->SetFont('Arial','',8);

                            // Código del periodo
                            $pdf->Text($x,$y,$row['codigo']);

                            // Fecha de pago
                            $fechapago = substr($row['fechasta'],8,2)."/".substr($row['fechasta'],5,2)."/".substr($row['fechasta'],0,4);
                            $pdf->Text($x+19,$y,$fechapago);

                            // Concepto pagado
                            $pdf->Text($x+38,$y,$row['nomconcepto']);

                            // Días cancelados
                            if($row['valor']>0)
                            {
                                $longitud = strlen($row['valor']);
        
                                if($longitud==1)
                                    $pdf->Text($x+115,$y,number_format($row['valor'],0));
        
                                if($longitud==2)
                                    $pdf->Text($x+113,$y,number_format($row['valor'],0));
                            }

                            // montos
                            if($row['tipodc']=="C")
                            {
                                $longitud = strlen($row['devengados']);

                                if($longitud==7)
                                    $pdf->Text($x+148,$y,number_format($row['devengados'],0));

                                if($longitud==6)
                                    $pdf->Text($x+150,$y,number_format($row['devengados'],0));

                                if($longitud==5)
                                    $pdf->Text($x+152,$y,number_format($row['devengados'],0));

                                if($longitud==4)
                                    $pdf->Text($x+150,$y,number_format($row['devengados'],0));

                                if($longitud==3)
                                    $pdf->Text($x+148,$y,number_format($row['devengados'],0));

                                if($longitud==2)
                                    $pdf->Text($x+146,$y,number_format($row['devengados'],0));

                                if($longitud==1)
                                    $pdf->Text($x+144,$y,number_format($row['devengados'],0));

                                $totaldevengado += $row['devengados'];
                            }
                            else
                            {
                                $longitud = strlen($row['descuentos']);

                                if($longitud==7)
                                    $pdf->Text($x+180,$y,number_format($row['descuentos'],0));

                                if($longitud==6)
                                    $pdf->Text($x+182,$y,number_format($row['descuentos'],0));

                                if($longitud==5)
                                    $pdf->Text($x+184,$y,number_format($row['descuentos'],0));

                                if($longitud==4)
                                    $pdf->Text($x+186,$y,number_format($row['descuentos'],0));

                                if($longitud==3)
                                    $pdf->Text($x+188,$y,number_format($row['descuentos'],0));

                                if($longitud==2)
                                    $pdf->Text($x+190,$y,number_format($row['descuentos'],0));

                                if($longitud==1)
                                    $pdf->Text($x+192,$y,number_format($row['descuentos'],0));

                                $totaldescuento += $row['descuentos'];
                            }

                            $y+=6;

                            if($i%35 == 0)
                            {
                                $pdf->AddPage("");

                                // Logo Dromedicas
                                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                                $x = 35;
                                $y = 15;
                                $pagina++;

                                // Impresión del encabezado
                                $pdf->SetFont('Arial','B',10);
                                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                                $pdf->Text($x,$y,$enc);
                                
                                // Fecha y hora de impresión
                                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                                $pdf->SetFont('Arial','',8);
                                $pdf->Text($x+115,$y,$fechoraimp);

                                $pdf->SetFont('Arial','B',10);
                                $enc= "DETALLE ACUMULADO POR PERSONA - CONCEPTO";
                                $pdf->Text(35,$y+6,$enc);

                                $enc= "EMPLEADO(A):";
                                $pdf->Text(35,$y+12,$enc);

                                $pdf->SetFont('Arial','',10);
                                $pdf->Text(63,$y+12,$nombreemp);

                                $pdf->SetFont('Arial','B',10);
                                $enc= "PERIODO: ";
                                $pdf->Text(35,$y+18,$enc);

                                $pdf->SetFont('Arial','',10);
                                $pdf->Text(55,$y+18,$fecinicio);

                                $pdf->SetFont('Arial','B',10);
                                $enc= "AL";
                                $pdf->Text(75,$y+18,$enc);

                                $pdf->SetFont('Arial','',10);
                                $pdf->Text(82,$y+18,$fecfinal);

                                $pdf->SetFillColor(220,220,220);
                                $pdf->Rect(7,$y+23,200,8,'F');

                                $pdf->SetFont('Arial','B',10);
                                $enc= "PERIODO";
                                $pdf->Text(9,$y+28,$enc);

                                $pdf->SetFont('Arial','B',10);
                                $enc= "FECHA";
                                $pdf->Text(28,$y+28,$enc);

                                $enc= "CONCEPTO";
                                $pdf->Text(47,$y+28,$enc);

                                $enc= "DIAS";
                                $pdf->Text(120,$y+28,$enc);

                                $enc= "DEVENGADOS";
                                $pdf->Text(145,$y+28,$enc);

                                $enc= "DESCUENTOS";
                                $pdf->Text(178,$y+28,$enc);

                                $x = 9;
                                $y = 51;
                            }
                        }

                        // ----------------------------------------------------------------------------------- //
                        // Impresión de los totales
                        $pdf->SetFillColor(180,180,180);
                        $pdf->Rect(7,$y-3,200,8,'F');

                        $pdf->SetFont('Arial','B',10);
                        $enc= "TOTALES:";
                        $pdf->Text($x+93,$y+2,$enc);

                        // devengados
                        $longitud = strlen($totaldevengado);

                        if($longitud==10)
                            $pdf->Text($x+141,$y+2,number_format($totaldevengado));

                        if($longitud==9)
                            $pdf->Text($x+143,$y+2,number_format($totaldevengado));

                        if($longitud==8)
                            $pdf->Text($x+145,$y+2,number_format($totaldevengado));

                        if($longitud==7)
                            $pdf->Text($x+147,$y+2,number_format($totaldevengado));

                        if($longitud==6)
                            $pdf->Text($x+149,$y+2,number_format($totaldevengado));

                        if($longitud==5)
                            $pdf->Text($x+151,$y+2,number_format($totaldevengado));

                        if($longitud==4)
                            $pdf->Text($x+153,$y+2,number_format($totaldevengado));

                        if($longitud==3)
                            $pdf->Text($x+155,$y+2,number_format($totaldevengado));

                        if($longitud==2)
                            $pdf->Text($x+157,$y+2,number_format($totaldevengado));

                        if($longitud==1)
                            $pdf->Text($x+159,$y+2,number_format($totaldevengado));

                        // descuentos
                        $longitud = strlen($totaldescuento);

                        if($longitud==10)
                            $pdf->Text($x+171,$y+2,number_format($totaldescuento));

                        if($longitud==9)
                            $pdf->Text($x+173,$y+2,number_format($totaldescuento));

                        if($longitud==8)
                            $pdf->Text($x+175,$y+2,number_format($totaldescuento));

                        if($longitud==7)
                            $pdf->Text($x+177,$y+2,number_format($totaldescuento));

                        if($longitud==6)
                            $pdf->Text($x+179,$y+2,number_format($totaldescuento));

                        if($longitud==5)
                            $pdf->Text($x+181,$y+2,number_format($totaldescuento));

                        if($longitud==4)
                            $pdf->Text($x+183,$y+2,number_format($totaldescuento));

                        if($longitud==3)
                            $pdf->Text($x+185,$y+2,number_format($totaldescuento));

                        if($longitud==2)
                            $pdf->Text($x+187,$y+2,number_format($totaldescuento));

                        if($longitud==1)
                            $pdf->Text($x+189,$y+2,number_format($totaldescuento));

                        // neto a pagar
                        $netoapagar = $totaldevengado - $totaldescuento;

                        $pdf->SetFillColor(180,180,180);
                        $pdf->Rect(7,$y+6,200,8,'F');

                        $enc= "NETO A PAGAR:";
                        $pdf->Text($x+83,$y+11,$enc);

                        $longitud = strlen($netoapagar);

                        if($longitud==10)
                            $pdf->Text($x+171,$y+11,number_format($netoapagar));

                        if($longitud==9)
                            $pdf->Text($x+173,$y+11,number_format($netoapagar));

                        if($longitud==8)
                            $pdf->Text($x+175,$y+11,number_format($netoapagar));

                        if($longitud==7)
                            $pdf->Text($x+177,$y+11,number_format($netoapagar));

                        if($longitud==6)
                            $pdf->Text($x+179,$y+11,number_format($netoapagar));

                        if($longitud==5)
                            $pdf->Text($x+181,$y+11,number_format($netoapagar));                        

                        if($longitud==4)
                            $pdf->Text($x+183,$y+11,number_format($netoapagar));

                        if($longitud==3)
                            $pdf->Text($x+185,$y+11,number_format($netoapagar));

                        if($longitud==2)
                            $pdf->Text($x+187,$y+11,number_format($netoapagar));

                        if($longitud==1)
                            $pdf->Text($x+189,$y+11,number_format($netoapagar));                        
                        // --------------------------------------------------------------------------------------------------- //
                        $pdf->Output();
                    }

                    // salida a excel
                    if($tiposalida=="excel")                
                    {
                        require_once 'lib/PHPExcel.php';
                        $clase = new Sistema();
                        $clase->Conectar();
                        ini_set("memory_limit","100M");
        
                        // Preparación del entorno para la salida a Excel
                        $clase = new Sistema();
                        $clase->Nombredb = $_SESSION['DBNOMBRE'];
                        error_reporting(E_ALL);
                        ini_set('display_errors', TRUE);
                        ini_set('display_startup_errors', TRUE);
                        date_default_timezone_set('Europe/London');
                    
                        if (PHP_SAPI == 'cli')
                            die('This example should only be run from a Web Browser');
                    
                        // Create new PHPExcel object
                        $objPHPExcel = new PHPExcel();
                    
                        // Set document properties
                        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                                     ->setTitle("Detalle acumulado por persona - DROPOS")
                                                     ->setSubject("Detalle acumulado por persona - DROPOS")
                                                     ->setDescription("Detalle acumulado por persona - DROPOS")
                                                     ->setKeywords("Detalle acumulado por persona - DROPOS")
                                                     ->setCategory("Categoria General");

                        // encabezado
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A1', 'DETALLE ACUMULADO POR PERSONA - CONCEPTO')
                                    ->setCellValue('A2', 'EMPLEADO(A): '.$nombreemp)
                                    ->setCellValue('A3', 'PERIODO: '.$fecinicio.' AL '.$fecfinal)
                                    ->setCellValue('A5', 'PERIODO')
                                    ->setCellValue('B5', 'FECHA')
                                    ->setCellValue('C5', 'CONCEPTO')
                                    ->setCellValue('D5', 'DIAS')
                                    ->setCellValue('E5', 'DEVENGADOS')
                                    ->setCellValue('F5', 'DESCUENTOS');

                        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
                        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);

                        $conex  = $clase->Conectar();
                        $result = mysql_query($vsql,$conex);
                        $cant   = mysql_num_rows($result);                
                        $i=6;
                        $totaldevengado = 0;
                        $totaldescuento = 0;
                        $netoapagar = 0;

                        while($row = mysql_fetch_array($result))
                        {
                            if($row['tipodc']=="C")
                            {
                                $objPHPExcel->setActiveSheetIndex(0)
                                            ->setCellValue('A'.$i, $row['codigo'])
                                            ->setCellValue('B'.$i, $row['fechasta'])
                                            ->setCellValue('C'.$i, $row['nomconcepto'])
                                            ->setCellValue('D'.$i, number_format($row['valor']))
                                            ->setCellValue('E'.$i, number_format($row['devengados']));
                                
                                $totaldevengado += $row['devengados'];
                            }
                            else
                            {
                                $objPHPExcel->setActiveSheetIndex(0)
                                            ->setCellValue('A'.$i, $row['codigo'])
                                            ->setCellValue('B'.$i, $row['fechasta'])
                                            ->setCellValue('C'.$i, $row['nomconcepto'])
                                            ->setCellValue('D'.$i, number_format($row['valor']))
                                            ->setCellValue('F'.$i, number_format($row['descuentos']));

                                $totaldescuento += $row['descuentos'];
                            }

                            $i++;
                        }

                        $rangoEncabezado = 'A5:F5';
                        $rangoCeldas     = 'A5:F'.($i-1);

                        // impresión de totales
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('C'.$i,'TOTALES:')
                                    ->setCellValue('E'.$i, number_format($totaldevengado))
                                    ->setCellValue('F'.$i, number_format($totaldescuento));

                        // neto a pagar
                        $netoapagar = $totaldevengado - $totaldescuento;                            
                        $i++;

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('C'.$i,'NETO A PAGAR:')                            
                                    ->setCellValue('F'.$i, number_format($netoapagar));

                        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //                
                        // Formato de Encabezado y Celdas
                        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
                        
                        $EstiloCeldas = array(
                        'borders' => array(
                            'allborders' => array(
                                'style' => PHPExcel_Style_Border::BORDER_THIN,
                                'color' => array('argb' => '00000000'),
                            ),
                            ),
                        );
                        // $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
                        /// Formato de Encabezados 
                        $EstiloEncabezado = array(
                        'font' => array(
                            'bold' => true,
                        ),
                        'alignment' => array(
                            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
                        ),
                        'borders' => array(
                            'allborders' => array(
                                'style' => PHPExcel_Style_Border::BORDER_THIN,
                                'color' => array('argb' => '00000000'),
                            ),
                        ),
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'rotation' => 90,
                            'startcolor' => array(
                                'argb' => '00FFFFCC',
                            ),
                            'endcolor' => array(
                                'argb' => 'FFFFFF',
                            ),
                            ),
                        );
                        // $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
                        // Rename worksheet
                        $objPHPExcel->getActiveSheet()->setTitle('detalle acumulado por persona');
                        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                        $objPHPExcel->setActiveSheetIndex(0);
                        // Redirect output to a client’s web browser (Excel5)
                        header('Content-Type: application/vnd.ms-excel');
                        // --------------------------------------------------------------------- //
                        // header('Content-Disposition: attachment;filename="planillanom.xls"');
                        $nombrearcexcel = "detalle acumulado por persona concepto ".strtolower($dni).".xls";
                        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
                        // --------------------------------------------------------------------- //
                        header('Cache-Control: max-age=0');
                        /// Genero la Salida
                        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
                        $objWriter->save('php://output');
                        exit;
                    }
                }
            }
        }
    }    
?>