<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: preactxsuc
    // Creación: 14/02/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que capta la sucursal para filtrar el informe
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "preactxsuc")
    {
        // preparo el combo de sucursales
        $params = ' class="Texto11" ';
        $vsqlcombo1 = "SELECT codigo , descripcion FROM sucursales WHERE 1 ORDER BY descripcion ASC";
        $combosucursales = $clase->CrearComboEsp("sucursal",$vsqlcombo1,"descripcion","descripcion",$row['codsuc'],"S",$params); 

        // pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                    <tr class="CabezoteTabla"> 
                    <td width="10"> </td>
                    <td width="37"> <img src="images/iconos/informes.png" width="32" height="32" border="0"> </td>
                    <td width="900"> <b> Activos por sucursales </b><br> Activos detallados por sucursal <td>
                    <td width="25"> <a href="principal.php"> <input type="button" value="<<" class="button"> </a> <td>
                    <td width="8"> </td> 
                    </tr>
                </table><center><br>
                <h3>Detalle del informe </h3> <br>';

        $cont.='<form action="?opcion=infactxsuc" method="POST" name="x" target="_blank">
                <center>
                <table width="100%">
                 <tr class="TablaDocsImpar"> 
                  <td width="100">  </td>
                  <td width="50"> <b> Sucursal: </td> 
                  <td width="120"> '.$combosucursales.' </td>
                 </tr>
                </table>';

        $cont.='<br>
                <input type="submit" value="Generar Informe" class="button red">
                </form>';
        echo $cont;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: infactxsuc
    // Creación: 14/02/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite el informe en vista html
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "infactxsuc")
    {
        $sucursal = $_POST['sucursal'];
        $descripcion  = $clase->BDLockup($sucursal,"sucursales","codigo","descripcion");
        $sucursalid  = $clase->BDLockup($sucursal,"sucursales","codigo","sucursalid");

        // pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/informes.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Activos por sucursales </b><br> '.$descripcion.'<td>
                  <td align="right"> <a href="?opcion=actxsucpdf&sucursalid='.$sucursalid.'" target="_blank"> <img src="images/iconos/exportarpdf2.png" border="0"> </a> </td>
                  <td width="8"> &nbsp; </td>
                  <td width="10"> <a href="?opcion=actxsucxls&sucursalid='.$sucursalid.'" target="_blank"> <img src="images/iconos/exportarexcel2.png" border="0"> </a> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>           
                </table>';

        // consulta del informe
        $vsql = "SELECT d.docuid, dd.productoid, p.codigo, p.descripcion
                   FROM documentos d
                        INNER JOIN dedocumentos dd ON (d.docuid = dd.docuid)
                        INNER JOIN productos p ON (dd.productoid = p.`productoid`) 
                  WHERE d.nrodocref = 'ACTIVOFIJO'
                        AND d.sucursalid = ".$sucursalid;

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;"> 
                   <td width="30">&nbsp; </td>
                   <td width="125" align="left">C&oacute;digo </td>				 
                   <td width="600" align="left">Descripci&oacute;n </td>
                   <td width="8" align="left">&nbsp; </td>   
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050; height:400px; overflow-Y:scroll">';

        // Impresión del detalle
        $i = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = @mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.= '<tr class="TablaDocsImPar">';
            else
                $cont.= '<tr class="TablaDocsPar">';

            $cont.= ' <td width="30" align="left"> &nbsp; </td>
                      <td width="125" align="left"> '.$row['codigo'].' </td>
                      <td width="875" align="left"> '.$row['descripcion'].' </td>
                     </tr>';
        }

        $cont.=' </tbody> 
                </table>';

        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="30"> &nbsp; </td>
                  <td width="1600" align="left"> <font color="WHITE"> <b> Total activos: </b> '.number_format($i).' </font> </td>
                 </tr>
                </table>';

        echo $cont;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: actxsucpdf
    // Creación: 15/02/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida en PDF del informe de activos por sucursales
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "actxsucpdf")
    {
        $sucursalid = $_GET['sucursalid'];
        $descripcion  = $clase->BDLockup($sucursalid,"sucursales","sucursalid","descripcion");
        
        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        $clase = new Sistema();
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF();

        $pdf->AddPage("");

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

        $x = 35;
        $y = 15;
        $pagina = 1;

        // titulo del informe
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+110,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "ACTIVOS POR SUCURSALES";
        $pdf->Text($x,$y+7,$enc);
        $enc= "SUCURSAL: ".strtoupper($descripcion);
        $pdf->Text($x,$y+14,$enc);

        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(7,$y+28,195,8,'F');

        $enc= "CODIGO";
        $pdf->Text(9,$y+33,$enc);

        $enc= "DESCRIPCION";
        $pdf->Text(38,$y+33,$enc);

        $pdf->SetFont('Arial','',8);

        // inicialización de variables
        $x = 9;
        $y = 56;
        $i = 0;
        $totactivos = 0;

        // consulta del informe
        $vsql = "SELECT d.docuid, dd.productoid, p.codigo, p.descripcion
                   FROM documentos d
                        INNER JOIN dedocumentos dd ON (d.docuid = dd.docuid)
                        INNER JOIN productos p ON (dd.productoid = p.`productoid`) 
                  WHERE d.nrodocref = 'ACTIVOFIJO'
                        AND d.sucursalid = ".$sucursalid;        

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            $totactivos++;

            // Impresión de documento y nombre
            $pdf->Text($x,$y,$row['codigo']);
            $pdf->Text($x+29,$y,$row['descripcion']);

            // salto de línea
            $y+=6;

            if($i%35 == 0)
            {
                $pdf->AddPage("");

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                $x = 35;
                $y = 15;
                $pagina++;

                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+110,$y,$fechoraimp);
                
                $pdf->SetFont('Arial','B',10);
                $enc= "ACTIVOS POR SUCURSALES";
                $pdf->Text($x,$y+7,$enc);
                $enc= "SUCURSAL: ".strtoupper($descripcion);
                $pdf->Text($x,$y+14,$enc);
                
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(7,$y+28,195,8,'F');
        
                $enc= "CODIGO";
                $pdf->Text(9,$y+33,$enc);
        
                $enc= "DESCRIPCION";
                $pdf->Text(38,$y+33,$enc);
                
                $pdf->SetFont('Arial','',8);
            
                // inicialización de variables
                $x = 9;
                $y = 56;                
            }
        }

        // Impresión del total de activos de la sucursal
        $y+=6;
        $pdf->SetFont('Arial','B',10);

        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(7,$y-5,195,8,'F');
        
        $longitud = strlen($totactivos);
        if($longitud==1)        $pdf->Text(150,$y,"TOTAL ACTIVOS: ".number_format($totactivos,0));
        if($longitud==2)        $pdf->Text(148,$y,"TOTAL ACTIVOS: ".number_format($totactivos,0));
        if($longitud==3)        $pdf->Text(146,$y,"TOTAL ACTIVOS: ".number_format($totactivos,0));

        $pdf->Output();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: actxsucxls
    // Creación: 15/02/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida a Excel del informe de activos por sucursales
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "actxsucxls")
    {
        $sucursalid = $_GET['sucursalid'];
        $descripcion  = $clase->BDLockup($sucursalid,"sucursales","sucursalid","descripcion");

        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("Activos por sucursales - DROPOS")
                                     ->setSubject("Activos por sucursales - DROPOS")
                                     ->setDescription("Activos por sucursales - DROPOS")
                                     ->setKeywords("Activos por sucursales - DROPOS")
                                     ->setCategory("Categoria General");

        // encabezado
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'ACTIVOS POR SUCURSALES')
                    ->setCellValue('A2', 'SUCURSAL: '.strtoupper($descripcion))
                    ->setCellValue('A3', 'CODIGO')
                    ->setCellValue('B3', 'DESCRIPCION');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        // consulta del informe
        $vsql = "SELECT d.docuid, dd.productoid, p.codigo, p.descripcion
                   FROM documentos d
                        INNER JOIN dedocumentos dd ON (d.docuid = dd.docuid)
                        INNER JOIN productos p ON (dd.productoid = p.`productoid`) 
                  WHERE d.nrodocref = 'ACTIVOFIJO'
                        AND d.sucursalid = ".$sucursalid;

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);                
        $i = 4;
        $totactivos = 0;

        // Detalle del informe
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['codigo'])
                        ->setCellValue('B'.$i, $row['descripcion']);
            
            $i++;
            $totactivos++;
        }

        // Impresión del último total
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A'.$i, 'TOTAL ACTIVOS:')
                    ->setCellValue('B'.$i, number_format($totactivos));

        $rangoEncabezado = 'A3:B3';
        $rangoCeldas     = 'A3:B'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //                
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        // $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Reportados por periodo');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //
        // header('Content-Disposition: attachment;filename="planillanom.xls"');
        $nombrearcexcel = "activos de la sucursal ".strtolower($descripcion).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }
?>    